# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnServerConfigurationArgs', 'VpnServerConfiguration']

@pulumi.input_type
class VpnServerConfigurationArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 vpn_authentication_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 azure_active_directory_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs']]]] = None,
                 client_revoked_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRevokedCertificateArgs']]]] = None,
                 client_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRootCertificateArgs']]]] = None,
                 ipsec_policy: Optional[pulumi.Input['VpnServerConfigurationIpsecPolicyArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input['VpnServerConfigurationRadiusArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VpnServerConfiguration resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_authentication_types: A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        :param pulumi.Input['VpnServerConfigurationIpsecPolicyArgs'] ipsec_policy: A `ipsec_policy` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_protocols: A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "vpn_authentication_types", vpn_authentication_types)
        if azure_active_directory_authentications is not None:
            pulumi.set(__self__, "azure_active_directory_authentications", azure_active_directory_authentications)
        if client_revoked_certificates is not None:
            pulumi.set(__self__, "client_revoked_certificates", client_revoked_certificates)
        if client_root_certificates is not None:
            pulumi.set(__self__, "client_root_certificates", client_root_certificates)
        if ipsec_policy is not None:
            pulumi.set(__self__, "ipsec_policy", ipsec_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius is not None:
            pulumi.set(__self__, "radius", radius)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_protocols is not None:
            pulumi.set(__self__, "vpn_protocols", vpn_protocols)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="vpnAuthenticationTypes")
    def vpn_authentication_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        """
        return pulumi.get(self, "vpn_authentication_types")

    @vpn_authentication_types.setter
    def vpn_authentication_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "vpn_authentication_types", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAuthentications")
    def azure_active_directory_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs']]]]:
        return pulumi.get(self, "azure_active_directory_authentications")

    @azure_active_directory_authentications.setter
    def azure_active_directory_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs']]]]):
        pulumi.set(self, "azure_active_directory_authentications", value)

    @_builtins.property
    @pulumi.getter(name="clientRevokedCertificates")
    def client_revoked_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRevokedCertificateArgs']]]]:
        return pulumi.get(self, "client_revoked_certificates")

    @client_revoked_certificates.setter
    def client_revoked_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRevokedCertificateArgs']]]]):
        pulumi.set(self, "client_revoked_certificates", value)

    @_builtins.property
    @pulumi.getter(name="clientRootCertificates")
    def client_root_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRootCertificateArgs']]]]:
        return pulumi.get(self, "client_root_certificates")

    @client_root_certificates.setter
    def client_root_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRootCertificateArgs']]]]):
        pulumi.set(self, "client_root_certificates", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPolicy")
    def ipsec_policy(self) -> Optional[pulumi.Input['VpnServerConfigurationIpsecPolicyArgs']]:
        """
        A `ipsec_policy` block as defined below.
        """
        return pulumi.get(self, "ipsec_policy")

    @ipsec_policy.setter
    def ipsec_policy(self, value: Optional[pulumi.Input['VpnServerConfigurationIpsecPolicyArgs']]):
        pulumi.set(self, "ipsec_policy", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def radius(self) -> Optional[pulumi.Input['VpnServerConfigurationRadiusArgs']]:
        return pulumi.get(self, "radius")

    @radius.setter
    def radius(self, value: Optional[pulumi.Input['VpnServerConfigurationRadiusArgs']]):
        pulumi.set(self, "radius", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpnProtocols")
    def vpn_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        return pulumi.get(self, "vpn_protocols")

    @vpn_protocols.setter
    def vpn_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpn_protocols", value)


@pulumi.input_type
class _VpnServerConfigurationState:
    def __init__(__self__, *,
                 azure_active_directory_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs']]]] = None,
                 client_revoked_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRevokedCertificateArgs']]]] = None,
                 client_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRootCertificateArgs']]]] = None,
                 ipsec_policy: Optional[pulumi.Input['VpnServerConfigurationIpsecPolicyArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input['VpnServerConfigurationRadiusArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpn_authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VpnServerConfiguration resources.
        :param pulumi.Input['VpnServerConfigurationIpsecPolicyArgs'] ipsec_policy: A `ipsec_policy` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_authentication_types: A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_protocols: A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        if azure_active_directory_authentications is not None:
            pulumi.set(__self__, "azure_active_directory_authentications", azure_active_directory_authentications)
        if client_revoked_certificates is not None:
            pulumi.set(__self__, "client_revoked_certificates", client_revoked_certificates)
        if client_root_certificates is not None:
            pulumi.set(__self__, "client_root_certificates", client_root_certificates)
        if ipsec_policy is not None:
            pulumi.set(__self__, "ipsec_policy", ipsec_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius is not None:
            pulumi.set(__self__, "radius", radius)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_authentication_types is not None:
            pulumi.set(__self__, "vpn_authentication_types", vpn_authentication_types)
        if vpn_protocols is not None:
            pulumi.set(__self__, "vpn_protocols", vpn_protocols)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAuthentications")
    def azure_active_directory_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs']]]]:
        return pulumi.get(self, "azure_active_directory_authentications")

    @azure_active_directory_authentications.setter
    def azure_active_directory_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs']]]]):
        pulumi.set(self, "azure_active_directory_authentications", value)

    @_builtins.property
    @pulumi.getter(name="clientRevokedCertificates")
    def client_revoked_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRevokedCertificateArgs']]]]:
        return pulumi.get(self, "client_revoked_certificates")

    @client_revoked_certificates.setter
    def client_revoked_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRevokedCertificateArgs']]]]):
        pulumi.set(self, "client_revoked_certificates", value)

    @_builtins.property
    @pulumi.getter(name="clientRootCertificates")
    def client_root_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRootCertificateArgs']]]]:
        return pulumi.get(self, "client_root_certificates")

    @client_root_certificates.setter
    def client_root_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnServerConfigurationClientRootCertificateArgs']]]]):
        pulumi.set(self, "client_root_certificates", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPolicy")
    def ipsec_policy(self) -> Optional[pulumi.Input['VpnServerConfigurationIpsecPolicyArgs']]:
        """
        A `ipsec_policy` block as defined below.
        """
        return pulumi.get(self, "ipsec_policy")

    @ipsec_policy.setter
    def ipsec_policy(self, value: Optional[pulumi.Input['VpnServerConfigurationIpsecPolicyArgs']]):
        pulumi.set(self, "ipsec_policy", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def radius(self) -> Optional[pulumi.Input['VpnServerConfigurationRadiusArgs']]:
        return pulumi.get(self, "radius")

    @radius.setter
    def radius(self, value: Optional[pulumi.Input['VpnServerConfigurationRadiusArgs']]):
        pulumi.set(self, "radius", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpnAuthenticationTypes")
    def vpn_authentication_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        """
        return pulumi.get(self, "vpn_authentication_types")

    @vpn_authentication_types.setter
    def vpn_authentication_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpn_authentication_types", value)

    @_builtins.property
    @pulumi.getter(name="vpnProtocols")
    def vpn_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        return pulumi.get(self, "vpn_protocols")

    @vpn_protocols.setter
    def vpn_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpn_protocols", value)


@pulumi.type_token("azure:network/vpnServerConfiguration:VpnServerConfiguration")
class VpnServerConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_active_directory_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs', 'VpnServerConfigurationAzureActiveDirectoryAuthenticationArgsDict']]]]] = None,
                 client_revoked_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationClientRevokedCertificateArgs', 'VpnServerConfigurationClientRevokedCertificateArgsDict']]]]] = None,
                 client_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationClientRootCertificateArgs', 'VpnServerConfigurationClientRootCertificateArgsDict']]]]] = None,
                 ipsec_policy: Optional[pulumi.Input[Union['VpnServerConfigurationIpsecPolicyArgs', 'VpnServerConfigurationIpsecPolicyArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input[Union['VpnServerConfigurationRadiusArgs', 'VpnServerConfigurationRadiusArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpn_authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a VPN Server Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.network.VpnServerConfiguration("test",
            name="example-config",
            resource_group_name=example.name,
            location=example.location,
            vpn_authentication_types=["Certificate"],
            client_root_certificates=[{
                "name": "DigiCert-Federated-ID-Root-CA",
                "public_cert_data": \"\"\"MIIDuzCCAqOgAwIBAgIQCHTZWCM+IlfFIRXIvyKSrjANBgkqhkiG9w0BAQsFADBn
        MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
        d3cuZGlnaWNlcnQuY29tMSYwJAYDVQQDEx1EaWdpQ2VydCBGZWRlcmF0ZWQgSUQg
        Um9vdCBDQTAeFw0xMzAxMTUxMjAwMDBaFw0zMzAxMTUxMjAwMDBaMGcxCzAJBgNV
        BAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdp
        Y2VydC5jb20xJjAkBgNVBAMTHURpZ2lDZXJ0IEZlZGVyYXRlZCBJRCBSb290IENB
        MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvAEB4pcCqnNNOWE6Ur5j
        QPUH+1y1F9KdHTRSza6k5iDlXq1kGS1qAkuKtw9JsiNRrjltmFnzMZRBbX8Tlfl8
        zAhBmb6dDduDGED01kBsTkgywYPxXVTKec0WxYEEF0oMn4wSYNl0lt2eJAKHXjNf
        GTwiibdP8CUR2ghSM2sUTI8Nt1Omfc4SMHhGhYD64uJMbX98THQ/4LMGuYegou+d
        GTiahfHtjn7AboSEknwAMJHCh5RlYZZ6B1O4QbKJ+34Q0eKgnI3X6Vc9u0zf6DH8
        Dk+4zQDYRRTqTnVO3VT8jzqDlCRuNtq6YvryOWN74/dq8LQhUnXHvFyrsdMaE1X2
        DwIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNV
        HQ4EFgQUGRdkFnbGt1EWjKwbUne+5OaZvRYwHwYDVR0jBBgwFoAUGRdkFnbGt1EW
        jKwbUne+5OaZvRYwDQYJKoZIhvcNAQELBQADggEBAHcqsHkrjpESqfuVTRiptJfP
        9JbdtWqRTmOf6uJi2c8YVqI6XlKXsD8C1dUUaaHKLUJzvKiazibVuBwMIT84AyqR
        QELn3e0BtgEymEygMU569b01ZPxoFSnNXc7qDZBDef8WfqAV/sxkTi8L9BkmFYfL
        uGLOhRJOFprPdoDIUBB+tmCl3oDcBy3vnUeOEioz8zAkprcb3GHwHAK+vHmmfgcn
        WsfMLH4JCLa/tRYL+Rw/N3ybCkDp00s0WUZ+AoDywSl0Q/ZEnNY0MsFiw6LyIdbq
        M/s/1JRtO3bDSzD9TazRVzn2oBqzSa8VgIo5C1nOnoAKJTlsClJKvIhnRlaLQqk=
        \"\"\",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        VPN Server Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/vpnServerConfiguration:VpnServerConfiguration config1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/vpnServerConfigurations/config1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VpnServerConfigurationIpsecPolicyArgs', 'VpnServerConfigurationIpsecPolicyArgsDict']] ipsec_policy: A `ipsec_policy` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_authentication_types: A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_protocols: A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnServerConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN Server Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.network.VpnServerConfiguration("test",
            name="example-config",
            resource_group_name=example.name,
            location=example.location,
            vpn_authentication_types=["Certificate"],
            client_root_certificates=[{
                "name": "DigiCert-Federated-ID-Root-CA",
                "public_cert_data": \"\"\"MIIDuzCCAqOgAwIBAgIQCHTZWCM+IlfFIRXIvyKSrjANBgkqhkiG9w0BAQsFADBn
        MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
        d3cuZGlnaWNlcnQuY29tMSYwJAYDVQQDEx1EaWdpQ2VydCBGZWRlcmF0ZWQgSUQg
        Um9vdCBDQTAeFw0xMzAxMTUxMjAwMDBaFw0zMzAxMTUxMjAwMDBaMGcxCzAJBgNV
        BAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdp
        Y2VydC5jb20xJjAkBgNVBAMTHURpZ2lDZXJ0IEZlZGVyYXRlZCBJRCBSb290IENB
        MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvAEB4pcCqnNNOWE6Ur5j
        QPUH+1y1F9KdHTRSza6k5iDlXq1kGS1qAkuKtw9JsiNRrjltmFnzMZRBbX8Tlfl8
        zAhBmb6dDduDGED01kBsTkgywYPxXVTKec0WxYEEF0oMn4wSYNl0lt2eJAKHXjNf
        GTwiibdP8CUR2ghSM2sUTI8Nt1Omfc4SMHhGhYD64uJMbX98THQ/4LMGuYegou+d
        GTiahfHtjn7AboSEknwAMJHCh5RlYZZ6B1O4QbKJ+34Q0eKgnI3X6Vc9u0zf6DH8
        Dk+4zQDYRRTqTnVO3VT8jzqDlCRuNtq6YvryOWN74/dq8LQhUnXHvFyrsdMaE1X2
        DwIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNV
        HQ4EFgQUGRdkFnbGt1EWjKwbUne+5OaZvRYwHwYDVR0jBBgwFoAUGRdkFnbGt1EW
        jKwbUne+5OaZvRYwDQYJKoZIhvcNAQELBQADggEBAHcqsHkrjpESqfuVTRiptJfP
        9JbdtWqRTmOf6uJi2c8YVqI6XlKXsD8C1dUUaaHKLUJzvKiazibVuBwMIT84AyqR
        QELn3e0BtgEymEygMU569b01ZPxoFSnNXc7qDZBDef8WfqAV/sxkTi8L9BkmFYfL
        uGLOhRJOFprPdoDIUBB+tmCl3oDcBy3vnUeOEioz8zAkprcb3GHwHAK+vHmmfgcn
        WsfMLH4JCLa/tRYL+Rw/N3ybCkDp00s0WUZ+AoDywSl0Q/ZEnNY0MsFiw6LyIdbq
        M/s/1JRtO3bDSzD9TazRVzn2oBqzSa8VgIo5C1nOnoAKJTlsClJKvIhnRlaLQqk=
        \"\"\",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        VPN Server Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/vpnServerConfiguration:VpnServerConfiguration config1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/vpnServerConfigurations/config1
        ```

        :param str resource_name: The name of the resource.
        :param VpnServerConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnServerConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_active_directory_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs', 'VpnServerConfigurationAzureActiveDirectoryAuthenticationArgsDict']]]]] = None,
                 client_revoked_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationClientRevokedCertificateArgs', 'VpnServerConfigurationClientRevokedCertificateArgsDict']]]]] = None,
                 client_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationClientRootCertificateArgs', 'VpnServerConfigurationClientRootCertificateArgsDict']]]]] = None,
                 ipsec_policy: Optional[pulumi.Input[Union['VpnServerConfigurationIpsecPolicyArgs', 'VpnServerConfigurationIpsecPolicyArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 radius: Optional[pulumi.Input[Union['VpnServerConfigurationRadiusArgs', 'VpnServerConfigurationRadiusArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpn_authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnServerConfigurationArgs.__new__(VpnServerConfigurationArgs)

            __props__.__dict__["azure_active_directory_authentications"] = azure_active_directory_authentications
            __props__.__dict__["client_revoked_certificates"] = client_revoked_certificates
            __props__.__dict__["client_root_certificates"] = client_root_certificates
            __props__.__dict__["ipsec_policy"] = ipsec_policy
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["radius"] = radius
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if vpn_authentication_types is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_authentication_types'")
            __props__.__dict__["vpn_authentication_types"] = vpn_authentication_types
            __props__.__dict__["vpn_protocols"] = vpn_protocols
        super(VpnServerConfiguration, __self__).__init__(
            'azure:network/vpnServerConfiguration:VpnServerConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_active_directory_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationAzureActiveDirectoryAuthenticationArgs', 'VpnServerConfigurationAzureActiveDirectoryAuthenticationArgsDict']]]]] = None,
            client_revoked_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationClientRevokedCertificateArgs', 'VpnServerConfigurationClientRevokedCertificateArgsDict']]]]] = None,
            client_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnServerConfigurationClientRootCertificateArgs', 'VpnServerConfigurationClientRootCertificateArgsDict']]]]] = None,
            ipsec_policy: Optional[pulumi.Input[Union['VpnServerConfigurationIpsecPolicyArgs', 'VpnServerConfigurationIpsecPolicyArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            radius: Optional[pulumi.Input[Union['VpnServerConfigurationRadiusArgs', 'VpnServerConfigurationRadiusArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpn_authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'VpnServerConfiguration':
        """
        Get an existing VpnServerConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VpnServerConfigurationIpsecPolicyArgs', 'VpnServerConfigurationIpsecPolicyArgsDict']] ipsec_policy: A `ipsec_policy` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_authentication_types: A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpn_protocols: A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnServerConfigurationState.__new__(_VpnServerConfigurationState)

        __props__.__dict__["azure_active_directory_authentications"] = azure_active_directory_authentications
        __props__.__dict__["client_revoked_certificates"] = client_revoked_certificates
        __props__.__dict__["client_root_certificates"] = client_root_certificates
        __props__.__dict__["ipsec_policy"] = ipsec_policy
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["radius"] = radius
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpn_authentication_types"] = vpn_authentication_types
        __props__.__dict__["vpn_protocols"] = vpn_protocols
        return VpnServerConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAuthentications")
    def azure_active_directory_authentications(self) -> pulumi.Output[Optional[Sequence['outputs.VpnServerConfigurationAzureActiveDirectoryAuthentication']]]:
        return pulumi.get(self, "azure_active_directory_authentications")

    @_builtins.property
    @pulumi.getter(name="clientRevokedCertificates")
    def client_revoked_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.VpnServerConfigurationClientRevokedCertificate']]]:
        return pulumi.get(self, "client_revoked_certificates")

    @_builtins.property
    @pulumi.getter(name="clientRootCertificates")
    def client_root_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.VpnServerConfigurationClientRootCertificate']]]:
        return pulumi.get(self, "client_root_certificates")

    @_builtins.property
    @pulumi.getter(name="ipsecPolicy")
    def ipsec_policy(self) -> pulumi.Output[Optional['outputs.VpnServerConfigurationIpsecPolicy']]:
        """
        A `ipsec_policy` block as defined below.
        """
        return pulumi.get(self, "ipsec_policy")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name which should be used for this VPN Server Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def radius(self) -> pulumi.Output[Optional['outputs.VpnServerConfigurationRadius']]:
        return pulumi.get(self, "radius")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Resource Group in which this VPN Server Configuration should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpnAuthenticationTypes")
    def vpn_authentication_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Authentication Types applicable for this VPN Server Configuration. Possible values are `AAD` (Azure Active Directory), `Certificate` and `Radius`.
        """
        return pulumi.get(self, "vpn_authentication_types")

    @_builtins.property
    @pulumi.getter(name="vpnProtocols")
    def vpn_protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of VPN Protocols to use for this Server Configuration. Possible values are `IkeV2` and `OpenVPN`.
        """
        return pulumi.get(self, "vpn_protocols")

