# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_virtual_path: pulumi.Input[_builtins.str],
                 key_vault_secret_id: pulumi.Input[_builtins.str],
                 key_virtual_path: pulumi.Input[_builtins.str],
                 nginx_deployment_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] certificate_virtual_path: Specify the path to the certificate file of this certificate.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specify the ID of the Key Vault Secret for this certificate.
        :param pulumi.Input[_builtins.str] key_virtual_path: Specify the path to the key file of this certificate.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        """
        pulumi.set(__self__, "certificate_virtual_path", certificate_virtual_path)
        pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        pulumi.set(__self__, "key_virtual_path", key_virtual_path)
        pulumi.set(__self__, "nginx_deployment_id", nginx_deployment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateVirtualPath")
    def certificate_virtual_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the path to the certificate file of this certificate.
        """
        return pulumi.get(self, "certificate_virtual_path")

    @certificate_virtual_path.setter
    def certificate_virtual_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_virtual_path", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the ID of the Key Vault Secret for this certificate.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVirtualPath")
    def key_virtual_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the path to the key file of this certificate.
        """
        return pulumi.get(self, "key_virtual_path")

    @key_virtual_path.setter
    def key_virtual_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_virtual_path", value)

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        """
        return pulumi.get(self, "nginx_deployment_id")

    @nginx_deployment_id.setter
    def nginx_deployment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nginx_deployment_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] certificate_virtual_path: Specify the path to the certificate file of this certificate.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specify the ID of the Key Vault Secret for this certificate.
        :param pulumi.Input[_builtins.str] key_virtual_path: Specify the path to the key file of this certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        """
        if certificate_virtual_path is not None:
            pulumi.set(__self__, "certificate_virtual_path", certificate_virtual_path)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if key_virtual_path is not None:
            pulumi.set(__self__, "key_virtual_path", key_virtual_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nginx_deployment_id is not None:
            pulumi.set(__self__, "nginx_deployment_id", nginx_deployment_id)

    @_builtins.property
    @pulumi.getter(name="certificateVirtualPath")
    def certificate_virtual_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the path to the certificate file of this certificate.
        """
        return pulumi.get(self, "certificate_virtual_path")

    @certificate_virtual_path.setter
    def certificate_virtual_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_virtual_path", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the ID of the Key Vault Secret for this certificate.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVirtualPath")
    def key_virtual_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the path to the key file of this certificate.
        """
        return pulumi.get(self, "key_virtual_path")

    @key_virtual_path.setter
    def key_virtual_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_virtual_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        """
        return pulumi.get(self, "nginx_deployment_id")

    @nginx_deployment_id.setter
    def nginx_deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nginx_deployment_id", value)


@pulumi.type_token("azure:nginx/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Certificate for an NGINX Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard",
            tags={
                "environment": "Production",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "name": "NGINX.NGINXPLUS/nginxDeployments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_deployment = azure.nginx.Deployment("example",
            name="example-nginx",
            resource_group_name=example.name,
            sku="publicpreview_Monthly_gmz7xq9ge3py",
            location=example.location,
            managed_resource_group="example",
            diagnose_support_enabled=True,
            frontend_public={
                "ip_addresses": [example_public_ip.id],
            },
            network_interfaces=[{
                "subnet_id": example_subnet.id,
            }])
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [
                    "Create",
                    "Delete",
                    "DeleteIssuers",
                    "Get",
                    "GetIssuers",
                    "Import",
                    "List",
                    "ListIssuers",
                    "ManageContacts",
                    "ManageIssuers",
                    "SetIssuers",
                    "Update",
                ],
            }])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        example_certificate2 = azure.nginx.Certificate("example",
            name="examplecert",
            nginx_deployment_id=example_deployment.id,
            key_virtual_path="/src/cert/soservermekey.key",
            certificate_virtual_path="/src/cert/server.cert",
            key_vault_secret_id=example_certificate.secret_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Nginx.NginxPlus` - 2024-11-01-preview

        ## Import

        An NGINX Certificate can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:nginx/certificate:Certificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Nginx.NginxPlus/nginxDeployments/deploy1/certificates/cer1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_virtual_path: Specify the path to the certificate file of this certificate.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specify the ID of the Key Vault Secret for this certificate.
        :param pulumi.Input[_builtins.str] key_virtual_path: Specify the path to the key file of this certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Certificate for an NGINX Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard",
            tags={
                "environment": "Production",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "name": "NGINX.NGINXPLUS/nginxDeployments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_deployment = azure.nginx.Deployment("example",
            name="example-nginx",
            resource_group_name=example.name,
            sku="publicpreview_Monthly_gmz7xq9ge3py",
            location=example.location,
            managed_resource_group="example",
            diagnose_support_enabled=True,
            frontend_public={
                "ip_addresses": [example_public_ip.id],
            },
            network_interfaces=[{
                "subnet_id": example_subnet.id,
            }])
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [
                    "Create",
                    "Delete",
                    "DeleteIssuers",
                    "Get",
                    "GetIssuers",
                    "Import",
                    "List",
                    "ListIssuers",
                    "ManageContacts",
                    "ManageIssuers",
                    "SetIssuers",
                    "Update",
                ],
            }])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        example_certificate2 = azure.nginx.Certificate("example",
            name="examplecert",
            nginx_deployment_id=example_deployment.id,
            key_virtual_path="/src/cert/soservermekey.key",
            certificate_virtual_path="/src/cert/server.cert",
            key_vault_secret_id=example_certificate.secret_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Nginx.NginxPlus` - 2024-11-01-preview

        ## Import

        An NGINX Certificate can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:nginx/certificate:Certificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Nginx.NginxPlus/nginxDeployments/deploy1/certificates/cer1
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate_virtual_path is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_virtual_path'")
            __props__.__dict__["certificate_virtual_path"] = certificate_virtual_path
            if key_vault_secret_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_secret_id'")
            __props__.__dict__["key_vault_secret_id"] = key_vault_secret_id
            if key_virtual_path is None and not opts.urn:
                raise TypeError("Missing required property 'key_virtual_path'")
            __props__.__dict__["key_virtual_path"] = key_virtual_path
            __props__.__dict__["name"] = name
            if nginx_deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'nginx_deployment_id'")
            __props__.__dict__["nginx_deployment_id"] = nginx_deployment_id
        super(Certificate, __self__).__init__(
            'azure:nginx/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_virtual_path: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_virtual_path: Specify the path to the certificate file of this certificate.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specify the ID of the Key Vault Secret for this certificate.
        :param pulumi.Input[_builtins.str] key_virtual_path: Specify the path to the key file of this certificate.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_virtual_path"] = certificate_virtual_path
        __props__.__dict__["key_vault_secret_id"] = key_vault_secret_id
        __props__.__dict__["key_virtual_path"] = key_virtual_path
        __props__.__dict__["name"] = name
        __props__.__dict__["nginx_deployment_id"] = nginx_deployment_id
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateVirtualPath")
    def certificate_virtual_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the path to the certificate file of this certificate.
        """
        return pulumi.get(self, "certificate_virtual_path")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the ID of the Key Vault Secret for this certificate.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter(name="keyVirtualPath")
    def key_virtual_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the path to the key file of this certificate.
        """
        return pulumi.get(self, "key_virtual_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this NGINX Certificate. Changing this forces a new NGINX Certificate to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the NGINX Deployment that this Certificate should be associated with. Changing this forces a new NGINX Certificate to be created.
        """
        return pulumi.get(self, "nginx_deployment_id")

