# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousDatabaseArgs', 'AutonomousDatabase']

@pulumi.input_type
class AutonomousDatabaseArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[_builtins.str],
                 auto_scaling_enabled: pulumi.Input[_builtins.bool],
                 auto_scaling_for_storage_enabled: pulumi.Input[_builtins.bool],
                 backup_retention_period_in_days: pulumi.Input[_builtins.int],
                 character_set: pulumi.Input[_builtins.str],
                 compute_count: pulumi.Input[_builtins.float],
                 compute_model: pulumi.Input[_builtins.str],
                 data_storage_size_in_tbs: pulumi.Input[_builtins.int],
                 db_version: pulumi.Input[_builtins.str],
                 db_workload: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 license_model: pulumi.Input[_builtins.str],
                 mtls_connection_required: pulumi.Input[_builtins.bool],
                 national_character_set: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_backup_schedule: Optional[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutonomousDatabase resource.
        :param pulumi.Input[_builtins.str] admin_password: The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tbs: The maximum storage that can be allocated for the database, in terabytes.
        :param pulumi.Input[_builtins.str] db_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] db_workload: The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.
               
               > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ips: (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        pulumi.set(__self__, "auto_scaling_for_storage_enabled", auto_scaling_for_storage_enabled)
        pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "compute_model", compute_model)
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "db_workload", db_workload)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "license_model", license_model)
        pulumi.set(__self__, "mtls_connection_required", mtls_connection_required)
        pulumi.set(__self__, "national_character_set", national_character_set)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if long_term_backup_schedule is not None:
            pulumi.set(__self__, "long_term_backup_schedule", long_term_backup_schedule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @auto_scaling_enabled.setter
    def auto_scaling_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingForStorageEnabled")
    def auto_scaling_for_storage_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        """
        return pulumi.get(self, "auto_scaling_for_storage_enabled")

    @auto_scaling_for_storage_enabled.setter
    def auto_scaling_for_storage_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_scaling_for_storage_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        Retention period, in days, for backups.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "backup_retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[_builtins.str]:
        """
        The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Input[_builtins.float]:
        """
        The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Input[_builtins.str]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum storage that can be allocated for the database, in terabytes.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[_builtins.str]:
        """
        A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Input[_builtins.str]:
        """
        The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_workload", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Input[_builtins.str]:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="mtlsConnectionRequired")
    def mtls_connection_required(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.

        > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        """
        return pulumi.get(self, "mtls_connection_required")

    @mtls_connection_required.setter
    def mtls_connection_required(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "mtls_connection_required", value)

    @_builtins.property
    @pulumi.getter(name="nationalCharacterSet")
    def national_character_set(self) -> pulumi.Input[_builtins.str]:
        """
        The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        """
        return pulumi.get(self, "national_character_set")

    @national_character_set.setter
    def national_character_set(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "national_character_set", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ips", value)

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "customer_contacts", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="longTermBackupSchedule")
    def long_term_backup_schedule(self) -> Optional[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]:
        return pulumi.get(self, "long_term_backup_schedule")

    @long_term_backup_schedule.setter
    def long_term_backup_schedule(self, value: Optional[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]):
        pulumi.set(self, "long_term_backup_schedule", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _AutonomousDatabaseState:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.float]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_backup_schedule: Optional[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']] = None,
                 mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabase resources.
        :param pulumi.Input[_builtins.str] admin_password: The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ips: (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tbs: The maximum storage that can be allocated for the database, in terabytes.
        :param pulumi.Input[_builtins.str] db_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] db_workload: The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.
               
               > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)
        if auto_scaling_enabled is not None:
            pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        if auto_scaling_for_storage_enabled is not None:
            pulumi.set(__self__, "auto_scaling_for_storage_enabled", auto_scaling_for_storage_enabled)
        if backup_retention_period_in_days is not None:
            pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if db_workload is not None:
            pulumi.set(__self__, "db_workload", db_workload)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if long_term_backup_schedule is not None:
            pulumi.set(__self__, "long_term_backup_schedule", long_term_backup_schedule)
        if mtls_connection_required is not None:
            pulumi.set(__self__, "mtls_connection_required", mtls_connection_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if national_character_set is not None:
            pulumi.set(__self__, "national_character_set", national_character_set)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ips", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @auto_scaling_enabled.setter
    def auto_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingForStorageEnabled")
    def auto_scaling_for_storage_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        """
        return pulumi.get(self, "auto_scaling_for_storage_enabled")

    @auto_scaling_for_storage_enabled.setter
    def auto_scaling_for_storage_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_for_storage_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention period, in days, for backups.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "customer_contacts", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum storage that can be allocated for the database, in terabytes.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_workload", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="longTermBackupSchedule")
    def long_term_backup_schedule(self) -> Optional[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]:
        return pulumi.get(self, "long_term_backup_schedule")

    @long_term_backup_schedule.setter
    def long_term_backup_schedule(self, value: Optional[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]):
        pulumi.set(self, "long_term_backup_schedule", value)

    @_builtins.property
    @pulumi.getter(name="mtlsConnectionRequired")
    def mtls_connection_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.

        > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        """
        return pulumi.get(self, "mtls_connection_required")

    @mtls_connection_required.setter
    def mtls_connection_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mtls_connection_required", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nationalCharacterSet")
    def national_character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        """
        return pulumi.get(self, "national_character_set")

    @national_character_set.setter
    def national_character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "national_character_set", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.type_token("azure:oracle/autonomousDatabase:AutonomousDatabase")
class AutonomousDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.float]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_backup_schedule: Optional[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]] = None,
                 mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Autonomous Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.oracle.AutonomousDatabase("example",
            name="example",
            resource_group_name="example",
            location="West Europe",
            subnet_id="example",
            display_name="example",
            db_workload="example",
            mtls_connection_required=False,
            backup_retention_period_in_days=42,
            compute_model="example",
            data_storage_size_in_gbs=42,
            auto_scaling_for_storage_enabled=False,
            virtual_network_id="example",
            admin_password="example",
            auto_scaling_enabled="example",
            character_set="example",
            compute_count=1.23456,
            national_character_set="example",
            license_model="false",
            db_version="example")
        ```

        ## > **Note:** `allowed_ips`  cannot be updated after provisioning the resource with an empty list (i.e., a publicly accessible Autonomous Database)

                      size: the maximum number of Ips provided shouldn't exceed 1024. At this time we only support IpV4.
        ***

        * `customer_contacts` - (Optional) Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database to be created.

        * `tags` - (Optional) A mapping of tags which should be assigned to the Autonomous Database.

        * `long_term_backup_schedule` - (Optional) A `long_term_backup_schedule` block as defined below.

        > **Note:** for more information see [Create Long-Term Backups on Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/serverless/adbsb/backup-long-term.html#GUID-BD76E02E-AEB0-4450-A6AB-5C9EB1F4EAD0)

        ***

        A `long_term_backup_schedule` blocks supports the following:

        * `repeat_cadence` - (Required)  Specifies the schedule for automated long-term backups. Possible values are `Weekly`, `Monthly`, `Yearly`, or `OneTime` (does not repeat) . For example, if the Backup date and Time is `Jan 24, 2025 00:09:00 UTC` and this is a Tuesday, and Weekly is selected, the long-term backup will happen every Tuesday.

        * `time_of_backup` - (Required) The date and time in which the backup should be taken in ISO8601 Date Time format.

        * `retention_period_in_days` - (Required) The retention period in days for the Autonomous Database Backup. Possible values range from `90` to `2558` days (7 years).

        * `enabled` - (Required) A boolean value that indicates whether the long term backup schedule is enabled.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        Autonomous Databases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/autonomousDatabase:AutonomousDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/autonomousDatabases/autonomousDatabases1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ips: (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tbs: The maximum storage that can be allocated for the database, in terabytes.
        :param pulumi.Input[_builtins.str] db_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] db_workload: The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.
               
               > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Autonomous Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.oracle.AutonomousDatabase("example",
            name="example",
            resource_group_name="example",
            location="West Europe",
            subnet_id="example",
            display_name="example",
            db_workload="example",
            mtls_connection_required=False,
            backup_retention_period_in_days=42,
            compute_model="example",
            data_storage_size_in_gbs=42,
            auto_scaling_for_storage_enabled=False,
            virtual_network_id="example",
            admin_password="example",
            auto_scaling_enabled="example",
            character_set="example",
            compute_count=1.23456,
            national_character_set="example",
            license_model="false",
            db_version="example")
        ```

        ## > **Note:** `allowed_ips`  cannot be updated after provisioning the resource with an empty list (i.e., a publicly accessible Autonomous Database)

                      size: the maximum number of Ips provided shouldn't exceed 1024. At this time we only support IpV4.
        ***

        * `customer_contacts` - (Optional) Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database to be created.

        * `tags` - (Optional) A mapping of tags which should be assigned to the Autonomous Database.

        * `long_term_backup_schedule` - (Optional) A `long_term_backup_schedule` block as defined below.

        > **Note:** for more information see [Create Long-Term Backups on Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/serverless/adbsb/backup-long-term.html#GUID-BD76E02E-AEB0-4450-A6AB-5C9EB1F4EAD0)

        ***

        A `long_term_backup_schedule` blocks supports the following:

        * `repeat_cadence` - (Required)  Specifies the schedule for automated long-term backups. Possible values are `Weekly`, `Monthly`, `Yearly`, or `OneTime` (does not repeat) . For example, if the Backup date and Time is `Jan 24, 2025 00:09:00 UTC` and this is a Tuesday, and Weekly is selected, the long-term backup will happen every Tuesday.

        * `time_of_backup` - (Required) The date and time in which the backup should be taken in ISO8601 Date Time format.

        * `retention_period_in_days` - (Required) The retention period in days for the Autonomous Database Backup. Possible values range from `90` to `2558` days (7 years).

        * `enabled` - (Required) A boolean value that indicates whether the long term backup schedule is enabled.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        Autonomous Databases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/autonomousDatabase:AutonomousDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/autonomousDatabases/autonomousDatabases1
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.float]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_backup_schedule: Optional[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]] = None,
                 mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseArgs.__new__(AutonomousDatabaseArgs)

            if admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'admin_password'")
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["allowed_ips"] = allowed_ips
            if auto_scaling_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'auto_scaling_enabled'")
            __props__.__dict__["auto_scaling_enabled"] = auto_scaling_enabled
            if auto_scaling_for_storage_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'auto_scaling_for_storage_enabled'")
            __props__.__dict__["auto_scaling_for_storage_enabled"] = auto_scaling_for_storage_enabled
            if backup_retention_period_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'backup_retention_period_in_days'")
            __props__.__dict__["backup_retention_period_in_days"] = backup_retention_period_in_days
            if character_set is None and not opts.urn:
                raise TypeError("Missing required property 'character_set'")
            __props__.__dict__["character_set"] = character_set
            if compute_count is None and not opts.urn:
                raise TypeError("Missing required property 'compute_count'")
            __props__.__dict__["compute_count"] = compute_count
            if compute_model is None and not opts.urn:
                raise TypeError("Missing required property 'compute_model'")
            __props__.__dict__["compute_model"] = compute_model
            __props__.__dict__["customer_contacts"] = customer_contacts
            if data_storage_size_in_tbs is None and not opts.urn:
                raise TypeError("Missing required property 'data_storage_size_in_tbs'")
            __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            if db_workload is None and not opts.urn:
                raise TypeError("Missing required property 'db_workload'")
            __props__.__dict__["db_workload"] = db_workload
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if license_model is None and not opts.urn:
                raise TypeError("Missing required property 'license_model'")
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["location"] = location
            __props__.__dict__["long_term_backup_schedule"] = long_term_backup_schedule
            if mtls_connection_required is None and not opts.urn:
                raise TypeError("Missing required property 'mtls_connection_required'")
            __props__.__dict__["mtls_connection_required"] = mtls_connection_required
            __props__.__dict__["name"] = name
            if national_character_set is None and not opts.urn:
                raise TypeError("Missing required property 'national_character_set'")
            __props__.__dict__["national_character_set"] = national_character_set
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_id"] = virtual_network_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabase, __self__).__init__(
            'azure:oracle/autonomousDatabase:AutonomousDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            character_set: Optional[pulumi.Input[_builtins.str]] = None,
            compute_count: Optional[pulumi.Input[_builtins.float]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_version: Optional[pulumi.Input[_builtins.str]] = None,
            db_workload: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            long_term_backup_schedule: Optional[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]] = None,
            mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutonomousDatabase':
        """
        Get an existing AutonomousDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ips: (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tbs: The maximum storage that can be allocated for the database, in terabytes.
        :param pulumi.Input[_builtins.str] db_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] db_workload: The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.
               
               > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseState.__new__(_AutonomousDatabaseState)

        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["allowed_ips"] = allowed_ips
        __props__.__dict__["auto_scaling_enabled"] = auto_scaling_enabled
        __props__.__dict__["auto_scaling_for_storage_enabled"] = auto_scaling_for_storage_enabled
        __props__.__dict__["backup_retention_period_in_days"] = backup_retention_period_in_days
        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["customer_contacts"] = customer_contacts
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["db_workload"] = db_workload
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["location"] = location
        __props__.__dict__["long_term_backup_schedule"] = long_term_backup_schedule
        __props__.__dict__["mtls_connection_required"] = mtls_connection_required
        __props__.__dict__["name"] = name
        __props__.__dict__["national_character_set"] = national_character_set
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return AutonomousDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        The password must be between `12` and `30 `characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        (Optional) Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses.
        """
        return pulumi.get(self, "allowed_ips")

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `true`.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @_builtins.property
    @pulumi.getter(name="autoScalingForStorageEnabled")
    def auto_scaling_for_storage_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `false`.
        """
        return pulumi.get(self, "auto_scaling_for_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Retention period, in days, for backups.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[_builtins.str]:
        """
        The character set for the autonomous database.  The default is `AL32UTF8`. Allowed values are:  `AL32UTF8`, `AR8ADOS710`, `AR8ADOS720`, `AR8APTEC715`, `AR8ARABICMACS`, `AR8ASMO8X`, `AR8ISO8859P6`, `AR8MSWIN1256`, `AR8MUSSAD768`, `AR8NAFITHA711`, `AR8NAFITHA721`, `AR8SAKHR706`, `AR8SAKHR707`, `AZ8ISO8859P9E`, `BG8MSWIN`, `BG8PC437S`, `BLT8CP921`, `BLT8ISO8859P13`, `BLT8MSWIN1257`, `BLT8PC775`, `BN8BSCII`, `CDN8PC863`, `CEL8ISO8859P14`, `CL8ISO8859P5`, `CL8ISOIR111`, `CL8KOI8R`, `CL8KOI8U`, `CL8MACCYRILLICS`, `CL8MSWIN1251`, `EE8ISO8859P2`, `EE8MACCES`, `EE8MACCROATIANS`, `EE8MSWIN1250`, `EE8PC852`, `EL8DEC`, `EL8ISO8859P7`, `EL8MACGREEKS`, `EL8MSWIN1253`, `EL8PC437S`, `EL8PC851`, `EL8PC869`, `ET8MSWIN923`, `HU8ABMOD`, `HU8CWI2`, `IN8ISCII`, `IS8PC861`, `IW8ISO8859P8`, `IW8MACHEBREWS`, `IW8MSWIN1255`, `IW8PC1507`, `JA16EUC`, `JA16EUCTILDE`, `JA16SJIS`, `JA16SJISTILDE`, `JA16VMS`, `KO16KSC5601`, `KO16KSCCS`, `KO16MSWIN949`, `LA8ISO6937`, `LA8PASSPORT`, `LT8MSWIN921`, `LT8PC772`, `LT8PC774`, `LV8PC1117`, `LV8PC8LR`, `LV8RST104090`, `N8PC865`, `NE8ISO8859P10`, `NEE8ISO8859P4`, `RU8BESTA`, `RU8PC855`, `RU8PC866`, `SE8ISO8859P3`, `TH8MACTHAIS`, `TH8TISASCII`, `TR8DEC`, `TR8MACTURKISHS`, `TR8MSWIN1254`, `TR8PC857`, `US7ASCII`, `US8PC437`, `UTF8`, `VN8MSWIN1258`, `VN8VN3`, `WE8DEC`, `WE8DG`, `WE8ISO8859P1`, `WE8ISO8859P15`, `WE8ISO8859P9`, `WE8MACROMAN8S`, `WE8MSWIN1252`, `WE8NCR4970`, `WE8NEXTSTEP`, `WE8PC850`, `WE8PC858`, `WE8PC860`, `WE8ROMAN8`, `ZHS16CGB231280`, `ZHS16GBK`, `ZHT16BIG5`, `ZHT16CCDC`, `ZHT16DBT`, `ZHT16HKSCS`, `ZHT16MSWIN950`, `ZHT32EUC`, `ZHT32SOPS`, `ZHT32TRIS`. Changing this forces a new Autonomous Database to be created
        """
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[_builtins.float]:
        """
        The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure.  For an Autonomous Database Serverless instance, the `ECPU` compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "customer_contacts")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum storage that can be allocated for the database, in terabytes.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[_builtins.str]:
        """
        A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Output[_builtins.str]:
        """
        The Autonomous Database workload type. Changing this forces a new Autonomous Database to be created. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        > **Note:** When Provisioning Database with `APEX` workload `mtls_connection_required` must be set to `true`.
        """
        return pulumi.get(self, "db_workload")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the Autonomous Database. The name does not have to be unique. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Changing this forces a new Autonomous Database to be created. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="longTermBackupSchedule")
    def long_term_backup_schedule(self) -> pulumi.Output[Optional['outputs.AutonomousDatabaseLongTermBackupSchedule']]:
        return pulumi.get(self, "long_term_backup_schedule")

    @_builtins.property
    @pulumi.getter(name="mtlsConnectionRequired")
    def mtls_connection_required(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database to be created. Default value `false`.

        > **Note:** `mtls_connection_required`  must be set to `true` for all workload types except 'APEX' when creating a database with public access.
        """
        return pulumi.get(self, "mtls_connection_required")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Autonomous Database. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nationalCharacterSet")
    def national_character_set(self) -> pulumi.Output[_builtins.str]:
        """
        The national character set for the autonomous database. Changing this forces a new Autonomous Database to be created. The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        """
        return pulumi.get(self, "national_character_set")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Autonomous Database should exist. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the vnet associated with the cloud VM cluster. Changing this forces a new Autonomous Database to be created.
        """
        return pulumi.get(self, "virtual_network_id")

