# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutonomousDatabaseCloneFromDatabaseArgs', 'AutonomousDatabaseCloneFromDatabase']

@pulumi.input_type
class AutonomousDatabaseCloneFromDatabaseArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[_builtins.str],
                 auto_scaling_enabled: pulumi.Input[_builtins.bool],
                 auto_scaling_for_storage_enabled: pulumi.Input[_builtins.bool],
                 backup_retention_period_in_days: pulumi.Input[_builtins.int],
                 character_set: pulumi.Input[_builtins.str],
                 clone_type: pulumi.Input[_builtins.str],
                 compute_count: pulumi.Input[_builtins.float],
                 compute_model: pulumi.Input[_builtins.str],
                 data_storage_size_in_tb: pulumi.Input[_builtins.int],
                 database_version: pulumi.Input[_builtins.str],
                 database_workload: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 license_model: pulumi.Input[_builtins.str],
                 mtls_connection_required: pulumi.Input[_builtins.bool],
                 national_character_set: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 source_autonomous_database_id: pulumi.Input[_builtins.str],
                 allowed_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 refreshable_model: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseCloneFromDatabase resource.
        :param pulumi.Input[_builtins.str] admin_password: The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] clone_type: The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.
               
               > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tb: The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_workload: The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] source_autonomous_database_id: The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_addresses: Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] customer_contacts: Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] refreshable_model: The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        pulumi.set(__self__, "auto_scaling_for_storage_enabled", auto_scaling_for_storage_enabled)
        pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "clone_type", clone_type)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "compute_model", compute_model)
        pulumi.set(__self__, "data_storage_size_in_tb", data_storage_size_in_tb)
        pulumi.set(__self__, "database_version", database_version)
        pulumi.set(__self__, "database_workload", database_workload)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "license_model", license_model)
        pulumi.set(__self__, "mtls_connection_required", mtls_connection_required)
        pulumi.set(__self__, "national_character_set", national_character_set)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "source_autonomous_database_id", source_autonomous_database_id)
        if allowed_ip_addresses is not None:
            pulumi.set(__self__, "allowed_ip_addresses", allowed_ip_addresses)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refreshable_model is not None:
            pulumi.set(__self__, "refreshable_model", refreshable_model)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @auto_scaling_enabled.setter
    def auto_scaling_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingForStorageEnabled")
    def auto_scaling_for_storage_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "auto_scaling_for_storage_enabled")

    @auto_scaling_for_storage_enabled.setter
    def auto_scaling_for_storage_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_scaling_for_storage_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "backup_retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[_builtins.str]:
        """
        The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "clone_type")

    @clone_type.setter
    def clone_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "clone_type", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Input[_builtins.float]:
        """
        The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Input[_builtins.str]:
        """
        The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.

        > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTb")
    def data_storage_size_in_tb(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "data_storage_size_in_tb")

    @data_storage_size_in_tb.setter
    def data_storage_size_in_tb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "data_storage_size_in_tb", value)

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Input[_builtins.str]:
        """
        A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_version", value)

    @_builtins.property
    @pulumi.getter(name="databaseWorkload")
    def database_workload(self) -> pulumi.Input[_builtins.str]:
        """
        The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        """
        return pulumi.get(self, "database_workload")

    @database_workload.setter
    def database_workload(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_workload", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Input[_builtins.str]:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="mtlsConnectionRequired")
    def mtls_connection_required(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "mtls_connection_required")

    @mtls_connection_required.setter
    def mtls_connection_required(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "mtls_connection_required", value)

    @_builtins.property
    @pulumi.getter(name="nationalCharacterSet")
    def national_character_set(self) -> pulumi.Input[_builtins.str]:
        """
        The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "national_character_set")

    @national_character_set.setter
    def national_character_set(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "national_character_set", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceAutonomousDatabaseId")
    def source_autonomous_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "source_autonomous_database_id")

    @source_autonomous_database_id.setter
    def source_autonomous_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="allowedIpAddresses")
    def allowed_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "allowed_ip_addresses")

    @allowed_ip_addresses.setter
    def allowed_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "customer_contacts", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refreshableModel")
    def refreshable_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "refreshable_model")

    @refreshable_model.setter
    def refreshable_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refreshable_model", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _AutonomousDatabaseCloneFromDatabaseState:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 clone_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.float]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_storage_size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 database_version: Optional[pulumi.Input[_builtins.str]] = None,
                 database_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 refreshable_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseCloneFromDatabase resources.
        :param pulumi.Input[_builtins.str] admin_password: The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_addresses: Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] clone_type: The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.
               
               > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] customer_contacts: Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tb: The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_workload: The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] refreshable_model: The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] source_autonomous_database_id: The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if allowed_ip_addresses is not None:
            pulumi.set(__self__, "allowed_ip_addresses", allowed_ip_addresses)
        if auto_scaling_enabled is not None:
            pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        if auto_scaling_for_storage_enabled is not None:
            pulumi.set(__self__, "auto_scaling_for_storage_enabled", auto_scaling_for_storage_enabled)
        if backup_retention_period_in_days is not None:
            pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if clone_type is not None:
            pulumi.set(__self__, "clone_type", clone_type)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_storage_size_in_tb is not None:
            pulumi.set(__self__, "data_storage_size_in_tb", data_storage_size_in_tb)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if database_workload is not None:
            pulumi.set(__self__, "database_workload", database_workload)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mtls_connection_required is not None:
            pulumi.set(__self__, "mtls_connection_required", mtls_connection_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if national_character_set is not None:
            pulumi.set(__self__, "national_character_set", national_character_set)
        if refreshable_model is not None:
            pulumi.set(__self__, "refreshable_model", refreshable_model)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_autonomous_database_id is not None:
            pulumi.set(__self__, "source_autonomous_database_id", source_autonomous_database_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="allowedIpAddresses")
    def allowed_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "allowed_ip_addresses")

    @allowed_ip_addresses.setter
    def allowed_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @auto_scaling_enabled.setter
    def auto_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingForStorageEnabled")
    def auto_scaling_for_storage_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "auto_scaling_for_storage_enabled")

    @auto_scaling_for_storage_enabled.setter
    def auto_scaling_for_storage_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_for_storage_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "clone_type")

    @clone_type.setter
    def clone_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clone_type", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.

        > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "customer_contacts", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTb")
    def data_storage_size_in_tb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "data_storage_size_in_tb")

    @data_storage_size_in_tb.setter
    def data_storage_size_in_tb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_storage_size_in_tb", value)

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_version", value)

    @_builtins.property
    @pulumi.getter(name="databaseWorkload")
    def database_workload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        """
        return pulumi.get(self, "database_workload")

    @database_workload.setter
    def database_workload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_workload", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mtlsConnectionRequired")
    def mtls_connection_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "mtls_connection_required")

    @mtls_connection_required.setter
    def mtls_connection_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mtls_connection_required", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nationalCharacterSet")
    def national_character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "national_character_set")

    @national_character_set.setter
    def national_character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "national_character_set", value)

    @_builtins.property
    @pulumi.getter(name="refreshableModel")
    def refreshable_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "refreshable_model")

    @refreshable_model.setter
    def refreshable_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refreshable_model", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceAutonomousDatabaseId")
    def source_autonomous_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "source_autonomous_database_id")

    @source_autonomous_database_id.setter
    def source_autonomous_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.type_token("azure:oracle/autonomousDatabaseCloneFromDatabase:AutonomousDatabaseCloneFromDatabase")
class AutonomousDatabaseCloneFromDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 clone_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.float]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_storage_size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 database_version: Optional[pulumi.Input[_builtins.str]] = None,
                 database_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 refreshable_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an autonomous database clone from database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="eastus")
        example_autonomous_database = azure.oracle.AutonomousDatabase("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            admin_password="BEstrO0ng_#11",
            backup_retention_period_in_days=7,
            character_set="AL32UTF8",
            compute_count=2,
            compute_model="ECPU",
            data_storage_size_in_tbs=1,
            db_version="19c",
            db_workload="OLTP",
            display_name="Example",
            license_model="LicenseIncluded",
            auto_scaling_enabled=False,
            auto_scaling_for_storage_enabled=True,
            mtls_connection_required=True,
            national_character_set="AL16UTF16",
            allowed_ips=[])
        example_autonomous_database_clone_from_database = azure.oracle.AutonomousDatabaseCloneFromDatabase("example",
            name="example",
            resource_group_name=example_autonomous_database.resource_group_name,
            location=example_autonomous_database.location,
            source_autonomous_database_id=example_autonomous_database.id,
            clone_type="Full",
            admin_password="BEstrO0ng_#11",
            backup_retention_period_in_days=7,
            character_set="AL32UTF8",
            compute_count=2,
            compute_model="ECPU",
            data_storage_size_in_tb=1,
            database_version="19c",
            database_workload="OLTP",
            display_name="ExampleClone",
            license_model="LicenseIncluded",
            auto_scaling_enabled=False,
            auto_scaling_for_storage_enabled=True,
            mtls_connection_required=True,
            national_character_set="AL16UTF16",
            allowed_ip_addresses=[])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        autonomous database clone from databases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/autonomousDatabaseCloneFromDatabase:AutonomousDatabaseCloneFromDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Oracle.Database/autonomousDatabases/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_addresses: Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] clone_type: The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.
               
               > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] customer_contacts: Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tb: The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_workload: The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] refreshable_model: The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] source_autonomous_database_id: The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseCloneFromDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an autonomous database clone from database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="eastus")
        example_autonomous_database = azure.oracle.AutonomousDatabase("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            admin_password="BEstrO0ng_#11",
            backup_retention_period_in_days=7,
            character_set="AL32UTF8",
            compute_count=2,
            compute_model="ECPU",
            data_storage_size_in_tbs=1,
            db_version="19c",
            db_workload="OLTP",
            display_name="Example",
            license_model="LicenseIncluded",
            auto_scaling_enabled=False,
            auto_scaling_for_storage_enabled=True,
            mtls_connection_required=True,
            national_character_set="AL16UTF16",
            allowed_ips=[])
        example_autonomous_database_clone_from_database = azure.oracle.AutonomousDatabaseCloneFromDatabase("example",
            name="example",
            resource_group_name=example_autonomous_database.resource_group_name,
            location=example_autonomous_database.location,
            source_autonomous_database_id=example_autonomous_database.id,
            clone_type="Full",
            admin_password="BEstrO0ng_#11",
            backup_retention_period_in_days=7,
            character_set="AL32UTF8",
            compute_count=2,
            compute_model="ECPU",
            data_storage_size_in_tb=1,
            database_version="19c",
            database_workload="OLTP",
            display_name="ExampleClone",
            license_model="LicenseIncluded",
            auto_scaling_enabled=False,
            auto_scaling_for_storage_enabled=True,
            mtls_connection_required=True,
            national_character_set="AL16UTF16",
            allowed_ip_addresses=[])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        autonomous database clone from databases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/autonomousDatabaseCloneFromDatabase:AutonomousDatabaseCloneFromDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Oracle.Database/autonomousDatabases/example
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseCloneFromDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseCloneFromDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 clone_type: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.float]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_storage_size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 database_version: Optional[pulumi.Input[_builtins.str]] = None,
                 database_workload: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 refreshable_model: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseCloneFromDatabaseArgs.__new__(AutonomousDatabaseCloneFromDatabaseArgs)

            if admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'admin_password'")
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["allowed_ip_addresses"] = allowed_ip_addresses
            if auto_scaling_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'auto_scaling_enabled'")
            __props__.__dict__["auto_scaling_enabled"] = auto_scaling_enabled
            if auto_scaling_for_storage_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'auto_scaling_for_storage_enabled'")
            __props__.__dict__["auto_scaling_for_storage_enabled"] = auto_scaling_for_storage_enabled
            if backup_retention_period_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'backup_retention_period_in_days'")
            __props__.__dict__["backup_retention_period_in_days"] = backup_retention_period_in_days
            if character_set is None and not opts.urn:
                raise TypeError("Missing required property 'character_set'")
            __props__.__dict__["character_set"] = character_set
            if clone_type is None and not opts.urn:
                raise TypeError("Missing required property 'clone_type'")
            __props__.__dict__["clone_type"] = clone_type
            if compute_count is None and not opts.urn:
                raise TypeError("Missing required property 'compute_count'")
            __props__.__dict__["compute_count"] = compute_count
            if compute_model is None and not opts.urn:
                raise TypeError("Missing required property 'compute_model'")
            __props__.__dict__["compute_model"] = compute_model
            __props__.__dict__["customer_contacts"] = customer_contacts
            if data_storage_size_in_tb is None and not opts.urn:
                raise TypeError("Missing required property 'data_storage_size_in_tb'")
            __props__.__dict__["data_storage_size_in_tb"] = data_storage_size_in_tb
            if database_version is None and not opts.urn:
                raise TypeError("Missing required property 'database_version'")
            __props__.__dict__["database_version"] = database_version
            if database_workload is None and not opts.urn:
                raise TypeError("Missing required property 'database_workload'")
            __props__.__dict__["database_workload"] = database_workload
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if license_model is None and not opts.urn:
                raise TypeError("Missing required property 'license_model'")
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["location"] = location
            if mtls_connection_required is None and not opts.urn:
                raise TypeError("Missing required property 'mtls_connection_required'")
            __props__.__dict__["mtls_connection_required"] = mtls_connection_required
            __props__.__dict__["name"] = name
            if national_character_set is None and not opts.urn:
                raise TypeError("Missing required property 'national_character_set'")
            __props__.__dict__["national_character_set"] = national_character_set
            __props__.__dict__["refreshable_model"] = refreshable_model
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if source_autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_autonomous_database_id'")
            __props__.__dict__["source_autonomous_database_id"] = source_autonomous_database_id
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_id"] = virtual_network_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabaseCloneFromDatabase, __self__).__init__(
            'azure:oracle/autonomousDatabaseCloneFromDatabase:AutonomousDatabaseCloneFromDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_scaling_for_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            backup_retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            character_set: Optional[pulumi.Input[_builtins.str]] = None,
            clone_type: Optional[pulumi.Input[_builtins.str]] = None,
            compute_count: Optional[pulumi.Input[_builtins.float]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_storage_size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
            database_version: Optional[pulumi.Input[_builtins.str]] = None,
            database_workload: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mtls_connection_required: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            national_character_set: Optional[pulumi.Input[_builtins.str]] = None,
            refreshable_model: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutonomousDatabaseCloneFromDatabase':
        """
        Get an existing AutonomousDatabaseCloneFromDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_password: The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_addresses: Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] backup_retention_period_in_days: Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] character_set: The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] clone_type: The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.float] compute_count: The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.
               
               > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] customer_contacts: Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.int] data_storage_size_in_tb: The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_version: A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] database_workload: The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.bool] mtls_connection_required: Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] national_character_set: The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] refreshable_model: The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] source_autonomous_database_id: The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseCloneFromDatabaseState.__new__(_AutonomousDatabaseCloneFromDatabaseState)

        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["allowed_ip_addresses"] = allowed_ip_addresses
        __props__.__dict__["auto_scaling_enabled"] = auto_scaling_enabled
        __props__.__dict__["auto_scaling_for_storage_enabled"] = auto_scaling_for_storage_enabled
        __props__.__dict__["backup_retention_period_in_days"] = backup_retention_period_in_days
        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["clone_type"] = clone_type
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["customer_contacts"] = customer_contacts
        __props__.__dict__["data_storage_size_in_tb"] = data_storage_size_in_tb
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["database_workload"] = database_workload
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["location"] = location
        __props__.__dict__["mtls_connection_required"] = mtls_connection_required
        __props__.__dict__["name"] = name
        __props__.__dict__["national_character_set"] = national_character_set
        __props__.__dict__["refreshable_model"] = refreshable_model
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["source_autonomous_database_id"] = source_autonomous_database_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return AutonomousDatabaseCloneFromDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the SYS, SYSTEM, and PDB Admin users. The password must be at least 12 characters long, and contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (`"`) or the username "admin", regardless of casing. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="allowedIpAddresses")
    def allowed_ip_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines the network access type for the Autonomous Database. If the property is explicitly set to an empty list, it allows secure public access to the database from any IP address. If specific ACL (Access Control List) values are provided, access will be restricted to only the specified IP addresses. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "allowed_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database CPU core count. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @_builtins.property
    @pulumi.getter(name="autoScalingForStorageEnabled")
    def auto_scaling_for_storage_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if auto scaling is enabled for the Autonomous Database storage. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "auto_scaling_for_storage_enabled")

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Retention period, in days, for backups. Possible values range between `1` and `60`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[_builtins.str]:
        """
        The character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of clone to create. Possible values are `Full` and `Metadata`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "clone_type")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[_builtins.float]:
        """
        The compute amount (CPUs) available to the database. Possible values range between `2.0` and `512.0`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The compute model of the Autonomous Database. Possible values are `ECPU` and `OCPU`. Changing this forces a new Autonomous Database Clone to be created.

        > **Note:** `ECPU` compute model is the recommended model and `OCPU` compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of customer contacts as email addresses. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "customer_contacts")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTb")
    def data_storage_size_in_tb(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum storage that can be allocated for the database, in terabytes. Possible values range between `1` and `384`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "data_storage_size_in_tb")

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[_builtins.str]:
        """
        A valid Oracle Database version for Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "database_version")

    @_builtins.property
    @pulumi.getter(name="databaseWorkload")
    def database_workload(self) -> pulumi.Output[_builtins.str]:
        """
        The Autonomous Database workload type. Possible values are `OLTP` and `DW`, `APEX`, `AJD`. Changing this forces a new Autonomous Database Clone to be created.
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        > **Note:** To clone the database with a different `database_workload` type, please refer to the documentation [here](https://docs.public.oneportal.content.oci.oraclecloud.com/iaas/autonomous-database-serverless/doc/autonomous-clone-cross-workload-type.html#GUID-527A712D-FF82-498B-AB35-8A1623E36EDD) for correct configuration steps.
        """
        return pulumi.get(self, "database_workload")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the Autonomous Database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Possible values are `LicenseIncluded` and `BringYourOwnLicense`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Autonomous Database should exist. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mtlsConnectionRequired")
    def mtls_connection_required(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the Autonomous Database requires mTLS connections. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "mtls_connection_required")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this autonomous database clone from database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nationalCharacterSet")
    def national_character_set(self) -> pulumi.Output[_builtins.str]:
        """
        The national character set for the autonomous database. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "national_character_set")

    @_builtins.property
    @pulumi.getter(name="refreshableModel")
    def refreshable_model(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The refreshable model for the clone. Possible values are `Automatic` and `Manual`. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "refreshable_model")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the autonomous database clone from database should exist. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sourceAutonomousDatabaseId")
    def source_autonomous_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the source Autonomous Database to clone from. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "source_autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the subnet the resource is associated with. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Autonomous Database Clone. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Virtual Network this Autonomous Database Clone should be created in. Changing this forces a new Autonomous Database Clone to be created.
        """
        return pulumi.get(self, "virtual_network_id")

