# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudVmClusterArgs', 'CloudVmCluster']

@pulumi.input_type
class CloudVmClusterArgs:
    def __init__(__self__, *,
                 cloud_exadata_infrastructure_id: pulumi.Input[_builtins.str],
                 cpu_core_count: pulumi.Input[_builtins.int],
                 db_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 display_name: pulumi.Input[_builtins.str],
                 gi_version: pulumi.Input[_builtins.str],
                 hostname: pulumi.Input[_builtins.str],
                 license_model: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 ssh_public_keys: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 subnet_id: pulumi.Input[_builtins.str],
                 virtual_network_id: pulumi.Input[_builtins.str],
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_options: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]]] = None,
                 local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[_builtins.int]] = None,
                 sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudVmCluster resource.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] gi_version: A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] backup_subnet_cidr: The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input['CloudVmClusterDataCollectionOptionsArgs'] data_collection_options: A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] domain: The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]] file_system_configurations: A `file_system_configuration` block as defined below.
        :param pulumi.Input[_builtins.bool] local_backup_enabled: If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] sparse_diskgroup_enabled: If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] zone_id: The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "db_servers", db_servers)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gi_version", gi_version)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "license_model", license_model)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)
        if backup_subnet_cidr is not None:
            pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if file_system_configurations is not None:
            pulumi.set(__self__, "file_system_configurations", file_system_configurations)
        if local_backup_enabled is not None:
            pulumi.set(__self__, "local_backup_enabled", local_backup_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scan_listener_port_tcp is not None:
            pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl is not None:
            pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "sparse_diskgroup_enabled", sparse_diskgroup_enabled)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Input[_builtins.int]:
        """
        The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Input[_builtins.str]:
        """
        A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Input[_builtins.str]:
        """
        The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_network_id", value)

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @backup_subnet_cidr.setter
    def backup_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]:
        """
        A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurations")
    def file_system_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]]]:
        """
        A `file_system_configuration` block as defined below.
        """
        return pulumi.get(self, "file_system_configurations")

    @file_system_configurations.setter
    def file_system_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]]]):
        pulumi.set(self, "file_system_configurations", value)

    @_builtins.property
    @pulumi.getter(name="localBackupEnabled")
    def local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "local_backup_enabled")

    @local_backup_enabled.setter
    def local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tcp", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @scan_listener_port_tcp_ssl.setter
    def scan_listener_port_tcp_ssl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tcp_ssl", value)

    @_builtins.property
    @pulumi.getter(name="sparseDiskgroupEnabled")
    def sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "sparse_diskgroup_enabled")

    @sparse_diskgroup_enabled.setter
    def sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Cloud VM Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _CloudVmClusterState:
    def __init__(__self__, *,
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_actual: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[_builtins.int]] = None,
                 sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudVmCluster resources.
        :param pulumi.Input[_builtins.str] backup_subnet_cidr: The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input['CloudVmClusterDataCollectionOptionsArgs'] data_collection_options: A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] domain: The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]] file_system_configurations: A `file_system_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] gi_version: A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] hostname_actual: The hostname for the Cloud VM Cluster with suffix.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] local_backup_enabled: If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] ocid: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] sparse_diskgroup_enabled: If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] zone_id: The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        if backup_subnet_cidr is not None:
            pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if file_system_configurations is not None:
            pulumi.set(__self__, "file_system_configurations", file_system_configurations)
        if gi_version is not None:
            pulumi.set(__self__, "gi_version", gi_version)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hostname_actual is not None:
            pulumi.set(__self__, "hostname_actual", hostname_actual)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if local_backup_enabled is not None:
            pulumi.set(__self__, "local_backup_enabled", local_backup_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scan_listener_port_tcp is not None:
            pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if scan_listener_port_tcp_ssl is not None:
            pulumi.set(__self__, "scan_listener_port_tcp_ssl", scan_listener_port_tcp_ssl)
        if sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "sparse_diskgroup_enabled", sparse_diskgroup_enabled)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @backup_subnet_cidr.setter
    def backup_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]:
        """
        A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurations")
    def file_system_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]]]:
        """
        A `file_system_configuration` block as defined below.
        """
        return pulumi.get(self, "file_system_configurations")

    @file_system_configurations.setter
    def file_system_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterFileSystemConfigurationArgs']]]]):
        pulumi.set(self, "file_system_configurations", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="hostnameActual")
    def hostname_actual(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname for the Cloud VM Cluster with suffix.
        """
        return pulumi.get(self, "hostname_actual")

    @hostname_actual.setter
    def hostname_actual(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname_actual", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="localBackupEnabled")
    def local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "local_backup_enabled")

    @local_backup_enabled.setter
    def local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud VM Cluster.
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocid", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tcp", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @scan_listener_port_tcp_ssl.setter
    def scan_listener_port_tcp_ssl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tcp_ssl", value)

    @_builtins.property
    @pulumi.getter(name="sparseDiskgroupEnabled")
    def sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "sparse_diskgroup_enabled")

    @sparse_diskgroup_enabled.setter
    def sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Cloud VM Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("azure:oracle/cloudVmCluster:CloudVmCluster")
class CloudVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']]] = None,
                 data_storage_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterFileSystemConfigurationArgs', 'CloudVmClusterFileSystemConfigurationArgsDict']]]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[_builtins.int]] = None,
                 sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cloud VM Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_exadata_infrastructure = azure.oracle.ExadataInfrastructure("example",
            name="example-exadata-infrastructure",
            display_name="example-exadata-infrastructure",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            shape="Exadata.X9M",
            storage_count=3,
            compute_count=2,
            zones=["3"])
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtual-network",
            address_spaces=["10.0.0.0/16"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                    "name": "Oracle.Database/networkAttachments",
                },
            }])
        example = azure.oracle.get_db_servers_output(resource_group_name=example_resource_group.name,
            cloud_exadata_infrastructure_name=example_exadata_infrastructure.name)
        example_cloud_vm_cluster = azure.oracle.CloudVmCluster("example",
            name="example-cloud-vm-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            gi_version="23.0.0.0",
            virtual_network_id=example_virtual_network.id,
            license_model="BringYourOwnLicense",
            db_servers=example.apply(lambda example: [obj.ocid for obj in example.db_servers]),
            ssh_public_keys=[std.file(input="~/.ssh/id_rsa.pub").result],
            display_name="example-cloud-vm-cluster",
            cloud_exadata_infrastructure_id=example_exadata_infrastructure.id,
            cpu_core_count=2,
            hostname="hostname",
            subnet_id=example_subnet.id,
            system_version="23.1.19.0.0.241015",
            file_system_configurations=[{
                "mount_point": "/var",
                "size_in_gb": 32,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        Cloud VM Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/cloudVmCluster:CloudVmCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/cloudVmClusters/cloudVmClusters1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_subnet_cidr: The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']] data_collection_options: A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] domain: The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterFileSystemConfigurationArgs', 'CloudVmClusterFileSystemConfigurationArgsDict']]]] file_system_configurations: A `file_system_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] gi_version: A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] local_backup_enabled: If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] sparse_diskgroup_enabled: If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] zone_id: The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud VM Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_exadata_infrastructure = azure.oracle.ExadataInfrastructure("example",
            name="example-exadata-infrastructure",
            display_name="example-exadata-infrastructure",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            shape="Exadata.X9M",
            storage_count=3,
            compute_count=2,
            zones=["3"])
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtual-network",
            address_spaces=["10.0.0.0/16"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                    "name": "Oracle.Database/networkAttachments",
                },
            }])
        example = azure.oracle.get_db_servers_output(resource_group_name=example_resource_group.name,
            cloud_exadata_infrastructure_name=example_exadata_infrastructure.name)
        example_cloud_vm_cluster = azure.oracle.CloudVmCluster("example",
            name="example-cloud-vm-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            gi_version="23.0.0.0",
            virtual_network_id=example_virtual_network.id,
            license_model="BringYourOwnLicense",
            db_servers=example.apply(lambda example: [obj.ocid for obj in example.db_servers]),
            ssh_public_keys=[std.file(input="~/.ssh/id_rsa.pub").result],
            display_name="example-cloud-vm-cluster",
            cloud_exadata_infrastructure_id=example_exadata_infrastructure.id,
            cpu_core_count=2,
            hostname="hostname",
            subnet_id=example_subnet.id,
            system_version="23.1.19.0.0.241015",
            file_system_configurations=[{
                "mount_point": "/var",
                "size_in_gb": 32,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        Cloud VM Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/cloudVmCluster:CloudVmCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/cloudVmClusters/cloudVmClusters1
        ```

        :param str resource_name: The name of the resource.
        :param CloudVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']]] = None,
                 data_storage_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterFileSystemConfigurationArgs', 'CloudVmClusterFileSystemConfigurationArgsDict']]]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tcp_ssl: Optional[pulumi.Input[_builtins.int]] = None,
                 sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudVmClusterArgs.__new__(CloudVmClusterArgs)

            __props__.__dict__["backup_subnet_cidr"] = backup_subnet_cidr
            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            __props__.__dict__["cluster_name"] = cluster_name
            if cpu_core_count is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_core_count'")
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["data_collection_options"] = data_collection_options
            __props__.__dict__["data_storage_percentage"] = data_storage_percentage
            __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
            __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
            if db_servers is None and not opts.urn:
                raise TypeError("Missing required property 'db_servers'")
            __props__.__dict__["db_servers"] = db_servers
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain"] = domain
            __props__.__dict__["file_system_configurations"] = file_system_configurations
            if gi_version is None and not opts.urn:
                raise TypeError("Missing required property 'gi_version'")
            __props__.__dict__["gi_version"] = gi_version
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if license_model is None and not opts.urn:
                raise TypeError("Missing required property 'license_model'")
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["local_backup_enabled"] = local_backup_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["scan_listener_port_tcp"] = scan_listener_port_tcp
            __props__.__dict__["scan_listener_port_tcp_ssl"] = scan_listener_port_tcp_ssl
            __props__.__dict__["sparse_diskgroup_enabled"] = sparse_diskgroup_enabled
            if ssh_public_keys is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_public_keys'")
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["system_version"] = system_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            if virtual_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_network_id'")
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["hostname_actual"] = None
            __props__.__dict__["ocid"] = None
        super(CloudVmCluster, __self__).__init__(
            'azure:oracle/cloudVmCluster:CloudVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
            data_collection_options: Optional[pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']]] = None,
            data_storage_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterFileSystemConfigurationArgs', 'CloudVmClusterFileSystemConfigurationArgsDict']]]]] = None,
            gi_version: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            hostname_actual: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ocid: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
            scan_listener_port_tcp_ssl: Optional[pulumi.Input[_builtins.int]] = None,
            sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_version: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudVmCluster':
        """
        Get an existing CloudVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_subnet_cidr: The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] cluster_name: The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']] data_collection_options: A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] domain: The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterFileSystemConfigurationArgs', 'CloudVmClusterFileSystemConfigurationArgsDict']]]] file_system_configurations: A `file_system_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] gi_version: A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] hostname: The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] hostname_actual: The hostname for the Cloud VM Cluster with suffix.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] local_backup_enabled: If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] ocid: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.bool] sparse_diskgroup_enabled: If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Cloud VM Cluster.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        :param pulumi.Input[_builtins.str] zone_id: The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudVmClusterState.__new__(_CloudVmClusterState)

        __props__.__dict__["backup_subnet_cidr"] = backup_subnet_cidr
        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["data_storage_percentage"] = data_storage_percentage
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["file_system_configurations"] = file_system_configurations
        __props__.__dict__["gi_version"] = gi_version
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["hostname_actual"] = hostname_actual
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["local_backup_enabled"] = local_backup_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["name"] = name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scan_listener_port_tcp"] = scan_listener_port_tcp
        __props__.__dict__["scan_listener_port_tcp_ssl"] = scan_listener_port_tcp_ssl
        __props__.__dict__["sparse_diskgroup_enabled"] = sparse_diskgroup_enabled
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_version"] = system_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        __props__.__dict__["zone_id"] = zone_id
        return CloudVmCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backup subnet CIDR of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster name for Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of CPU cores enabled on the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output['outputs.CloudVmClusterDataCollectionOptions']:
        """
        A `data_collection_options` block as defined below. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "data_collection_options")

    @_builtins.property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The percentage assigned to DATA storage (user data and database files). Changing this forces a new Cloud VM Cluster to be created. The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are `35`, `40`, `60` and `80`.
        """
        return pulumi.get(self, "data_storage_percentage")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The data disk group size to be allocated in TBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The local node storage to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of DB servers. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurations")
    def file_system_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.CloudVmClusterFileSystemConfiguration']]]:
        """
        A `file_system_configuration` block as defined below.
        """
        return pulumi.get(self, "file_system_configurations")

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Output[_builtins.str]:
        """
        A valid Oracle Grid Infrastructure (GI) software version. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "gi_version")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname for the Cloud VM Cluster without suffix. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hostnameActual")
    def hostname_actual(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname for the Cloud VM Cluster with suffix.
        """
        return pulumi.get(self, "hostname_actual")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle license model that applies to the Cloud VM Cluster, either `BringYourOwnLicense` or `LicenseIncluded`. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter(name="localBackupEnabled")
    def local_backup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, database backup on local Exadata storage is configured for the Cloud VM Cluster. If `false`, database backup on local Exadata storage is not available in the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "local_backup_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The memory to be allocated in GBs. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud VM Cluster.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Cloud VM Cluster should exist. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The TCP Single Client Access Name (SCAN) port. The default port to 1521. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcpSsl")
    def scan_listener_port_tcp_ssl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The TCPS Single Client Access Name (SCAN) port. The default port to 2484. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "scan_listener_port_tcp_ssl")

    @_builtins.property
    @pulumi.getter(name="sparseDiskgroupEnabled")
    def sparse_diskgroup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the sparse disk group is configured for the Cloud VM Cluster. If `false`, the sparse disk group is not created. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "sparse_diskgroup_enabled")

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The public key portion of one or more key pairs used for SSH access to the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "ssh_public_keys")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subnet associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system version of the Exadata image. System version must be <= Db server major version (the first two parts of the DB server version eg 23.1.X.X.XXXX). Accepted Values for Grid Infrastructure (GI) version 19.0.0.0 are 22.1.30.0.0.241204, 22.1.32.0.0.250205, 22.1.31.0.0.250110, 23.1.20.0.0.241112, 23.1.21.0.0.241204, 23.1.22.0.0.250119, 23.1.23.0.0.250207. For Grid Infrastructure (GI) version 23.0.0.0 allowed system versions are 23.1.19.0.0.241015, 23.1.20.0.0.241112, 23.1.22.0.0.250119, 23.1.21.0.0.241204, 23.1.23.0.0.250207.
        """
        return pulumi.get(self, "system_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Cloud VM Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone of the Cloud VM Cluster. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Network associated with the Cloud VM Cluster. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "virtual_network_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the OCI Private DNS Zone to be associated with the Cloud VM Cluster. This is required for specifying your own private domain name. Changing this forces a new Cloud VM Cluster to be created.
        """
        return pulumi.get(self, "zone_id")

