# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExascaleDatabaseStorageVaultArgs', 'ExascaleDatabaseStorageVault']

@pulumi.input_type
class ExascaleDatabaseStorageVaultArgs:
    def __init__(__self__, *,
                 additional_flash_cache_percentage: pulumi.Input[_builtins.int],
                 display_name: pulumi.Input[_builtins.str],
                 high_capacity_database_storage: pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExascaleDatabaseStorageVault resource.
        :param pulumi.Input[_builtins.int] additional_flash_cache_percentage: The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs'] high_capacity_database_storage: A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] description: Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        :param pulumi.Input[_builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        """
        pulumi.set(__self__, "additional_flash_cache_percentage", additional_flash_cache_percentage)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "high_capacity_database_storage", high_capacity_database_storage)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "zones", zones)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="additionalFlashCachePercentage")
    def additional_flash_cache_percentage(self) -> pulumi.Input[_builtins.int]:
        """
        The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "additional_flash_cache_percentage")

    @additional_flash_cache_percentage.setter
    def additional_flash_cache_percentage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "additional_flash_cache_percentage", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="highCapacityDatabaseStorage")
    def high_capacity_database_storage(self) -> pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs']:
        """
        A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "high_capacity_database_storage")

    @high_capacity_database_storage.setter
    def high_capacity_database_storage(self, value: pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs']):
        pulumi.set(self, "high_capacity_database_storage", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "zones", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _ExascaleDatabaseStorageVaultState:
    def __init__(__self__, *,
                 additional_flash_cache_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_capacity_database_storage: Optional[pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ExascaleDatabaseStorageVault resources.
        :param pulumi.Input[_builtins.int] additional_flash_cache_percentage: The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] description: Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs'] high_capacity_database_storage: A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        :param pulumi.Input[_builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        if additional_flash_cache_percentage is not None:
            pulumi.set(__self__, "additional_flash_cache_percentage", additional_flash_cache_percentage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if high_capacity_database_storage is not None:
            pulumi.set(__self__, "high_capacity_database_storage", high_capacity_database_storage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="additionalFlashCachePercentage")
    def additional_flash_cache_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "additional_flash_cache_percentage")

    @additional_flash_cache_percentage.setter
    def additional_flash_cache_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "additional_flash_cache_percentage", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="highCapacityDatabaseStorage")
    def high_capacity_database_storage(self) -> Optional[pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs']]:
        """
        A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "high_capacity_database_storage")

    @high_capacity_database_storage.setter
    def high_capacity_database_storage(self, value: Optional[pulumi.Input['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs']]):
        pulumi.set(self, "high_capacity_database_storage", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:oracle/exascaleDatabaseStorageVault:ExascaleDatabaseStorageVault")
class ExascaleDatabaseStorageVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_flash_cache_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_capacity_database_storage: Optional[pulumi.Input[Union['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Exadata Database Storage Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_exascale_database_storage_vault = azure.oracle.ExascaleDatabaseStorageVault("example",
            name="example-exascale-db-storage-vault",
            resource_group_name=example.name,
            location=example.location,
            zones=["1"],
            display_name="example-exascale-db-storage-vault",
            description="description",
            additional_flash_cache_percentage=100,
            high_capacity_database_storage={
                "total_size_in_gb": 300,
            },
            time_zone="UTC")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        Exadata Database Storage Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/exascaleDatabaseStorageVault:ExascaleDatabaseStorageVault example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/exascaleDbStorageVaults/exascaleDbStorageVaults1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] additional_flash_cache_percentage: The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] description: Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Union['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgsDict']] high_capacity_database_storage: A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        :param pulumi.Input[_builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExascaleDatabaseStorageVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Exadata Database Storage Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_exascale_database_storage_vault = azure.oracle.ExascaleDatabaseStorageVault("example",
            name="example-exascale-db-storage-vault",
            resource_group_name=example.name,
            location=example.location,
            zones=["1"],
            display_name="example-exascale-db-storage-vault",
            description="description",
            additional_flash_cache_percentage=100,
            high_capacity_database_storage={
                "total_size_in_gb": 300,
            },
            time_zone="UTC")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Oracle.Database` - 2025-09-01

        ## Import

        Exadata Database Storage Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:oracle/exascaleDatabaseStorageVault:ExascaleDatabaseStorageVault example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/exascaleDbStorageVaults/exascaleDbStorageVaults1
        ```

        :param str resource_name: The name of the resource.
        :param ExascaleDatabaseStorageVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExascaleDatabaseStorageVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_flash_cache_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_capacity_database_storage: Optional[pulumi.Input[Union['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExascaleDatabaseStorageVaultArgs.__new__(ExascaleDatabaseStorageVaultArgs)

            if additional_flash_cache_percentage is None and not opts.urn:
                raise TypeError("Missing required property 'additional_flash_cache_percentage'")
            __props__.__dict__["additional_flash_cache_percentage"] = additional_flash_cache_percentage
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if high_capacity_database_storage is None and not opts.urn:
                raise TypeError("Missing required property 'high_capacity_database_storage'")
            __props__.__dict__["high_capacity_database_storage"] = high_capacity_database_storage
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            if zones is None and not opts.urn:
                raise TypeError("Missing required property 'zones'")
            __props__.__dict__["zones"] = zones
        super(ExascaleDatabaseStorageVault, __self__).__init__(
            'azure:oracle/exascaleDatabaseStorageVault:ExascaleDatabaseStorageVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_flash_cache_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            high_capacity_database_storage: Optional[pulumi.Input[Union['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ExascaleDatabaseStorageVault':
        """
        Get an existing ExascaleDatabaseStorageVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] additional_flash_cache_percentage: The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] description: Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Union['ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDatabaseStorageVaultHighCapacityDatabaseStorageArgsDict']] high_capacity_database_storage: A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        :param pulumi.Input[_builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExascaleDatabaseStorageVaultState.__new__(_ExascaleDatabaseStorageVaultState)

        __props__.__dict__["additional_flash_cache_percentage"] = additional_flash_cache_percentage
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["high_capacity_database_storage"] = high_capacity_database_storage
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["zones"] = zones
        return ExascaleDatabaseStorageVault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalFlashCachePercentage")
    def additional_flash_cache_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The size of additional Flash Cache in percentage of High Capacity database storage. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "additional_flash_cache_percentage")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Exadata Database Storage Vault description. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the Exadata Database Storage Vault resource. The name does not need to be unique. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="highCapacityDatabaseStorage")
    def high_capacity_database_storage(self) -> pulumi.Output['outputs.ExascaleDatabaseStorageVaultHighCapacityDatabaseStorage']:
        """
        A `high_capacity_database_storage` block as defined below. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "high_capacity_database_storage")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Exadata Database Storage Vault should exist. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. Changing this forces a new Exadata Database Storage Vault to be created. For details, see [Time Zones](https://docs.oracle.com/en/cloud/paas/base-database/time-zone/).
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Exadata Database Storage Vault zones. Changing this forces a new Exadata Database Storage Vault to be created.
        """
        return pulumi.get(self, "zones")

