# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAutonomousDatabaseBackupResult',
    'AwaitableGetAutonomousDatabaseBackupResult',
    'get_autonomous_database_backup',
    'get_autonomous_database_backup_output',
]

@pulumi.output_type
class GetAutonomousDatabaseBackupResult:
    """
    A collection of values returned by getAutonomousDatabaseBackup.
    """
    def __init__(__self__, automatic=None, autonomous_database_backup_ocid=None, autonomous_database_id=None, autonomous_database_ocid=None, database_backup_size_in_tbs=None, database_version=None, display_name=None, id=None, lifecycle_details=None, lifecycle_state=None, location=None, name=None, provisioning_state=None, restorable=None, retention_period_in_days=None, time_available_til=None, time_ended=None, time_started=None, type=None):
        if automatic and not isinstance(automatic, bool):
            raise TypeError("Expected argument 'automatic' to be a bool")
        pulumi.set(__self__, "automatic", automatic)
        if autonomous_database_backup_ocid and not isinstance(autonomous_database_backup_ocid, str):
            raise TypeError("Expected argument 'autonomous_database_backup_ocid' to be a str")
        pulumi.set(__self__, "autonomous_database_backup_ocid", autonomous_database_backup_ocid)
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if autonomous_database_ocid and not isinstance(autonomous_database_ocid, str):
            raise TypeError("Expected argument 'autonomous_database_ocid' to be a str")
        pulumi.set(__self__, "autonomous_database_ocid", autonomous_database_ocid)
        if database_backup_size_in_tbs and not isinstance(database_backup_size_in_tbs, float):
            raise TypeError("Expected argument 'database_backup_size_in_tbs' to be a float")
        pulumi.set(__self__, "database_backup_size_in_tbs", database_backup_size_in_tbs)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_state and not isinstance(lifecycle_state, str):
            raise TypeError("Expected argument 'lifecycle_state' to be a str")
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if restorable and not isinstance(restorable, bool):
            raise TypeError("Expected argument 'restorable' to be a bool")
        pulumi.set(__self__, "restorable", restorable)
        if retention_period_in_days and not isinstance(retention_period_in_days, int):
            raise TypeError("Expected argument 'retention_period_in_days' to be a int")
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if time_available_til and not isinstance(time_available_til, str):
            raise TypeError("Expected argument 'time_available_til' to be a str")
        pulumi.set(__self__, "time_available_til", time_available_til)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def automatic(self) -> _builtins.bool:
        return pulumi.get(self, "automatic")

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseBackupOcid")
    def autonomous_database_backup_ocid(self) -> _builtins.str:
        """
        The backup OCID.
        """
        return pulumi.get(self, "autonomous_database_backup_ocid")

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> _builtins.str:
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseOcid")
    def autonomous_database_ocid(self) -> _builtins.str:
        """
        The OCID of the Autonomous Database OCID.
        """
        return pulumi.get(self, "autonomous_database_ocid")

    @_builtins.property
    @pulumi.getter(name="databaseBackupSizeInTbs")
    def database_backup_size_in_tbs(self) -> _builtins.float:
        return pulumi.get(self, "database_backup_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> _builtins.str:
        return pulumi.get(self, "database_version")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name of the backup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Autonomous Database Backup.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Information about the current lifecycle state of the backup.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> _builtins.str:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        `- The Azure Region where the Autonomous Database Backup exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> _builtins.str:
        """
        The current provisioning state of the Autonomous Database Backup.
        """
        return pulumi.get(self, "provisioning_state")

    @_builtins.property
    @pulumi.getter
    def restorable(self) -> _builtins.bool:
        return pulumi.get(self, "restorable")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> _builtins.int:
        """
        The retention period in days for the Autonomous Database Backup.
        """
        return pulumi.get(self, "retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="timeAvailableTil")
    def time_available_til(self) -> _builtins.str:
        """
        The date and time the backup will become unusable.
        """
        return pulumi.get(self, "time_available_til")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> _builtins.str:
        """
        The date and time the backup was completed.
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time the backup started.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetAutonomousDatabaseBackupResult(GetAutonomousDatabaseBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseBackupResult(
            automatic=self.automatic,
            autonomous_database_backup_ocid=self.autonomous_database_backup_ocid,
            autonomous_database_id=self.autonomous_database_id,
            autonomous_database_ocid=self.autonomous_database_ocid,
            database_backup_size_in_tbs=self.database_backup_size_in_tbs,
            database_version=self.database_version,
            display_name=self.display_name,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            lifecycle_state=self.lifecycle_state,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            restorable=self.restorable,
            retention_period_in_days=self.retention_period_in_days,
            time_available_til=self.time_available_til,
            time_ended=self.time_ended,
            time_started=self.time_started,
            type=self.type)


def get_autonomous_database_backup(autonomous_database_id: Optional[_builtins.str] = None,
                                   name: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseBackupResult:
    """
    Use this data source to access information about existing Autonomous Database Backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_autonomous_database_backup(autonomous_database_id=example_azurerm_oracle_autonomous_database["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-09-01


    :param _builtins.str autonomous_database_id: The azureId of the Autonomous Database for we will be listing the backups.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:oracle/getAutonomousDatabaseBackup:getAutonomousDatabaseBackup', __args__, opts=opts, typ=GetAutonomousDatabaseBackupResult).value

    return AwaitableGetAutonomousDatabaseBackupResult(
        automatic=pulumi.get(__ret__, 'automatic'),
        autonomous_database_backup_ocid=pulumi.get(__ret__, 'autonomous_database_backup_ocid'),
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        autonomous_database_ocid=pulumi.get(__ret__, 'autonomous_database_ocid'),
        database_backup_size_in_tbs=pulumi.get(__ret__, 'database_backup_size_in_tbs'),
        database_version=pulumi.get(__ret__, 'database_version'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_state=pulumi.get(__ret__, 'lifecycle_state'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        provisioning_state=pulumi.get(__ret__, 'provisioning_state'),
        restorable=pulumi.get(__ret__, 'restorable'),
        retention_period_in_days=pulumi.get(__ret__, 'retention_period_in_days'),
        time_available_til=pulumi.get(__ret__, 'time_available_til'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'),
        type=pulumi.get(__ret__, 'type'))
def get_autonomous_database_backup_output(autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          name: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseBackupResult]:
    """
    Use this data source to access information about existing Autonomous Database Backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_autonomous_database_backup(autonomous_database_id=example_azurerm_oracle_autonomous_database["id"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-09-01


    :param _builtins.str autonomous_database_id: The azureId of the Autonomous Database for we will be listing the backups.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:oracle/getAutonomousDatabaseBackup:getAutonomousDatabaseBackup', __args__, opts=opts, typ=GetAutonomousDatabaseBackupResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseBackupResult(
        automatic=pulumi.get(__response__, 'automatic'),
        autonomous_database_backup_ocid=pulumi.get(__response__, 'autonomous_database_backup_ocid'),
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        autonomous_database_ocid=pulumi.get(__response__, 'autonomous_database_ocid'),
        database_backup_size_in_tbs=pulumi.get(__response__, 'database_backup_size_in_tbs'),
        database_version=pulumi.get(__response__, 'database_version'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_state=pulumi.get(__response__, 'lifecycle_state'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        provisioning_state=pulumi.get(__response__, 'provisioning_state'),
        restorable=pulumi.get(__response__, 'restorable'),
        retention_period_in_days=pulumi.get(__response__, 'retention_period_in_days'),
        time_available_til=pulumi.get(__response__, 'time_available_til'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started'),
        type=pulumi.get(__response__, 'type')))
