# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbSystemShapesResult',
    'AwaitableGetDbSystemShapesResult',
    'get_db_system_shapes',
    'get_db_system_shapes_output',
]

@pulumi.output_type
class GetDbSystemShapesResult:
    """
    A collection of values returned by getDbSystemShapes.
    """
    def __init__(__self__, db_system_shapes=None, id=None, location=None, zone=None):
        if db_system_shapes and not isinstance(db_system_shapes, list):
            raise TypeError("Expected argument 'db_system_shapes' to be a list")
        pulumi.set(__self__, "db_system_shapes", db_system_shapes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="dbSystemShapes")
    def db_system_shapes(self) -> Sequence['outputs.GetDbSystemShapesDbSystemShapeResult']:
        """
        A `db_system_shapes` block as defined below.
        """
        return pulumi.get(self, "db_system_shapes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetDbSystemShapesResult(GetDbSystemShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemShapesResult(
            db_system_shapes=self.db_system_shapes,
            id=self.id,
            location=self.location,
            zone=self.zone)


def get_db_system_shapes(location: Optional[_builtins.str] = None,
                         zone: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemShapesResult:
    """
    This data source provides the list of DB System Shapes in Oracle Cloud Infrastructure Database service.

    Gets a list of the shapes that can be used to launch a new DB system. The shape determines resources to allocate to the DB system - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_db_system_shapes(location="eastus",
        zone="2")
    pulumi.export("example", example)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-09-01


    :param _builtins.str location: The Azure Region to query for the system shapes in.
    :param _builtins.str zone: The Cloud Exadata Infrastructure Azure zone, used to filter out the available DB System Shapes in the specific zone.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:oracle/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult).value

    return AwaitableGetDbSystemShapesResult(
        db_system_shapes=pulumi.get(__ret__, 'db_system_shapes'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        zone=pulumi.get(__ret__, 'zone'))
def get_db_system_shapes_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                                zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSystemShapesResult]:
    """
    This data source provides the list of DB System Shapes in Oracle Cloud Infrastructure Database service.

    Gets a list of the shapes that can be used to launch a new DB system. The shape determines resources to allocate to the DB system - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_db_system_shapes(location="eastus",
        zone="2")
    pulumi.export("example", example)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-09-01


    :param _builtins.str location: The Azure Region to query for the system shapes in.
    :param _builtins.str zone: The Cloud Exadata Infrastructure Azure zone, used to filter out the available DB System Shapes in the specific zone.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:oracle/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult)
    return __ret__.apply(lambda __response__: GetDbSystemShapesResult(
        db_system_shapes=pulumi.get(__response__, 'db_system_shapes'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        zone=pulumi.get(__response__, 'zone')))
