# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExascaleDatabaseStorageVaultResult',
    'AwaitableGetExascaleDatabaseStorageVaultResult',
    'get_exascale_database_storage_vault',
    'get_exascale_database_storage_vault_output',
]

@pulumi.output_type
class GetExascaleDatabaseStorageVaultResult:
    """
    A collection of values returned by getExascaleDatabaseStorageVault.
    """
    def __init__(__self__, additional_flash_cache_percentage=None, description=None, display_name=None, high_capacity_database_storages=None, id=None, lifecycle_details=None, lifecycle_state=None, location=None, name=None, oci_url=None, ocid=None, resource_group_name=None, time_zone=None, virtual_machine_cluster_count=None, zones=None):
        if additional_flash_cache_percentage and not isinstance(additional_flash_cache_percentage, int):
            raise TypeError("Expected argument 'additional_flash_cache_percentage' to be a int")
        pulumi.set(__self__, "additional_flash_cache_percentage", additional_flash_cache_percentage)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if high_capacity_database_storages and not isinstance(high_capacity_database_storages, list):
            raise TypeError("Expected argument 'high_capacity_database_storages' to be a list")
        pulumi.set(__self__, "high_capacity_database_storages", high_capacity_database_storages)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_state and not isinstance(lifecycle_state, str):
            raise TypeError("Expected argument 'lifecycle_state' to be a str")
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oci_url and not isinstance(oci_url, str):
            raise TypeError("Expected argument 'oci_url' to be a str")
        pulumi.set(__self__, "oci_url", oci_url)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if virtual_machine_cluster_count and not isinstance(virtual_machine_cluster_count, int):
            raise TypeError("Expected argument 'virtual_machine_cluster_count' to be a int")
        pulumi.set(__self__, "virtual_machine_cluster_count", virtual_machine_cluster_count)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="additionalFlashCachePercentage")
    def additional_flash_cache_percentage(self) -> _builtins.int:
        """
        The size of additional Flash Cache in percentage of High Capacity database storage.
        """
        return pulumi.get(self, "additional_flash_cache_percentage")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Exadata Database Storage Vault description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="highCapacityDatabaseStorages")
    def high_capacity_database_storages(self) -> Sequence['outputs.GetExascaleDatabaseStorageVaultHighCapacityDatabaseStorageResult']:
        """
        A `high_capacity_database_storage` block as defined below.
        """
        return pulumi.get(self, "high_capacity_database_storages")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> _builtins.str:
        """
        Exadata Database Storage Vault lifecycle state enum.
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Exadata Database Storage Vault exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> _builtins.str:
        """
        The URL of the resource in the OCI console.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The [OCID](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The time zone of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="virtualMachineClusterCount")
    def virtual_machine_cluster_count(self) -> _builtins.int:
        """
        The number of Exadata virtual machine clusters used the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "virtual_machine_cluster_count")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence[_builtins.str]:
        """
        The Exadata Database Storage Vault Azure zones.
        """
        return pulumi.get(self, "zones")


class AwaitableGetExascaleDatabaseStorageVaultResult(GetExascaleDatabaseStorageVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExascaleDatabaseStorageVaultResult(
            additional_flash_cache_percentage=self.additional_flash_cache_percentage,
            description=self.description,
            display_name=self.display_name,
            high_capacity_database_storages=self.high_capacity_database_storages,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            lifecycle_state=self.lifecycle_state,
            location=self.location,
            name=self.name,
            oci_url=self.oci_url,
            ocid=self.ocid,
            resource_group_name=self.resource_group_name,
            time_zone=self.time_zone,
            virtual_machine_cluster_count=self.virtual_machine_cluster_count,
            zones=self.zones)


def get_exascale_database_storage_vault(name: Optional[_builtins.str] = None,
                                        resource_group_name: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExascaleDatabaseStorageVaultResult:
    """
    Use this data source to access information about an existing Exadata Database Storage Vault

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_exascale_database_storage_vault(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-09-01


    :param _builtins.str name: The name of this Exadata Database Storage Vault.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Exadata Database Storage Vault exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:oracle/getExascaleDatabaseStorageVault:getExascaleDatabaseStorageVault', __args__, opts=opts, typ=GetExascaleDatabaseStorageVaultResult).value

    return AwaitableGetExascaleDatabaseStorageVaultResult(
        additional_flash_cache_percentage=pulumi.get(__ret__, 'additional_flash_cache_percentage'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        high_capacity_database_storages=pulumi.get(__ret__, 'high_capacity_database_storages'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_state=pulumi.get(__ret__, 'lifecycle_state'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        oci_url=pulumi.get(__ret__, 'oci_url'),
        ocid=pulumi.get(__ret__, 'ocid'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        virtual_machine_cluster_count=pulumi.get(__ret__, 'virtual_machine_cluster_count'),
        zones=pulumi.get(__ret__, 'zones'))
def get_exascale_database_storage_vault_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExascaleDatabaseStorageVaultResult]:
    """
    Use this data source to access information about an existing Exadata Database Storage Vault

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_exascale_database_storage_vault(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-09-01


    :param _builtins.str name: The name of this Exadata Database Storage Vault.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Exadata Database Storage Vault exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:oracle/getExascaleDatabaseStorageVault:getExascaleDatabaseStorageVault', __args__, opts=opts, typ=GetExascaleDatabaseStorageVaultResult)
    return __ret__.apply(lambda __response__: GetExascaleDatabaseStorageVaultResult(
        additional_flash_cache_percentage=pulumi.get(__response__, 'additional_flash_cache_percentage'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        high_capacity_database_storages=pulumi.get(__response__, 'high_capacity_database_storages'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_state=pulumi.get(__response__, 'lifecycle_state'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        oci_url=pulumi.get(__response__, 'oci_url'),
        ocid=pulumi.get(__response__, 'ocid'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        time_zone=pulumi.get(__response__, 'time_zone'),
        virtual_machine_cluster_count=pulumi.get(__response__, 'virtual_machine_cluster_count'),
        zones=pulumi.get(__response__, 'zones')))
