# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ContactProfileLinkArgs',
    'ContactProfileLinkArgsDict',
    'ContactProfileLinkChannelArgs',
    'ContactProfileLinkChannelArgsDict',
    'ContactProfileLinkChannelEndPointArgs',
    'ContactProfileLinkChannelEndPointArgsDict',
    'SpacecraftLinkArgs',
    'SpacecraftLinkArgsDict',
]

MYPY = False

if not MYPY:
    class ContactProfileLinkArgsDict(TypedDict):
        channels: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgsDict']]]
        """
        A list of contact profile link channels. A `channels` block as defined below.
        """
        direction: pulumi.Input[_builtins.str]
        """
        Direction of the link. Possible values are `Uplink` and `Downlink`.
        """
        name: pulumi.Input[_builtins.str]
        """
        Name of the link.
        """
        polarization: pulumi.Input[_builtins.str]
        """
        Polarization of the link. Possible values are `LHCP`, `RHCP`, `linearVertical` and `linearHorizontal`.
        """
elif False:
    ContactProfileLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContactProfileLinkArgs:
    def __init__(__self__, *,
                 channels: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]],
                 direction: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 polarization: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]] channels: A list of contact profile link channels. A `channels` block as defined below.
        :param pulumi.Input[_builtins.str] direction: Direction of the link. Possible values are `Uplink` and `Downlink`.
        :param pulumi.Input[_builtins.str] name: Name of the link.
        :param pulumi.Input[_builtins.str] polarization: Polarization of the link. Possible values are `LHCP`, `RHCP`, `linearVertical` and `linearHorizontal`.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "polarization", polarization)

    @_builtins.property
    @pulumi.getter
    def channels(self) -> pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]]:
        """
        A list of contact profile link channels. A `channels` block as defined below.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]]):
        pulumi.set(self, "channels", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        Direction of the link. Possible values are `Uplink` and `Downlink`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def polarization(self) -> pulumi.Input[_builtins.str]:
        """
        Polarization of the link. Possible values are `LHCP`, `RHCP`, `linearVertical` and `linearHorizontal`.
        """
        return pulumi.get(self, "polarization")

    @polarization.setter
    def polarization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "polarization", value)


if not MYPY:
    class ContactProfileLinkChannelArgsDict(TypedDict):
        bandwidth_mhz: pulumi.Input[_builtins.float]
        """
        Bandwidth in MHz.
        """
        center_frequency_mhz: pulumi.Input[_builtins.float]
        """
        Center frequency in MHz.
        """
        end_points: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelEndPointArgsDict']]]
        """
        Customer End point to store/retrieve data during a contact. An `end_point` block as defined below.
        """
        name: pulumi.Input[_builtins.str]
        """
        Name of the channel.
        """
        demodulation_configuration: NotRequired[pulumi.Input[_builtins.str]]
        """
        Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        """
        modulation_configuration: NotRequired[pulumi.Input[_builtins.str]]
        """
        Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
elif False:
    ContactProfileLinkChannelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContactProfileLinkChannelArgs:
    def __init__(__self__, *,
                 bandwidth_mhz: pulumi.Input[_builtins.float],
                 center_frequency_mhz: pulumi.Input[_builtins.float],
                 end_points: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelEndPointArgs']]],
                 name: pulumi.Input[_builtins.str],
                 demodulation_configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 modulation_configuration: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.float] bandwidth_mhz: Bandwidth in MHz.
        :param pulumi.Input[_builtins.float] center_frequency_mhz: Center frequency in MHz.
        :param pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelEndPointArgs']]] end_points: Customer End point to store/retrieve data during a contact. An `end_point` block as defined below.
        :param pulumi.Input[_builtins.str] name: Name of the channel.
        :param pulumi.Input[_builtins.str] demodulation_configuration: Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        :param pulumi.Input[_builtins.str] modulation_configuration: Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
        pulumi.set(__self__, "bandwidth_mhz", bandwidth_mhz)
        pulumi.set(__self__, "center_frequency_mhz", center_frequency_mhz)
        pulumi.set(__self__, "end_points", end_points)
        pulumi.set(__self__, "name", name)
        if demodulation_configuration is not None:
            pulumi.set(__self__, "demodulation_configuration", demodulation_configuration)
        if modulation_configuration is not None:
            pulumi.set(__self__, "modulation_configuration", modulation_configuration)

    @_builtins.property
    @pulumi.getter(name="bandwidthMhz")
    def bandwidth_mhz(self) -> pulumi.Input[_builtins.float]:
        """
        Bandwidth in MHz.
        """
        return pulumi.get(self, "bandwidth_mhz")

    @bandwidth_mhz.setter
    def bandwidth_mhz(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "bandwidth_mhz", value)

    @_builtins.property
    @pulumi.getter(name="centerFrequencyMhz")
    def center_frequency_mhz(self) -> pulumi.Input[_builtins.float]:
        """
        Center frequency in MHz.
        """
        return pulumi.get(self, "center_frequency_mhz")

    @center_frequency_mhz.setter
    def center_frequency_mhz(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "center_frequency_mhz", value)

    @_builtins.property
    @pulumi.getter(name="endPoints")
    def end_points(self) -> pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelEndPointArgs']]]:
        """
        Customer End point to store/retrieve data during a contact. An `end_point` block as defined below.
        """
        return pulumi.get(self, "end_points")

    @end_points.setter
    def end_points(self, value: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelEndPointArgs']]]):
        pulumi.set(self, "end_points", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the channel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="demodulationConfiguration")
    def demodulation_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        """
        return pulumi.get(self, "demodulation_configuration")

    @demodulation_configuration.setter
    def demodulation_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demodulation_configuration", value)

    @_builtins.property
    @pulumi.getter(name="modulationConfiguration")
    def modulation_configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
        return pulumi.get(self, "modulation_configuration")

    @modulation_configuration.setter
    def modulation_configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modulation_configuration", value)


if not MYPY:
    class ContactProfileLinkChannelEndPointArgsDict(TypedDict):
        end_point_name: pulumi.Input[_builtins.str]
        """
        Name of an end point.
        """
        port: pulumi.Input[_builtins.str]
        """
        TCP port to listen on to receive data.
        """
        protocol: pulumi.Input[_builtins.str]
        """
        Protocol of an end point. Possible values are `TCP` and `UDP`.
        """
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        IP address of an end point.
        """
elif False:
    ContactProfileLinkChannelEndPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContactProfileLinkChannelEndPointArgs:
    def __init__(__self__, *,
                 end_point_name: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] end_point_name: Name of an end point.
        :param pulumi.Input[_builtins.str] port: TCP port to listen on to receive data.
        :param pulumi.Input[_builtins.str] protocol: Protocol of an end point. Possible values are `TCP` and `UDP`.
        :param pulumi.Input[_builtins.str] ip_address: IP address of an end point.
        """
        pulumi.set(__self__, "end_point_name", end_point_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @_builtins.property
    @pulumi.getter(name="endPointName")
    def end_point_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of an end point.
        """
        return pulumi.get(self, "end_point_name")

    @end_point_name.setter
    def end_point_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_point_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.str]:
        """
        TCP port to listen on to receive data.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol of an end point. Possible values are `TCP` and `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of an end point.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)


if not MYPY:
    class SpacecraftLinkArgsDict(TypedDict):
        bandwidth_mhz: pulumi.Input[_builtins.float]
        """
        Bandwidth in Mhz.
        """
        center_frequency_mhz: pulumi.Input[_builtins.float]
        """
        Center frequency in Mhz.

        > **Note:** The value of `center_frequency_mhz +/- bandwidth_mhz / 2` should fall in one of these ranges: `Uplink/LHCP`: [2025, 2120]; `Uplink/Linear`: [399, 403],[435, 438],[449, 451]; `Uplink/RHCP`: [399, 403],[435, 438],[449, 451],[2025, 2120]; `Downlink/LHCP`: [2200, 2300], [7500, 8400]; `Downlink/Linear`: [399, 403], [435, 438], [449, 451]; Downlink/Linear`: [399, 403], [435, 438], [449, 451], [2200, 2300], [7500, 8400]
        """
        direction: pulumi.Input[_builtins.str]
        """
        Direction if the communication. Possible values are `Uplink` and `Downlink`.
        """
        name: pulumi.Input[_builtins.str]
        """
        Name of the link.
        """
        polarization: pulumi.Input[_builtins.str]
        """
        Polarization. Possible values are `RHCP`, `LHCP`, `linearVertical` and `linearHorizontal`.
        """
elif False:
    SpacecraftLinkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SpacecraftLinkArgs:
    def __init__(__self__, *,
                 bandwidth_mhz: pulumi.Input[_builtins.float],
                 center_frequency_mhz: pulumi.Input[_builtins.float],
                 direction: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 polarization: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.float] bandwidth_mhz: Bandwidth in Mhz.
        :param pulumi.Input[_builtins.float] center_frequency_mhz: Center frequency in Mhz.
               
               > **Note:** The value of `center_frequency_mhz +/- bandwidth_mhz / 2` should fall in one of these ranges: `Uplink/LHCP`: [2025, 2120]; `Uplink/Linear`: [399, 403],[435, 438],[449, 451]; `Uplink/RHCP`: [399, 403],[435, 438],[449, 451],[2025, 2120]; `Downlink/LHCP`: [2200, 2300], [7500, 8400]; `Downlink/Linear`: [399, 403], [435, 438], [449, 451]; Downlink/Linear`: [399, 403], [435, 438], [449, 451], [2200, 2300], [7500, 8400]
        :param pulumi.Input[_builtins.str] direction: Direction if the communication. Possible values are `Uplink` and `Downlink`.
        :param pulumi.Input[_builtins.str] name: Name of the link.
        :param pulumi.Input[_builtins.str] polarization: Polarization. Possible values are `RHCP`, `LHCP`, `linearVertical` and `linearHorizontal`.
        """
        pulumi.set(__self__, "bandwidth_mhz", bandwidth_mhz)
        pulumi.set(__self__, "center_frequency_mhz", center_frequency_mhz)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "polarization", polarization)

    @_builtins.property
    @pulumi.getter(name="bandwidthMhz")
    def bandwidth_mhz(self) -> pulumi.Input[_builtins.float]:
        """
        Bandwidth in Mhz.
        """
        return pulumi.get(self, "bandwidth_mhz")

    @bandwidth_mhz.setter
    def bandwidth_mhz(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "bandwidth_mhz", value)

    @_builtins.property
    @pulumi.getter(name="centerFrequencyMhz")
    def center_frequency_mhz(self) -> pulumi.Input[_builtins.float]:
        """
        Center frequency in Mhz.

        > **Note:** The value of `center_frequency_mhz +/- bandwidth_mhz / 2` should fall in one of these ranges: `Uplink/LHCP`: [2025, 2120]; `Uplink/Linear`: [399, 403],[435, 438],[449, 451]; `Uplink/RHCP`: [399, 403],[435, 438],[449, 451],[2025, 2120]; `Downlink/LHCP`: [2200, 2300], [7500, 8400]; `Downlink/Linear`: [399, 403], [435, 438], [449, 451]; Downlink/Linear`: [399, 403], [435, 438], [449, 451], [2200, 2300], [7500, 8400]
        """
        return pulumi.get(self, "center_frequency_mhz")

    @center_frequency_mhz.setter
    def center_frequency_mhz(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "center_frequency_mhz", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        Direction if the communication. Possible values are `Uplink` and `Downlink`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def polarization(self) -> pulumi.Input[_builtins.str]:
        """
        Polarization. Possible values are `RHCP`, `LHCP`, `linearVertical` and `linearHorizontal`.
        """
        return pulumi.get(self, "polarization")

    @polarization.setter
    def polarization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "polarization", value)


