# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NextGenerationFirewallVirtualHubLocalRulestackArgs', 'NextGenerationFirewallVirtualHubLocalRulestack']

@pulumi.input_type
class NextGenerationFirewallVirtualHubLocalRulestackArgs:
    def __init__(__self__, *,
                 network_profile: pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 rulestack_id: pulumi.Input[_builtins.str],
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]]] = None,
                 dns_settings: Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs']] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NextGenerationFirewallVirtualHubLocalRulestack resource.
        :param pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs'] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack to be used for this Next Generation Firewall.
        :param pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs'] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        pulumi.set(__self__, "network_profile", network_profile)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "rulestack_id", rulestack_id)
        if destination_nats is not None:
            pulumi.set(__self__, "destination_nats", destination_nats)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if marketplace_offer_id is not None:
            pulumi.set(__self__, "marketplace_offer_id", marketplace_offer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs']:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs']):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Local Rulestack to be used for this Next Generation Firewall.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationNats")
    def destination_nats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]]]:
        """
        One or more `destination_nat` blocks as defined below.
        """
        return pulumi.get(self, "destination_nats")

    @destination_nats.setter
    def destination_nats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]]]):
        pulumi.set(self, "destination_nats", value)

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs']]:
        """
        A `dns_settings` block as defined below.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceOfferId")
    def marketplace_offer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "marketplace_offer_id")

    @marketplace_offer_id.setter
    def marketplace_offer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "marketplace_offer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.

        > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NextGenerationFirewallVirtualHubLocalRulestackState:
    def __init__(__self__, *,
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]]] = None,
                 dns_settings: Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs']] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs']] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NextGenerationFirewallVirtualHubLocalRulestack resources.
        :param pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs'] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs'] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack to be used for this Next Generation Firewall.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        if destination_nats is not None:
            pulumi.set(__self__, "destination_nats", destination_nats)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if marketplace_offer_id is not None:
            pulumi.set(__self__, "marketplace_offer_id", marketplace_offer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rulestack_id is not None:
            pulumi.set(__self__, "rulestack_id", rulestack_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="destinationNats")
    def destination_nats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]]]:
        """
        One or more `destination_nat` blocks as defined below.
        """
        return pulumi.get(self, "destination_nats")

    @destination_nats.setter
    def destination_nats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs']]]]):
        pulumi.set(self, "destination_nats", value)

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs']]:
        """
        A `dns_settings` block as defined below.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceOfferId")
    def marketplace_offer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "marketplace_offer_id")

    @marketplace_offer_id.setter
    def marketplace_offer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "marketplace_offer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.

        > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Local Rulestack to be used for this Next Generation Firewall.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:paloalto/nextGenerationFirewallVirtualHubLocalRulestack:NextGenerationFirewallVirtualHubLocalRulestack")
class NextGenerationFirewallVirtualHubLocalRulestack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgsDict']]]]] = None,
                 dns_settings: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgsDict']]] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgsDict']]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Palo Alto Next Generation Firewall VHub Local Rulestack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="acceptanceTestPublicIp1",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            tags={
                "environment": "Production",
            })
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-virtualwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-virtualhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.0.0/23",
            tags={
                "hubSaaSPreview": "true",
            })
        example_virtual_network_appliance = azure.paloalto.VirtualNetworkAppliance("example",
            name="example-appliance",
            virtual_hub_id=example_virtual_hub.id)
        example_next_generation_firewall_virtual_hub_local_rulestack = azure.paloalto.NextGenerationFirewallVirtualHubLocalRulestack("example",
            name="example-ngfwvn",
            resource_group_name=example.name,
            rulestack_id=example_azurerm_palo_alto_local_rulestack["id"],
            network_profile={
                "public_ip_address_ids": [example_public_ip.id],
                "virtual_hub_id": example_virtual_hub.id,
                "network_virtual_appliance_id": example_virtual_network_appliance.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw` - 2025-05-23, 2022-08-29

        ## Import

        Palo Alto Next Generation Firewall VHub Local Rulestacks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/nextGenerationFirewallVirtualHubLocalRulestack:NextGenerationFirewallVirtualHubLocalRulestack example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/firewalls/myVhubRulestackFW
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgsDict']]]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgsDict']] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack to be used for this Next Generation Firewall.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NextGenerationFirewallVirtualHubLocalRulestackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Palo Alto Next Generation Firewall VHub Local Rulestack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="acceptanceTestPublicIp1",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            tags={
                "environment": "Production",
            })
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-virtualwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-virtualhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.0.0/23",
            tags={
                "hubSaaSPreview": "true",
            })
        example_virtual_network_appliance = azure.paloalto.VirtualNetworkAppliance("example",
            name="example-appliance",
            virtual_hub_id=example_virtual_hub.id)
        example_next_generation_firewall_virtual_hub_local_rulestack = azure.paloalto.NextGenerationFirewallVirtualHubLocalRulestack("example",
            name="example-ngfwvn",
            resource_group_name=example.name,
            rulestack_id=example_azurerm_palo_alto_local_rulestack["id"],
            network_profile={
                "public_ip_address_ids": [example_public_ip.id],
                "virtual_hub_id": example_virtual_hub.id,
                "network_virtual_appliance_id": example_virtual_network_appliance.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw` - 2025-05-23, 2022-08-29

        ## Import

        Palo Alto Next Generation Firewall VHub Local Rulestacks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/nextGenerationFirewallVirtualHubLocalRulestack:NextGenerationFirewallVirtualHubLocalRulestack example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/firewalls/myVhubRulestackFW
        ```

        :param str resource_name: The name of the resource.
        :param NextGenerationFirewallVirtualHubLocalRulestackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NextGenerationFirewallVirtualHubLocalRulestackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgsDict']]]]] = None,
                 dns_settings: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgsDict']]] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgsDict']]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NextGenerationFirewallVirtualHubLocalRulestackArgs.__new__(NextGenerationFirewallVirtualHubLocalRulestackArgs)

            __props__.__dict__["destination_nats"] = destination_nats
            __props__.__dict__["dns_settings"] = dns_settings
            __props__.__dict__["marketplace_offer_id"] = marketplace_offer_id
            __props__.__dict__["name"] = name
            if network_profile is None and not opts.urn:
                raise TypeError("Missing required property 'network_profile'")
            __props__.__dict__["network_profile"] = network_profile
            __props__.__dict__["plan_id"] = plan_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if rulestack_id is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack_id'")
            __props__.__dict__["rulestack_id"] = rulestack_id
            __props__.__dict__["tags"] = tags
        super(NextGenerationFirewallVirtualHubLocalRulestack, __self__).__init__(
            'azure:paloalto/nextGenerationFirewallVirtualHubLocalRulestack:NextGenerationFirewallVirtualHubLocalRulestack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgsDict']]]]] = None,
            dns_settings: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgsDict']]] = None,
            marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgsDict']]] = None,
            plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'NextGenerationFirewallVirtualHubLocalRulestack':
        """
        Get an existing NextGenerationFirewallVirtualHubLocalRulestack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDestinationNatArgsDict']]]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualHubLocalRulestackDnsSettingsArgsDict']] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualHubLocalRulestackNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack to be used for this Next Generation Firewall.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NextGenerationFirewallVirtualHubLocalRulestackState.__new__(_NextGenerationFirewallVirtualHubLocalRulestackState)

        __props__.__dict__["destination_nats"] = destination_nats
        __props__.__dict__["dns_settings"] = dns_settings
        __props__.__dict__["marketplace_offer_id"] = marketplace_offer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile"] = network_profile
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rulestack_id"] = rulestack_id
        __props__.__dict__["tags"] = tags
        return NextGenerationFirewallVirtualHubLocalRulestack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="destinationNats")
    def destination_nats(self) -> pulumi.Output[Optional[Sequence['outputs.NextGenerationFirewallVirtualHubLocalRulestackDestinationNat']]]:
        """
        One or more `destination_nat` blocks as defined below.
        """
        return pulumi.get(self, "destination_nats")

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> pulumi.Output[Optional['outputs.NextGenerationFirewallVirtualHubLocalRulestackDnsSettings']]:
        """
        A `dns_settings` block as defined below.
        """
        return pulumi.get(self, "dns_settings")

    @_builtins.property
    @pulumi.getter(name="marketplaceOfferId")
    def marketplace_offer_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "marketplace_offer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Palo Alto Next Generation Firewall VHub Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output['outputs.NextGenerationFirewallVirtualHubLocalRulestackNetworkProfile']:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.

        > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Palo Alto Next Generation Firewall VHub Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall VHub Local Rulestack to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Local Rulestack to be used for this Next Generation Firewall.
        """
        return pulumi.get(self, "rulestack_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall VHub Local Rulestack.
        """
        return pulumi.get(self, "tags")

