# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlexibleServerBackupArgs', 'FlexibleServerBackup']

@pulumi.input_type
class FlexibleServerBackupArgs:
    def __init__(__self__, *,
                 server_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlexibleServerBackup resource.
        :param pulumi.Input[_builtins.str] server_id: The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "server_id", server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FlexibleServerBackupState:
    def __init__(__self__, *,
                 completed_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlexibleServerBackup resources.
        :param pulumi.Input[_builtins.str] completed_time: The Time (ISO8601 format) at which the backup was completed.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        if completed_time is not None:
            pulumi.set(__self__, "completed_time", completed_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter(name="completedTime")
    def completed_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Time (ISO8601 format) at which the backup was completed.
        """
        return pulumi.get(self, "completed_time")

    @completed_time.setter
    def completed_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "completed_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)


@pulumi.type_token("azure:postgresql/flexibleServerBackup:FlexibleServerBackup")
class FlexibleServerBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a PostgreSQL Flexible Server Backup.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example-fs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="adminTerraform",
            administrator_password="QAZwsx123",
            version="12",
            sku_name="GP_Standard_D2s_v3",
            zone="2")
        example_flexible_server_backup = azure.postgresql.FlexibleServerBackup("example",
            name="example-pfsb",
            server_id=example_flexible_server.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL` - 2024-08-01

        ## Import

        An existing PostgreSQL Flexible Server Backup can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/flexibleServerBackup:FlexibleServerBackup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforPostgreSQL/flexibleServers/fs1/backups/backup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexibleServerBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PostgreSQL Flexible Server Backup.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example-fs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="adminTerraform",
            administrator_password="QAZwsx123",
            version="12",
            sku_name="GP_Standard_D2s_v3",
            zone="2")
        example_flexible_server_backup = azure.postgresql.FlexibleServerBackup("example",
            name="example-pfsb",
            server_id=example_flexible_server.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL` - 2024-08-01

        ## Import

        An existing PostgreSQL Flexible Server Backup can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/flexibleServerBackup:FlexibleServerBackup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforPostgreSQL/flexibleServers/fs1/backups/backup1
        ```

        :param str resource_name: The name of the resource.
        :param FlexibleServerBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexibleServerBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexibleServerBackupArgs.__new__(FlexibleServerBackupArgs)

            __props__.__dict__["name"] = name
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["completed_time"] = None
        super(FlexibleServerBackup, __self__).__init__(
            'azure:postgresql/flexibleServerBackup:FlexibleServerBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            completed_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlexibleServerBackup':
        """
        Get an existing FlexibleServerBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] completed_time: The Time (ISO8601 format) at which the backup was completed.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexibleServerBackupState.__new__(_FlexibleServerBackupState)

        __props__.__dict__["completed_time"] = completed_time
        __props__.__dict__["name"] = name
        __props__.__dict__["server_id"] = server_id
        return FlexibleServerBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="completedTime")
    def completed_time(self) -> pulumi.Output[_builtins.str]:
        """
        The Time (ISO8601 format) at which the backup was completed.
        """
        return pulumi.get(self, "completed_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the PostgreSQL Flexible Server from which to create this PostgreSQL Flexible Server Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

