# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResolverInboundEndpointArgs', 'ResolverInboundEndpoint']

@pulumi.input_type
class ResolverInboundEndpointArgs:
    def __init__(__self__, *,
                 ip_configurations: pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs'],
                 private_dns_resolver_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ResolverInboundEndpoint resource.
        :param pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs'] ip_configurations: One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_dns_resolver_id: Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "private_dns_resolver_id", private_dns_resolver_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs']:
        """
        One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs']):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsResolverId")
    def private_dns_resolver_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "private_dns_resolver_id")

    @private_dns_resolver_id.setter
    def private_dns_resolver_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_dns_resolver_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ResolverInboundEndpointState:
    def __init__(__self__, *,
                 ip_configurations: Optional[pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_resolver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ResolverInboundEndpoint resources.
        :param pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs'] ip_configurations: One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_dns_resolver_id: Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_dns_resolver_id is not None:
            pulumi.set(__self__, "private_dns_resolver_id", private_dns_resolver_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs']]:
        """
        One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input['ResolverInboundEndpointIpConfigurationsArgs']]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsResolverId")
    def private_dns_resolver_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "private_dns_resolver_id")

    @private_dns_resolver_id.setter
    def private_dns_resolver_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_resolver_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:privatedns/resolverInboundEndpoint:ResolverInboundEndpoint")
class ResolverInboundEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_configurations: Optional[pulumi.Input[Union['ResolverInboundEndpointIpConfigurationsArgs', 'ResolverInboundEndpointIpConfigurationsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_resolver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Private DNS Resolver Inbound Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.0.0.0/16"])
        example_resolver = azure.privatedns.Resolver("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            virtual_network_id=example_virtual_network.id)
        example_subnet = azure.network.Subnet("example",
            name="inbounddns",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/28"],
            delegations=[{
                "name": "Microsoft.Network.dnsResolvers",
                "service_delegation": {
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                    "name": "Microsoft.Network/dnsResolvers",
                },
            }])
        example_resolver_inbound_endpoint = azure.privatedns.ResolverInboundEndpoint("example",
            name="example-drie",
            private_dns_resolver_id=example_resolver.id,
            location=example_resolver.location,
            ip_configurations={
                "private_ip_allocation_method": "Dynamic",
                "subnet_id": example_subnet.id,
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2022-07-01

        ## Import

        Private DNS Resolver Inbound Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatedns/resolverInboundEndpoint:ResolverInboundEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/dnsResolvers/dnsResolver1/inboundEndpoints/inboundEndpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ResolverInboundEndpointIpConfigurationsArgs', 'ResolverInboundEndpointIpConfigurationsArgsDict']] ip_configurations: One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_dns_resolver_id: Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverInboundEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Private DNS Resolver Inbound Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.0.0.0/16"])
        example_resolver = azure.privatedns.Resolver("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            virtual_network_id=example_virtual_network.id)
        example_subnet = azure.network.Subnet("example",
            name="inbounddns",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/28"],
            delegations=[{
                "name": "Microsoft.Network.dnsResolvers",
                "service_delegation": {
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                    "name": "Microsoft.Network/dnsResolvers",
                },
            }])
        example_resolver_inbound_endpoint = azure.privatedns.ResolverInboundEndpoint("example",
            name="example-drie",
            private_dns_resolver_id=example_resolver.id,
            location=example_resolver.location,
            ip_configurations={
                "private_ip_allocation_method": "Dynamic",
                "subnet_id": example_subnet.id,
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2022-07-01

        ## Import

        Private DNS Resolver Inbound Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatedns/resolverInboundEndpoint:ResolverInboundEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/dnsResolvers/dnsResolver1/inboundEndpoints/inboundEndpoint1
        ```

        :param str resource_name: The name of the resource.
        :param ResolverInboundEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverInboundEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_configurations: Optional[pulumi.Input[Union['ResolverInboundEndpointIpConfigurationsArgs', 'ResolverInboundEndpointIpConfigurationsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_resolver_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverInboundEndpointArgs.__new__(ResolverInboundEndpointArgs)

            if ip_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'ip_configurations'")
            __props__.__dict__["ip_configurations"] = ip_configurations
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if private_dns_resolver_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_dns_resolver_id'")
            __props__.__dict__["private_dns_resolver_id"] = private_dns_resolver_id
            __props__.__dict__["tags"] = tags
        super(ResolverInboundEndpoint, __self__).__init__(
            'azure:privatedns/resolverInboundEndpoint:ResolverInboundEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip_configurations: Optional[pulumi.Input[Union['ResolverInboundEndpointIpConfigurationsArgs', 'ResolverInboundEndpointIpConfigurationsArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_dns_resolver_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ResolverInboundEndpoint':
        """
        Get an existing ResolverInboundEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ResolverInboundEndpointIpConfigurationsArgs', 'ResolverInboundEndpointIpConfigurationsArgsDict']] ip_configurations: One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_dns_resolver_id: Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResolverInboundEndpointState.__new__(_ResolverInboundEndpointState)

        __props__.__dict__["ip_configurations"] = ip_configurations
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_dns_resolver_id"] = private_dns_resolver_id
        __props__.__dict__["tags"] = tags
        return ResolverInboundEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Output['outputs.ResolverInboundEndpointIpConfigurations']:
        """
        One `ip_configurations` block as defined below. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Private DNS Resolver Inbound Endpoint should exist. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateDnsResolverId")
    def private_dns_resolver_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Private DNS Resolver Inbound Endpoint. Changing this forces a new Private DNS Resolver Inbound Endpoint to be created.
        """
        return pulumi.get(self, "private_dns_resolver_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Private DNS Resolver Inbound Endpoint.
        """
        return pulumi.get(self, "tags")

