# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 private_service_connection: pulumi.Input['EndpointPrivateServiceConnectionArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 custom_network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_group: Optional[pulumi.Input['EndpointPrivateDnsZoneGroupArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input['EndpointPrivateServiceConnectionArgs'] private_service_connection: A `private_service_connection` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_network_interface_name: The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]] ip_configurations: One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input['EndpointPrivateDnsZoneGroupArgs'] private_dns_zone_group: A `private_dns_zone_group` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "private_service_connection", private_service_connection)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if custom_network_interface_name is not None:
            pulumi.set(__self__, "custom_network_interface_name", custom_network_interface_name)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_dns_zone_group is not None:
            pulumi.set(__self__, "private_dns_zone_group", private_dns_zone_group)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="privateServiceConnection")
    def private_service_connection(self) -> pulumi.Input['EndpointPrivateServiceConnectionArgs']:
        """
        A `private_service_connection` block as defined below.
        """
        return pulumi.get(self, "private_service_connection")

    @private_service_connection.setter
    def private_service_connection(self, value: pulumi.Input['EndpointPrivateServiceConnectionArgs']):
        pulumi.set(self, "private_service_connection", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="customNetworkInterfaceName")
    def custom_network_interface_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_network_interface_name")

    @custom_network_interface_name.setter
    def custom_network_interface_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_network_interface_name", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]]]:
        """
        One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneGroup")
    def private_dns_zone_group(self) -> Optional[pulumi.Input['EndpointPrivateDnsZoneGroupArgs']]:
        """
        A `private_dns_zone_group` block as defined below.
        """
        return pulumi.get(self, "private_dns_zone_group")

    @private_dns_zone_group.setter
    def private_dns_zone_group(self, value: Optional[pulumi.Input['EndpointPrivateDnsZoneGroupArgs']]):
        pulumi.set(self, "private_dns_zone_group", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 custom_dns_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointCustomDnsConfigArgs']]]] = None,
                 custom_network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointNetworkInterfaceArgs']]]] = None,
                 private_dns_zone_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigArgs']]]] = None,
                 private_dns_zone_group: Optional[pulumi.Input['EndpointPrivateDnsZoneGroupArgs']] = None,
                 private_service_connection: Optional[pulumi.Input['EndpointPrivateServiceConnectionArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointCustomDnsConfigArgs']]] custom_dns_configs: A `custom_dns_configs` block as defined below.
        :param pulumi.Input[_builtins.str] custom_network_interface_name: The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]] ip_configurations: One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointNetworkInterfaceArgs']]] network_interfaces: A `network_interface` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigArgs']]] private_dns_zone_configs: A `private_dns_zone_configs` block as defined below.
        :param pulumi.Input['EndpointPrivateDnsZoneGroupArgs'] private_dns_zone_group: A `private_dns_zone_group` block as defined below.
        :param pulumi.Input['EndpointPrivateServiceConnectionArgs'] private_service_connection: A `private_service_connection` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if custom_dns_configs is not None:
            pulumi.set(__self__, "custom_dns_configs", custom_dns_configs)
        if custom_network_interface_name is not None:
            pulumi.set(__self__, "custom_network_interface_name", custom_network_interface_name)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if private_dns_zone_configs is not None:
            pulumi.set(__self__, "private_dns_zone_configs", private_dns_zone_configs)
        if private_dns_zone_group is not None:
            pulumi.set(__self__, "private_dns_zone_group", private_dns_zone_group)
        if private_service_connection is not None:
            pulumi.set(__self__, "private_service_connection", private_service_connection)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customDnsConfigs")
    def custom_dns_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointCustomDnsConfigArgs']]]]:
        """
        A `custom_dns_configs` block as defined below.
        """
        return pulumi.get(self, "custom_dns_configs")

    @custom_dns_configs.setter
    def custom_dns_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointCustomDnsConfigArgs']]]]):
        pulumi.set(self, "custom_dns_configs", value)

    @_builtins.property
    @pulumi.getter(name="customNetworkInterfaceName")
    def custom_network_interface_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_network_interface_name")

    @custom_network_interface_name.setter
    def custom_network_interface_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_network_interface_name", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]]]:
        """
        One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointNetworkInterfaceArgs']]]]:
        """
        A `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneConfigs")
    def private_dns_zone_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigArgs']]]]:
        """
        A `private_dns_zone_configs` block as defined below.
        """
        return pulumi.get(self, "private_dns_zone_configs")

    @private_dns_zone_configs.setter
    def private_dns_zone_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigArgs']]]]):
        pulumi.set(self, "private_dns_zone_configs", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneGroup")
    def private_dns_zone_group(self) -> Optional[pulumi.Input['EndpointPrivateDnsZoneGroupArgs']]:
        """
        A `private_dns_zone_group` block as defined below.
        """
        return pulumi.get(self, "private_dns_zone_group")

    @private_dns_zone_group.setter
    def private_dns_zone_group(self, value: Optional[pulumi.Input['EndpointPrivateDnsZoneGroupArgs']]):
        pulumi.set(self, "private_dns_zone_group", value)

    @_builtins.property
    @pulumi.getter(name="privateServiceConnection")
    def private_service_connection(self) -> Optional[pulumi.Input['EndpointPrivateServiceConnectionArgs']]:
        """
        A `private_service_connection` block as defined below.
        """
        return pulumi.get(self, "private_service_connection")

    @private_service_connection.setter
    def private_service_connection(self, value: Optional[pulumi.Input['EndpointPrivateServiceConnectionArgs']]):
        pulumi.set(self, "private_service_connection", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:privatelink/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigurationArgs', 'EndpointIpConfigurationArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_group: Optional[pulumi.Input[Union['EndpointPrivateDnsZoneGroupArgs', 'EndpointPrivateDnsZoneGroupArgsDict']]] = None,
                 private_service_connection: Optional[pulumi.Input[Union['EndpointPrivateServiceConnectionArgs', 'EndpointPrivateServiceConnectionArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Private Endpoint.

        Azure Private Endpoint is a network interface that connects you privately and securely to a service powered by Azure Private Link. Private Endpoint uses a private IP address from your VNet, effectively bringing the service into your VNet. The service could be an Azure service such as Azure Storage, SQL, etc. or your own Private Link Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        service = azure.network.Subnet("service",
            name="service",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            enforce_private_link_service_network_policies=True)
        endpoint = azure.network.Subnet("endpoint",
            name="endpoint",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            enforce_private_link_endpoint_network_policies=True)
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="example-lb",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": example_public_ip.name,
                "public_ip_address_id": example_public_ip.id,
            }])
        example_link_service = azure.privatedns.LinkService("example",
            name="example-privatelink",
            location=example.location,
            resource_group_name=example.name,
            nat_ip_configurations=[{
                "name": example_public_ip.name,
                "primary": True,
                "subnet_id": service.id,
            }],
            load_balancer_frontend_ip_configuration_ids=[example_load_balancer.frontend_ip_configurations[0].id])
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-endpoint",
            location=example.location,
            resource_group_name=example.name,
            subnet_id=endpoint.id,
            private_service_connection={
                "name": "example-privateserviceconnection",
                "private_connection_resource_id": example_link_service.id,
                "is_manual_connection": False,
            })
        ```

        Using a Private Link Service Alias with existing resources:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_resource_group(name="example-resources")
        vnet = azure.network.get_virtual_network(name="example-network",
            resource_group_name=example.name)
        subnet = azure.network.get_subnet(name="default",
            virtual_network_name=vnet.name,
            resource_group_name=example.name)
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-endpoint",
            location=example.location,
            resource_group_name=example.name,
            subnet_id=subnet.id,
            private_service_connection={
                "name": "example-privateserviceconnection",
                "private_connection_resource_alias": "example-privatelinkservice.d20286c8-4ea5-11eb-9584-8f53157226c6.centralus.azure.privatelinkservice",
                "is_manual_connection": True,
                "request_message": "PL",
            })
        ```

        Using a Private Endpoint pointing to an *owned* Azure service, with proper DNS configuration:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="exampleaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="virtnetname",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="subnetname",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_zone = azure.privatedns.Zone("example",
            name="privatelink.blob.core.windows.net",
            resource_group_name=example.name)
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-endpoint",
            location=example.location,
            resource_group_name=example.name,
            subnet_id=example_subnet.id,
            private_service_connection={
                "name": "example-privateserviceconnection",
                "private_connection_resource_id": example_account.id,
                "subresource_names": ["blob"],
                "is_manual_connection": False,
            },
            private_dns_zone_group={
                "name": "example-dns-zone-group",
                "private_dns_zone_ids": [example_zone.id],
            })
        example_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("example",
            name="example-link",
            resource_group_name=example.name,
            private_dns_zone_name=example_zone.name,
            virtual_network_id=example_virtual_network.id)
        ```

        ## Example HCL Configurations

        * How to conneca `Private Endpoint` to a Application Gateway
        * How to connect a `Private Endpoint` to a Cosmos MongoDB
        * How to connect a `Private Endpoint` to a Cosmos PostgreSQL
        * How to connect a `Private Endpoint` to a PostgreSQL Server
        * How to connect a `Private Endpoint` to a Private Link Service
        * How to connect a `Private Endpoint` to a Private DNS Group
        * How to connect a `Private Endpoint` to a Databricks Workspace
        * How to connect a `Private Endpoint` to a Managed Redis

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Private Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatelink/endpoint:Endpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/privateEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_network_interface_name: The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigurationArgs', 'EndpointIpConfigurationArgsDict']]]] ip_configurations: One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EndpointPrivateDnsZoneGroupArgs', 'EndpointPrivateDnsZoneGroupArgsDict']] private_dns_zone_group: A `private_dns_zone_group` block as defined below.
        :param pulumi.Input[Union['EndpointPrivateServiceConnectionArgs', 'EndpointPrivateServiceConnectionArgsDict']] private_service_connection: A `private_service_connection` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Private Endpoint.

        Azure Private Endpoint is a network interface that connects you privately and securely to a service powered by Azure Private Link. Private Endpoint uses a private IP address from your VNet, effectively bringing the service into your VNet. The service could be an Azure service such as Azure Storage, SQL, etc. or your own Private Link Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        service = azure.network.Subnet("service",
            name="service",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            enforce_private_link_service_network_policies=True)
        endpoint = azure.network.Subnet("endpoint",
            name="endpoint",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            enforce_private_link_endpoint_network_policies=True)
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="example-lb",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": example_public_ip.name,
                "public_ip_address_id": example_public_ip.id,
            }])
        example_link_service = azure.privatedns.LinkService("example",
            name="example-privatelink",
            location=example.location,
            resource_group_name=example.name,
            nat_ip_configurations=[{
                "name": example_public_ip.name,
                "primary": True,
                "subnet_id": service.id,
            }],
            load_balancer_frontend_ip_configuration_ids=[example_load_balancer.frontend_ip_configurations[0].id])
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-endpoint",
            location=example.location,
            resource_group_name=example.name,
            subnet_id=endpoint.id,
            private_service_connection={
                "name": "example-privateserviceconnection",
                "private_connection_resource_id": example_link_service.id,
                "is_manual_connection": False,
            })
        ```

        Using a Private Link Service Alias with existing resources:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_resource_group(name="example-resources")
        vnet = azure.network.get_virtual_network(name="example-network",
            resource_group_name=example.name)
        subnet = azure.network.get_subnet(name="default",
            virtual_network_name=vnet.name,
            resource_group_name=example.name)
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-endpoint",
            location=example.location,
            resource_group_name=example.name,
            subnet_id=subnet.id,
            private_service_connection={
                "name": "example-privateserviceconnection",
                "private_connection_resource_alias": "example-privatelinkservice.d20286c8-4ea5-11eb-9584-8f53157226c6.centralus.azure.privatelinkservice",
                "is_manual_connection": True,
                "request_message": "PL",
            })
        ```

        Using a Private Endpoint pointing to an *owned* Azure service, with proper DNS configuration:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="exampleaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="virtnetname",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="subnetname",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_zone = azure.privatedns.Zone("example",
            name="privatelink.blob.core.windows.net",
            resource_group_name=example.name)
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-endpoint",
            location=example.location,
            resource_group_name=example.name,
            subnet_id=example_subnet.id,
            private_service_connection={
                "name": "example-privateserviceconnection",
                "private_connection_resource_id": example_account.id,
                "subresource_names": ["blob"],
                "is_manual_connection": False,
            },
            private_dns_zone_group={
                "name": "example-dns-zone-group",
                "private_dns_zone_ids": [example_zone.id],
            })
        example_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("example",
            name="example-link",
            resource_group_name=example.name,
            private_dns_zone_name=example_zone.name,
            virtual_network_id=example_virtual_network.id)
        ```

        ## Example HCL Configurations

        * How to conneca `Private Endpoint` to a Application Gateway
        * How to connect a `Private Endpoint` to a Cosmos MongoDB
        * How to connect a `Private Endpoint` to a Cosmos PostgreSQL
        * How to connect a `Private Endpoint` to a PostgreSQL Server
        * How to connect a `Private Endpoint` to a Private Link Service
        * How to connect a `Private Endpoint` to a Private DNS Group
        * How to connect a `Private Endpoint` to a Databricks Workspace
        * How to connect a `Private Endpoint` to a Managed Redis

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        ## Import

        Private Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatelink/endpoint:Endpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/privateEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigurationArgs', 'EndpointIpConfigurationArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_group: Optional[pulumi.Input[Union['EndpointPrivateDnsZoneGroupArgs', 'EndpointPrivateDnsZoneGroupArgsDict']]] = None,
                 private_service_connection: Optional[pulumi.Input[Union['EndpointPrivateServiceConnectionArgs', 'EndpointPrivateServiceConnectionArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["custom_network_interface_name"] = custom_network_interface_name
            __props__.__dict__["ip_configurations"] = ip_configurations
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["private_dns_zone_group"] = private_dns_zone_group
            if private_service_connection is None and not opts.urn:
                raise TypeError("Missing required property 'private_service_connection'")
            __props__.__dict__["private_service_connection"] = private_service_connection
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["custom_dns_configs"] = None
            __props__.__dict__["network_interfaces"] = None
            __props__.__dict__["private_dns_zone_configs"] = None
        super(Endpoint, __self__).__init__(
            'azure:privatelink/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_dns_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointCustomDnsConfigArgs', 'EndpointCustomDnsConfigArgsDict']]]]] = None,
            custom_network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigurationArgs', 'EndpointIpConfigurationArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointNetworkInterfaceArgs', 'EndpointNetworkInterfaceArgsDict']]]]] = None,
            private_dns_zone_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointPrivateDnsZoneConfigArgs', 'EndpointPrivateDnsZoneConfigArgsDict']]]]] = None,
            private_dns_zone_group: Optional[pulumi.Input[Union['EndpointPrivateDnsZoneGroupArgs', 'EndpointPrivateDnsZoneGroupArgsDict']]] = None,
            private_service_connection: Optional[pulumi.Input[Union['EndpointPrivateServiceConnectionArgs', 'EndpointPrivateServiceConnectionArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointCustomDnsConfigArgs', 'EndpointCustomDnsConfigArgsDict']]]] custom_dns_configs: A `custom_dns_configs` block as defined below.
        :param pulumi.Input[_builtins.str] custom_network_interface_name: The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointIpConfigurationArgs', 'EndpointIpConfigurationArgsDict']]]] ip_configurations: One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointNetworkInterfaceArgs', 'EndpointNetworkInterfaceArgsDict']]]] network_interfaces: A `network_interface` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointPrivateDnsZoneConfigArgs', 'EndpointPrivateDnsZoneConfigArgsDict']]]] private_dns_zone_configs: A `private_dns_zone_configs` block as defined below.
        :param pulumi.Input[Union['EndpointPrivateDnsZoneGroupArgs', 'EndpointPrivateDnsZoneGroupArgsDict']] private_dns_zone_group: A `private_dns_zone_group` block as defined below.
        :param pulumi.Input[Union['EndpointPrivateServiceConnectionArgs', 'EndpointPrivateServiceConnectionArgsDict']] private_service_connection: A `private_service_connection` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["custom_dns_configs"] = custom_dns_configs
        __props__.__dict__["custom_network_interface_name"] = custom_network_interface_name
        __props__.__dict__["ip_configurations"] = ip_configurations
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["private_dns_zone_configs"] = private_dns_zone_configs
        __props__.__dict__["private_dns_zone_group"] = private_dns_zone_group
        __props__.__dict__["private_service_connection"] = private_service_connection
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customDnsConfigs")
    def custom_dns_configs(self) -> pulumi.Output[Sequence['outputs.EndpointCustomDnsConfig']]:
        """
        A `custom_dns_configs` block as defined below.
        """
        return pulumi.get(self, "custom_dns_configs")

    @_builtins.property
    @pulumi.getter(name="customNetworkInterfaceName")
    def custom_network_interface_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The custom name of the network interface attached to the private endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_network_interface_name")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.EndpointIpConfiguration']]]:
        """
        One or more `ip_configuration` blocks as defined below. This allows a static IP address to be set for this Private Endpoint, otherwise an address is dynamically allocated from the Subnet.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.EndpointNetworkInterface']]:
        """
        A `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneConfigs")
    def private_dns_zone_configs(self) -> pulumi.Output[Sequence['outputs.EndpointPrivateDnsZoneConfig']]:
        """
        A `private_dns_zone_configs` block as defined below.
        """
        return pulumi.get(self, "private_dns_zone_configs")

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneGroup")
    def private_dns_zone_group(self) -> pulumi.Output[Optional['outputs.EndpointPrivateDnsZoneGroup']]:
        """
        A `private_dns_zone_group` block as defined below.
        """
        return pulumi.get(self, "private_dns_zone_group")

    @_builtins.property
    @pulumi.getter(name="privateServiceConnection")
    def private_service_connection(self) -> pulumi.Output['outputs.EndpointPrivateServiceConnection']:
        """
        A `private_service_connection` block as defined below.
        """
        return pulumi.get(self, "private_service_connection")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Name of the Resource Group within which the Private Endpoint should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet from which Private IP Addresses will be allocated for this Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

