# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VaultResourceGuardAssociationArgs', 'VaultResourceGuardAssociation']

@pulumi.input_type
class VaultResourceGuardAssociationArgs:
    def __init__(__self__, *,
                 resource_guard_id: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a VaultResourceGuardAssociation resource.
        :param pulumi.Input[_builtins.str] resource_guard_id: ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "resource_guard_id", resource_guard_id)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="resourceGuardId")
    def resource_guard_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_guard_id")

    @resource_guard_id.setter
    def resource_guard_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_guard_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class _VaultResourceGuardAssociationState:
    def __init__(__self__, *,
                 resource_guard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VaultResourceGuardAssociation resources.
        :param pulumi.Input[_builtins.str] resource_guard_id: ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        if resource_guard_id is not None:
            pulumi.set(__self__, "resource_guard_id", resource_guard_id)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="resourceGuardId")
    def resource_guard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_guard_id")

    @resource_guard_id.setter
    def resource_guard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_guard_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("azure:recoveryservices/vaultResourceGuardAssociation:VaultResourceGuardAssociation")
class VaultResourceGuardAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_guard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an association of a Resource Guard and Recovery Services Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_resource_guard = azure.dataprotection.ResourceGuard("example",
            name="example-resourceguard",
            resource_group_name=example.name,
            location=example.location)
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            soft_delete_enabled=True)
        test = azure.recoveryservices.VaultResourceGuardAssociation("test",
            vault_id=test_azurerm_recovery_services_vault["id"],
            resource_guard_id=test_azurerm_data_protection_resource_guard["id"])
        ```

        ## Import

        Resource Guards can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:recoveryservices/vaultResourceGuardAssociation:VaultResourceGuardAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/vault1/backupResourceGuardProxies/proxy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] resource_guard_id: ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultResourceGuardAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an association of a Resource Guard and Recovery Services Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_resource_guard = azure.dataprotection.ResourceGuard("example",
            name="example-resourceguard",
            resource_group_name=example.name,
            location=example.location)
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            soft_delete_enabled=True)
        test = azure.recoveryservices.VaultResourceGuardAssociation("test",
            vault_id=test_azurerm_recovery_services_vault["id"],
            resource_guard_id=test_azurerm_data_protection_resource_guard["id"])
        ```

        ## Import

        Resource Guards can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:recoveryservices/vaultResourceGuardAssociation:VaultResourceGuardAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/vault1/backupResourceGuardProxies/proxy1
        ```

        :param str resource_name: The name of the resource.
        :param VaultResourceGuardAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultResourceGuardAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_guard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultResourceGuardAssociationArgs.__new__(VaultResourceGuardAssociationArgs)

            if resource_guard_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_guard_id'")
            __props__.__dict__["resource_guard_id"] = resource_guard_id
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(VaultResourceGuardAssociation, __self__).__init__(
            'azure:recoveryservices/vaultResourceGuardAssociation:VaultResourceGuardAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            resource_guard_id: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VaultResourceGuardAssociation':
        """
        Get an existing VaultResourceGuardAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] resource_guard_id: ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultResourceGuardAssociationState.__new__(_VaultResourceGuardAssociationState)

        __props__.__dict__["resource_guard_id"] = resource_guard_id
        __props__.__dict__["vault_id"] = vault_id
        return VaultResourceGuardAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="resourceGuardId")
    def resource_guard_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Resource Guard which should be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_guard_id")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Recovery Services Vault which should be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

