# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 api_server_profile: pulumi.Input['ClusterApiServerProfileArgs'],
                 cluster_profile: pulumi.Input['ClusterClusterProfileArgs'],
                 ingress_profile: pulumi.Input['ClusterIngressProfileArgs'],
                 main_profile: pulumi.Input['ClusterMainProfileArgs'],
                 network_profile: pulumi.Input['ClusterNetworkProfileArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 service_principal: pulumi.Input['ClusterServicePrincipalArgs'],
                 worker_profile: pulumi.Input['ClusterWorkerProfileArgs'],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterApiServerProfileArgs'] api_server_profile: An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterClusterProfileArgs'] cluster_profile: A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterIngressProfileArgs'] ingress_profile: An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterMainProfileArgs'] main_profile: A `main_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterNetworkProfileArgs'] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterServicePrincipalArgs'] service_principal: A `service_principal` block as defined below.
        :param pulumi.Input['ClusterWorkerProfileArgs'] worker_profile: A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "api_server_profile", api_server_profile)
        pulumi.set(__self__, "cluster_profile", cluster_profile)
        pulumi.set(__self__, "ingress_profile", ingress_profile)
        pulumi.set(__self__, "main_profile", main_profile)
        pulumi.set(__self__, "network_profile", network_profile)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_principal", service_principal)
        pulumi.set(__self__, "worker_profile", worker_profile)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiServerProfile")
    def api_server_profile(self) -> pulumi.Input['ClusterApiServerProfileArgs']:
        """
        An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_server_profile")

    @api_server_profile.setter
    def api_server_profile(self, value: pulumi.Input['ClusterApiServerProfileArgs']):
        pulumi.set(self, "api_server_profile", value)

    @_builtins.property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> pulumi.Input['ClusterClusterProfileArgs']:
        """
        A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_profile")

    @cluster_profile.setter
    def cluster_profile(self, value: pulumi.Input['ClusterClusterProfileArgs']):
        pulumi.set(self, "cluster_profile", value)

    @_builtins.property
    @pulumi.getter(name="ingressProfile")
    def ingress_profile(self) -> pulumi.Input['ClusterIngressProfileArgs']:
        """
        An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ingress_profile")

    @ingress_profile.setter
    def ingress_profile(self, value: pulumi.Input['ClusterIngressProfileArgs']):
        pulumi.set(self, "ingress_profile", value)

    @_builtins.property
    @pulumi.getter(name="mainProfile")
    def main_profile(self) -> pulumi.Input['ClusterMainProfileArgs']:
        """
        A `main_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "main_profile")

    @main_profile.setter
    def main_profile(self, value: pulumi.Input['ClusterMainProfileArgs']):
        pulumi.set(self, "main_profile", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Input['ClusterNetworkProfileArgs']:
        """
        A `network_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: pulumi.Input['ClusterNetworkProfileArgs']):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> pulumi.Input['ClusterServicePrincipalArgs']:
        """
        A `service_principal` block as defined below.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: pulumi.Input['ClusterServicePrincipalArgs']):
        pulumi.set(self, "service_principal", value)

    @_builtins.property
    @pulumi.getter(name="workerProfile")
    def worker_profile(self) -> pulumi.Input['ClusterWorkerProfileArgs']:
        """
        A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "worker_profile")

    @worker_profile.setter
    def worker_profile(self, value: pulumi.Input['ClusterWorkerProfileArgs']):
        pulumi.set(self, "worker_profile", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 api_server_profile: Optional[pulumi.Input['ClusterApiServerProfileArgs']] = None,
                 cluster_profile: Optional[pulumi.Input['ClusterClusterProfileArgs']] = None,
                 console_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_profile: Optional[pulumi.Input['ClusterIngressProfileArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 main_profile: Optional[pulumi.Input['ClusterMainProfileArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['ClusterNetworkProfileArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal: Optional[pulumi.Input['ClusterServicePrincipalArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_profile: Optional[pulumi.Input['ClusterWorkerProfileArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterApiServerProfileArgs'] api_server_profile: An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterClusterProfileArgs'] cluster_profile: A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] console_url: The Red Hat OpenShift cluster console URL.
        :param pulumi.Input['ClusterIngressProfileArgs'] ingress_profile: An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterMainProfileArgs'] main_profile: A `main_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterNetworkProfileArgs'] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterServicePrincipalArgs'] service_principal: A `service_principal` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['ClusterWorkerProfileArgs'] worker_profile: A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        """
        if api_server_profile is not None:
            pulumi.set(__self__, "api_server_profile", api_server_profile)
        if cluster_profile is not None:
            pulumi.set(__self__, "cluster_profile", cluster_profile)
        if console_url is not None:
            pulumi.set(__self__, "console_url", console_url)
        if ingress_profile is not None:
            pulumi.set(__self__, "ingress_profile", ingress_profile)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if main_profile is not None:
            pulumi.set(__self__, "main_profile", main_profile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if worker_profile is not None:
            pulumi.set(__self__, "worker_profile", worker_profile)

    @_builtins.property
    @pulumi.getter(name="apiServerProfile")
    def api_server_profile(self) -> Optional[pulumi.Input['ClusterApiServerProfileArgs']]:
        """
        An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_server_profile")

    @api_server_profile.setter
    def api_server_profile(self, value: Optional[pulumi.Input['ClusterApiServerProfileArgs']]):
        pulumi.set(self, "api_server_profile", value)

    @_builtins.property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> Optional[pulumi.Input['ClusterClusterProfileArgs']]:
        """
        A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_profile")

    @cluster_profile.setter
    def cluster_profile(self, value: Optional[pulumi.Input['ClusterClusterProfileArgs']]):
        pulumi.set(self, "cluster_profile", value)

    @_builtins.property
    @pulumi.getter(name="consoleUrl")
    def console_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Red Hat OpenShift cluster console URL.
        """
        return pulumi.get(self, "console_url")

    @console_url.setter
    def console_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "console_url", value)

    @_builtins.property
    @pulumi.getter(name="ingressProfile")
    def ingress_profile(self) -> Optional[pulumi.Input['ClusterIngressProfileArgs']]:
        """
        An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ingress_profile")

    @ingress_profile.setter
    def ingress_profile(self, value: Optional[pulumi.Input['ClusterIngressProfileArgs']]):
        pulumi.set(self, "ingress_profile", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mainProfile")
    def main_profile(self) -> Optional[pulumi.Input['ClusterMainProfileArgs']]:
        """
        A `main_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "main_profile")

    @main_profile.setter
    def main_profile(self, value: Optional[pulumi.Input['ClusterMainProfileArgs']]):
        pulumi.set(self, "main_profile", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['ClusterNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['ClusterNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional[pulumi.Input['ClusterServicePrincipalArgs']]:
        """
        A `service_principal` block as defined below.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: Optional[pulumi.Input['ClusterServicePrincipalArgs']]):
        pulumi.set(self, "service_principal", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workerProfile")
    def worker_profile(self) -> Optional[pulumi.Input['ClusterWorkerProfileArgs']]:
        """
        A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "worker_profile")

    @worker_profile.setter
    def worker_profile(self, value: Optional[pulumi.Input['ClusterWorkerProfileArgs']]):
        pulumi.set(self, "worker_profile", value)


@pulumi.type_token("azure:redhatopenshift/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_server_profile: Optional[pulumi.Input[Union['ClusterApiServerProfileArgs', 'ClusterApiServerProfileArgsDict']]] = None,
                 cluster_profile: Optional[pulumi.Input[Union['ClusterClusterProfileArgs', 'ClusterClusterProfileArgsDict']]] = None,
                 ingress_profile: Optional[pulumi.Input[Union['ClusterIngressProfileArgs', 'ClusterIngressProfileArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 main_profile: Optional[pulumi.Input[Union['ClusterMainProfileArgs', 'ClusterMainProfileArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['ClusterNetworkProfileArgs', 'ClusterNetworkProfileArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal: Optional[pulumi.Input[Union['ClusterServicePrincipalArgs', 'ClusterServicePrincipalArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_profile: Optional[pulumi.Input[Union['ClusterWorkerProfileArgs', 'ClusterWorkerProfileArgsDict']]] = None,
                 __props__=None):
        """
        Manages a fully managed Azure Red Hat OpenShift Cluster (also known as ARO).

        > **Note:** All arguments including the client secret will be stored in the raw state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.get_client_config()
        example_get_client_config = azuread.get_client_config()
        example_application = azuread.Application("example", display_name="example-aro")
        example_service_principal = azuread.ServicePrincipal("example", client_id=example_application.client_id)
        example_service_principal_password = azuread.ServicePrincipalPassword("example", service_principal_id=example_service_principal.object_id)
        redhatopenshift = azuread.get_service_principal(client_id="f1dd0a37-89c6-4e07-bcd1-ffd3d43d8875")
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/22"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        role_network1 = azure.authorization.Assignment("role_network1",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=example_service_principal.object_id)
        role_network2 = azure.authorization.Assignment("role_network2",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=redhatopenshift.object_id)
        main_subnet = azure.network.Subnet("main_subnet",
            name="main-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/23"],
            service_endpoints=[
                "Microsoft.Storage",
                "Microsoft.ContainerRegistry",
            ])
        worker_subnet = azure.network.Subnet("worker_subnet",
            name="worker-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/23"],
            service_endpoints=[
                "Microsoft.Storage",
                "Microsoft.ContainerRegistry",
            ])
        example_cluster = azure.redhatopenshift.Cluster("example",
            name="examplearo",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            cluster_profile={
                "domain": "aro-example.com",
                "version": "4.13.23",
            },
            network_profile={
                "pod_cidr": "10.128.0.0/14",
                "service_cidr": "172.30.0.0/16",
            },
            main_profile={
                "vm_size": "Standard_D8s_v3",
                "subnet_id": main_subnet.id,
            },
            api_server_profile={
                "visibility": "Public",
            },
            ingress_profile={
                "visibility": "Public",
            },
            worker_profile={
                "vm_size": "Standard_D4s_v3",
                "disk_size_gb": 128,
                "node_count": 3,
                "subnet_id": worker_subnet.id,
            },
            service_principal={
                "client_id": example_application.client_id,
                "client_secret": example_service_principal_password.value,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    role_network1,
                    role_network2,
                ]))
        pulumi.export("consoleUrl", example_cluster.console_url)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RedHatOpenShift` - 2023-09-04

        ## Import

        Red Hat OpenShift Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redhatopenshift/cluster:Cluster cluster1 /subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/group1/providers/Microsoft.RedHatOpenShift/openShiftClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterApiServerProfileArgs', 'ClusterApiServerProfileArgsDict']] api_server_profile: An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterClusterProfileArgs', 'ClusterClusterProfileArgsDict']] cluster_profile: A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterIngressProfileArgs', 'ClusterIngressProfileArgsDict']] ingress_profile: An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterMainProfileArgs', 'ClusterMainProfileArgsDict']] main_profile: A `main_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterNetworkProfileArgs', 'ClusterNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterServicePrincipalArgs', 'ClusterServicePrincipalArgsDict']] service_principal: A `service_principal` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['ClusterWorkerProfileArgs', 'ClusterWorkerProfileArgsDict']] worker_profile: A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a fully managed Azure Red Hat OpenShift Cluster (also known as ARO).

        > **Note:** All arguments including the client secret will be stored in the raw state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.get_client_config()
        example_get_client_config = azuread.get_client_config()
        example_application = azuread.Application("example", display_name="example-aro")
        example_service_principal = azuread.ServicePrincipal("example", client_id=example_application.client_id)
        example_service_principal_password = azuread.ServicePrincipalPassword("example", service_principal_id=example_service_principal.object_id)
        redhatopenshift = azuread.get_service_principal(client_id="f1dd0a37-89c6-4e07-bcd1-ffd3d43d8875")
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/22"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        role_network1 = azure.authorization.Assignment("role_network1",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=example_service_principal.object_id)
        role_network2 = azure.authorization.Assignment("role_network2",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=redhatopenshift.object_id)
        main_subnet = azure.network.Subnet("main_subnet",
            name="main-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/23"],
            service_endpoints=[
                "Microsoft.Storage",
                "Microsoft.ContainerRegistry",
            ])
        worker_subnet = azure.network.Subnet("worker_subnet",
            name="worker-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/23"],
            service_endpoints=[
                "Microsoft.Storage",
                "Microsoft.ContainerRegistry",
            ])
        example_cluster = azure.redhatopenshift.Cluster("example",
            name="examplearo",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            cluster_profile={
                "domain": "aro-example.com",
                "version": "4.13.23",
            },
            network_profile={
                "pod_cidr": "10.128.0.0/14",
                "service_cidr": "172.30.0.0/16",
            },
            main_profile={
                "vm_size": "Standard_D8s_v3",
                "subnet_id": main_subnet.id,
            },
            api_server_profile={
                "visibility": "Public",
            },
            ingress_profile={
                "visibility": "Public",
            },
            worker_profile={
                "vm_size": "Standard_D4s_v3",
                "disk_size_gb": 128,
                "node_count": 3,
                "subnet_id": worker_subnet.id,
            },
            service_principal={
                "client_id": example_application.client_id,
                "client_secret": example_service_principal_password.value,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    role_network1,
                    role_network2,
                ]))
        pulumi.export("consoleUrl", example_cluster.console_url)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RedHatOpenShift` - 2023-09-04

        ## Import

        Red Hat OpenShift Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redhatopenshift/cluster:Cluster cluster1 /subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/group1/providers/Microsoft.RedHatOpenShift/openShiftClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_server_profile: Optional[pulumi.Input[Union['ClusterApiServerProfileArgs', 'ClusterApiServerProfileArgsDict']]] = None,
                 cluster_profile: Optional[pulumi.Input[Union['ClusterClusterProfileArgs', 'ClusterClusterProfileArgsDict']]] = None,
                 ingress_profile: Optional[pulumi.Input[Union['ClusterIngressProfileArgs', 'ClusterIngressProfileArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 main_profile: Optional[pulumi.Input[Union['ClusterMainProfileArgs', 'ClusterMainProfileArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['ClusterNetworkProfileArgs', 'ClusterNetworkProfileArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal: Optional[pulumi.Input[Union['ClusterServicePrincipalArgs', 'ClusterServicePrincipalArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_profile: Optional[pulumi.Input[Union['ClusterWorkerProfileArgs', 'ClusterWorkerProfileArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if api_server_profile is None and not opts.urn:
                raise TypeError("Missing required property 'api_server_profile'")
            __props__.__dict__["api_server_profile"] = api_server_profile
            if cluster_profile is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_profile'")
            __props__.__dict__["cluster_profile"] = cluster_profile
            if ingress_profile is None and not opts.urn:
                raise TypeError("Missing required property 'ingress_profile'")
            __props__.__dict__["ingress_profile"] = ingress_profile
            __props__.__dict__["location"] = location
            if main_profile is None and not opts.urn:
                raise TypeError("Missing required property 'main_profile'")
            __props__.__dict__["main_profile"] = main_profile
            __props__.__dict__["name"] = name
            if network_profile is None and not opts.urn:
                raise TypeError("Missing required property 'network_profile'")
            __props__.__dict__["network_profile"] = network_profile
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if service_principal is None and not opts.urn:
                raise TypeError("Missing required property 'service_principal'")
            __props__.__dict__["service_principal"] = service_principal
            __props__.__dict__["tags"] = tags
            if worker_profile is None and not opts.urn:
                raise TypeError("Missing required property 'worker_profile'")
            __props__.__dict__["worker_profile"] = worker_profile
            __props__.__dict__["console_url"] = None
        super(Cluster, __self__).__init__(
            'azure:redhatopenshift/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_server_profile: Optional[pulumi.Input[Union['ClusterApiServerProfileArgs', 'ClusterApiServerProfileArgsDict']]] = None,
            cluster_profile: Optional[pulumi.Input[Union['ClusterClusterProfileArgs', 'ClusterClusterProfileArgsDict']]] = None,
            console_url: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_profile: Optional[pulumi.Input[Union['ClusterIngressProfileArgs', 'ClusterIngressProfileArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            main_profile: Optional[pulumi.Input[Union['ClusterMainProfileArgs', 'ClusterMainProfileArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile: Optional[pulumi.Input[Union['ClusterNetworkProfileArgs', 'ClusterNetworkProfileArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal: Optional[pulumi.Input[Union['ClusterServicePrincipalArgs', 'ClusterServicePrincipalArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            worker_profile: Optional[pulumi.Input[Union['ClusterWorkerProfileArgs', 'ClusterWorkerProfileArgsDict']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterApiServerProfileArgs', 'ClusterApiServerProfileArgsDict']] api_server_profile: An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterClusterProfileArgs', 'ClusterClusterProfileArgsDict']] cluster_profile: A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] console_url: The Red Hat OpenShift cluster console URL.
        :param pulumi.Input[Union['ClusterIngressProfileArgs', 'ClusterIngressProfileArgsDict']] ingress_profile: An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterMainProfileArgs', 'ClusterMainProfileArgsDict']] main_profile: A `main_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterNetworkProfileArgs', 'ClusterNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterServicePrincipalArgs', 'ClusterServicePrincipalArgsDict']] service_principal: A `service_principal` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['ClusterWorkerProfileArgs', 'ClusterWorkerProfileArgsDict']] worker_profile: A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["api_server_profile"] = api_server_profile
        __props__.__dict__["cluster_profile"] = cluster_profile
        __props__.__dict__["console_url"] = console_url
        __props__.__dict__["ingress_profile"] = ingress_profile
        __props__.__dict__["location"] = location
        __props__.__dict__["main_profile"] = main_profile
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile"] = network_profile
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_principal"] = service_principal
        __props__.__dict__["tags"] = tags
        __props__.__dict__["worker_profile"] = worker_profile
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiServerProfile")
    def api_server_profile(self) -> pulumi.Output['outputs.ClusterApiServerProfile']:
        """
        An `api_server_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_server_profile")

    @_builtins.property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> pulumi.Output['outputs.ClusterClusterProfile']:
        """
        A `cluster_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_profile")

    @_builtins.property
    @pulumi.getter(name="consoleUrl")
    def console_url(self) -> pulumi.Output[_builtins.str]:
        """
        The Red Hat OpenShift cluster console URL.
        """
        return pulumi.get(self, "console_url")

    @_builtins.property
    @pulumi.getter(name="ingressProfile")
    def ingress_profile(self) -> pulumi.Output['outputs.ClusterIngressProfile']:
        """
        An `ingress_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ingress_profile")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Azure Red Hat OpenShift Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mainProfile")
    def main_profile(self) -> pulumi.Output['outputs.ClusterMainProfile']:
        """
        A `main_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "main_profile")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Red Hat OpenShift Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output['outputs.ClusterNetworkProfile']:
        """
        A `network_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_profile")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Resource Group where the Azure Red Hat OpenShift Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> pulumi.Output['outputs.ClusterServicePrincipal']:
        """
        A `service_principal` block as defined below.
        """
        return pulumi.get(self, "service_principal")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workerProfile")
    def worker_profile(self) -> pulumi.Output['outputs.ClusterWorkerProfile']:
        """
        A `worker_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "worker_profile")

