# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CacheAccessPolicyArgs', 'CacheAccessPolicy']

@pulumi.input_type
class CacheAccessPolicyArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[_builtins.str],
                 redis_cache_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CacheAccessPolicy resource.
        :param pulumi.Input[_builtins.str] permissions: Permissions that are going to be assigned to this Redis Cache Access Policy.
        :param pulumi.Input[_builtins.str] redis_cache_id: The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "redis_cache_id", redis_cache_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[_builtins.str]:
        """
        Permissions that are going to be assigned to this Redis Cache Access Policy.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="redisCacheId")
    def redis_cache_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        """
        return pulumi.get(self, "redis_cache_id")

    @redis_cache_id.setter
    def redis_cache_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "redis_cache_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CacheAccessPolicyState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cache_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CacheAccessPolicy resources.
        :param pulumi.Input[_builtins.str] name: The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        :param pulumi.Input[_builtins.str] permissions: Permissions that are going to be assigned to this Redis Cache Access Policy.
        :param pulumi.Input[_builtins.str] redis_cache_id: The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if redis_cache_id is not None:
            pulumi.set(__self__, "redis_cache_id", redis_cache_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Permissions that are going to be assigned to this Redis Cache Access Policy.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="redisCacheId")
    def redis_cache_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        """
        return pulumi.get(self, "redis_cache_id")

    @redis_cache_id.setter
    def redis_cache_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_cache_id", value)


@pulumi.type_token("azure:redis/cacheAccessPolicy:CacheAccessPolicy")
class CacheAccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cache_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Redis Cache Access Policy

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_cache = azure.redis.Cache("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            capacity=1,
            family="P",
            sku_name="Premium",
            enable_non_ssl_port=False,
            redis_configuration={
                "maxmemory_reserved": 2,
                "maxmemory_delta": 2,
                "maxmemory_policy": "allkeys-lru",
            })
        example_cache_access_policy = azure.redis.CacheAccessPolicy("example",
            name="example",
            redis_cache_id=example_cache.id,
            permissions="+@read +@connection +cluster|info")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2024-11-01

        ## Import

        Redis Cache Access Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/cacheAccessPolicy:CacheAccessPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redis/cache1/accessPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        :param pulumi.Input[_builtins.str] permissions: Permissions that are going to be assigned to this Redis Cache Access Policy.
        :param pulumi.Input[_builtins.str] redis_cache_id: The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheAccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Redis Cache Access Policy

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_cache = azure.redis.Cache("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            capacity=1,
            family="P",
            sku_name="Premium",
            enable_non_ssl_port=False,
            redis_configuration={
                "maxmemory_reserved": 2,
                "maxmemory_delta": 2,
                "maxmemory_policy": "allkeys-lru",
            })
        example_cache_access_policy = azure.redis.CacheAccessPolicy("example",
            name="example",
            redis_cache_id=example_cache.id,
            permissions="+@read +@connection +cluster|info")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2024-11-01

        ## Import

        Redis Cache Access Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/cacheAccessPolicy:CacheAccessPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redis/cache1/accessPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param CacheAccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheAccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cache_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheAccessPolicyArgs.__new__(CacheAccessPolicyArgs)

            __props__.__dict__["name"] = name
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if redis_cache_id is None and not opts.urn:
                raise TypeError("Missing required property 'redis_cache_id'")
            __props__.__dict__["redis_cache_id"] = redis_cache_id
        super(CacheAccessPolicy, __self__).__init__(
            'azure:redis/cacheAccessPolicy:CacheAccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[_builtins.str]] = None,
            redis_cache_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CacheAccessPolicy':
        """
        Get an existing CacheAccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        :param pulumi.Input[_builtins.str] permissions: Permissions that are going to be assigned to this Redis Cache Access Policy.
        :param pulumi.Input[_builtins.str] redis_cache_id: The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheAccessPolicyState.__new__(_CacheAccessPolicyState)

        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["redis_cache_id"] = redis_cache_id
        return CacheAccessPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Redis Cache Access Policy. Changing this forces a new Redis Cache Access Policy to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[_builtins.str]:
        """
        Permissions that are going to be assigned to this Redis Cache Access Policy.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="redisCacheId")
    def redis_cache_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Redis Cache. Changing this forces a new Redis Cache Access Policy to be created.
        """
        return pulumi.get(self, "redis_cache_id")

