# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnterpriseDatabaseArgs', 'EnterpriseDatabase']

@pulumi.input_type
class EnterpriseDatabaseArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 client_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 clustering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_group_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a EnterpriseDatabase resource.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] client_protocol: Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] clustering_policy: Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        :param pulumi.Input[_builtins.str] linked_database_group_nickname: Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_database_ids: A list of database resources to link with this database with a maximum of 5.
               
               > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        :param pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]] modules: A `module` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.int] port: TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if client_protocol is not None:
            pulumi.set(__self__, "client_protocol", client_protocol)
        if clustering_policy is not None:
            pulumi.set(__self__, "clustering_policy", clustering_policy)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if linked_database_group_nickname is not None:
            pulumi.set(__self__, "linked_database_group_nickname", linked_database_group_nickname)
        if linked_database_ids is not None:
            pulumi.set(__self__, "linked_database_ids", linked_database_ids)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "client_protocol")

    @client_protocol.setter
    def client_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_protocol", value)

    @_builtins.property
    @pulumi.getter(name="clusteringPolicy")
    def clustering_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "clustering_policy")

    @clustering_policy.setter
    def clustering_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clustering_policy", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabaseGroupNickname")
    def linked_database_group_nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        """
        return pulumi.get(self, "linked_database_group_nickname")

    @linked_database_group_nickname.setter
    def linked_database_group_nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linked_database_group_nickname", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabaseIds")
    def linked_database_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of database resources to link with this database with a maximum of 5.

        > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        """
        return pulumi.get(self, "linked_database_ids")

    @linked_database_ids.setter
    def linked_database_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "linked_database_ids", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]]]:
        """
        A `module` block as defined below. Changing this forces a new resource to be created.

        > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class _EnterpriseDatabaseState:
    def __init__(__self__, *,
                 client_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 clustering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_group_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnterpriseDatabase resources.
        :param pulumi.Input[_builtins.str] client_protocol: Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] clustering_policy: Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        :param pulumi.Input[_builtins.str] linked_database_group_nickname: Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_database_ids: A list of database resources to link with this database with a maximum of 5.
               
               > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        :param pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]] modules: A `module` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.int] port: TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        :param pulumi.Input[_builtins.str] primary_access_key: The Primary Access Key for the Redis Enterprise Database Instance.
        :param pulumi.Input[_builtins.str] secondary_access_key: The Secondary Access Key for the Redis Enterprise Database Instance.
        """
        if client_protocol is not None:
            pulumi.set(__self__, "client_protocol", client_protocol)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if clustering_policy is not None:
            pulumi.set(__self__, "clustering_policy", clustering_policy)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if linked_database_group_nickname is not None:
            pulumi.set(__self__, "linked_database_group_nickname", linked_database_group_nickname)
        if linked_database_ids is not None:
            pulumi.set(__self__, "linked_database_ids", linked_database_ids)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @_builtins.property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "client_protocol")

    @client_protocol.setter
    def client_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_protocol", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusteringPolicy")
    def clustering_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "clustering_policy")

    @clustering_policy.setter
    def clustering_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clustering_policy", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabaseGroupNickname")
    def linked_database_group_nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        """
        return pulumi.get(self, "linked_database_group_nickname")

    @linked_database_group_nickname.setter
    def linked_database_group_nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linked_database_group_nickname", value)

    @_builtins.property
    @pulumi.getter(name="linkedDatabaseIds")
    def linked_database_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of database resources to link with this database with a maximum of 5.

        > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        """
        return pulumi.get(self, "linked_database_ids")

    @linked_database_ids.setter
    def linked_database_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "linked_database_ids", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]]]:
        """
        A `module` block as defined below. Changing this forces a new resource to be created.

        > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseDatabaseModuleArgs']]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Access Key for the Redis Enterprise Database Instance.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Access Key for the Redis Enterprise Database Instance.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)


@pulumi.type_token("azure:redis/enterpriseDatabase:EnterpriseDatabase")
class EnterpriseDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 clustering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_group_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnterpriseDatabaseModuleArgs', 'EnterpriseDatabaseModuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Redis Enterprise Database.

        > **Note:** This resource has been deprecated in favor of azurerm_managed_redis.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-redisenterprise",
            location="West Europe")
        example_enterprise_cluster = azure.redis.EnterpriseCluster("example",
            name="example-redisenterprise",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Enterprise_E20-4")
        example1 = azure.redis.EnterpriseCluster("example1",
            name="example-redisenterprise1",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Enterprise_E20-4")
        example_enterprise_database = azure.redis.EnterpriseDatabase("example",
            name="default",
            cluster_id=example_enterprise_cluster.id,
            client_protocol="Encrypted",
            clustering_policy="EnterpriseCluster",
            eviction_policy="NoEviction",
            port=10000,
            linked_database_ids=[
                example_enterprise_cluster.id.apply(lambda id: f"{id}/databases/default"),
                example1.id.apply(lambda id: f"{id}/databases/default"),
            ],
            linked_database_group_nickname="tftestGeoGroup")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2024-10-01

        ## Import

        Redis Enterprise Databases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/enterpriseDatabase:EnterpriseDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redisEnterprise/cluster1/databases/database1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_protocol: Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] clustering_policy: Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        :param pulumi.Input[_builtins.str] linked_database_group_nickname: Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_database_ids: A list of database resources to link with this database with a maximum of 5.
               
               > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnterpriseDatabaseModuleArgs', 'EnterpriseDatabaseModuleArgsDict']]]] modules: A `module` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.int] port: TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Redis Enterprise Database.

        > **Note:** This resource has been deprecated in favor of azurerm_managed_redis.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-redisenterprise",
            location="West Europe")
        example_enterprise_cluster = azure.redis.EnterpriseCluster("example",
            name="example-redisenterprise",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Enterprise_E20-4")
        example1 = azure.redis.EnterpriseCluster("example1",
            name="example-redisenterprise1",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Enterprise_E20-4")
        example_enterprise_database = azure.redis.EnterpriseDatabase("example",
            name="default",
            cluster_id=example_enterprise_cluster.id,
            client_protocol="Encrypted",
            clustering_policy="EnterpriseCluster",
            eviction_policy="NoEviction",
            port=10000,
            linked_database_ids=[
                example_enterprise_cluster.id.apply(lambda id: f"{id}/databases/default"),
                example1.id.apply(lambda id: f"{id}/databases/default"),
            ],
            linked_database_group_nickname="tftestGeoGroup")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cache` - 2024-10-01

        ## Import

        Redis Enterprise Databases can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/enterpriseDatabase:EnterpriseDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redisEnterprise/cluster1/databases/database1
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 clustering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_group_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnterpriseDatabaseModuleArgs', 'EnterpriseDatabaseModuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseDatabaseArgs.__new__(EnterpriseDatabaseArgs)

            __props__.__dict__["client_protocol"] = client_protocol
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["clustering_policy"] = clustering_policy
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["linked_database_group_nickname"] = linked_database_group_nickname
            __props__.__dict__["linked_database_ids"] = linked_database_ids
            __props__.__dict__["modules"] = modules
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["secondary_access_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "secondaryAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EnterpriseDatabase, __self__).__init__(
            'azure:redis/enterpriseDatabase:EnterpriseDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            clustering_policy: Optional[pulumi.Input[_builtins.str]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            linked_database_group_nickname: Optional[pulumi.Input[_builtins.str]] = None,
            linked_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            modules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnterpriseDatabaseModuleArgs', 'EnterpriseDatabaseModuleArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnterpriseDatabase':
        """
        Get an existing EnterpriseDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_protocol: Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] clustering_policy: Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        :param pulumi.Input[_builtins.str] linked_database_group_nickname: Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linked_database_ids: A list of database resources to link with this database with a maximum of 5.
               
               > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnterpriseDatabaseModuleArgs', 'EnterpriseDatabaseModuleArgsDict']]]] modules: A `module` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        :param pulumi.Input[_builtins.int] port: TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        :param pulumi.Input[_builtins.str] primary_access_key: The Primary Access Key for the Redis Enterprise Database Instance.
        :param pulumi.Input[_builtins.str] secondary_access_key: The Secondary Access Key for the Redis Enterprise Database Instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseDatabaseState.__new__(_EnterpriseDatabaseState)

        __props__.__dict__["client_protocol"] = client_protocol
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["clustering_policy"] = clustering_policy
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["linked_database_group_nickname"] = linked_database_group_nickname
        __props__.__dict__["linked_database_ids"] = linked_database_ids
        __props__.__dict__["modules"] = modules
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        return EnterpriseDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Possible values are `Encrypted` and `Plaintext`. Defaults to `Encrypted`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "client_protocol")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource id of the Redis Enterprise Cluster to deploy this Redis Enterprise Database. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusteringPolicy")
    def clustering_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Clustering policy Specified at create time. Possible values are `EnterpriseCluster` and `OSSCluster`. Defaults to `OSSCluster`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "clustering_policy")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Redis eviction policy possible values are `AllKeysLFU`, `AllKeysLRU`, `AllKeysRandom`, `VolatileLRU`, `VolatileLFU`, `VolatileTTL`, `VolatileRandom` and `NoEviction`. Changing this forces a new Redis Enterprise Database to be created. Defaults to `VolatileLRU`.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="linkedDatabaseGroupNickname")
    def linked_database_group_nickname(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Nickname of the group of linked databases. Changing this force a new Redis Enterprise Geo Database to be created.
        """
        return pulumi.get(self, "linked_database_group_nickname")

    @_builtins.property
    @pulumi.getter(name="linkedDatabaseIds")
    def linked_database_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of database resources to link with this database with a maximum of 5.

        > **Note:** Only the newly created databases can be added to an existing geo-replication group. Existing regular databases or recreated databases cannot be added to the existing geo-replication group. Any linked database removed from the list will be forcefully unlinked. The only recommended operation is to delete after force-unlink and the recommended scenario of force-unlink is region outage. The database cannot be linked again after force-unlink.
        """
        return pulumi.get(self, "linked_database_ids")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> pulumi.Output[Optional[Sequence['outputs.EnterpriseDatabaseModule']]]:
        """
        A `module` block as defined below. Changing this forces a new resource to be created.

        > **Note:** Only `RediSearch` and `RedisJSON` modules are allowed with geo-replication
        """
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Redis Enterprise Database. Currently the acceptable value for this argument is `default`. Defaults to `default`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        TCP port of the database endpoint. Specified at create time. Defaults to an available port. Changing this forces a new Redis Enterprise Database to be created. Defaults to `10000`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Access Key for the Redis Enterprise Database Instance.
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary Access Key for the Redis Enterprise Database Instance.
        """
        return pulumi.get(self, "secondary_access_key")

