# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssignmentArgs', 'Assignment']

@pulumi.input_type
class AssignmentArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Assignment resource.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        :param pulumi.Input[_builtins.str] scope: The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition` is required when `condition_version` is set.
        :param pulumi.Input[_builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[_builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_type: The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        :param pulumi.Input[_builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created.
               
               > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        :param pulumi.Input[_builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.
               
               > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "scope", scope)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if condition_version is not None:
            pulumi.set(__self__, "condition_version", condition_version)
        if delegated_managed_identity_resource_id is not None:
            pulumi.set(__self__, "delegated_managed_identity_resource_id", delegated_managed_identity_resource_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if role_definition_name is not None:
            pulumi.set(__self__, "role_definition_name", role_definition_name)
        if skip_service_principal_aad_check is not None:
            pulumi.set(__self__, "skip_service_principal_aad_check", skip_service_principal_aad_check)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.

        > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.

        > **Note:** `condition` is required when `condition_version` is set.
        """
        return pulumi.get(self, "condition_version")

    @condition_version.setter
    def condition_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_version", value)

    @_builtins.property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.

        > **Note:** This field is only used in cross tenant scenarios.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @delegated_managed_identity_resource_id.setter
    def delegated_managed_identity_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_managed_identity_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for this Role Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionName")
    def role_definition_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a built-in Role. Changing this forces a new resource to be created.

        > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        """
        return pulumi.get(self, "role_definition_name")

    @role_definition_name.setter
    def role_definition_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_name", value)

    @_builtins.property
    @pulumi.getter(name="skipServicePrincipalAadCheck")
    def skip_service_principal_aad_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.

        > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        return pulumi.get(self, "skip_service_principal_aad_check")

    @skip_service_principal_aad_check.setter
    def skip_service_principal_aad_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_service_principal_aad_check", value)


@pulumi.input_type
class _AssignmentState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Assignment resources.
        :param pulumi.Input[_builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition` is required when `condition_version` is set.
        :param pulumi.Input[_builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[_builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        :param pulumi.Input[_builtins.str] principal_type: The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        :param pulumi.Input[_builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created.
               
               > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        :param pulumi.Input[_builtins.str] scope: The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.
               
               > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if condition_version is not None:
            pulumi.set(__self__, "condition_version", condition_version)
        if delegated_managed_identity_resource_id is not None:
            pulumi.set(__self__, "delegated_managed_identity_resource_id", delegated_managed_identity_resource_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if role_definition_name is not None:
            pulumi.set(__self__, "role_definition_name", role_definition_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if skip_service_principal_aad_check is not None:
            pulumi.set(__self__, "skip_service_principal_aad_check", skip_service_principal_aad_check)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.

        > **Note:** `condition` is required when `condition_version` is set.
        """
        return pulumi.get(self, "condition_version")

    @condition_version.setter
    def condition_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_version", value)

    @_builtins.property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.

        > **Note:** This field is only used in cross tenant scenarios.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @delegated_managed_identity_resource_id.setter
    def delegated_managed_identity_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_managed_identity_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for this Role Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.

        > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionName")
    def role_definition_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a built-in Role. Changing this forces a new resource to be created.

        > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        """
        return pulumi.get(self, "role_definition_name")

    @role_definition_name.setter
    def role_definition_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_name", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="skipServicePrincipalAadCheck")
    def skip_service_principal_aad_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.

        > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        return pulumi.get(self, "skip_service_principal_aad_check")

    @skip_service_principal_aad_check.setter
    def skip_service_principal_aad_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_service_principal_aad_check", value)


warnings.warn("""azure.role.Assignment has been deprecated in favor of azure.authorization.Assignment""", DeprecationWarning)


@pulumi.type_token("azure:role/assignment:Assignment")
class Assignment(pulumi.CustomResource):
    warnings.warn("""azure.role.Assignment has been deprecated in favor of azure.authorization.Assignment""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Assigns a given Principal (User or Group) to a given Role.

        ## Example Usage

        ### Using A Built-In Role)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_assignment = azure.authorization.Assignment("example",
            scope=primary.id,
            role_definition_name="Reader",
            principal_id=example.object_id)
        ```

        ### Custom Role & Service Principal)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_role_definition = azure.authorization.RoleDefinition("example",
            role_definition_id="00000000-0000-0000-0000-000000000000",
            name="my-custom-role-definition",
            scope=primary.id,
            permissions=[{
                "actions": ["Microsoft.Resources/subscriptions/resourceGroups/read"],
                "not_actions": [],
            }],
            assignable_scopes=[primary.id])
        example_assignment = azure.authorization.Assignment("example",
            name="00000000-0000-0000-0000-000000000000",
            scope=primary.id,
            role_definition_id=example_role_definition.role_definition_resource_id,
            principal_id=example.object_id)
        ```

        ### Custom Role & User)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_role_definition = azure.authorization.RoleDefinition("example",
            role_definition_id="00000000-0000-0000-0000-000000000000",
            name="my-custom-role-definition",
            scope=primary.id,
            permissions=[{
                "actions": ["Microsoft.Resources/subscriptions/resourceGroups/read"],
                "not_actions": [],
            }],
            assignable_scopes=[primary.id])
        example_assignment = azure.authorization.Assignment("example",
            name="00000000-0000-0000-0000-000000000000",
            scope=primary.id,
            role_definition_id=example_role_definition.role_definition_resource_id,
            principal_id=example.object_id)
        ```

        ### Custom Role & Management Group)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_get_group = azure.management.get_group(name="00000000-0000-0000-0000-000000000000")
        example_role_definition = azure.authorization.RoleDefinition("example",
            role_definition_id="00000000-0000-0000-0000-000000000000",
            name="my-custom-role-definition",
            scope=primary.id,
            permissions=[{
                "actions": ["Microsoft.Resources/subscriptions/resourceGroups/read"],
                "not_actions": [],
            }],
            assignable_scopes=[primary.id])
        example_assignment = azure.authorization.Assignment("example",
            name="00000000-0000-0000-0000-000000000000",
            scope=primary_azurerm_management_group["id"],
            role_definition_id=example_role_definition.role_definition_resource_id,
            principal_id=example.object_id)
        ```

        ### ABAC Condition)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        builtin = azure.authorization.get_role_definition(name="Reader")
        example_assignment = azure.authorization.Assignment("example",
            role_definition_name="Role Based Access Control Administrator",
            scope=primary.id,
            principal_id=example.object_id,
            principal_type="ServicePrincipal",
            description="Role Based Access Control Administrator role assignment with ABAC Condition.",
            condition_version="2.0",
            condition=f\"\"\"(
         (
          !(ActionMatches{{'Microsoft.Authorization/roleAssignments/write'}})
         )
         OR
         (
          @Request[Microsoft.Authorization/roleAssignments:RoleDefinitionId] ForAnyOfAnyValues:GuidEquals {{{std.basename(input=builtin.role_definition_id).result}}}
         )
        )
        AND
        (
         (
          !(ActionMatches{{'Microsoft.Authorization/roleAssignments/delete'}})
         )
         OR
         (
          @Resource[Microsoft.Authorization/roleAssignments:RoleDefinitionId] ForAnyOfAnyValues:GuidEquals {{{std.basename(input=builtin.role_definition_id).result}}}
         )
        )
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization` - 2022-05-01-preview, 2022-04-01

        ## Import

        Role Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:role/assignment:Assignment example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000
        ```

        * for scope `Subscription`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        * for scope `Resource Group`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        * for scope `Key Vault`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.KeyVault/vaults/vault1/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        * for scope `Storage Account`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Storage/storageAccounts/storageAccount1/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        text

        /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000|00000000-0000-0000-0000-000000000000

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition` is required when `condition_version` is set.
        :param pulumi.Input[_builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[_builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        :param pulumi.Input[_builtins.str] principal_type: The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        :param pulumi.Input[_builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created.
               
               > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        :param pulumi.Input[_builtins.str] scope: The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.
               
               > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assigns a given Principal (User or Group) to a given Role.

        ## Example Usage

        ### Using A Built-In Role)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_assignment = azure.authorization.Assignment("example",
            scope=primary.id,
            role_definition_name="Reader",
            principal_id=example.object_id)
        ```

        ### Custom Role & Service Principal)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_role_definition = azure.authorization.RoleDefinition("example",
            role_definition_id="00000000-0000-0000-0000-000000000000",
            name="my-custom-role-definition",
            scope=primary.id,
            permissions=[{
                "actions": ["Microsoft.Resources/subscriptions/resourceGroups/read"],
                "not_actions": [],
            }],
            assignable_scopes=[primary.id])
        example_assignment = azure.authorization.Assignment("example",
            name="00000000-0000-0000-0000-000000000000",
            scope=primary.id,
            role_definition_id=example_role_definition.role_definition_resource_id,
            principal_id=example.object_id)
        ```

        ### Custom Role & User)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_role_definition = azure.authorization.RoleDefinition("example",
            role_definition_id="00000000-0000-0000-0000-000000000000",
            name="my-custom-role-definition",
            scope=primary.id,
            permissions=[{
                "actions": ["Microsoft.Resources/subscriptions/resourceGroups/read"],
                "not_actions": [],
            }],
            assignable_scopes=[primary.id])
        example_assignment = azure.authorization.Assignment("example",
            name="00000000-0000-0000-0000-000000000000",
            scope=primary.id,
            role_definition_id=example_role_definition.role_definition_resource_id,
            principal_id=example.object_id)
        ```

        ### Custom Role & Management Group)

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        example_get_group = azure.management.get_group(name="00000000-0000-0000-0000-000000000000")
        example_role_definition = azure.authorization.RoleDefinition("example",
            role_definition_id="00000000-0000-0000-0000-000000000000",
            name="my-custom-role-definition",
            scope=primary.id,
            permissions=[{
                "actions": ["Microsoft.Resources/subscriptions/resourceGroups/read"],
                "not_actions": [],
            }],
            assignable_scopes=[primary.id])
        example_assignment = azure.authorization.Assignment("example",
            name="00000000-0000-0000-0000-000000000000",
            scope=primary_azurerm_management_group["id"],
            role_definition_id=example_role_definition.role_definition_resource_id,
            principal_id=example.object_id)
        ```

        ### ABAC Condition)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        primary = azure.core.get_subscription()
        example = azure.core.get_client_config()
        builtin = azure.authorization.get_role_definition(name="Reader")
        example_assignment = azure.authorization.Assignment("example",
            role_definition_name="Role Based Access Control Administrator",
            scope=primary.id,
            principal_id=example.object_id,
            principal_type="ServicePrincipal",
            description="Role Based Access Control Administrator role assignment with ABAC Condition.",
            condition_version="2.0",
            condition=f\"\"\"(
         (
          !(ActionMatches{{'Microsoft.Authorization/roleAssignments/write'}})
         )
         OR
         (
          @Request[Microsoft.Authorization/roleAssignments:RoleDefinitionId] ForAnyOfAnyValues:GuidEquals {{{std.basename(input=builtin.role_definition_id).result}}}
         )
        )
        AND
        (
         (
          !(ActionMatches{{'Microsoft.Authorization/roleAssignments/delete'}})
         )
         OR
         (
          @Resource[Microsoft.Authorization/roleAssignments:RoleDefinitionId] ForAnyOfAnyValues:GuidEquals {{{std.basename(input=builtin.role_definition_id).result}}}
         )
        )
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization` - 2022-05-01-preview, 2022-04-01

        ## Import

        Role Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:role/assignment:Assignment example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000
        ```

        * for scope `Subscription`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        * for scope `Resource Group`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        * for scope `Key Vault`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.KeyVault/vaults/vault1/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        * for scope `Storage Account`, the id format is `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Storage/storageAccounts/storageAccount1/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000`

        text

        /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000|00000000-0000-0000-0000-000000000000

        :param str resource_name: The name of the resource.
        :param AssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        pulumi.log.warn("""Assignment is deprecated: azure.role.Assignment has been deprecated in favor of azure.authorization.Assignment""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssignmentArgs.__new__(AssignmentArgs)

            __props__.__dict__["condition"] = condition
            __props__.__dict__["condition_version"] = condition_version
            __props__.__dict__["delegated_managed_identity_resource_id"] = delegated_managed_identity_resource_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            __props__.__dict__["principal_type"] = principal_type
            __props__.__dict__["role_definition_id"] = role_definition_id
            __props__.__dict__["role_definition_name"] = role_definition_name
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["skip_service_principal_aad_check"] = skip_service_principal_aad_check
        super(Assignment, __self__).__init__(
            'azure:role/assignment:Assignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[_builtins.str]] = None,
            condition_version: Optional[pulumi.Input[_builtins.str]] = None,
            delegated_managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            skip_service_principal_aad_check: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Assignment':
        """
        Get an existing Assignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
               
               > **Note:** `condition` is required when `condition_version` is set.
        :param pulumi.Input[_builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[_builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        :param pulumi.Input[_builtins.str] principal_type: The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        :param pulumi.Input[_builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created.
               
               > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        :param pulumi.Input[_builtins.str] scope: The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.
               
               > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssignmentState.__new__(_AssignmentState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["condition_version"] = condition_version
        __props__.__dict__["delegated_managed_identity_resource_id"] = delegated_managed_identity_resource_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["role_definition_id"] = role_definition_id
        __props__.__dict__["role_definition_name"] = role_definition_name
        __props__.__dict__["scope"] = scope
        __props__.__dict__["skip_service_principal_aad_check"] = skip_service_principal_aad_check
        return Assignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.

        > **Note:** `condition` is required when `condition_version` is set.
        """
        return pulumi.get(self, "condition_version")

    @_builtins.property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The delegated Azure Resource Id which contains a Managed Identity. Changing this forces a new resource to be created.

        > **Note:** This field is only used in cross tenant scenarios.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for this Role Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.

        > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications).
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the `principal_id`. Possible values are `User`, `Group` and `ServicePrincipal`. Changing this forces a new resource to be created. It is necessary to explicitly set this attribute when creating role assignments if the principal creating the assignment is constrained by ABAC rules that filters on the PrincipalType attribute.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Scoped-ID of the Role Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionName")
    def role_definition_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of a built-in Role. Changing this forces a new resource to be created.

        > **Note:** Either `role_definition_id` or `role_definition_name` must be set.
        """
        return pulumi.get(self, "role_definition_name")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope at which the Role Assignment applies to, such as `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333`, `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup`, or `/subscriptions/0b1f6471-1bf0-4dda-aec3-111122223333/resourceGroups/myGroup/providers/Microsoft.Compute/virtualMachines/myVM`, or `/providers/Microsoft.Management/managementGroups/myMG`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="skipServicePrincipalAadCheck")
    def skip_service_principal_aad_check(self) -> pulumi.Output[_builtins.bool]:
        """
        If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`.

        > **Note:** If it is not a `Service Principal` identity it will cause the role assignment to fail.
        """
        return pulumi.get(self, "skip_service_principal_aad_check")

