# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SharedPrivateLinkServiceArgs', 'SharedPrivateLinkService']

@pulumi.input_type
class SharedPrivateLinkServiceArgs:
    def __init__(__self__, *,
                 search_service_id: pulumi.Input[_builtins.str],
                 subresource_name: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SharedPrivateLinkService resource.
        :param pulumi.Input[_builtins.str] search_service_id: Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        pulumi.set(__self__, "search_service_id", search_service_id)
        pulumi.set(__self__, "subresource_name", subresource_name)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)

    @_builtins.property
    @pulumi.getter(name="searchServiceId")
    def search_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "search_service_id")

    @search_service_id.setter
    def search_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "search_service_id", value)

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subresource_name")

    @subresource_name.setter
    def subresource_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subresource_name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.

        > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)


@pulumi.input_type
class _SharedPrivateLinkServiceState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SharedPrivateLinkService resources.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        :param pulumi.Input[_builtins.str] search_service_id: Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if search_service_id is not None:
            pulumi.set(__self__, "search_service_id", search_service_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subresource_name is not None:
            pulumi.set(__self__, "subresource_name", subresource_name)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)

    @_builtins.property
    @pulumi.getter(name="searchServiceId")
    def search_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "search_service_id")

    @search_service_id.setter
    def search_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_service_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subresource_name")

    @subresource_name.setter
    def subresource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subresource_name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.

        > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.type_token("azure:search/sharedPrivateLinkService:SharedPrivateLinkService")
class SharedPrivateLinkService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Shared Private Link Service for an Azure Search Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        test = azure.core.ResourceGroup("test",
            name="example-resourceGroup",
            location="east us")
        test_service = azure.search.Service("test",
            name="example-search",
            resource_group_name=test.name,
            location=test.location,
            sku="standard")
        test_account = azure.storage.Account("test",
            name="example",
            resource_group_name=test.name,
            location=test.location,
            account_tier="Standard",
            account_replication_type="LRS")
        test_shared_private_link_service = azure.search.SharedPrivateLinkService("test",
            name="example-spl",
            search_service_id=test_service.id,
            subresource_name="blob",
            target_resource_id=test_account.id,
            request_message="please approve")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Search` - 2025-05-01

        ## Import

        Azure Search Shared Private Link Resource can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:search/sharedPrivateLinkService:SharedPrivateLinkService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Search/searchServices/service1/sharedPrivateLinkResources/resource1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        :param pulumi.Input[_builtins.str] search_service_id: Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedPrivateLinkServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Shared Private Link Service for an Azure Search Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        test = azure.core.ResourceGroup("test",
            name="example-resourceGroup",
            location="east us")
        test_service = azure.search.Service("test",
            name="example-search",
            resource_group_name=test.name,
            location=test.location,
            sku="standard")
        test_account = azure.storage.Account("test",
            name="example",
            resource_group_name=test.name,
            location=test.location,
            account_tier="Standard",
            account_replication_type="LRS")
        test_shared_private_link_service = azure.search.SharedPrivateLinkService("test",
            name="example-spl",
            search_service_id=test_service.id,
            subresource_name="blob",
            target_resource_id=test_account.id,
            request_message="please approve")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Search` - 2025-05-01

        ## Import

        Azure Search Shared Private Link Resource can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:search/sharedPrivateLinkService:SharedPrivateLinkService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Search/searchServices/service1/sharedPrivateLinkResources/resource1
        ```

        :param str resource_name: The name of the resource.
        :param SharedPrivateLinkServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedPrivateLinkServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedPrivateLinkServiceArgs.__new__(SharedPrivateLinkServiceArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["request_message"] = request_message
            if search_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'search_service_id'")
            __props__.__dict__["search_service_id"] = search_service_id
            if subresource_name is None and not opts.urn:
                raise TypeError("Missing required property 'subresource_name'")
            __props__.__dict__["subresource_name"] = subresource_name
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            __props__.__dict__["status"] = None
        super(SharedPrivateLinkService, __self__).__init__(
            'azure:search/sharedPrivateLinkService:SharedPrivateLinkService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            request_message: Optional[pulumi.Input[_builtins.str]] = None,
            search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SharedPrivateLinkService':
        """
        Get an existing SharedPrivateLinkService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        :param pulumi.Input[_builtins.str] search_service_id: Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedPrivateLinkServiceState.__new__(_SharedPrivateLinkServiceState)

        __props__.__dict__["name"] = name
        __props__.__dict__["request_message"] = request_message
        __props__.__dict__["search_service_id"] = search_service_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subresource_name"] = subresource_name
        __props__.__dict__["target_resource_id"] = target_resource_id
        return SharedPrivateLinkService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the name of the Azure Search Shared Private Link Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        return pulumi.get(self, "request_message")

    @_builtins.property
    @pulumi.getter(name="searchServiceId")
    def search_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the id of the Azure Search Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "search_service_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the sub resource name which the Azure Search Private Endpoint is able to connect to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subresource_name")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the ID of the Shared Private Link Enabled Remote Resource which this Azure Search Private Endpoint should be connected to. Changing this forces a new resource to be created.

        > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        return pulumi.get(self, "target_resource_id")

