# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssessmentPolicyArgs', 'AssessmentPolicy']

@pulumi.input_type
class AssessmentPolicyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 implementation_effort: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_impact: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AssessmentPolicy resource.
        :param pulumi.Input[_builtins.str] description: The description of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly display name of the Security Center Assessment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        :param pulumi.Input[_builtins.str] implementation_effort: The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        :param pulumi.Input[_builtins.str] remediation_description: The description which is used to mitigate the security issue.
        :param pulumi.Input[_builtins.str] severity: The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threats: A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        :param pulumi.Input[_builtins.str] user_impact: The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if implementation_effort is not None:
            pulumi.set(__self__, "implementation_effort", implementation_effort)
        if remediation_description is not None:
            pulumi.set(__self__, "remediation_description", remediation_description)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if threats is not None:
            pulumi.set(__self__, "threats", threats)
        if user_impact is not None:
            pulumi.set(__self__, "user_impact", user_impact)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the Security Center Assessment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly display name of the Security Center Assessment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        return pulumi.get(self, "implementation_effort")

    @implementation_effort.setter
    def implementation_effort(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "implementation_effort", value)

    @_builtins.property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description which is used to mitigate the security issue.
        """
        return pulumi.get(self, "remediation_description")

    @remediation_description.setter
    def remediation_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remediation_description", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def threats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        """
        return pulumi.get(self, "threats")

    @threats.setter
    def threats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "threats", value)

    @_builtins.property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        return pulumi.get(self, "user_impact")

    @user_impact.setter
    def user_impact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_impact", value)


@pulumi.input_type
class _AssessmentPolicyState:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 implementation_effort: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_impact: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AssessmentPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        :param pulumi.Input[_builtins.str] description: The description of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly display name of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] implementation_effort: The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        :param pulumi.Input[_builtins.str] name: The GUID as the name of the Security Center Assessment Policy.
        :param pulumi.Input[_builtins.str] remediation_description: The description which is used to mitigate the security issue.
        :param pulumi.Input[_builtins.str] severity: The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threats: A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        :param pulumi.Input[_builtins.str] user_impact: The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if implementation_effort is not None:
            pulumi.set(__self__, "implementation_effort", implementation_effort)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remediation_description is not None:
            pulumi.set(__self__, "remediation_description", remediation_description)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if threats is not None:
            pulumi.set(__self__, "threats", threats)
        if user_impact is not None:
            pulumi.set(__self__, "user_impact", user_impact)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Security Center Assessment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly display name of the Security Center Assessment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        return pulumi.get(self, "implementation_effort")

    @implementation_effort.setter
    def implementation_effort(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "implementation_effort", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID as the name of the Security Center Assessment Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description which is used to mitigate the security issue.
        """
        return pulumi.get(self, "remediation_description")

    @remediation_description.setter
    def remediation_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remediation_description", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def threats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        """
        return pulumi.get(self, "threats")

    @threats.setter
    def threats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "threats", value)

    @_builtins.property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        return pulumi.get(self, "user_impact")

    @user_impact.setter
    def user_impact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_impact", value)


@pulumi.type_token("azure:securitycenter/assessmentPolicy:AssessmentPolicy")
class AssessmentPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 implementation_effort: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_impact: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Security Center Assessment Metadata for Azure Security Center.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.AssessmentPolicy("example",
            display_name="Test Display Name",
            severity="Medium",
            description="Test Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security` - 2021-06-01

        ## Import

        Security Assessments Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/assessmentPolicy:AssessmentPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/assessmentMetadata/metadata1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        :param pulumi.Input[_builtins.str] description: The description of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly display name of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] implementation_effort: The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        :param pulumi.Input[_builtins.str] remediation_description: The description which is used to mitigate the security issue.
        :param pulumi.Input[_builtins.str] severity: The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threats: A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        :param pulumi.Input[_builtins.str] user_impact: The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssessmentPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Security Center Assessment Metadata for Azure Security Center.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.AssessmentPolicy("example",
            display_name="Test Display Name",
            severity="Medium",
            description="Test Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security` - 2021-06-01

        ## Import

        Security Assessments Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/assessmentPolicy:AssessmentPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/assessmentMetadata/metadata1
        ```

        :param str resource_name: The name of the resource.
        :param AssessmentPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssessmentPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 implementation_effort: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_impact: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssessmentPolicyArgs.__new__(AssessmentPolicyArgs)

            __props__.__dict__["categories"] = categories
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["implementation_effort"] = implementation_effort
            __props__.__dict__["remediation_description"] = remediation_description
            __props__.__dict__["severity"] = severity
            __props__.__dict__["threats"] = threats
            __props__.__dict__["user_impact"] = user_impact
            __props__.__dict__["name"] = None
        super(AssessmentPolicy, __self__).__init__(
            'azure:securitycenter/assessmentPolicy:AssessmentPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            implementation_effort: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            remediation_description: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            threats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_impact: Optional[pulumi.Input[_builtins.str]] = None) -> 'AssessmentPolicy':
        """
        Get an existing AssessmentPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        :param pulumi.Input[_builtins.str] description: The description of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly display name of the Security Center Assessment.
        :param pulumi.Input[_builtins.str] implementation_effort: The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        :param pulumi.Input[_builtins.str] name: The GUID as the name of the Security Center Assessment Policy.
        :param pulumi.Input[_builtins.str] remediation_description: The description which is used to mitigate the security issue.
        :param pulumi.Input[_builtins.str] severity: The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threats: A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        :param pulumi.Input[_builtins.str] user_impact: The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssessmentPolicyState.__new__(_AssessmentPolicyState)

        __props__.__dict__["categories"] = categories
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["implementation_effort"] = implementation_effort
        __props__.__dict__["name"] = name
        __props__.__dict__["remediation_description"] = remediation_description
        __props__.__dict__["severity"] = severity
        __props__.__dict__["threats"] = threats
        __props__.__dict__["user_impact"] = user_impact
        return AssessmentPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of the categories of resource that is at risk when the Security Center Assessment is unhealthy. Possible values are `Unknown`, `Compute`, `Data`, `IdentityAndAccess`, `IoT` and `Networking`.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the Security Center Assessment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly display name of the Security Center Assessment.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The implementation effort which is used to remediate the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        return pulumi.get(self, "implementation_effort")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The GUID as the name of the Security Center Assessment Policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description which is used to mitigate the security issue.
        """
        return pulumi.get(self, "remediation_description")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The severity level of the Security Center Assessment. Possible values are `Low`, `Medium` and `High`. Defaults to `Medium`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def threats(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the threat impacts for the Security Center Assessment. Possible values are `AccountBreach`, `DataExfiltration`, `DataSpillage`, `DenialOfService`, `ElevationOfPrivilege`, `MaliciousInsider`, `MissingCoverage` and `ThreatResistance`.
        """
        return pulumi.get(self, "threats")

    @_builtins.property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user impact of the Security Center Assessment. Possible values are `Low`, `Moderate` and `High`.
        """
        return pulumi.get(self, "user_impact")

