# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAzureActiveDirectory',
    'ClusterCertificate',
    'ClusterCertificateCommonNames',
    'ClusterCertificateCommonNamesCommonName',
    'ClusterClientCertificateCommonName',
    'ClusterClientCertificateThumbprint',
    'ClusterDiagnosticsConfig',
    'ClusterFabricSetting',
    'ClusterNodeType',
    'ClusterNodeTypeApplicationPorts',
    'ClusterNodeTypeEphemeralPorts',
    'ClusterReverseProxyCertificate',
    'ClusterReverseProxyCertificateCommonNames',
    'ClusterReverseProxyCertificateCommonNamesCommonName',
    'ClusterUpgradePolicy',
    'ClusterUpgradePolicyDeltaHealthPolicy',
    'ClusterUpgradePolicyHealthPolicy',
    'ManagedClusterAuthentication',
    'ManagedClusterAuthenticationActiveDirectory',
    'ManagedClusterAuthenticationCertificate',
    'ManagedClusterCustomFabricSetting',
    'ManagedClusterLbRule',
    'ManagedClusterNodeType',
    'ManagedClusterNodeTypeVmSecret',
    'ManagedClusterNodeTypeVmSecretCertificate',
]

@pulumi.output_type
class ClusterAzureActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientApplicationId":
            suggest = "client_application_id"
        elif key == "clusterApplicationId":
            suggest = "cluster_application_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAzureActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAzureActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAzureActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_application_id: _builtins.str,
                 cluster_application_id: _builtins.str,
                 tenant_id: _builtins.str):
        """
        :param _builtins.str client_application_id: The Azure Active Directory Client ID which should be used for the Client Application.
        :param _builtins.str cluster_application_id: The Azure Active Directory Cluster Application ID.
        :param _builtins.str tenant_id: The Azure Active Directory Tenant ID.
        """
        pulumi.set(__self__, "client_application_id", client_application_id)
        pulumi.set(__self__, "cluster_application_id", cluster_application_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="clientApplicationId")
    def client_application_id(self) -> _builtins.str:
        """
        The Azure Active Directory Client ID which should be used for the Client Application.
        """
        return pulumi.get(self, "client_application_id")

    @_builtins.property
    @pulumi.getter(name="clusterApplicationId")
    def cluster_application_id(self) -> _builtins.str:
        """
        The Azure Active Directory Cluster Application ID.
        """
        return pulumi.get(self, "cluster_application_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ClusterCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509StoreName":
            suggest = "x509_store_name"
        elif key == "thumbprintSecondary":
            suggest = "thumbprint_secondary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 thumbprint: _builtins.str,
                 x509_store_name: _builtins.str,
                 thumbprint_secondary: Optional[_builtins.str] = None):
        """
        :param _builtins.str thumbprint: The Thumbprint of the Certificate.
        :param _builtins.str x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        :param _builtins.str thumbprint_secondary: The Secondary Thumbprint of the Certificate.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "x509_store_name", x509_store_name)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> _builtins.str:
        """
        The Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @_builtins.property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> _builtins.str:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")

    @_builtins.property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[_builtins.str]:
        """
        The Secondary Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")


@pulumi.output_type
class ClusterCertificateCommonNames(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonNames":
            suggest = "common_names"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCertificateCommonNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCertificateCommonNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCertificateCommonNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_names: Sequence['outputs.ClusterCertificateCommonNamesCommonName'],
                 x509_store_name: _builtins.str):
        """
        :param Sequence['ClusterCertificateCommonNamesCommonNameArgs'] common_names: A `common_names` block as defined below.
        :param _builtins.str x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        """
        pulumi.set(__self__, "common_names", common_names)
        pulumi.set(__self__, "x509_store_name", x509_store_name)

    @_builtins.property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> Sequence['outputs.ClusterCertificateCommonNamesCommonName']:
        """
        A `common_names` block as defined below.
        """
        return pulumi.get(self, "common_names")

    @_builtins.property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> _builtins.str:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ClusterCertificateCommonNamesCommonName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCertificateCommonNamesCommonName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCertificateCommonNamesCommonName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCertificateCommonNamesCommonName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: _builtins.str,
                 certificate_issuer_thumbprint: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_common_name: The common or subject name of the certificate.
        :param _builtins.str certificate_issuer_thumbprint: The Issuer Thumbprint of the Certificate.
               
               > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        if certificate_issuer_thumbprint is not None:
            pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @_builtins.property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> _builtins.str:
        """
        The common or subject name of the certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @_builtins.property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> Optional[_builtins.str]:
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")


@pulumi.output_type
class ClusterClientCertificateCommonName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "isAdmin":
            suggest = "is_admin"
        elif key == "issuerThumbprint":
            suggest = "issuer_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClientCertificateCommonName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClientCertificateCommonName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClientCertificateCommonName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: _builtins.str,
                 is_admin: _builtins.bool,
                 issuer_thumbprint: Optional[_builtins.str] = None):
        """
        :param _builtins.str common_name: The common or subject name of the certificate.
        :param _builtins.bool is_admin: Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        :param _builtins.str issuer_thumbprint: The Issuer Thumbprint of the Certificate.
               
               > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "is_admin", is_admin)
        if issuer_thumbprint is not None:
            pulumi.set(__self__, "issuer_thumbprint", issuer_thumbprint)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The common or subject name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> _builtins.bool:
        """
        Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @_builtins.property
    @pulumi.getter(name="issuerThumbprint")
    def issuer_thumbprint(self) -> Optional[_builtins.str]:
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        return pulumi.get(self, "issuer_thumbprint")


@pulumi.output_type
class ClusterClientCertificateThumbprint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClientCertificateThumbprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClientCertificateThumbprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClientCertificateThumbprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_admin: _builtins.bool,
                 thumbprint: _builtins.str):
        """
        :param _builtins.bool is_admin: Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        :param _builtins.str thumbprint: The Thumbprint associated with the Client Certificate.
        """
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "thumbprint", thumbprint)

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> _builtins.bool:
        """
        Does the Client Certificate have Admin Access to the cluster? Non-admin clients can only perform read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> _builtins.str:
        """
        The Thumbprint associated with the Client Certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class ClusterDiagnosticsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobEndpoint":
            suggest = "blob_endpoint"
        elif key == "protectedAccountKeyName":
            suggest = "protected_account_key_name"
        elif key == "queueEndpoint":
            suggest = "queue_endpoint"
        elif key == "storageAccountName":
            suggest = "storage_account_name"
        elif key == "tableEndpoint":
            suggest = "table_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDiagnosticsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDiagnosticsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDiagnosticsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_endpoint: _builtins.str,
                 protected_account_key_name: _builtins.str,
                 queue_endpoint: _builtins.str,
                 storage_account_name: _builtins.str,
                 table_endpoint: _builtins.str):
        """
        :param _builtins.str blob_endpoint: The Blob Endpoint of the Storage Account.
        :param _builtins.str protected_account_key_name: The protected diagnostics storage key name, such as `StorageAccountKey1`.
        :param _builtins.str queue_endpoint: The Queue Endpoint of the Storage Account.
        :param _builtins.str storage_account_name: The name of the Storage Account where the Diagnostics should be sent to.
        :param _builtins.str table_endpoint: The Table Endpoint of the Storage Account.
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)

    @_builtins.property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> _builtins.str:
        """
        The Blob Endpoint of the Storage Account.
        """
        return pulumi.get(self, "blob_endpoint")

    @_builtins.property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> _builtins.str:
        """
        The protected diagnostics storage key name, such as `StorageAccountKey1`.
        """
        return pulumi.get(self, "protected_account_key_name")

    @_builtins.property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> _builtins.str:
        """
        The Queue Endpoint of the Storage Account.
        """
        return pulumi.get(self, "queue_endpoint")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> _builtins.str:
        """
        The name of the Storage Account where the Diagnostics should be sent to.
        """
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> _builtins.str:
        """
        The Table Endpoint of the Storage Account.
        """
        return pulumi.get(self, "table_endpoint")


@pulumi.output_type
class ClusterFabricSetting(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 parameters: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str name: The name of the Fabric Setting, such as `Security` or `Federation`.
        :param Mapping[str, _builtins.str] parameters: A map containing settings for the specified Fabric Setting.
        """
        pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Fabric Setting, such as `Security` or `Federation`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map containing settings for the specified Fabric Setting.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ClusterNodeType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientEndpointPort":
            suggest = "client_endpoint_port"
        elif key == "httpEndpointPort":
            suggest = "http_endpoint_port"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "isPrimary":
            suggest = "is_primary"
        elif key == "applicationPorts":
            suggest = "application_ports"
        elif key == "durabilityLevel":
            suggest = "durability_level"
        elif key == "ephemeralPorts":
            suggest = "ephemeral_ports"
        elif key == "isStateless":
            suggest = "is_stateless"
        elif key == "multipleAvailabilityZones":
            suggest = "multiple_availability_zones"
        elif key == "placementProperties":
            suggest = "placement_properties"
        elif key == "reverseProxyEndpointPort":
            suggest = "reverse_proxy_endpoint_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_endpoint_port: _builtins.int,
                 http_endpoint_port: _builtins.int,
                 instance_count: _builtins.int,
                 is_primary: _builtins.bool,
                 name: _builtins.str,
                 application_ports: Optional['outputs.ClusterNodeTypeApplicationPorts'] = None,
                 capacities: Optional[Mapping[str, _builtins.str]] = None,
                 durability_level: Optional[_builtins.str] = None,
                 ephemeral_ports: Optional['outputs.ClusterNodeTypeEphemeralPorts'] = None,
                 is_stateless: Optional[_builtins.bool] = None,
                 multiple_availability_zones: Optional[_builtins.bool] = None,
                 placement_properties: Optional[Mapping[str, _builtins.str]] = None,
                 reverse_proxy_endpoint_port: Optional[_builtins.int] = None):
        """
        :param _builtins.int client_endpoint_port: The Port used for the Client Endpoint for this Node Type.
        :param _builtins.int http_endpoint_port: The Port used for the HTTP Endpoint for this Node Type.
        :param _builtins.int instance_count: The number of nodes for this Node Type.
        :param _builtins.bool is_primary: Is this the Primary Node Type?
        :param _builtins.str name: The name of the Node Type.
        :param 'ClusterNodeTypeApplicationPortsArgs' application_ports: A `application_ports` block as defined below.
        :param Mapping[str, _builtins.str] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        :param _builtins.str durability_level: The Durability Level for this Node Type. Possible values include `Bronze`, `Gold` and `Silver`. Defaults to `Bronze`.
        :param 'ClusterNodeTypeEphemeralPortsArgs' ephemeral_ports: A `ephemeral_ports` block as defined below.
        :param _builtins.bool is_stateless: Should this node type run only stateless services?
        :param _builtins.bool multiple_availability_zones: Does this node type span availability zones?
        :param Mapping[str, _builtins.str] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        :param _builtins.int reverse_proxy_endpoint_port: The Port used for the Reverse Proxy Endpoint for this Node Type. Changing this will upgrade the cluster.
        """
        pulumi.set(__self__, "client_endpoint_port", client_endpoint_port)
        pulumi.set(__self__, "http_endpoint_port", http_endpoint_port)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if is_stateless is not None:
            pulumi.set(__self__, "is_stateless", is_stateless)
        if multiple_availability_zones is not None:
            pulumi.set(__self__, "multiple_availability_zones", multiple_availability_zones)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @_builtins.property
    @pulumi.getter(name="clientEndpointPort")
    def client_endpoint_port(self) -> _builtins.int:
        """
        The Port used for the Client Endpoint for this Node Type.
        """
        return pulumi.get(self, "client_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="httpEndpointPort")
    def http_endpoint_port(self) -> _builtins.int:
        """
        The Port used for the HTTP Endpoint for this Node Type.
        """
        return pulumi.get(self, "http_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> _builtins.int:
        """
        The number of nodes for this Node Type.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> _builtins.bool:
        """
        Is this the Primary Node Type?
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Node Type.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional['outputs.ClusterNodeTypeApplicationPorts']:
        """
        A `application_ports` block as defined below.
        """
        return pulumi.get(self, "application_ports")

    @_builtins.property
    @pulumi.getter
    def capacities(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        return pulumi.get(self, "capacities")

    @_builtins.property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[_builtins.str]:
        """
        The Durability Level for this Node Type. Possible values include `Bronze`, `Gold` and `Silver`. Defaults to `Bronze`.
        """
        return pulumi.get(self, "durability_level")

    @_builtins.property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional['outputs.ClusterNodeTypeEphemeralPorts']:
        """
        A `ephemeral_ports` block as defined below.
        """
        return pulumi.get(self, "ephemeral_ports")

    @_builtins.property
    @pulumi.getter(name="isStateless")
    def is_stateless(self) -> Optional[_builtins.bool]:
        """
        Should this node type run only stateless services?
        """
        return pulumi.get(self, "is_stateless")

    @_builtins.property
    @pulumi.getter(name="multipleAvailabilityZones")
    def multiple_availability_zones(self) -> Optional[_builtins.bool]:
        """
        Does this node type span availability zones?
        """
        return pulumi.get(self, "multiple_availability_zones")

    @_builtins.property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        return pulumi.get(self, "placement_properties")

    @_builtins.property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[_builtins.int]:
        """
        The Port used for the Reverse Proxy Endpoint for this Node Type. Changing this will upgrade the cluster.
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")


@pulumi.output_type
class ClusterNodeTypeApplicationPorts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeTypeApplicationPorts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeTypeApplicationPorts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeTypeApplicationPorts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: _builtins.int,
                 start_port: _builtins.int):
        """
        :param _builtins.int end_port: The end of the Application Port Range on this Node Type.
        :param _builtins.int start_port: The start of the Application Port Range on this Node Type.
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> _builtins.int:
        """
        The end of the Application Port Range on this Node Type.
        """
        return pulumi.get(self, "end_port")

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> _builtins.int:
        """
        The start of the Application Port Range on this Node Type.
        """
        return pulumi.get(self, "start_port")


@pulumi.output_type
class ClusterNodeTypeEphemeralPorts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeTypeEphemeralPorts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeTypeEphemeralPorts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeTypeEphemeralPorts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: _builtins.int,
                 start_port: _builtins.int):
        """
        :param _builtins.int end_port: The end of the Ephemeral Port Range on this Node Type.
        :param _builtins.int start_port: The start of the Ephemeral Port Range on this Node Type.
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @_builtins.property
    @pulumi.getter(name="endPort")
    def end_port(self) -> _builtins.int:
        """
        The end of the Ephemeral Port Range on this Node Type.
        """
        return pulumi.get(self, "end_port")

    @_builtins.property
    @pulumi.getter(name="startPort")
    def start_port(self) -> _builtins.int:
        """
        The start of the Ephemeral Port Range on this Node Type.
        """
        return pulumi.get(self, "start_port")


@pulumi.output_type
class ClusterReverseProxyCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509StoreName":
            suggest = "x509_store_name"
        elif key == "thumbprintSecondary":
            suggest = "thumbprint_secondary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReverseProxyCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReverseProxyCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReverseProxyCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 thumbprint: _builtins.str,
                 x509_store_name: _builtins.str,
                 thumbprint_secondary: Optional[_builtins.str] = None):
        """
        :param _builtins.str thumbprint: The Thumbprint of the Certificate.
        :param _builtins.str x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        :param _builtins.str thumbprint_secondary: The Secondary Thumbprint of the Certificate.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "x509_store_name", x509_store_name)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> _builtins.str:
        """
        The Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @_builtins.property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> _builtins.str:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")

    @_builtins.property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[_builtins.str]:
        """
        The Secondary Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")


@pulumi.output_type
class ClusterReverseProxyCertificateCommonNames(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonNames":
            suggest = "common_names"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReverseProxyCertificateCommonNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReverseProxyCertificateCommonNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReverseProxyCertificateCommonNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_names: Sequence['outputs.ClusterReverseProxyCertificateCommonNamesCommonName'],
                 x509_store_name: _builtins.str):
        """
        :param Sequence['ClusterReverseProxyCertificateCommonNamesCommonNameArgs'] common_names: A `common_names` block as defined below.
        :param _builtins.str x509_store_name: The X509 Store where the Certificate Exists, such as `My`.
        """
        pulumi.set(__self__, "common_names", common_names)
        pulumi.set(__self__, "x509_store_name", x509_store_name)

    @_builtins.property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> Sequence['outputs.ClusterReverseProxyCertificateCommonNamesCommonName']:
        """
        A `common_names` block as defined below.
        """
        return pulumi.get(self, "common_names")

    @_builtins.property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> _builtins.str:
        """
        The X509 Store where the Certificate Exists, such as `My`.
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ClusterReverseProxyCertificateCommonNamesCommonName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReverseProxyCertificateCommonNamesCommonName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReverseProxyCertificateCommonNamesCommonName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReverseProxyCertificateCommonNamesCommonName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: _builtins.str,
                 certificate_issuer_thumbprint: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_common_name: The common or subject name of the certificate.
        :param _builtins.str certificate_issuer_thumbprint: The Issuer Thumbprint of the Certificate.
               
               > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        if certificate_issuer_thumbprint is not None:
            pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @_builtins.property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> _builtins.str:
        """
        The common or subject name of the certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @_builtins.property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> Optional[_builtins.str]:
        """
        The Issuer Thumbprint of the Certificate.

        > **Note:** Certificate Issuer Thumbprint may become required in the future, `https://docs.microsoft.com/azure/service-fabric/service-fabric-create-cluster-using-cert-cn#download-and-update-a-sample-template`.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")


@pulumi.output_type
class ClusterUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaHealthPolicy":
            suggest = "delta_health_policy"
        elif key == "forceRestartEnabled":
            suggest = "force_restart_enabled"
        elif key == "healthCheckRetryTimeout":
            suggest = "health_check_retry_timeout"
        elif key == "healthCheckStableDuration":
            suggest = "health_check_stable_duration"
        elif key == "healthCheckWaitDuration":
            suggest = "health_check_wait_duration"
        elif key == "healthPolicy":
            suggest = "health_policy"
        elif key == "upgradeDomainTimeout":
            suggest = "upgrade_domain_timeout"
        elif key == "upgradeReplicaSetCheckTimeout":
            suggest = "upgrade_replica_set_check_timeout"
        elif key == "upgradeTimeout":
            suggest = "upgrade_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_health_policy: Optional['outputs.ClusterUpgradePolicyDeltaHealthPolicy'] = None,
                 force_restart_enabled: Optional[_builtins.bool] = None,
                 health_check_retry_timeout: Optional[_builtins.str] = None,
                 health_check_stable_duration: Optional[_builtins.str] = None,
                 health_check_wait_duration: Optional[_builtins.str] = None,
                 health_policy: Optional['outputs.ClusterUpgradePolicyHealthPolicy'] = None,
                 upgrade_domain_timeout: Optional[_builtins.str] = None,
                 upgrade_replica_set_check_timeout: Optional[_builtins.str] = None,
                 upgrade_timeout: Optional[_builtins.str] = None):
        """
        :param 'ClusterUpgradePolicyDeltaHealthPolicyArgs' delta_health_policy: A `delta_health_policy` block as defined below
        :param _builtins.bool force_restart_enabled: Indicates whether to restart the Service Fabric node even if only dynamic configurations have changed.
        :param _builtins.str health_check_retry_timeout: Specifies the duration, in "hh:mm:ss" string format, after which Service Fabric retries the health check if the previous health check fails. Defaults to `00:45:00`.
        :param _builtins.str health_check_stable_duration: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits in order to verify that the cluster is stable before it continues to the next upgrade domain or completes the upgrade. This wait duration prevents undetected changes of health right after the health check is performed. Defaults to `00:01:00`.
        :param _builtins.str health_check_wait_duration: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits before it performs the initial health check after it finishes the upgrade on the upgrade domain. Defaults to `00:00:30`.
        :param 'ClusterUpgradePolicyHealthPolicyArgs' health_policy: A `health_policy` block as defined below
        :param _builtins.str upgrade_domain_timeout: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes to upgrade a single upgrade domain. After this period, the upgrade fails. Defaults to `02:00:00`.
        :param _builtins.str upgrade_replica_set_check_timeout: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits for a replica set to reconfigure into a safe state, if it is not already in a safe state, before Service Fabric proceeds with the upgrade. Defaults to `10675199.02:48:05.4775807`.
        :param _builtins.str upgrade_timeout: Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes for the entire upgrade. After this period, the upgrade fails. Defaults to `12:00:00`.
        """
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart_enabled is not None:
            pulumi.set(__self__, "force_restart_enabled", force_restart_enabled)
        if health_check_retry_timeout is not None:
            pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        if health_check_stable_duration is not None:
            pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        if health_check_wait_duration is not None:
            pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        if health_policy is not None:
            pulumi.set(__self__, "health_policy", health_policy)
        if upgrade_domain_timeout is not None:
            pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        if upgrade_replica_set_check_timeout is not None:
            pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        if upgrade_timeout is not None:
            pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)

    @_builtins.property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional['outputs.ClusterUpgradePolicyDeltaHealthPolicy']:
        """
        A `delta_health_policy` block as defined below
        """
        return pulumi.get(self, "delta_health_policy")

    @_builtins.property
    @pulumi.getter(name="forceRestartEnabled")
    def force_restart_enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to restart the Service Fabric node even if only dynamic configurations have changed.
        """
        return pulumi.get(self, "force_restart_enabled")

    @_builtins.property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> Optional[_builtins.str]:
        """
        Specifies the duration, in "hh:mm:ss" string format, after which Service Fabric retries the health check if the previous health check fails. Defaults to `00:45:00`.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> Optional[_builtins.str]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits in order to verify that the cluster is stable before it continues to the next upgrade domain or completes the upgrade. This wait duration prevents undetected changes of health right after the health check is performed. Defaults to `00:01:00`.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @_builtins.property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> Optional[_builtins.str]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits before it performs the initial health check after it finishes the upgrade on the upgrade domain. Defaults to `00:00:30`.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @_builtins.property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> Optional['outputs.ClusterUpgradePolicyHealthPolicy']:
        """
        A `health_policy` block as defined below
        """
        return pulumi.get(self, "health_policy")

    @_builtins.property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> Optional[_builtins.str]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes to upgrade a single upgrade domain. After this period, the upgrade fails. Defaults to `02:00:00`.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @_builtins.property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> Optional[_builtins.str]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric waits for a replica set to reconfigure into a safe state, if it is not already in a safe state, before Service Fabric proceeds with the upgrade. Defaults to `10675199.02:48:05.4775807`.
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @_builtins.property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> Optional[_builtins.str]:
        """
        Specifies the duration, in "hh:mm:ss" string format, that Service Fabric takes for the entire upgrade. After this period, the upgrade fails. Defaults to `12:00:00`.
        """
        return pulumi.get(self, "upgrade_timeout")


@pulumi.output_type
class ClusterUpgradePolicyDeltaHealthPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxDeltaUnhealthyApplicationsPercent":
            suggest = "max_delta_unhealthy_applications_percent"
        elif key == "maxDeltaUnhealthyNodesPercent":
            suggest = "max_delta_unhealthy_nodes_percent"
        elif key == "maxUpgradeDomainDeltaUnhealthyNodesPercent":
            suggest = "max_upgrade_domain_delta_unhealthy_nodes_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicyDeltaHealthPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicyDeltaHealthPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicyDeltaHealthPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_delta_unhealthy_applications_percent: Optional[_builtins.int] = None,
                 max_delta_unhealthy_nodes_percent: Optional[_builtins.int] = None,
                 max_upgrade_domain_delta_unhealthy_nodes_percent: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_delta_unhealthy_applications_percent: Specifies the maximum tolerated percentage of delta unhealthy applications that can have aggregated health states of error. If the current unhealthy applications do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        :param _builtins.int max_delta_unhealthy_nodes_percent: Specifies the maximum tolerated percentage of delta unhealthy nodes that can have aggregated health states of error. If the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        :param _builtins.int max_upgrade_domain_delta_unhealthy_nodes_percent: Specifies the maximum tolerated percentage of upgrade domain delta unhealthy nodes that can have aggregated health state of error. If there is any upgrade domain where the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        if max_delta_unhealthy_applications_percent is not None:
            pulumi.set(__self__, "max_delta_unhealthy_applications_percent", max_delta_unhealthy_applications_percent)
        if max_delta_unhealthy_nodes_percent is not None:
            pulumi.set(__self__, "max_delta_unhealthy_nodes_percent", max_delta_unhealthy_nodes_percent)
        if max_upgrade_domain_delta_unhealthy_nodes_percent is not None:
            pulumi.set(__self__, "max_upgrade_domain_delta_unhealthy_nodes_percent", max_upgrade_domain_delta_unhealthy_nodes_percent)

    @_builtins.property
    @pulumi.getter(name="maxDeltaUnhealthyApplicationsPercent")
    def max_delta_unhealthy_applications_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum tolerated percentage of delta unhealthy applications that can have aggregated health states of error. If the current unhealthy applications do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_delta_unhealthy_applications_percent")

    @_builtins.property
    @pulumi.getter(name="maxDeltaUnhealthyNodesPercent")
    def max_delta_unhealthy_nodes_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum tolerated percentage of delta unhealthy nodes that can have aggregated health states of error. If the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_delta_unhealthy_nodes_percent")

    @_builtins.property
    @pulumi.getter(name="maxUpgradeDomainDeltaUnhealthyNodesPercent")
    def max_upgrade_domain_delta_unhealthy_nodes_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum tolerated percentage of upgrade domain delta unhealthy nodes that can have aggregated health state of error. If there is any upgrade domain where the current unhealthy nodes do not respect the percentage relative to the state at the beginning of the upgrade, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_upgrade_domain_delta_unhealthy_nodes_percent")


@pulumi.output_type
class ClusterUpgradePolicyHealthPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnhealthyApplicationsPercent":
            suggest = "max_unhealthy_applications_percent"
        elif key == "maxUnhealthyNodesPercent":
            suggest = "max_unhealthy_nodes_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicyHealthPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicyHealthPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicyHealthPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unhealthy_applications_percent: Optional[_builtins.int] = None,
                 max_unhealthy_nodes_percent: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_unhealthy_applications_percent: Specifies the maximum tolerated percentage of applications that can have aggregated health state of error. If the upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        :param _builtins.int max_unhealthy_nodes_percent: Specifies the maximum tolerated percentage of nodes that can have aggregated health states of error. If an upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        if max_unhealthy_applications_percent is not None:
            pulumi.set(__self__, "max_unhealthy_applications_percent", max_unhealthy_applications_percent)
        if max_unhealthy_nodes_percent is not None:
            pulumi.set(__self__, "max_unhealthy_nodes_percent", max_unhealthy_nodes_percent)

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyApplicationsPercent")
    def max_unhealthy_applications_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum tolerated percentage of applications that can have aggregated health state of error. If the upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_unhealthy_applications_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyNodesPercent")
    def max_unhealthy_nodes_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum tolerated percentage of nodes that can have aggregated health states of error. If an upgrade exceeds this percentage, the cluster is unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "max_unhealthy_nodes_percent")


@pulumi.output_type
class ManagedClusterAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectory":
            suggest = "active_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory: Optional['outputs.ManagedClusterAuthenticationActiveDirectory'] = None,
                 certificates: Optional[Sequence['outputs.ManagedClusterAuthenticationCertificate']] = None):
        """
        :param 'ManagedClusterAuthenticationActiveDirectoryArgs' active_directory: A `active_directory` block as defined above.
        :param Sequence['ManagedClusterAuthenticationCertificateArgs'] certificates: One or more `certificate` blocks as defined below.
        """
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)

    @_builtins.property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional['outputs.ManagedClusterAuthenticationActiveDirectory']:
        """
        A `active_directory` block as defined above.
        """
        return pulumi.get(self, "active_directory")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence['outputs.ManagedClusterAuthenticationCertificate']]:
        """
        One or more `certificate` blocks as defined below.
        """
        return pulumi.get(self, "certificates")


@pulumi.output_type
class ManagedClusterAuthenticationActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientApplicationId":
            suggest = "client_application_id"
        elif key == "clusterApplicationId":
            suggest = "cluster_application_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterAuthenticationActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterAuthenticationActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterAuthenticationActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_application_id: _builtins.str,
                 cluster_application_id: _builtins.str,
                 tenant_id: _builtins.str):
        """
        :param _builtins.str client_application_id: The ID of the Client Application.
        :param _builtins.str cluster_application_id: The ID of the Cluster Application.
        :param _builtins.str tenant_id: The ID of the Tenant.
        """
        pulumi.set(__self__, "client_application_id", client_application_id)
        pulumi.set(__self__, "cluster_application_id", cluster_application_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="clientApplicationId")
    def client_application_id(self) -> _builtins.str:
        """
        The ID of the Client Application.
        """
        return pulumi.get(self, "client_application_id")

    @_builtins.property
    @pulumi.getter(name="clusterApplicationId")
    def cluster_application_id(self) -> _builtins.str:
        """
        The ID of the Cluster Application.
        """
        return pulumi.get(self, "cluster_application_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The ID of the Tenant.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ManagedClusterAuthenticationCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterAuthenticationCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterAuthenticationCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterAuthenticationCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 thumbprint: _builtins.str,
                 type: _builtins.str,
                 common_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str thumbprint: The thumbprint of the certificate.
        :param _builtins.str type: The type of the certificate. Can be `AdminClient` or `ReadOnlyClient`.
        :param _builtins.str common_name: The certificate's CN.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "type", type)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> _builtins.str:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the certificate. Can be `AdminClient` or `ReadOnlyClient`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[_builtins.str]:
        """
        The certificate's CN.
        """
        return pulumi.get(self, "common_name")


@pulumi.output_type
class ManagedClusterCustomFabricSetting(dict):
    def __init__(__self__, *,
                 parameter: _builtins.str,
                 section: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str parameter: Parameter name.
        :param _builtins.str section: Section name.
        :param _builtins.str value: Parameter value.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "section", section)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> _builtins.str:
        """
        Parameter name.
        """
        return pulumi.get(self, "parameter")

    @_builtins.property
    @pulumi.getter
    def section(self) -> _builtins.str:
        """
        Section name.
        """
        return pulumi.get(self, "section")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagedClusterLbRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "probeProtocol":
            suggest = "probe_protocol"
        elif key == "probeRequestPath":
            suggest = "probe_request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterLbRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterLbRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterLbRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: _builtins.int,
                 frontend_port: _builtins.int,
                 probe_protocol: _builtins.str,
                 protocol: _builtins.str,
                 probe_request_path: Optional[_builtins.str] = None):
        """
        :param _builtins.int backend_port: LB Backend port.
        :param _builtins.int frontend_port: LB Frontend port.
        :param _builtins.str probe_protocol: Protocol for the probe. Can be one of `tcp`, `udp`, `http`, or `https`.
        :param _builtins.str protocol: The transport protocol used in this rule. Can be one of `tcp` or `udp`.
        :param _builtins.str probe_request_path: Path for the probe to check, when probe protocol is set to `http`.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "probe_protocol", probe_protocol)
        pulumi.set(__self__, "protocol", protocol)
        if probe_request_path is not None:
            pulumi.set(__self__, "probe_request_path", probe_request_path)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.int:
        """
        LB Backend port.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.int:
        """
        LB Frontend port.
        """
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> _builtins.str:
        """
        Protocol for the probe. Can be one of `tcp`, `udp`, `http`, or `https`.
        """
        return pulumi.get(self, "probe_protocol")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The transport protocol used in this rule. Can be one of `tcp` or `udp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="probeRequestPath")
    def probe_request_path(self) -> Optional[_builtins.str]:
        """
        Path for the probe to check, when probe protocol is set to `http`.
        """
        return pulumi.get(self, "probe_request_path")


@pulumi.output_type
class ManagedClusterNodeType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationPortRange":
            suggest = "application_port_range"
        elif key == "dataDiskSizeGb":
            suggest = "data_disk_size_gb"
        elif key == "ephemeralPortRange":
            suggest = "ephemeral_port_range"
        elif key == "vmImageOffer":
            suggest = "vm_image_offer"
        elif key == "vmImagePublisher":
            suggest = "vm_image_publisher"
        elif key == "vmImageSku":
            suggest = "vm_image_sku"
        elif key == "vmImageVersion":
            suggest = "vm_image_version"
        elif key == "vmInstanceCount":
            suggest = "vm_instance_count"
        elif key == "vmSize":
            suggest = "vm_size"
        elif key == "dataDiskType":
            suggest = "data_disk_type"
        elif key == "multiplePlacementGroupsEnabled":
            suggest = "multiple_placement_groups_enabled"
        elif key == "placementProperties":
            suggest = "placement_properties"
        elif key == "vmSecrets":
            suggest = "vm_secrets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterNodeType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterNodeType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterNodeType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_port_range: _builtins.str,
                 data_disk_size_gb: _builtins.int,
                 ephemeral_port_range: _builtins.str,
                 name: _builtins.str,
                 vm_image_offer: _builtins.str,
                 vm_image_publisher: _builtins.str,
                 vm_image_sku: _builtins.str,
                 vm_image_version: _builtins.str,
                 vm_instance_count: _builtins.int,
                 vm_size: _builtins.str,
                 capacities: Optional[Mapping[str, _builtins.str]] = None,
                 data_disk_type: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 multiple_placement_groups_enabled: Optional[_builtins.bool] = None,
                 placement_properties: Optional[Mapping[str, _builtins.str]] = None,
                 primary: Optional[_builtins.bool] = None,
                 stateless: Optional[_builtins.bool] = None,
                 vm_secrets: Optional[Sequence['outputs.ManagedClusterNodeTypeVmSecret']] = None):
        """
        :param _builtins.str application_port_range: Sets the port range available for applications. Format is `<from_port>-<to_port>`, for example `10000-20000`.
        :param _builtins.int data_disk_size_gb: The size of the data disk in gigabytes..
        :param _builtins.str ephemeral_port_range: Sets the port range available for the OS. Format is `<from_port>-<to_port>`, for example `10000-20000`. There has to be at least 255 ports available and cannot overlap with `application_port_range`..
        :param _builtins.str name: The name which should be used for this node type.
        :param _builtins.str vm_image_offer: The offer type of the marketplace image cluster VMs will use.
        :param _builtins.str vm_image_publisher: The publisher of the marketplace image cluster VMs will use.
        :param _builtins.str vm_image_sku: The SKU of the marketplace image cluster VMs will use.
        :param _builtins.str vm_image_version: The version of the marketplace image cluster VMs will use.
        :param _builtins.int vm_instance_count: The number of instances this node type will launch.
        :param _builtins.str vm_size: The size of the instances in this node type.
        :param Mapping[str, _builtins.str] capacities: Specifies a list of key/value pairs used to set capacity tags for this node type.
        :param _builtins.str data_disk_type: The type of the disk to use for storing data. It can be one of `Premium_LRS`, `Standard_LRS`, or `StandardSSD_LRS`. Defaults to `Standard_LRS`.
        :param _builtins.str id: The ID of the Resource Group.
        :param _builtins.bool multiple_placement_groups_enabled: If set the node type can be composed of multiple placement groups.
        :param Mapping[str, _builtins.str] placement_properties: Specifies a list of placement tags that can be used to indicate where services should run..
        :param _builtins.bool primary: If set to true, system services will run on this node type. Only one node type should be marked as primary. Primary node type cannot be deleted or changed once they're created.
        :param _builtins.bool stateless: If set to true, only stateless workloads can run on this node type.
        :param Sequence['ManagedClusterNodeTypeVmSecretArgs'] vm_secrets: One or more `vm_secrets` blocks as defined below.
        """
        pulumi.set(__self__, "application_port_range", application_port_range)
        pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        pulumi.set(__self__, "ephemeral_port_range", ephemeral_port_range)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_image_offer", vm_image_offer)
        pulumi.set(__self__, "vm_image_publisher", vm_image_publisher)
        pulumi.set(__self__, "vm_image_sku", vm_image_sku)
        pulumi.set(__self__, "vm_image_version", vm_image_version)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        pulumi.set(__self__, "vm_size", vm_size)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if multiple_placement_groups_enabled is not None:
            pulumi.set(__self__, "multiple_placement_groups_enabled", multiple_placement_groups_enabled)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if stateless is not None:
            pulumi.set(__self__, "stateless", stateless)
        if vm_secrets is not None:
            pulumi.set(__self__, "vm_secrets", vm_secrets)

    @_builtins.property
    @pulumi.getter(name="applicationPortRange")
    def application_port_range(self) -> _builtins.str:
        """
        Sets the port range available for applications. Format is `<from_port>-<to_port>`, for example `10000-20000`.
        """
        return pulumi.get(self, "application_port_range")

    @_builtins.property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> _builtins.int:
        """
        The size of the data disk in gigabytes..
        """
        return pulumi.get(self, "data_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="ephemeralPortRange")
    def ephemeral_port_range(self) -> _builtins.str:
        """
        Sets the port range available for the OS. Format is `<from_port>-<to_port>`, for example `10000-20000`. There has to be at least 255 ports available and cannot overlap with `application_port_range`..
        """
        return pulumi.get(self, "ephemeral_port_range")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this node type.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="vmImageOffer")
    def vm_image_offer(self) -> _builtins.str:
        """
        The offer type of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_offer")

    @_builtins.property
    @pulumi.getter(name="vmImagePublisher")
    def vm_image_publisher(self) -> _builtins.str:
        """
        The publisher of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_publisher")

    @_builtins.property
    @pulumi.getter(name="vmImageSku")
    def vm_image_sku(self) -> _builtins.str:
        """
        The SKU of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_sku")

    @_builtins.property
    @pulumi.getter(name="vmImageVersion")
    def vm_image_version(self) -> _builtins.str:
        """
        The version of the marketplace image cluster VMs will use.
        """
        return pulumi.get(self, "vm_image_version")

    @_builtins.property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> _builtins.int:
        """
        The number of instances this node type will launch.
        """
        return pulumi.get(self, "vm_instance_count")

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> _builtins.str:
        """
        The size of the instances in this node type.
        """
        return pulumi.get(self, "vm_size")

    @_builtins.property
    @pulumi.getter
    def capacities(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies a list of key/value pairs used to set capacity tags for this node type.
        """
        return pulumi.get(self, "capacities")

    @_builtins.property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[_builtins.str]:
        """
        The type of the disk to use for storing data. It can be one of `Premium_LRS`, `Standard_LRS`, or `StandardSSD_LRS`. Defaults to `Standard_LRS`.
        """
        return pulumi.get(self, "data_disk_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiplePlacementGroupsEnabled")
    def multiple_placement_groups_enabled(self) -> Optional[_builtins.bool]:
        """
        If set the node type can be composed of multiple placement groups.
        """
        return pulumi.get(self, "multiple_placement_groups_enabled")

    @_builtins.property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies a list of placement tags that can be used to indicate where services should run..
        """
        return pulumi.get(self, "placement_properties")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        If set to true, system services will run on this node type. Only one node type should be marked as primary. Primary node type cannot be deleted or changed once they're created.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter
    def stateless(self) -> Optional[_builtins.bool]:
        """
        If set to true, only stateless workloads can run on this node type.
        """
        return pulumi.get(self, "stateless")

    @_builtins.property
    @pulumi.getter(name="vmSecrets")
    def vm_secrets(self) -> Optional[Sequence['outputs.ManagedClusterNodeTypeVmSecret']]:
        """
        One or more `vm_secrets` blocks as defined below.
        """
        return pulumi.get(self, "vm_secrets")


@pulumi.output_type
class ManagedClusterNodeTypeVmSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterNodeTypeVmSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterNodeTypeVmSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterNodeTypeVmSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.ManagedClusterNodeTypeVmSecretCertificate'],
                 vault_id: _builtins.str):
        """
        :param Sequence['ManagedClusterNodeTypeVmSecretCertificateArgs'] certificates: One or more `certificates` blocks as defined above.
        :param _builtins.str vault_id: The ID of the Vault that contain the certificates.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.ManagedClusterNodeTypeVmSecretCertificate']:
        """
        One or more `certificates` blocks as defined above.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the Vault that contain the certificates.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class ManagedClusterNodeTypeVmSecretCertificate(dict):
    def __init__(__self__, *,
                 store: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str store: The certificate store on the Virtual Machine to which the certificate should be added.
        :param _builtins.str url: The URL of a certificate that has been uploaded to Key Vault as a secret
        """
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def store(self) -> _builtins.str:
        """
        The certificate store on the Virtual Machine to which the certificate should be added.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of a certificate that has been uploaded to Key Vault as a secret
        """
        return pulumi.get(self, "url")


