# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHciClusterResult',
    'AwaitableGetHciClusterResult',
    'get_hci_cluster',
    'get_hci_cluster_output',
]

@pulumi.output_type
class GetHciClusterResult:
    """
    A collection of values returned by getHciCluster.
    """
    def __init__(__self__, automanage_configuration_id=None, client_id=None, cloud_id=None, id=None, identities=None, location=None, name=None, resource_group_name=None, resource_provider_object_id=None, service_endpoint=None, tags=None, tenant_id=None):
        if automanage_configuration_id and not isinstance(automanage_configuration_id, str):
            raise TypeError("Expected argument 'automanage_configuration_id' to be a str")
        pulumi.set(__self__, "automanage_configuration_id", automanage_configuration_id)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_provider_object_id and not isinstance(resource_provider_object_id, str):
            raise TypeError("Expected argument 'resource_provider_object_id' to be a str")
        pulumi.set(__self__, "resource_provider_object_id", resource_provider_object_id)
        if service_endpoint and not isinstance(service_endpoint, str):
            raise TypeError("Expected argument 'service_endpoint' to be a str")
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="automanageConfigurationId")
    def automanage_configuration_id(self) -> _builtins.str:
        """
        The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "automanage_configuration_id")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The Client ID of the Azure Active Directory used by the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        An immutable UUID for the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetHciClusterIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Azure Stack HCI Cluster exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="resourceProviderObjectId")
    def resource_provider_object_id(self) -> _builtins.str:
        """
        The object ID of the Resource Provider Service Principal.
        """
        return pulumi.get(self, "resource_provider_object_id")

    @_builtins.property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> _builtins.str:
        """
        The region specific Data Path Endpoint of the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "service_endpoint")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetHciClusterResult(GetHciClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHciClusterResult(
            automanage_configuration_id=self.automanage_configuration_id,
            client_id=self.client_id,
            cloud_id=self.cloud_id,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            resource_provider_object_id=self.resource_provider_object_id,
            service_endpoint=self.service_endpoint,
            tags=self.tags,
            tenant_id=self.tenant_id)


def get_hci_cluster(name: Optional[_builtins.str] = None,
                    resource_group_name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHciClusterResult:
    """
    Use this data source to access information about an existing Azure Stack HCI Cluster instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.stack.get_hci_cluster(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    pulumi.export("location", example.location)
    pulumi.export("clientId", example.client_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AzureStackHCI` - 2024-01-01, 2022-05-04


    :param _builtins.str name: The name of the Azure Stack HCI Cluster.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Azure Stack HCI Cluster exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:stack/getHciCluster:getHciCluster', __args__, opts=opts, typ=GetHciClusterResult).value

    return AwaitableGetHciClusterResult(
        automanage_configuration_id=pulumi.get(__ret__, 'automanage_configuration_id'),
        client_id=pulumi.get(__ret__, 'client_id'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        resource_provider_object_id=pulumi.get(__ret__, 'resource_provider_object_id'),
        service_endpoint=pulumi.get(__ret__, 'service_endpoint'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_hci_cluster_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHciClusterResult]:
    """
    Use this data source to access information about an existing Azure Stack HCI Cluster instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.stack.get_hci_cluster(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    pulumi.export("location", example.location)
    pulumi.export("clientId", example.client_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AzureStackHCI` - 2024-01-01, 2022-05-04


    :param _builtins.str name: The name of the Azure Stack HCI Cluster.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Azure Stack HCI Cluster exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:stack/getHciCluster:getHciCluster', __args__, opts=opts, typ=GetHciClusterResult)
    return __ret__.apply(lambda __response__: GetHciClusterResult(
        automanage_configuration_id=pulumi.get(__response__, 'automanage_configuration_id'),
        client_id=pulumi.get(__response__, 'client_id'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        resource_provider_object_id=pulumi.get(__response__, 'resource_provider_object_id'),
        service_endpoint=pulumi.get(__response__, 'service_endpoint'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
