# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HciLogicalNetworkArgs', 'HciLogicalNetwork']

@pulumi.input_type
class HciLogicalNetworkArgs:
    def __init__(__self__, *,
                 custom_location_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 subnet: pulumi.Input['HciLogicalNetworkSubnetArgs'],
                 virtual_switch_name: pulumi.Input[_builtins.str],
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a HciLogicalNetwork resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HciLogicalNetworkSubnetArgs'] subnet: A `subnet` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_switch_name: The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        """
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "virtual_switch_name", virtual_switch_name)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Input['HciLogicalNetworkSubnetArgs']:
        """
        A `subnet` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input['HciLogicalNetworkSubnetArgs']):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter(name="virtualSwitchName")
    def virtual_switch_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_switch_name")

    @virtual_switch_name.setter
    def virtual_switch_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_switch_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HciLogicalNetworkState:
    def __init__(__self__, *,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input['HciLogicalNetworkSubnetArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_switch_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HciLogicalNetwork resources.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HciLogicalNetworkSubnetArgs'] subnet: A `subnet` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        :param pulumi.Input[_builtins.str] virtual_switch_name: The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        """
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_switch_name is not None:
            pulumi.set(__self__, "virtual_switch_name", virtual_switch_name)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['HciLogicalNetworkSubnetArgs']]:
        """
        A `subnet` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['HciLogicalNetworkSubnetArgs']]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualSwitchName")
    def virtual_switch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_switch_name")

    @virtual_switch_name.setter
    def virtual_switch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_switch_name", value)


@pulumi.type_token("azure:stack/hciLogicalNetwork:HciLogicalNetwork")
class HciLogicalNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[Union['HciLogicalNetworkSubnetArgs', 'HciLogicalNetworkSubnetArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_switch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Stack HCI Logical Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_hci_logical_network = azure.stack.HciLogicalNetwork("example",
            name="example-hci-ln",
            resource_group_name=example.name,
            location=example.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            virtual_switch_name="ConvergedSwitch(managementcompute)",
            dns_servers=[
                "10.0.0.7",
                "10.0.0.8",
            ],
            subnet={
                "ip_allocation_method": "Static",
                "address_prefix": "10.0.0.0/24",
                "vlan_id": 123,
                "route": {
                    "addressPrefix": "0.0.0.0/0",
                    "nextHopIpAddress": "10.0.0.1",
                },
            },
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AzureStackHCI` - 2024-01-01

        ## Import

        Azure Stack HCI Logical Networks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciLogicalNetwork:HciLogicalNetwork example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AzureStackHCI/logicalNetworks/ln1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HciLogicalNetworkSubnetArgs', 'HciLogicalNetworkSubnetArgsDict']] subnet: A `subnet` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        :param pulumi.Input[_builtins.str] virtual_switch_name: The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HciLogicalNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Stack HCI Logical Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_hci_logical_network = azure.stack.HciLogicalNetwork("example",
            name="example-hci-ln",
            resource_group_name=example.name,
            location=example.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            virtual_switch_name="ConvergedSwitch(managementcompute)",
            dns_servers=[
                "10.0.0.7",
                "10.0.0.8",
            ],
            subnet={
                "ip_allocation_method": "Static",
                "address_prefix": "10.0.0.0/24",
                "vlan_id": 123,
                "route": {
                    "addressPrefix": "0.0.0.0/0",
                    "nextHopIpAddress": "10.0.0.1",
                },
            },
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AzureStackHCI` - 2024-01-01

        ## Import

        Azure Stack HCI Logical Networks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciLogicalNetwork:HciLogicalNetwork example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AzureStackHCI/logicalNetworks/ln1
        ```

        :param str resource_name: The name of the resource.
        :param HciLogicalNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HciLogicalNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[Union['HciLogicalNetworkSubnetArgs', 'HciLogicalNetworkSubnetArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_switch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HciLogicalNetworkArgs.__new__(HciLogicalNetworkArgs)

            if custom_location_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_location_id'")
            __props__.__dict__["custom_location_id"] = custom_location_id
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["tags"] = tags
            if virtual_switch_name is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_switch_name'")
            __props__.__dict__["virtual_switch_name"] = virtual_switch_name
        super(HciLogicalNetwork, __self__).__init__(
            'azure:stack/hciLogicalNetwork:HciLogicalNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet: Optional[pulumi.Input[Union['HciLogicalNetworkSubnetArgs', 'HciLogicalNetworkSubnetArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_switch_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'HciLogicalNetwork':
        """
        Get an existing HciLogicalNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HciLogicalNetworkSubnetArgs', 'HciLogicalNetworkSubnetArgsDict']] subnet: A `subnet` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        :param pulumi.Input[_builtins.str] virtual_switch_name: The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HciLogicalNetworkState.__new__(_HciLogicalNetworkState)

        __props__.__dict__["custom_location_id"] = custom_location_id
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_switch_name"] = virtual_switch_name
        return HciLogicalNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Custom Location where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of IPv4 addresses of DNS servers available to VMs deployed in the Logical Networks. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Stack HCI Logical Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Logical Network should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output['outputs.HciLogicalNetworkSubnet']:
        """
        A `subnet` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Logical Network.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualSwitchName")
    def virtual_switch_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the virtual switch on the cluster used to associate with the Azure Stack HCI Logical Network. Possible switch names can be retrieved by following this [Azure guide](https://learn.microsoft.com/azure-stack/hci/manage/create-logical-networks?tabs=azurecli#prerequisites). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_switch_name")

