# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContainerImmutabilityPolicyArgs', 'ContainerImmutabilityPolicy']

@pulumi.input_type
class ContainerImmutabilityPolicyArgs:
    def __init__(__self__, *,
                 immutability_period_in_days: pulumi.Input[_builtins.int],
                 storage_container_resource_manager_id: pulumi.Input[_builtins.str],
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_all_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ContainerImmutabilityPolicy resource.
        :param pulumi.Input[_builtins.int] immutability_period_in_days: The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        :param pulumi.Input[_builtins.str] storage_container_resource_manager_id: The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] locked: Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.
               
               !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        :param pulumi.Input[_builtins.bool] protected_append_writes_all_enabled: Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        :param pulumi.Input[_builtins.bool] protected_append_writes_enabled: Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        """
        pulumi.set(__self__, "immutability_period_in_days", immutability_period_in_days)
        pulumi.set(__self__, "storage_container_resource_manager_id", storage_container_resource_manager_id)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if protected_append_writes_all_enabled is not None:
            pulumi.set(__self__, "protected_append_writes_all_enabled", protected_append_writes_all_enabled)
        if protected_append_writes_enabled is not None:
            pulumi.set(__self__, "protected_append_writes_enabled", protected_append_writes_enabled)

    @_builtins.property
    @pulumi.getter(name="immutabilityPeriodInDays")
    def immutability_period_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        """
        return pulumi.get(self, "immutability_period_in_days")

    @immutability_period_in_days.setter
    def immutability_period_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "immutability_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerResourceManagerId")
    def storage_container_resource_manager_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_resource_manager_id")

    @storage_container_resource_manager_id.setter
    def storage_container_resource_manager_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_resource_manager_id", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.

        !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter(name="protectedAppendWritesAllEnabled")
    def protected_append_writes_all_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        """
        return pulumi.get(self, "protected_append_writes_all_enabled")

    @protected_append_writes_all_enabled.setter
    def protected_append_writes_all_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected_append_writes_all_enabled", value)

    @_builtins.property
    @pulumi.getter(name="protectedAppendWritesEnabled")
    def protected_append_writes_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        """
        return pulumi.get(self, "protected_append_writes_enabled")

    @protected_append_writes_enabled.setter
    def protected_append_writes_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected_append_writes_enabled", value)


@pulumi.input_type
class _ContainerImmutabilityPolicyState:
    def __init__(__self__, *,
                 immutability_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_all_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_container_resource_manager_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerImmutabilityPolicy resources.
        :param pulumi.Input[_builtins.int] immutability_period_in_days: The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        :param pulumi.Input[_builtins.bool] locked: Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.
               
               !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        :param pulumi.Input[_builtins.bool] protected_append_writes_all_enabled: Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        :param pulumi.Input[_builtins.bool] protected_append_writes_enabled: Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        :param pulumi.Input[_builtins.str] storage_container_resource_manager_id: The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        """
        if immutability_period_in_days is not None:
            pulumi.set(__self__, "immutability_period_in_days", immutability_period_in_days)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if protected_append_writes_all_enabled is not None:
            pulumi.set(__self__, "protected_append_writes_all_enabled", protected_append_writes_all_enabled)
        if protected_append_writes_enabled is not None:
            pulumi.set(__self__, "protected_append_writes_enabled", protected_append_writes_enabled)
        if storage_container_resource_manager_id is not None:
            pulumi.set(__self__, "storage_container_resource_manager_id", storage_container_resource_manager_id)

    @_builtins.property
    @pulumi.getter(name="immutabilityPeriodInDays")
    def immutability_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        """
        return pulumi.get(self, "immutability_period_in_days")

    @immutability_period_in_days.setter
    def immutability_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "immutability_period_in_days", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.

        !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter(name="protectedAppendWritesAllEnabled")
    def protected_append_writes_all_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        """
        return pulumi.get(self, "protected_append_writes_all_enabled")

    @protected_append_writes_all_enabled.setter
    def protected_append_writes_all_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected_append_writes_all_enabled", value)

    @_builtins.property
    @pulumi.getter(name="protectedAppendWritesEnabled")
    def protected_append_writes_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        """
        return pulumi.get(self, "protected_append_writes_enabled")

    @protected_append_writes_enabled.setter
    def protected_append_writes_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected_append_writes_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerResourceManagerId")
    def storage_container_resource_manager_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_resource_manager_id")

    @storage_container_resource_manager_id.setter
    def storage_container_resource_manager_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_resource_manager_id", value)


@pulumi.type_token("azure:storage/containerImmutabilityPolicy:ContainerImmutabilityPolicy")
class ContainerImmutabilityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 immutability_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_all_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_container_resource_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Immutability Policy for a Container within an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestoraccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "staging",
            })
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_container_immutability_policy = azure.storage.ContainerImmutabilityPolicy("example",
            storage_container_resource_manager_id=example_container.id,
            immutability_period_in_days=14,
            protected_append_writes_all_enabled=False,
            protected_append_writes_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage` - 2023-05-01

        ## Import

        Storage Container Immutability Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/containerImmutabilityPolicy:ContainerImmutabilityPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount/blobServices/default/containers/mycontainer/immutabilityPolicies/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] immutability_period_in_days: The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        :param pulumi.Input[_builtins.bool] locked: Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.
               
               !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        :param pulumi.Input[_builtins.bool] protected_append_writes_all_enabled: Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        :param pulumi.Input[_builtins.bool] protected_append_writes_enabled: Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        :param pulumi.Input[_builtins.str] storage_container_resource_manager_id: The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerImmutabilityPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Immutability Policy for a Container within an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestoraccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "staging",
            })
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_container_immutability_policy = azure.storage.ContainerImmutabilityPolicy("example",
            storage_container_resource_manager_id=example_container.id,
            immutability_period_in_days=14,
            protected_append_writes_all_enabled=False,
            protected_append_writes_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage` - 2023-05-01

        ## Import

        Storage Container Immutability Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/containerImmutabilityPolicy:ContainerImmutabilityPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount/blobServices/default/containers/mycontainer/immutabilityPolicies/default
        ```

        :param str resource_name: The name of the resource.
        :param ContainerImmutabilityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerImmutabilityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 immutability_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_all_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected_append_writes_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_container_resource_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerImmutabilityPolicyArgs.__new__(ContainerImmutabilityPolicyArgs)

            if immutability_period_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'immutability_period_in_days'")
            __props__.__dict__["immutability_period_in_days"] = immutability_period_in_days
            __props__.__dict__["locked"] = locked
            __props__.__dict__["protected_append_writes_all_enabled"] = protected_append_writes_all_enabled
            __props__.__dict__["protected_append_writes_enabled"] = protected_append_writes_enabled
            if storage_container_resource_manager_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_resource_manager_id'")
            __props__.__dict__["storage_container_resource_manager_id"] = storage_container_resource_manager_id
        super(ContainerImmutabilityPolicy, __self__).__init__(
            'azure:storage/containerImmutabilityPolicy:ContainerImmutabilityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            immutability_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            protected_append_writes_all_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            protected_append_writes_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_container_resource_manager_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ContainerImmutabilityPolicy':
        """
        Get an existing ContainerImmutabilityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] immutability_period_in_days: The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        :param pulumi.Input[_builtins.bool] locked: Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.
               
               !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        :param pulumi.Input[_builtins.bool] protected_append_writes_all_enabled: Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        :param pulumi.Input[_builtins.bool] protected_append_writes_enabled: Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        :param pulumi.Input[_builtins.str] storage_container_resource_manager_id: The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerImmutabilityPolicyState.__new__(_ContainerImmutabilityPolicyState)

        __props__.__dict__["immutability_period_in_days"] = immutability_period_in_days
        __props__.__dict__["locked"] = locked
        __props__.__dict__["protected_append_writes_all_enabled"] = protected_append_writes_all_enabled
        __props__.__dict__["protected_append_writes_enabled"] = protected_append_writes_enabled
        __props__.__dict__["storage_container_resource_manager_id"] = storage_container_resource_manager_id
        return ContainerImmutabilityPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="immutabilityPeriodInDays")
    def immutability_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        The time interval in days that the data needs to be kept in a non-erasable and non-modifiable state.
        """
        return pulumi.get(self, "immutability_period_in_days")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to lock this immutability policy. Cannot be set to `false` once the policy has been locked.

        !> **Note:** Once an Immutability Policy has been locked, it cannot be unlocked. After locking, it will only be possible to increase the value for `retention_period_in_days` up to 5 times for the lifetime of the policy. No other properties will be updateable. Furthermore, the Storage Container and the Storage Account in which it resides will become protected by the policy. It will no longer be possible to delete the Storage Container or the Storage Account. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/immutable-policy-configure-container-scope?tabs=azure-portal#lock-a-time-based-retention-policy) for more information.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter(name="protectedAppendWritesAllEnabled")
    def protected_append_writes_all_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow protected append writes to block and append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_enabled`.
        """
        return pulumi.get(self, "protected_append_writes_all_enabled")

    @_builtins.property
    @pulumi.getter(name="protectedAppendWritesEnabled")
    def protected_append_writes_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow protected append writes to append blobs to the container. Defaults to `false`. Cannot be set with `protected_append_writes_all_enabled`.
        """
        return pulumi.get(self, "protected_append_writes_enabled")

    @_builtins.property
    @pulumi.getter(name="storageContainerResourceManagerId")
    def storage_container_resource_manager_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Resource Manager ID of the Storage Container where this Immutability Policy should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_resource_manager_id")

