# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEncryptionScopeResult',
    'AwaitableGetEncryptionScopeResult',
    'get_encryption_scope',
    'get_encryption_scope_output',
]

@pulumi.output_type
class GetEncryptionScopeResult:
    """
    A collection of values returned by getEncryptionScope.
    """
    def __init__(__self__, id=None, key_vault_key_id=None, name=None, source=None, storage_account_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_vault_key_id and not isinstance(key_vault_key_id, str):
            raise TypeError("Expected argument 'key_vault_key_id' to be a str")
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if storage_account_id and not isinstance(storage_account_id, str):
            raise TypeError("Expected argument 'storage_account_id' to be a str")
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The ID of the Key Vault Key.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The source of the Storage Encryption Scope.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> _builtins.str:
        return pulumi.get(self, "storage_account_id")


class AwaitableGetEncryptionScopeResult(GetEncryptionScopeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEncryptionScopeResult(
            id=self.id,
            key_vault_key_id=self.key_vault_key_id,
            name=self.name,
            source=self.source,
            storage_account_id=self.storage_account_id)


def get_encryption_scope(name: Optional[_builtins.str] = None,
                         storage_account_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEncryptionScopeResult:
    """
    Use this data source to access information about an existing Storage Encryption Scope.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_account(name="storageaccountname",
        resource_group_name="resourcegroupname")
    example_get_encryption_scope = azure.storage.get_encryption_scope(name="existingStorageES",
        storage_account_id=example.id)
    pulumi.export("id", example_get_encryption_scope.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Storage` - 2023-05-01


    :param _builtins.str name: The name of this Storage Encryption Scope.
    :param _builtins.str storage_account_id: The ID of the Storage Account where this Storage Encryption Scope exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['storageAccountId'] = storage_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getEncryptionScope:getEncryptionScope', __args__, opts=opts, typ=GetEncryptionScopeResult).value

    return AwaitableGetEncryptionScopeResult(
        id=pulumi.get(__ret__, 'id'),
        key_vault_key_id=pulumi.get(__ret__, 'key_vault_key_id'),
        name=pulumi.get(__ret__, 'name'),
        source=pulumi.get(__ret__, 'source'),
        storage_account_id=pulumi.get(__ret__, 'storage_account_id'))
def get_encryption_scope_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEncryptionScopeResult]:
    """
    Use this data source to access information about an existing Storage Encryption Scope.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_account(name="storageaccountname",
        resource_group_name="resourcegroupname")
    example_get_encryption_scope = azure.storage.get_encryption_scope(name="existingStorageES",
        storage_account_id=example.id)
    pulumi.export("id", example_get_encryption_scope.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Storage` - 2023-05-01


    :param _builtins.str name: The name of this Storage Encryption Scope.
    :param _builtins.str storage_account_id: The ID of the Storage Account where this Storage Encryption Scope exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['storageAccountId'] = storage_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getEncryptionScope:getEncryptionScope', __args__, opts=opts, typ=GetEncryptionScopeResult)
    return __ret__.apply(lambda __response__: GetEncryptionScopeResult(
        id=pulumi.get(__response__, 'id'),
        key_vault_key_id=pulumi.get(__response__, 'key_vault_key_id'),
        name=pulumi.get(__response__, 'name'),
        source=pulumi.get(__response__, 'source'),
        storage_account_id=pulumi.get(__response__, 'storage_account_id')))
