# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LinkedServiceIntegrationRuntime',
    'SparkPoolAutoPause',
    'SparkPoolAutoScale',
    'SparkPoolLibraryRequirement',
    'SparkPoolSparkConfig',
    'SqlPoolRestore',
    'SqlPoolVulnerabilityAssessmentBaselineBaseline',
    'SqlPoolVulnerabilityAssessmentRecurringScans',
    'WorkspaceAzureDevopsRepo',
    'WorkspaceCustomerManagedKey',
    'WorkspaceGithubRepo',
    'WorkspaceIdentity',
    'WorkspaceVulnerabilityAssessmentRecurringScans',
    'GetWorkspaceIdentityResult',
]

@pulumi.output_type
class LinkedServiceIntegrationRuntime(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 parameters: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str name: The integration runtime reference to associate with the Synapse Linked Service.
        :param Mapping[str, _builtins.str] parameters: A map of parameters to associate with the integration runtime.
        """
        pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The integration runtime reference to associate with the Synapse Linked Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of parameters to associate with the integration runtime.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class SparkPoolAutoPause(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delayInMinutes":
            suggest = "delay_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkPoolAutoPause. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkPoolAutoPause.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkPoolAutoPause.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay_in_minutes: _builtins.int):
        """
        :param _builtins.int delay_in_minutes: Number of minutes of idle time before the Spark Pool is automatically paused. Must be between `5` and `10080`.
        """
        pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)

    @_builtins.property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> _builtins.int:
        """
        Number of minutes of idle time before the Spark Pool is automatically paused. Must be between `5` and `10080`.
        """
        return pulumi.get(self, "delay_in_minutes")


@pulumi.output_type
class SparkPoolAutoScale(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkPoolAutoScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkPoolAutoScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkPoolAutoScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: _builtins.int,
                 min_node_count: _builtins.int):
        """
        :param _builtins.int max_node_count: The maximum number of nodes the Spark Pool can support. Must be between `3` and `200`.
        :param _builtins.int min_node_count: The minimum number of nodes the Spark Pool can support. Must be between `3` and `200`.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> _builtins.int:
        """
        The maximum number of nodes the Spark Pool can support. Must be between `3` and `200`.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> _builtins.int:
        """
        The minimum number of nodes the Spark Pool can support. Must be between `3` and `200`.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class SparkPoolLibraryRequirement(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 filename: _builtins.str):
        """
        :param _builtins.str content: The content of library requirements.
        :param _builtins.str filename: The name of the library requirements file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "filename", filename)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The content of library requirements.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> _builtins.str:
        """
        The name of the library requirements file.
        """
        return pulumi.get(self, "filename")


@pulumi.output_type
class SparkPoolSparkConfig(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 filename: _builtins.str):
        """
        :param _builtins.str content: The contents of a spark configuration.
        :param _builtins.str filename: The name of the file where the spark configuration `content` will be stored.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "filename", filename)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The contents of a spark configuration.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> _builtins.str:
        """
        The name of the file where the spark configuration `content` will be stored.
        """
        return pulumi.get(self, "filename")


@pulumi.output_type
class SqlPoolRestore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pointInTime":
            suggest = "point_in_time"
        elif key == "sourceDatabaseId":
            suggest = "source_database_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlPoolRestore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlPoolRestore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlPoolRestore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 point_in_time: _builtins.str,
                 source_database_id: _builtins.str):
        """
        :param _builtins.str point_in_time: Specifies the Snapshot time to restore formatted as an RFC3339 date string. Changing this forces a new Synapse SQL Pool to be created.
        :param _builtins.str source_database_id: The ID of the Synapse SQL Pool or SQL Database which is to restore. Changing this forces a new Synapse SQL Pool to be created.
        """
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "source_database_id", source_database_id)

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> _builtins.str:
        """
        Specifies the Snapshot time to restore formatted as an RFC3339 date string. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "point_in_time")

    @_builtins.property
    @pulumi.getter(name="sourceDatabaseId")
    def source_database_id(self) -> _builtins.str:
        """
        The ID of the Synapse SQL Pool or SQL Database which is to restore. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "source_database_id")


@pulumi.output_type
class SqlPoolVulnerabilityAssessmentBaselineBaseline(dict):
    def __init__(__self__, *,
                 results: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] results: Specifies a list of rule baseline result.
        """
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of rule baseline result.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class SqlPoolVulnerabilityAssessmentRecurringScans(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdminsEnabled":
            suggest = "email_subscription_admins_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlPoolVulnerabilityAssessmentRecurringScans. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlPoolVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlPoolVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins_enabled: Optional[_builtins.bool] = None,
                 emails: Optional[Sequence[_builtins.str]] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool email_subscription_admins_enabled: Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        :param Sequence[_builtins.str] emails: Specifies an array of email addresses to which the scan notification is sent.
        :param _builtins.bool enabled: Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        if email_subscription_admins_enabled is not None:
            pulumi.set(__self__, "email_subscription_admins_enabled", email_subscription_admins_enabled)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="emailSubscriptionAdminsEnabled")
    def email_subscription_admins_enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        """
        return pulumi.get(self, "email_subscription_admins_enabled")

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies an array of email addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class WorkspaceAzureDevopsRepo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "branchName":
            suggest = "branch_name"
        elif key == "projectName":
            suggest = "project_name"
        elif key == "repositoryName":
            suggest = "repository_name"
        elif key == "rootFolder":
            suggest = "root_folder"
        elif key == "lastCommitId":
            suggest = "last_commit_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceAzureDevopsRepo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceAzureDevopsRepo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceAzureDevopsRepo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: _builtins.str,
                 branch_name: _builtins.str,
                 project_name: _builtins.str,
                 repository_name: _builtins.str,
                 root_folder: _builtins.str,
                 last_commit_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_name: Specifies the Azure DevOps account name.
        :param _builtins.str branch_name: Specifies the collaboration branch of the repository to get code from.
        :param _builtins.str project_name: Specifies the name of the Azure DevOps project.
        :param _builtins.str repository_name: Specifies the name of the git repository.
        :param _builtins.str root_folder: Specifies the root folder within the repository. Set to `/` for the top level.
        :param _builtins.str last_commit_id: The last commit ID.
        :param _builtins.str tenant_id: the ID of the tenant for the Azure DevOps account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "root_folder", root_folder)
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        Specifies the Azure DevOps account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        """
        Specifies the collaboration branch of the repository to get code from.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        Specifies the name of the Azure DevOps project.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        """
        Specifies the name of the git repository.
        """
        return pulumi.get(self, "repository_name")

    @_builtins.property
    @pulumi.getter(name="rootFolder")
    def root_folder(self) -> _builtins.str:
        """
        Specifies the root folder within the repository. Set to `/` for the top level.
        """
        return pulumi.get(self, "root_folder")

    @_builtins.property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[_builtins.str]:
        """
        The last commit ID.
        """
        return pulumi.get(self, "last_commit_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        the ID of the tenant for the Azure DevOps account.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspaceCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVersionlessId":
            suggest = "key_versionless_id"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_versionless_id: _builtins.str,
                 key_name: Optional[_builtins.str] = None,
                 user_assigned_identity_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_versionless_id: The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption (e.g. `https://example-keyvault.vault.azure.net/type/cmk/`).
        :param _builtins.str key_name: An identifier for the key. Name needs to match the name of the key used with the `synapse.WorkspaceKey` resource. Defaults to "cmk" if not specified.
        :param _builtins.str user_assigned_identity_id: The User Assigned Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
        pulumi.set(__self__, "key_versionless_id", key_versionless_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVersionlessId")
    def key_versionless_id(self) -> _builtins.str:
        """
        The Azure Key Vault Key Versionless ID to be used as the Customer Managed Key (CMK) for double encryption (e.g. `https://example-keyvault.vault.azure.net/type/cmk/`).
        """
        return pulumi.get(self, "key_versionless_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[_builtins.str]:
        """
        An identifier for the key. Name needs to match the name of the key used with the `synapse.WorkspaceKey` resource. Defaults to "cmk" if not specified.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The User Assigned Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class WorkspaceGithubRepo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "branchName":
            suggest = "branch_name"
        elif key == "repositoryName":
            suggest = "repository_name"
        elif key == "rootFolder":
            suggest = "root_folder"
        elif key == "gitUrl":
            suggest = "git_url"
        elif key == "lastCommitId":
            suggest = "last_commit_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceGithubRepo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceGithubRepo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceGithubRepo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: _builtins.str,
                 branch_name: _builtins.str,
                 repository_name: _builtins.str,
                 root_folder: _builtins.str,
                 git_url: Optional[_builtins.str] = None,
                 last_commit_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_name: Specifies the GitHub account name.
        :param _builtins.str branch_name: Specifies the collaboration branch of the repository to get code from.
        :param _builtins.str repository_name: Specifies the name of the git repository.
        :param _builtins.str root_folder: Specifies the root folder within the repository. Set to `/` for the top level.
        :param _builtins.str git_url: Specifies the GitHub Enterprise host name. For example: <https://github.mydomain.com>.
               
               > **Note:** You must log in to the Synapse UI to complete the authentication to the GitHub repository.
        :param _builtins.str last_commit_id: The last commit ID.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "root_folder", root_folder)
        if git_url is not None:
            pulumi.set(__self__, "git_url", git_url)
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        Specifies the GitHub account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        """
        Specifies the collaboration branch of the repository to get code from.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        """
        Specifies the name of the git repository.
        """
        return pulumi.get(self, "repository_name")

    @_builtins.property
    @pulumi.getter(name="rootFolder")
    def root_folder(self) -> _builtins.str:
        """
        Specifies the root folder within the repository. Set to `/` for the top level.
        """
        return pulumi.get(self, "root_folder")

    @_builtins.property
    @pulumi.getter(name="gitUrl")
    def git_url(self) -> Optional[_builtins.str]:
        """
        Specifies the GitHub Enterprise host name. For example: <https://github.mydomain.com>.

        > **Note:** You must log in to the Synapse UI to complete the authentication to the GitHub repository.
        """
        return pulumi.get(self, "git_url")

    @_builtins.property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[_builtins.str]:
        """
        The last commit ID.
        """
        return pulumi.get(self, "last_commit_id")


@pulumi.output_type
class WorkspaceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be associated with this Synapse Workspace. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Synapse Workspace.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be associated with this Synapse Workspace. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Synapse Workspace.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspaceVulnerabilityAssessmentRecurringScans(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdminsEnabled":
            suggest = "email_subscription_admins_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceVulnerabilityAssessmentRecurringScans. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins_enabled: Optional[_builtins.bool] = None,
                 emails: Optional[Sequence[_builtins.str]] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool email_subscription_admins_enabled: Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        :param Sequence[_builtins.str] emails: Specifies an array of email addresses to which the scan notification is sent.
        :param _builtins.bool enabled: Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        if email_subscription_admins_enabled is not None:
            pulumi.set(__self__, "email_subscription_admins_enabled", email_subscription_admins_enabled)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="emailSubscriptionAdminsEnabled")
    def email_subscription_admins_enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        """
        return pulumi.get(self, "email_subscription_admins_enabled")

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies an array of email addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetWorkspaceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        :param _builtins.str type: The Identity Type for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Identity Type for the Service Principal associated with the Managed Service Identity of this Synapse Workspace.
        """
        return pulumi.get(self, "type")


