# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'VirtualMachineManagerVirtualMachineInstanceHardware',
    'VirtualMachineManagerVirtualMachineInstanceInfrastructure',
    'VirtualMachineManagerVirtualMachineInstanceNetworkInterface',
    'VirtualMachineManagerVirtualMachineInstanceOperatingSystem',
    'VirtualMachineManagerVirtualMachineInstanceStorageDisk',
    'GetVirtualMachineManagerInventoryItemsInventoryItemResult',
]

@pulumi.output_type
class VirtualMachineManagerVirtualMachineInstanceHardware(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"
        elif key == "dynamicMemoryMaxInMb":
            suggest = "dynamic_memory_max_in_mb"
        elif key == "dynamicMemoryMinInMb":
            suggest = "dynamic_memory_min_in_mb"
        elif key == "limitCpuForMigrationEnabled":
            suggest = "limit_cpu_for_migration_enabled"
        elif key == "memoryInMb":
            suggest = "memory_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineManagerVirtualMachineInstanceHardware. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineManagerVirtualMachineInstanceHardware.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineManagerVirtualMachineInstanceHardware.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[_builtins.int] = None,
                 dynamic_memory_max_in_mb: Optional[_builtins.int] = None,
                 dynamic_memory_min_in_mb: Optional[_builtins.int] = None,
                 limit_cpu_for_migration_enabled: Optional[_builtins.bool] = None,
                 memory_in_mb: Optional[_builtins.int] = None):
        """
        :param _builtins.int cpu_count: The number of vCPUs for the Virtual Machine. Possible values are between `1` and `64`.
        :param _builtins.int dynamic_memory_max_in_mb: The max dynamic memory for the Virtual Machine. Possible values are between `32` and `1048576`.
        :param _builtins.int dynamic_memory_min_in_mb: The min dynamic memory for the Virtual Machine. Possible values are between `32` and `1048576`.
        :param _builtins.bool limit_cpu_for_migration_enabled: Whether processor compatibility mode for live migration of Virtual Machines is enabled.
        :param _builtins.int memory_in_mb: The size of a Virtual Machine's memory. Possible values are between `32` and `1048576`.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if dynamic_memory_max_in_mb is not None:
            pulumi.set(__self__, "dynamic_memory_max_in_mb", dynamic_memory_max_in_mb)
        if dynamic_memory_min_in_mb is not None:
            pulumi.set(__self__, "dynamic_memory_min_in_mb", dynamic_memory_min_in_mb)
        if limit_cpu_for_migration_enabled is not None:
            pulumi.set(__self__, "limit_cpu_for_migration_enabled", limit_cpu_for_migration_enabled)
        if memory_in_mb is not None:
            pulumi.set(__self__, "memory_in_mb", memory_in_mb)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[_builtins.int]:
        """
        The number of vCPUs for the Virtual Machine. Possible values are between `1` and `64`.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="dynamicMemoryMaxInMb")
    def dynamic_memory_max_in_mb(self) -> Optional[_builtins.int]:
        """
        The max dynamic memory for the Virtual Machine. Possible values are between `32` and `1048576`.
        """
        return pulumi.get(self, "dynamic_memory_max_in_mb")

    @_builtins.property
    @pulumi.getter(name="dynamicMemoryMinInMb")
    def dynamic_memory_min_in_mb(self) -> Optional[_builtins.int]:
        """
        The min dynamic memory for the Virtual Machine. Possible values are between `32` and `1048576`.
        """
        return pulumi.get(self, "dynamic_memory_min_in_mb")

    @_builtins.property
    @pulumi.getter(name="limitCpuForMigrationEnabled")
    def limit_cpu_for_migration_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether processor compatibility mode for live migration of Virtual Machines is enabled.
        """
        return pulumi.get(self, "limit_cpu_for_migration_enabled")

    @_builtins.property
    @pulumi.getter(name="memoryInMb")
    def memory_in_mb(self) -> Optional[_builtins.int]:
        """
        The size of a Virtual Machine's memory. Possible values are between `32` and `1048576`.
        """
        return pulumi.get(self, "memory_in_mb")


@pulumi.output_type
class VirtualMachineManagerVirtualMachineInstanceInfrastructure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkpointType":
            suggest = "checkpoint_type"
        elif key == "systemCenterVirtualMachineManagerCloudId":
            suggest = "system_center_virtual_machine_manager_cloud_id"
        elif key == "systemCenterVirtualMachineManagerInventoryItemId":
            suggest = "system_center_virtual_machine_manager_inventory_item_id"
        elif key == "systemCenterVirtualMachineManagerTemplateId":
            suggest = "system_center_virtual_machine_manager_template_id"
        elif key == "systemCenterVirtualMachineManagerVirtualMachineServerId":
            suggest = "system_center_virtual_machine_manager_virtual_machine_server_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineManagerVirtualMachineInstanceInfrastructure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineManagerVirtualMachineInstanceInfrastructure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineManagerVirtualMachineInstanceInfrastructure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 checkpoint_type: Optional[_builtins.str] = None,
                 system_center_virtual_machine_manager_cloud_id: Optional[_builtins.str] = None,
                 system_center_virtual_machine_manager_inventory_item_id: Optional[_builtins.str] = None,
                 system_center_virtual_machine_manager_template_id: Optional[_builtins.str] = None,
                 system_center_virtual_machine_manager_virtual_machine_server_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str checkpoint_type: The type of checkpoint supported for the Virtual Machine. Possible values are `Disabled`, `Production`, `ProductionOnly` and `Standard`.
        :param _builtins.str system_center_virtual_machine_manager_cloud_id: The ID of the System Center Virtual Machine Manager Cloud resource to use for deploying the Virtual Machine. Changing this forces a new resource to be created.
        :param _builtins.str system_center_virtual_machine_manager_inventory_item_id: The ID of the System Center Virtual Machine Manager Inventory Item for System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        :param _builtins.str system_center_virtual_machine_manager_template_id: The ID of the System Center Virtual Machine Manager Virtual Machine Template to use for deploying the Virtual Machine. Changing this forces a new resource to be created.
        :param _builtins.str system_center_virtual_machine_manager_virtual_machine_server_id: The ID of the System Center Virtual Machine Manager Virtual Machine. Changing this forces a new resource to be created.
        """
        if checkpoint_type is not None:
            pulumi.set(__self__, "checkpoint_type", checkpoint_type)
        if system_center_virtual_machine_manager_cloud_id is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_cloud_id", system_center_virtual_machine_manager_cloud_id)
        if system_center_virtual_machine_manager_inventory_item_id is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_inventory_item_id", system_center_virtual_machine_manager_inventory_item_id)
        if system_center_virtual_machine_manager_template_id is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_template_id", system_center_virtual_machine_manager_template_id)
        if system_center_virtual_machine_manager_virtual_machine_server_id is not None:
            pulumi.set(__self__, "system_center_virtual_machine_manager_virtual_machine_server_id", system_center_virtual_machine_manager_virtual_machine_server_id)

    @_builtins.property
    @pulumi.getter(name="checkpointType")
    def checkpoint_type(self) -> Optional[_builtins.str]:
        """
        The type of checkpoint supported for the Virtual Machine. Possible values are `Disabled`, `Production`, `ProductionOnly` and `Standard`.
        """
        return pulumi.get(self, "checkpoint_type")

    @_builtins.property
    @pulumi.getter(name="systemCenterVirtualMachineManagerCloudId")
    def system_center_virtual_machine_manager_cloud_id(self) -> Optional[_builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Cloud resource to use for deploying the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_cloud_id")

    @_builtins.property
    @pulumi.getter(name="systemCenterVirtualMachineManagerInventoryItemId")
    def system_center_virtual_machine_manager_inventory_item_id(self) -> Optional[_builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Inventory Item for System Center Virtual Machine Manager Virtual Machine Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_inventory_item_id")

    @_builtins.property
    @pulumi.getter(name="systemCenterVirtualMachineManagerTemplateId")
    def system_center_virtual_machine_manager_template_id(self) -> Optional[_builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Virtual Machine Template to use for deploying the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_template_id")

    @_builtins.property
    @pulumi.getter(name="systemCenterVirtualMachineManagerVirtualMachineServerId")
    def system_center_virtual_machine_manager_virtual_machine_server_id(self) -> Optional[_builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "system_center_virtual_machine_manager_virtual_machine_server_id")


@pulumi.output_type
class VirtualMachineManagerVirtualMachineInstanceNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4AddressType":
            suggest = "ipv4_address_type"
        elif key == "ipv6AddressType":
            suggest = "ipv6_address_type"
        elif key == "macAddressType":
            suggest = "mac_address_type"
        elif key == "virtualNetworkId":
            suggest = "virtual_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineManagerVirtualMachineInstanceNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineManagerVirtualMachineInstanceNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineManagerVirtualMachineInstanceNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 ipv4_address_type: Optional[_builtins.str] = None,
                 ipv6_address_type: Optional[_builtins.str] = None,
                 mac_address_type: Optional[_builtins.str] = None,
                 virtual_network_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the Virtual Network in System Center Virtual Machine Manager Server that the Network Interface is connected to.
        :param _builtins.str ipv4_address_type: The IPv4 address type. Possible values are `Dynamic` and `Static`.
        :param _builtins.str ipv6_address_type: The IPv6 address type. Possible values are `Dynamic` and `Static`.
        :param _builtins.str mac_address_type: The MAC address type. Possible values are `Dynamic` and `Static`.
        :param _builtins.str virtual_network_id: The ID of the System Center Virtual Machine Manager Virtual Network to connect the Network Interface.
        """
        pulumi.set(__self__, "name", name)
        if ipv4_address_type is not None:
            pulumi.set(__self__, "ipv4_address_type", ipv4_address_type)
        if ipv6_address_type is not None:
            pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        if mac_address_type is not None:
            pulumi.set(__self__, "mac_address_type", mac_address_type)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Virtual Network in System Center Virtual Machine Manager Server that the Network Interface is connected to.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ipv4AddressType")
    def ipv4_address_type(self) -> Optional[_builtins.str]:
        """
        The IPv4 address type. Possible values are `Dynamic` and `Static`.
        """
        return pulumi.get(self, "ipv4_address_type")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> Optional[_builtins.str]:
        """
        The IPv6 address type. Possible values are `Dynamic` and `Static`.
        """
        return pulumi.get(self, "ipv6_address_type")

    @_builtins.property
    @pulumi.getter(name="macAddressType")
    def mac_address_type(self) -> Optional[_builtins.str]:
        """
        The MAC address type. Possible values are `Dynamic` and `Static`.
        """
        return pulumi.get(self, "mac_address_type")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[_builtins.str]:
        """
        The ID of the System Center Virtual Machine Manager Virtual Network to connect the Network Interface.
        """
        return pulumi.get(self, "virtual_network_id")


@pulumi.output_type
class VirtualMachineManagerVirtualMachineInstanceOperatingSystem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "computerName":
            suggest = "computer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineManagerVirtualMachineInstanceOperatingSystem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineManagerVirtualMachineInstanceOperatingSystem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineManagerVirtualMachineInstanceOperatingSystem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[_builtins.str] = None,
                 computer_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str admin_password: The admin password of the Virtual Machine. Changing this forces a new resource to be created.
        :param _builtins.str computer_name: The computer name of the Virtual Machine. Changing this forces a new resource to be created.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        The admin password of the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[_builtins.str]:
        """
        The computer name of the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name")


@pulumi.output_type
class VirtualMachineManagerVirtualMachineInstanceStorageDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "busType":
            suggest = "bus_type"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "storageQosPolicyName":
            suggest = "storage_qos_policy_name"
        elif key == "templateDiskId":
            suggest = "template_disk_id"
        elif key == "vhdType":
            suggest = "vhd_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineManagerVirtualMachineInstanceStorageDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineManagerVirtualMachineInstanceStorageDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineManagerVirtualMachineInstanceStorageDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bus: Optional[_builtins.int] = None,
                 bus_type: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 lun: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 storage_qos_policy_name: Optional[_builtins.str] = None,
                 template_disk_id: Optional[_builtins.str] = None,
                 vhd_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int bus: The disk bus. Possible values are between `0` and `3`.
        :param _builtins.str bus_type: The disk bus type. Possible values are `IDE` and `SCSI`.
        :param _builtins.int disk_size_gb: The disk total size.
        :param _builtins.int lun: The disk lun. Possible values are between `0` and `63`.
        :param _builtins.str name: The name of the disk.
        :param _builtins.str storage_qos_policy_name: The name of the Storage QoS policy.
        :param _builtins.str template_disk_id: The disk ID in the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        :param _builtins.str vhd_type: The disk vhd type. Possible values are `Dynamic` and `Fixed`.
        """
        if bus is not None:
            pulumi.set(__self__, "bus", bus)
        if bus_type is not None:
            pulumi.set(__self__, "bus_type", bus_type)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_qos_policy_name is not None:
            pulumi.set(__self__, "storage_qos_policy_name", storage_qos_policy_name)
        if template_disk_id is not None:
            pulumi.set(__self__, "template_disk_id", template_disk_id)
        if vhd_type is not None:
            pulumi.set(__self__, "vhd_type", vhd_type)

    @_builtins.property
    @pulumi.getter
    def bus(self) -> Optional[_builtins.int]:
        """
        The disk bus. Possible values are between `0` and `3`.
        """
        return pulumi.get(self, "bus")

    @_builtins.property
    @pulumi.getter(name="busType")
    def bus_type(self) -> Optional[_builtins.str]:
        """
        The disk bus type. Possible values are `IDE` and `SCSI`.
        """
        return pulumi.get(self, "bus_type")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The disk total size.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        The disk lun. Possible values are between `0` and `63`.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the disk.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageQosPolicyName")
    def storage_qos_policy_name(self) -> Optional[_builtins.str]:
        """
        The name of the Storage QoS policy.
        """
        return pulumi.get(self, "storage_qos_policy_name")

    @_builtins.property
    @pulumi.getter(name="templateDiskId")
    def template_disk_id(self) -> Optional[_builtins.str]:
        """
        The disk ID in the System Center Virtual Machine Manager Virtual Machine Template. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "template_disk_id")

    @_builtins.property
    @pulumi.getter(name="vhdType")
    def vhd_type(self) -> Optional[_builtins.str]:
        """
        The disk vhd type. Possible values are `Dynamic` and `Fixed`.
        """
        return pulumi.get(self, "vhd_type")


@pulumi.output_type
class GetVirtualMachineManagerInventoryItemsInventoryItemResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str id: The ID of the System Center Virtual Machine Manager Inventory Item.
        :param _builtins.str name: The name of the System Center Virtual Machine Manager Inventory Item.
        :param _builtins.str uuid: The UUID of the System Center Virtual Machine Manager Inventory Item that is assigned by System Center Virtual Machine Manager.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the System Center Virtual Machine Manager Inventory Item.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the System Center Virtual Machine Manager Inventory Item.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the System Center Virtual Machine Manager Inventory Item that is assigned by System Center Virtual Machine Manager.
        """
        return pulumi.get(self, "uuid")


