# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicesCommunicationsGatewayArgs', 'ServicesCommunicationsGateway']

@pulumi.input_type
class ServicesCommunicationsGatewayArgs:
    def __init__(__self__, *,
                 codecs: pulumi.Input[_builtins.str],
                 connectivity: pulumi.Input[_builtins.str],
                 e911_type: pulumi.Input[_builtins.str],
                 platforms: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 service_locations: pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]],
                 api_bridge: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 emergency_dial_strings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_teams_voicemail_pilot_number: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_prem_mcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServicesCommunicationsGateway resource.
        :param pulumi.Input[_builtins.str] codecs: The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        :param pulumi.Input[_builtins.str] connectivity: How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        :param pulumi.Input[_builtins.str] e911_type: How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]] service_locations: A `service_location` block as defined below.
        :param pulumi.Input[_builtins.str] api_bridge: Details of API bridge functionality, if required.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emergency_dial_strings: A list of dial strings used for emergency calling.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_teams_voicemail_pilot_number: This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] on_prem_mcp_enabled: Whether an on-premises Mobile Control Point is in use.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        pulumi.set(__self__, "codecs", codecs)
        pulumi.set(__self__, "connectivity", connectivity)
        pulumi.set(__self__, "e911_type", e911_type)
        pulumi.set(__self__, "platforms", platforms)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_locations", service_locations)
        if api_bridge is not None:
            pulumi.set(__self__, "api_bridge", api_bridge)
        if auto_generated_domain_name_label_scope is not None:
            pulumi.set(__self__, "auto_generated_domain_name_label_scope", auto_generated_domain_name_label_scope)
        if emergency_dial_strings is not None:
            pulumi.set(__self__, "emergency_dial_strings", emergency_dial_strings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if microsoft_teams_voicemail_pilot_number is not None:
            pulumi.set(__self__, "microsoft_teams_voicemail_pilot_number", microsoft_teams_voicemail_pilot_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_prem_mcp_enabled is not None:
            pulumi.set(__self__, "on_prem_mcp_enabled", on_prem_mcp_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def codecs(self) -> pulumi.Input[_builtins.str]:
        """
        The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        """
        return pulumi.get(self, "codecs")

    @codecs.setter
    def codecs(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "codecs", value)

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> pulumi.Input[_builtins.str]:
        """
        How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connectivity", value)

    @_builtins.property
    @pulumi.getter(name="e911Type")
    def e911_type(self) -> pulumi.Input[_builtins.str]:
        """
        How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        """
        return pulumi.get(self, "e911_type")

    @e911_type.setter
    def e911_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "e911_type", value)

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        """
        return pulumi.get(self, "platforms")

    @platforms.setter
    def platforms(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "platforms", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceLocations")
    def service_locations(self) -> pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]]:
        """
        A `service_location` block as defined below.
        """
        return pulumi.get(self, "service_locations")

    @service_locations.setter
    def service_locations(self, value: pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]]):
        pulumi.set(self, "service_locations", value)

    @_builtins.property
    @pulumi.getter(name="apiBridge")
    def api_bridge(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details of API bridge functionality, if required.
        """
        return pulumi.get(self, "api_bridge")

    @api_bridge.setter
    def api_bridge(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_bridge", value)

    @_builtins.property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @auto_generated_domain_name_label_scope.setter
    def auto_generated_domain_name_label_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_generated_domain_name_label_scope", value)

    @_builtins.property
    @pulumi.getter(name="emergencyDialStrings")
    def emergency_dial_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of dial strings used for emergency calling.
        """
        return pulumi.get(self, "emergency_dial_strings")

    @emergency_dial_strings.setter
    def emergency_dial_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "emergency_dial_strings", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="microsoftTeamsVoicemailPilotNumber")
    def microsoft_teams_voicemail_pilot_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        """
        return pulumi.get(self, "microsoft_teams_voicemail_pilot_number")

    @microsoft_teams_voicemail_pilot_number.setter
    def microsoft_teams_voicemail_pilot_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_teams_voicemail_pilot_number", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onPremMcpEnabled")
    def on_prem_mcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an on-premises Mobile Control Point is in use.
        """
        return pulumi.get(self, "on_prem_mcp_enabled")

    @on_prem_mcp_enabled.setter
    def on_prem_mcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_prem_mcp_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServicesCommunicationsGatewayState:
    def __init__(__self__, *,
                 api_bridge: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 codecs: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 e911_type: Optional[pulumi.Input[_builtins.str]] = None,
                 emergency_dial_strings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_teams_voicemail_pilot_number: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_prem_mcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ServicesCommunicationsGateway resources.
        :param pulumi.Input[_builtins.str] api_bridge: Details of API bridge functionality, if required.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        :param pulumi.Input[_builtins.str] codecs: The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        :param pulumi.Input[_builtins.str] connectivity: How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        :param pulumi.Input[_builtins.str] e911_type: How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emergency_dial_strings: A list of dial strings used for emergency calling.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_teams_voicemail_pilot_number: This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] on_prem_mcp_enabled: Whether an on-premises Mobile Control Point is in use.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]] service_locations: A `service_location` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        if api_bridge is not None:
            pulumi.set(__self__, "api_bridge", api_bridge)
        if auto_generated_domain_name_label_scope is not None:
            pulumi.set(__self__, "auto_generated_domain_name_label_scope", auto_generated_domain_name_label_scope)
        if codecs is not None:
            pulumi.set(__self__, "codecs", codecs)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if e911_type is not None:
            pulumi.set(__self__, "e911_type", e911_type)
        if emergency_dial_strings is not None:
            pulumi.set(__self__, "emergency_dial_strings", emergency_dial_strings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if microsoft_teams_voicemail_pilot_number is not None:
            pulumi.set(__self__, "microsoft_teams_voicemail_pilot_number", microsoft_teams_voicemail_pilot_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_prem_mcp_enabled is not None:
            pulumi.set(__self__, "on_prem_mcp_enabled", on_prem_mcp_enabled)
        if platforms is not None:
            pulumi.set(__self__, "platforms", platforms)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_locations is not None:
            pulumi.set(__self__, "service_locations", service_locations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiBridge")
    def api_bridge(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details of API bridge functionality, if required.
        """
        return pulumi.get(self, "api_bridge")

    @api_bridge.setter
    def api_bridge(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_bridge", value)

    @_builtins.property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @auto_generated_domain_name_label_scope.setter
    def auto_generated_domain_name_label_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_generated_domain_name_label_scope", value)

    @_builtins.property
    @pulumi.getter
    def codecs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        """
        return pulumi.get(self, "codecs")

    @codecs.setter
    def codecs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "codecs", value)

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connectivity", value)

    @_builtins.property
    @pulumi.getter(name="e911Type")
    def e911_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        """
        return pulumi.get(self, "e911_type")

    @e911_type.setter
    def e911_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "e911_type", value)

    @_builtins.property
    @pulumi.getter(name="emergencyDialStrings")
    def emergency_dial_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of dial strings used for emergency calling.
        """
        return pulumi.get(self, "emergency_dial_strings")

    @emergency_dial_strings.setter
    def emergency_dial_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "emergency_dial_strings", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="microsoftTeamsVoicemailPilotNumber")
    def microsoft_teams_voicemail_pilot_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        """
        return pulumi.get(self, "microsoft_teams_voicemail_pilot_number")

    @microsoft_teams_voicemail_pilot_number.setter
    def microsoft_teams_voicemail_pilot_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_teams_voicemail_pilot_number", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="onPremMcpEnabled")
    def on_prem_mcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an on-premises Mobile Control Point is in use.
        """
        return pulumi.get(self, "on_prem_mcp_enabled")

    @on_prem_mcp_enabled.setter
    def on_prem_mcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_prem_mcp_enabled", value)

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        """
        return pulumi.get(self, "platforms")

    @platforms.setter
    def platforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "platforms", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceLocations")
    def service_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]]]:
        """
        A `service_location` block as defined below.
        """
        return pulumi.get(self, "service_locations")

    @service_locations.setter
    def service_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicesCommunicationsGatewayServiceLocationArgs']]]]):
        pulumi.set(self, "service_locations", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:voice/servicesCommunicationsGateway:ServicesCommunicationsGateway")
class ServicesCommunicationsGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_bridge: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 codecs: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 e911_type: Optional[pulumi.Input[_builtins.str]] = None,
                 emergency_dial_strings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_teams_voicemail_pilot_number: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_prem_mcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicesCommunicationsGatewayServiceLocationArgs', 'ServicesCommunicationsGatewayServiceLocationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Voice Services Communications Gateways.

        !> **Note:** You must have signed an Operator Connect agreement with Microsoft to use this resource. For more information, see [`Prerequisites`](https://learn.microsoft.com/en-us/azure/communications-gateway/prepare-to-deploy#prerequisites).

        !> **Note:** Access to Azure Communications Gateway is restricted, see [`Get access to Azure Communications Gateway for your Azure subscription`](https://learn.microsoft.com/en-us/azure/communications-gateway/prepare-to-deploy#9-get-access-to-azure-communications-gateway-for-your-azure-subscription) for details.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_services_communications_gateway = azure.voice.ServicesCommunicationsGateway("example",
            name="example-vcg",
            location="West Europe",
            resource_group_name=example.name,
            connectivity="PublicAddress",
            codecs="PCMA",
            e911_type="DirectToEsrp",
            platforms=[
                "OperatorConnect",
                "TeamsPhoneMobile",
            ],
            service_locations=[
                {
                    "location": "eastus",
                    "allowed_media_source_address_prefixes": ["10.1.2.0/24"],
                    "allowed_signaling_source_address_prefixes": ["10.1.1.0/24"],
                    "esrp_addresses": ["198.51.100.3"],
                    "operator_addresses": ["198.51.100.1"],
                },
                {
                    "location": "eastus2",
                    "allowed_media_source_address_prefixes": ["10.2.2.0/24"],
                    "allowed_signaling_source_address_prefixes": ["10.2.1.0/24"],
                    "esrp_addresses": ["198.51.100.4"],
                    "operator_addresses": ["198.51.100.2"],
                },
            ],
            auto_generated_domain_name_label_scope="SubscriptionReuse",
            api_bridge=json.dumps({}),
            emergency_dial_strings=[
                "911",
                "933",
            ],
            on_prem_mcp_enabled=False,
            tags={
                "key": "value",
            },
            microsoft_teams_voicemail_pilot_number="1")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.VoiceServices` - 2023-04-03

        ## Import

        Voice Services Communications Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:voice/servicesCommunicationsGateway:ServicesCommunicationsGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.VoiceServices/communicationsGateways/communicationsGateway1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_bridge: Details of API bridge functionality, if required.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        :param pulumi.Input[_builtins.str] codecs: The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        :param pulumi.Input[_builtins.str] connectivity: How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        :param pulumi.Input[_builtins.str] e911_type: How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emergency_dial_strings: A list of dial strings used for emergency calling.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_teams_voicemail_pilot_number: This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] on_prem_mcp_enabled: Whether an on-premises Mobile Control Point is in use.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicesCommunicationsGatewayServiceLocationArgs', 'ServicesCommunicationsGatewayServiceLocationArgsDict']]]] service_locations: A `service_location` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicesCommunicationsGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Voice Services Communications Gateways.

        !> **Note:** You must have signed an Operator Connect agreement with Microsoft to use this resource. For more information, see [`Prerequisites`](https://learn.microsoft.com/en-us/azure/communications-gateway/prepare-to-deploy#prerequisites).

        !> **Note:** Access to Azure Communications Gateway is restricted, see [`Get access to Azure Communications Gateway for your Azure subscription`](https://learn.microsoft.com/en-us/azure/communications-gateway/prepare-to-deploy#9-get-access-to-azure-communications-gateway-for-your-azure-subscription) for details.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_services_communications_gateway = azure.voice.ServicesCommunicationsGateway("example",
            name="example-vcg",
            location="West Europe",
            resource_group_name=example.name,
            connectivity="PublicAddress",
            codecs="PCMA",
            e911_type="DirectToEsrp",
            platforms=[
                "OperatorConnect",
                "TeamsPhoneMobile",
            ],
            service_locations=[
                {
                    "location": "eastus",
                    "allowed_media_source_address_prefixes": ["10.1.2.0/24"],
                    "allowed_signaling_source_address_prefixes": ["10.1.1.0/24"],
                    "esrp_addresses": ["198.51.100.3"],
                    "operator_addresses": ["198.51.100.1"],
                },
                {
                    "location": "eastus2",
                    "allowed_media_source_address_prefixes": ["10.2.2.0/24"],
                    "allowed_signaling_source_address_prefixes": ["10.2.1.0/24"],
                    "esrp_addresses": ["198.51.100.4"],
                    "operator_addresses": ["198.51.100.2"],
                },
            ],
            auto_generated_domain_name_label_scope="SubscriptionReuse",
            api_bridge=json.dumps({}),
            emergency_dial_strings=[
                "911",
                "933",
            ],
            on_prem_mcp_enabled=False,
            tags={
                "key": "value",
            },
            microsoft_teams_voicemail_pilot_number="1")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.VoiceServices` - 2023-04-03

        ## Import

        Voice Services Communications Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:voice/servicesCommunicationsGateway:ServicesCommunicationsGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.VoiceServices/communicationsGateways/communicationsGateway1
        ```

        :param str resource_name: The name of the resource.
        :param ServicesCommunicationsGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicesCommunicationsGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_bridge: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 codecs: Optional[pulumi.Input[_builtins.str]] = None,
                 connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 e911_type: Optional[pulumi.Input[_builtins.str]] = None,
                 emergency_dial_strings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_teams_voicemail_pilot_number: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_prem_mcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicesCommunicationsGatewayServiceLocationArgs', 'ServicesCommunicationsGatewayServiceLocationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicesCommunicationsGatewayArgs.__new__(ServicesCommunicationsGatewayArgs)

            __props__.__dict__["api_bridge"] = api_bridge
            __props__.__dict__["auto_generated_domain_name_label_scope"] = auto_generated_domain_name_label_scope
            if codecs is None and not opts.urn:
                raise TypeError("Missing required property 'codecs'")
            __props__.__dict__["codecs"] = codecs
            if connectivity is None and not opts.urn:
                raise TypeError("Missing required property 'connectivity'")
            __props__.__dict__["connectivity"] = connectivity
            if e911_type is None and not opts.urn:
                raise TypeError("Missing required property 'e911_type'")
            __props__.__dict__["e911_type"] = e911_type
            __props__.__dict__["emergency_dial_strings"] = emergency_dial_strings
            __props__.__dict__["location"] = location
            __props__.__dict__["microsoft_teams_voicemail_pilot_number"] = microsoft_teams_voicemail_pilot_number
            __props__.__dict__["name"] = name
            __props__.__dict__["on_prem_mcp_enabled"] = on_prem_mcp_enabled
            if platforms is None and not opts.urn:
                raise TypeError("Missing required property 'platforms'")
            __props__.__dict__["platforms"] = platforms
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if service_locations is None and not opts.urn:
                raise TypeError("Missing required property 'service_locations'")
            __props__.__dict__["service_locations"] = service_locations
            __props__.__dict__["tags"] = tags
        super(ServicesCommunicationsGateway, __self__).__init__(
            'azure:voice/servicesCommunicationsGateway:ServicesCommunicationsGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_bridge: Optional[pulumi.Input[_builtins.str]] = None,
            auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
            codecs: Optional[pulumi.Input[_builtins.str]] = None,
            connectivity: Optional[pulumi.Input[_builtins.str]] = None,
            e911_type: Optional[pulumi.Input[_builtins.str]] = None,
            emergency_dial_strings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            microsoft_teams_voicemail_pilot_number: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            on_prem_mcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicesCommunicationsGatewayServiceLocationArgs', 'ServicesCommunicationsGatewayServiceLocationArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ServicesCommunicationsGateway':
        """
        Get an existing ServicesCommunicationsGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_bridge: Details of API bridge functionality, if required.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        :param pulumi.Input[_builtins.str] codecs: The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        :param pulumi.Input[_builtins.str] connectivity: How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        :param pulumi.Input[_builtins.str] e911_type: How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emergency_dial_strings: A list of dial strings used for emergency calling.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_teams_voicemail_pilot_number: This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] on_prem_mcp_enabled: Whether an on-premises Mobile Control Point is in use.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicesCommunicationsGatewayServiceLocationArgs', 'ServicesCommunicationsGatewayServiceLocationArgsDict']]]] service_locations: A `service_location` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicesCommunicationsGatewayState.__new__(_ServicesCommunicationsGatewayState)

        __props__.__dict__["api_bridge"] = api_bridge
        __props__.__dict__["auto_generated_domain_name_label_scope"] = auto_generated_domain_name_label_scope
        __props__.__dict__["codecs"] = codecs
        __props__.__dict__["connectivity"] = connectivity
        __props__.__dict__["e911_type"] = e911_type
        __props__.__dict__["emergency_dial_strings"] = emergency_dial_strings
        __props__.__dict__["location"] = location
        __props__.__dict__["microsoft_teams_voicemail_pilot_number"] = microsoft_teams_voicemail_pilot_number
        __props__.__dict__["name"] = name
        __props__.__dict__["on_prem_mcp_enabled"] = on_prem_mcp_enabled
        __props__.__dict__["platforms"] = platforms
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_locations"] = service_locations
        __props__.__dict__["tags"] = tags
        return ServicesCommunicationsGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiBridge")
    def api_bridge(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Details of API bridge functionality, if required.
        """
        return pulumi.get(self, "api_bridge")

    @_builtins.property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the scope at which the auto-generated domain name can be re-used. Possible values are `TenantReuse`, `SubscriptionReuse`, `ResourceGroupReuse` and `NoReuse` . Changing this forces a new resource to be created. Defaults to `TenantReuse`.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @_builtins.property
    @pulumi.getter
    def codecs(self) -> pulumi.Output[_builtins.str]:
        """
        The voice codecs expected for communication with Teams. Possible values are `PCMA`, `PCMU`,`G722`,`G722_2`,`SILK_8` and `SILK_16`.
        """
        return pulumi.get(self, "codecs")

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> pulumi.Output[_builtins.str]:
        """
        How to connect back to the operator network, e.g. MAPS. Possible values is `PublicAddress`. Changing this forces a new Voice Services Communications Gateways to be created.
        """
        return pulumi.get(self, "connectivity")

    @_builtins.property
    @pulumi.getter(name="e911Type")
    def e911_type(self) -> pulumi.Output[_builtins.str]:
        """
        How to handle 911 calls. Possible values are `Standard` and `DirectToEsrp`.
        """
        return pulumi.get(self, "e911_type")

    @_builtins.property
    @pulumi.getter(name="emergencyDialStrings")
    def emergency_dial_strings(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of dial strings used for emergency calling.
        """
        return pulumi.get(self, "emergency_dial_strings")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="microsoftTeamsVoicemailPilotNumber")
    def microsoft_teams_voicemail_pilot_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
        """
        return pulumi.get(self, "microsoft_teams_voicemail_pilot_number")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Voice Services Communications Gateways. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onPremMcpEnabled")
    def on_prem_mcp_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether an on-premises Mobile Control Point is in use.
        """
        return pulumi.get(self, "on_prem_mcp_enabled")

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Voice Services Communications GatewaysAvailable supports platform types. Possible values are `OperatorConnect`, `TeamsPhoneMobile`.
        """
        return pulumi.get(self, "platforms")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Voice Services Communications Gateways should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceLocations")
    def service_locations(self) -> pulumi.Output[Sequence['outputs.ServicesCommunicationsGatewayServiceLocation']]:
        """
        A `service_location` block as defined below.
        """
        return pulumi.get(self, "service_locations")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Voice Services Communications Gateways.
        """
        return pulumi.get(self, "tags")

