# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAclArgs', 'NetworkAcl']

@pulumi.input_type
class NetworkAclArgs:
    def __init__(__self__, *,
                 public_network: pulumi.Input['NetworkAclPublicNetworkArgs'],
                 web_pubsub_id: pulumi.Input[_builtins.str],
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkAcl resource.
        :param pulumi.Input['NetworkAclPublicNetworkArgs'] public_network: A `public_network` block as defined below.
        :param pulumi.Input[_builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]] private_endpoints: A `private_endpoint` block as defined below.
        """
        pulumi.set(__self__, "public_network", public_network)
        pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)

    @_builtins.property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Input['NetworkAclPublicNetworkArgs']:
        """
        A `public_network` block as defined below.
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: pulumi.Input['NetworkAclPublicNetworkArgs']):
        pulumi.set(self, "public_network", value)

    @_builtins.property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_pubsub_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]:
        """
        A `private_endpoint` block as defined below.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)


@pulumi.input_type
class _NetworkAclState:
    def __init__(__self__, *,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]] = None,
                 public_network: Optional[pulumi.Input['NetworkAclPublicNetworkArgs']] = None,
                 web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkAcl resources.
        :param pulumi.Input[_builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]] private_endpoints: A `private_endpoint` block as defined below.
        :param pulumi.Input['NetworkAclPublicNetworkArgs'] public_network: A `public_network` block as defined below.
        :param pulumi.Input[_builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if web_pubsub_id is not None:
            pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]:
        """
        A `private_endpoint` block as defined below.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAclPrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['NetworkAclPublicNetworkArgs']]:
        """
        A `public_network` block as defined below.
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['NetworkAclPublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @_builtins.property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_pubsub_id", value)


@pulumi.type_token("azure:webpubsub/networkAcl:NetworkAcl")
class NetworkAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]]] = None,
                 public_network: Optional[pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']]] = None,
                 web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Network ACL for a Web Pubsub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.5.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.2.0/24"],
            enforce_private_link_endpoint_network_policies=True)
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-privateendpoint",
            resource_group_name=example.name,
            location=example.location,
            subnet_id=example_subnet.id,
            private_service_connection={
                "name": "psc-sig-test",
                "is_manual_connection": False,
                "private_connection_resource_id": example_service.id,
                "subresource_names": ["webpubsub"],
            })
        example_network_acl = azure.webpubsub.NetworkAcl("example",
            web_pubsub_id=example_service.id,
            default_action="Allow",
            public_network={
                "denied_request_types": ["ClientConnection"],
            },
            private_endpoints=[{
                "id": example_endpoint.id,
                "denied_request_types": [
                    "RESTAPI",
                    "ClientConnection",
                ],
            }],
            opts = pulumi.ResourceOptions(depends_on=[example_endpoint]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService` - 2024-03-01

        ## Import

        Network ACLs for a Web Pubsub service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/networkAcl:NetworkAcl example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webpubsub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]] private_endpoints: A `private_endpoint` block as defined below.
        :param pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']] public_network: A `public_network` block as defined below.
        :param pulumi.Input[_builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Network ACL for a Web Pubsub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.5.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.2.0/24"],
            enforce_private_link_endpoint_network_policies=True)
        example_endpoint = azure.privatelink.Endpoint("example",
            name="example-privateendpoint",
            resource_group_name=example.name,
            location=example.location,
            subnet_id=example_subnet.id,
            private_service_connection={
                "name": "psc-sig-test",
                "is_manual_connection": False,
                "private_connection_resource_id": example_service.id,
                "subresource_names": ["webpubsub"],
            })
        example_network_acl = azure.webpubsub.NetworkAcl("example",
            web_pubsub_id=example_service.id,
            default_action="Allow",
            public_network={
                "denied_request_types": ["ClientConnection"],
            },
            private_endpoints=[{
                "id": example_endpoint.id,
                "denied_request_types": [
                    "RESTAPI",
                    "ClientConnection",
                ],
            }],
            opts = pulumi.ResourceOptions(depends_on=[example_endpoint]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService` - 2024-03-01

        ## Import

        Network ACLs for a Web Pubsub service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/networkAcl:NetworkAcl example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webpubsub1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]]] = None,
                 public_network: Optional[pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']]] = None,
                 web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclArgs.__new__(NetworkAclArgs)

            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["private_endpoints"] = private_endpoints
            if public_network is None and not opts.urn:
                raise TypeError("Missing required property 'public_network'")
            __props__.__dict__["public_network"] = public_network
            if web_pubsub_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_pubsub_id'")
            __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        super(NetworkAcl, __self__).__init__(
            'azure:webpubsub/networkAcl:NetworkAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_action: Optional[pulumi.Input[_builtins.str]] = None,
            private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]]] = None,
            public_network: Optional[pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']]] = None,
            web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkAcl':
        """
        Get an existing NetworkAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_action: The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAclPrivateEndpointArgs', 'NetworkAclPrivateEndpointArgsDict']]]] private_endpoints: A `private_endpoint` block as defined below.
        :param pulumi.Input[Union['NetworkAclPublicNetworkArgs', 'NetworkAclPublicNetworkArgsDict']] public_network: A `public_network` block as defined below.
        :param pulumi.Input[_builtins.str] web_pubsub_id: The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclState.__new__(_NetworkAclState)

        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["private_endpoints"] = private_endpoints
        __props__.__dict__["public_network"] = public_network
        __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        return NetworkAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default action to control the network access when no other rule matches. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAclPrivateEndpoint']]]:
        """
        A `private_endpoint` block as defined below.
        """
        return pulumi.get(self, "private_endpoints")

    @_builtins.property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Output['outputs.NetworkAclPublicNetwork']:
        """
        A `public_network` block as defined below.
        """
        return pulumi.get(self, "public_network")

    @_builtins.property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Web Pubsub service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

