# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SharedPrivateLinkResourceArgs', 'SharedPrivateLinkResource']

@pulumi.input_type
class SharedPrivateLinkResourceArgs:
    def __init__(__self__, *,
                 subresource_name: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 web_pubsub_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SharedPrivateLinkResource resource.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.
               
               > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        :param pulumi.Input[_builtins.str] web_pubsub_id: Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        pulumi.set(__self__, "subresource_name", subresource_name)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.

        > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        """
        return pulumi.get(self, "subresource_name")

    @subresource_name.setter
    def subresource_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subresource_name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.

        > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_pubsub_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)


@pulumi.input_type
class _SharedPrivateLinkResourceState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SharedPrivateLinkResource resources.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        :param pulumi.Input[_builtins.str] status: The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.
               
               > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        :param pulumi.Input[_builtins.str] web_pubsub_id: Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subresource_name is not None:
            pulumi.set(__self__, "subresource_name", subresource_name)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if web_pubsub_id is not None:
            pulumi.set(__self__, "web_pubsub_id", web_pubsub_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.

        > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        """
        return pulumi.get(self, "subresource_name")

    @subresource_name.setter
    def subresource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subresource_name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.

        > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

    @web_pubsub_id.setter
    def web_pubsub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_pubsub_id", value)


@pulumi.type_token("azure:webpubsub/sharedPrivateLinkResource:SharedPrivateLinkResource")
class SharedPrivateLinkResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Shared Private Link Resource for a Web Pubsub service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": ["managecontacts"],
                "key_permissions": ["create"],
                "secret_permissions": ["set"],
            }])
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1)
        example_shared_private_link_resource = azure.webpubsub.SharedPrivateLinkResource("example",
            name="tfex-webpubsub-splr",
            web_pubsub_id=example_service.id,
            subresource_name="vault",
            target_resource_id=example_key_vault.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService` - 2024-03-01

        ## Import

        Web Pubsub Shared Private Link Resource can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/sharedPrivateLinkResource:SharedPrivateLinkResource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webPubSub1/sharedPrivateLinkResources/resource1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.
               
               > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        :param pulumi.Input[_builtins.str] web_pubsub_id: Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedPrivateLinkResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Shared Private Link Resource for a Web Pubsub service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="terraform-webpubsub",
            location="east us")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": ["managecontacts"],
                "key_permissions": ["create"],
                "secret_permissions": ["set"],
            }])
        example_service = azure.webpubsub.Service("example",
            name="tfex-webpubsub",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_S1",
            capacity=1)
        example_shared_private_link_resource = azure.webpubsub.SharedPrivateLinkResource("example",
            name="tfex-webpubsub-splr",
            web_pubsub_id=example_service.id,
            subresource_name="vault",
            target_resource_id=example_key_vault.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService` - 2024-03-01

        ## Import

        Web Pubsub Shared Private Link Resource can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/sharedPrivateLinkResource:SharedPrivateLinkResource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/webPubSub1/sharedPrivateLinkResources/resource1
        ```

        :param str resource_name: The name of the resource.
        :param SharedPrivateLinkResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedPrivateLinkResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedPrivateLinkResourceArgs.__new__(SharedPrivateLinkResourceArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["request_message"] = request_message
            if subresource_name is None and not opts.urn:
                raise TypeError("Missing required property 'subresource_name'")
            __props__.__dict__["subresource_name"] = subresource_name
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            if web_pubsub_id is None and not opts.urn:
                raise TypeError("Missing required property 'web_pubsub_id'")
            __props__.__dict__["web_pubsub_id"] = web_pubsub_id
            __props__.__dict__["status"] = None
        super(SharedPrivateLinkResource, __self__).__init__(
            'azure:webpubsub/sharedPrivateLinkResource:SharedPrivateLinkResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            request_message: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subresource_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            web_pubsub_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SharedPrivateLinkResource':
        """
        Get an existing SharedPrivateLinkResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] request_message: Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        :param pulumi.Input[_builtins.str] status: The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        :param pulumi.Input[_builtins.str] subresource_name: Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.
               
               > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        :param pulumi.Input[_builtins.str] target_resource_id: Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        :param pulumi.Input[_builtins.str] web_pubsub_id: Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedPrivateLinkResourceState.__new__(_SharedPrivateLinkResourceState)

        __props__.__dict__["name"] = name
        __props__.__dict__["request_message"] = request_message
        __props__.__dict__["status"] = status
        __props__.__dict__["subresource_name"] = subresource_name
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["web_pubsub_id"] = web_pubsub_id
        return SharedPrivateLinkResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the name of the Web Pubsub Shared Private Link Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the request message for requesting approval of the Shared Private Link Enabled Remote Resource.
        """
        return pulumi.get(self, "request_message")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of a private endpoint connection. Possible values are Pending, Approved, Rejected or Disconnected.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the sub resource name which the Web Pubsub Private Endpoint is able to connect to. Changing this forces a new resource to be created.

        > **Note:** The available sub resource can be retrieved by using `webpubsub_get_private_link_resource` data source.
        """
        return pulumi.get(self, "subresource_name")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the ID of the Shared Private Link Enabled Remote Resource which this Web Pubsub Private Endpoint should be connected to. Changing this forces a new resource to be created.

        > **Note:** The sub resource name should match with the type of the target resource id that's being specified.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="webPubsubId")
    def web_pubsub_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the id of the Web Pubsub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "web_pubsub_id")

