# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SocketioArgs', 'Socketio']

@pulumi.input_type
class SocketioArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['SocketioSkuArgs'],
                 aad_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['SocketioIdentityArgs']] = None,
                 live_trace_connectivity_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_http_request_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_messaging_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 service_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Socketio resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input['SocketioSkuArgs'] sku: The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        :param pulumi.Input[_builtins.bool] aad_auth_enabled: Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        :param pulumi.Input['SocketioIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] live_trace_connectivity_logs_enabled: Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_enabled: Whether the live trace tool is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_http_request_logs_enabled: Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_messaging_logs_enabled: Whether the messaging log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication using an access key is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        :param pulumi.Input[_builtins.str] service_mode: The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Web PubSub Service.
        :param pulumi.Input[_builtins.bool] tls_client_cert_enabled: Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if live_trace_connectivity_logs_enabled is not None:
            pulumi.set(__self__, "live_trace_connectivity_logs_enabled", live_trace_connectivity_logs_enabled)
        if live_trace_enabled is not None:
            pulumi.set(__self__, "live_trace_enabled", live_trace_enabled)
        if live_trace_http_request_logs_enabled is not None:
            pulumi.set(__self__, "live_trace_http_request_logs_enabled", live_trace_http_request_logs_enabled)
        if live_trace_messaging_logs_enabled is not None:
            pulumi.set(__self__, "live_trace_messaging_logs_enabled", live_trace_messaging_logs_enabled)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if service_mode is not None:
            pulumi.set(__self__, "service_mode", service_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_client_cert_enabled is not None:
            pulumi.set(__self__, "tls_client_cert_enabled", tls_client_cert_enabled)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['SocketioSkuArgs']:
        """
        The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['SocketioSkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @aad_auth_enabled.setter
    def aad_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "aad_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['SocketioIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['SocketioIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceConnectivityLogsEnabled")
    def live_trace_connectivity_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_connectivity_logs_enabled")

    @live_trace_connectivity_logs_enabled.setter
    def live_trace_connectivity_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_connectivity_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceEnabled")
    def live_trace_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the live trace tool is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_enabled")

    @live_trace_enabled.setter
    def live_trace_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_enabled", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceHttpRequestLogsEnabled")
    def live_trace_http_request_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_http_request_logs_enabled")

    @live_trace_http_request_logs_enabled.setter
    def live_trace_http_request_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_http_request_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceMessagingLogsEnabled")
    def live_trace_messaging_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the messaging log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_messaging_logs_enabled")

    @live_trace_messaging_logs_enabled.setter
    def live_trace_messaging_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_messaging_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication using an access key is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.

        > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="serviceMode")
    def service_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        """
        return pulumi.get(self, "service_mode")

    @service_mode.setter
    def service_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Web PubSub Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.

        > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @tls_client_cert_enabled.setter
    def tls_client_cert_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_client_cert_enabled", value)


@pulumi.input_type
class _SocketioState:
    def __init__(__self__, *,
                 aad_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['SocketioIdentityArgs']] = None,
                 live_trace_connectivity_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_http_request_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_messaging_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 public_port: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 server_port: Optional[pulumi.Input[_builtins.int]] = None,
                 service_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input['SocketioSkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Socketio resources.
        :param pulumi.Input[_builtins.bool] aad_auth_enabled: Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] external_ip: The publicly accessible IP address of the Web PubSub Service.
        :param pulumi.Input[_builtins.str] hostname: The FQDN of the Web PubSub Service.
        :param pulumi.Input['SocketioIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] live_trace_connectivity_logs_enabled: Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_enabled: Whether the live trace tool is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_http_request_logs_enabled: Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_messaging_logs_enabled: Whether the messaging log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication using an access key is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] primary_access_key: The primary access key for the Web PubSub Service.
        :param pulumi.Input[_builtins.str] primary_connection_string: The primary connection string for the Web PubSub Service.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        :param pulumi.Input[_builtins.int] public_port: The publicly accessible port for client-side usage of the Web PubSub Service.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The secondary access key for the Web PubSub Service.
        :param pulumi.Input[_builtins.str] secondary_connection_string: The secondary connection string for the Web PubSub Service.
        :param pulumi.Input[_builtins.int] server_port: The publicly accessible port for server-side usage of the Web PubSub Service.
        :param pulumi.Input[_builtins.str] service_mode: The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        :param pulumi.Input['SocketioSkuArgs'] sku: The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Web PubSub Service.
        :param pulumi.Input[_builtins.bool] tls_client_cert_enabled: Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if external_ip is not None:
            pulumi.set(__self__, "external_ip", external_ip)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if live_trace_connectivity_logs_enabled is not None:
            pulumi.set(__self__, "live_trace_connectivity_logs_enabled", live_trace_connectivity_logs_enabled)
        if live_trace_enabled is not None:
            pulumi.set(__self__, "live_trace_enabled", live_trace_enabled)
        if live_trace_http_request_logs_enabled is not None:
            pulumi.set(__self__, "live_trace_http_request_logs_enabled", live_trace_http_request_logs_enabled)
        if live_trace_messaging_logs_enabled is not None:
            pulumi.set(__self__, "live_trace_messaging_logs_enabled", live_trace_messaging_logs_enabled)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)
        if service_mode is not None:
            pulumi.set(__self__, "service_mode", service_mode)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_client_cert_enabled is not None:
            pulumi.set(__self__, "tls_client_cert_enabled", tls_client_cert_enabled)

    @_builtins.property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @aad_auth_enabled.setter
    def aad_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "aad_auth_enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The publicly accessible IP address of the Web PubSub Service.
        """
        return pulumi.get(self, "external_ip")

    @external_ip.setter
    def external_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_ip", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the Web PubSub Service.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['SocketioIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['SocketioIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceConnectivityLogsEnabled")
    def live_trace_connectivity_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_connectivity_logs_enabled")

    @live_trace_connectivity_logs_enabled.setter
    def live_trace_connectivity_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_connectivity_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceEnabled")
    def live_trace_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the live trace tool is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_enabled")

    @live_trace_enabled.setter
    def live_trace_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_enabled", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceHttpRequestLogsEnabled")
    def live_trace_http_request_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_http_request_logs_enabled")

    @live_trace_http_request_logs_enabled.setter
    def live_trace_http_request_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_http_request_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="liveTraceMessagingLogsEnabled")
    def live_trace_messaging_logs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the messaging log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_messaging_logs_enabled")

    @live_trace_messaging_logs_enabled.setter
    def live_trace_messaging_logs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "live_trace_messaging_logs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication using an access key is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary access key for the Web PubSub Service.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary connection string for the Web PubSub Service.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.

        > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The publicly accessible port for client-side usage of the Web PubSub Service.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_port", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary access key for the Web PubSub Service.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary connection string for the Web PubSub Service.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The publicly accessible port for server-side usage of the Web PubSub Service.
        """
        return pulumi.get(self, "server_port")

    @server_port.setter
    def server_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "server_port", value)

    @_builtins.property
    @pulumi.getter(name="serviceMode")
    def service_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        """
        return pulumi.get(self, "service_mode")

    @service_mode.setter
    def service_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_mode", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['SocketioSkuArgs']]:
        """
        The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['SocketioSkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Web PubSub Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.

        > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

    @tls_client_cert_enabled.setter
    def tls_client_cert_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_client_cert_enabled", value)


@pulumi.type_token("azure:webpubsub/socketio:Socketio")
class Socketio(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['SocketioIdentityArgs', 'SocketioIdentityArgsDict']]] = None,
                 live_trace_connectivity_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_http_request_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_messaging_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['SocketioSkuArgs', 'SocketioSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Web PubSub Service for Socket.IO.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_socketio = azure.webpubsub.Socketio("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Free_F1"[0])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService` - 2024-03-01

        ## Import

        Web PubSub Service for Socket.IOs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/socketio:Socketio example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/pubsub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] aad_auth_enabled: Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        :param pulumi.Input[Union['SocketioIdentityArgs', 'SocketioIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] live_trace_connectivity_logs_enabled: Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_enabled: Whether the live trace tool is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_http_request_logs_enabled: Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_messaging_logs_enabled: Whether the messaging log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication using an access key is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] service_mode: The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        :param pulumi.Input[Union['SocketioSkuArgs', 'SocketioSkuArgsDict']] sku: The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Web PubSub Service.
        :param pulumi.Input[_builtins.bool] tls_client_cert_enabled: Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SocketioArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Web PubSub Service for Socket.IO.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_socketio = azure.webpubsub.Socketio("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Free_F1"[0])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService` - 2024-03-01

        ## Import

        Web PubSub Service for Socket.IOs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:webpubsub/socketio:Socketio example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/webPubSub/pubsub1
        ```

        :param str resource_name: The name of the resource.
        :param SocketioArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SocketioArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aad_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['SocketioIdentityArgs', 'SocketioIdentityArgsDict']]] = None,
                 live_trace_connectivity_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_http_request_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 live_trace_messaging_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['SocketioSkuArgs', 'SocketioSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_client_cert_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SocketioArgs.__new__(SocketioArgs)

            __props__.__dict__["aad_auth_enabled"] = aad_auth_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["live_trace_connectivity_logs_enabled"] = live_trace_connectivity_logs_enabled
            __props__.__dict__["live_trace_enabled"] = live_trace_enabled
            __props__.__dict__["live_trace_http_request_logs_enabled"] = live_trace_http_request_logs_enabled
            __props__.__dict__["live_trace_messaging_logs_enabled"] = live_trace_messaging_logs_enabled
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_mode"] = service_mode
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_client_cert_enabled"] = tls_client_cert_enabled
            __props__.__dict__["external_ip"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["public_port"] = None
            __props__.__dict__["secondary_access_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["server_port"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "primaryConnectionString", "secondaryAccessKey", "secondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Socketio, __self__).__init__(
            'azure:webpubsub/socketio:Socketio',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aad_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            external_ip: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['SocketioIdentityArgs', 'SocketioIdentityArgsDict']]] = None,
            live_trace_connectivity_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            live_trace_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            live_trace_http_request_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            live_trace_messaging_logs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            public_port: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            server_port: Optional[pulumi.Input[_builtins.int]] = None,
            service_mode: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['SocketioSkuArgs', 'SocketioSkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tls_client_cert_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Socketio':
        """
        Get an existing Socketio resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] aad_auth_enabled: Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] external_ip: The publicly accessible IP address of the Web PubSub Service.
        :param pulumi.Input[_builtins.str] hostname: The FQDN of the Web PubSub Service.
        :param pulumi.Input[Union['SocketioIdentityArgs', 'SocketioIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] live_trace_connectivity_logs_enabled: Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_enabled: Whether the live trace tool is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_http_request_logs_enabled: Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] live_trace_messaging_logs_enabled: Whether the messaging log category for live trace is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication using an access key is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] primary_access_key: The primary access key for the Web PubSub Service.
        :param pulumi.Input[_builtins.str] primary_connection_string: The primary connection string for the Web PubSub Service.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        :param pulumi.Input[_builtins.int] public_port: The publicly accessible port for client-side usage of the Web PubSub Service.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The secondary access key for the Web PubSub Service.
        :param pulumi.Input[_builtins.str] secondary_connection_string: The secondary connection string for the Web PubSub Service.
        :param pulumi.Input[_builtins.int] server_port: The publicly accessible port for server-side usage of the Web PubSub Service.
        :param pulumi.Input[_builtins.str] service_mode: The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        :param pulumi.Input[Union['SocketioSkuArgs', 'SocketioSkuArgsDict']] sku: The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Web PubSub Service.
        :param pulumi.Input[_builtins.bool] tls_client_cert_enabled: Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.
               
               > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SocketioState.__new__(_SocketioState)

        __props__.__dict__["aad_auth_enabled"] = aad_auth_enabled
        __props__.__dict__["external_ip"] = external_ip
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["identity"] = identity
        __props__.__dict__["live_trace_connectivity_logs_enabled"] = live_trace_connectivity_logs_enabled
        __props__.__dict__["live_trace_enabled"] = live_trace_enabled
        __props__.__dict__["live_trace_http_request_logs_enabled"] = live_trace_http_request_logs_enabled
        __props__.__dict__["live_trace_messaging_logs_enabled"] = live_trace_messaging_logs_enabled
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["public_port"] = public_port
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["server_port"] = server_port
        __props__.__dict__["service_mode"] = service_mode
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_client_cert_enabled"] = tls_client_cert_enabled
        return Socketio(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Azure Active Directory authentication is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @_builtins.property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The publicly accessible IP address of the Web PubSub Service.
        """
        return pulumi.get(self, "external_ip")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the Web PubSub Service.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.SocketioIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="liveTraceConnectivityLogsEnabled")
    def live_trace_connectivity_logs_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the connectivity log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_connectivity_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="liveTraceEnabled")
    def live_trace_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the live trace tool is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_enabled")

    @_builtins.property
    @pulumi.getter(name="liveTraceHttpRequestLogsEnabled")
    def live_trace_http_request_logs_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the HTTP request log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_http_request_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="liveTraceMessagingLogsEnabled")
    def live_trace_messaging_logs_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the messaging log category for live trace is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "live_trace_messaging_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether local authentication using an access key is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The primary access key for the Web PubSub Service.
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The primary connection string for the Web PubSub Service.
        """
        return pulumi.get(self, "primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether public network access is enabled. Defaults to `Enabled`. Possible values are `Enabled` and `Disabled`.

        > **Note:** `public_network_access` cannot be set to `Disabled` when `sku` is `Free_F1`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> pulumi.Output[_builtins.int]:
        """
        The publicly accessible port for client-side usage of the Web PubSub Service.
        """
        return pulumi.get(self, "public_port")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Web PubSub Service should exist. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary access key for the Web PubSub Service.
        """
        return pulumi.get(self, "secondary_access_key")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary connection string for the Web PubSub Service.
        """
        return pulumi.get(self, "secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> pulumi.Output[_builtins.int]:
        """
        The publicly accessible port for server-side usage of the Web PubSub Service.
        """
        return pulumi.get(self, "server_port")

    @_builtins.property
    @pulumi.getter(name="serviceMode")
    def service_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service mode of this Web PubSub Service. Defaults to `Default`. Possible values are `Default` and `Serverless`.
        """
        return pulumi.get(self, "service_mode")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.SocketioSku']:
        """
        The SKU to use for this Web PubSub Service. Possible values are `Free_F1`, `Standard_S1`, `Premium_P1`, and `Premium_P2`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Web PubSub Service.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tlsClientCertEnabled")
    def tls_client_cert_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the service should request a client certificate during a TLS handshake. Defaults to `false`.

        > **Note:** `tls_client_cert_enabled` cannot be set to `true` when `sku` is `Free_F1`.
        """
        return pulumi.get(self, "tls_client_cert_enabled")

