## Contributing

Truss was first created at [Baseten](https://baseten.co), but as an open and living project eagerly accepts contributions of all kinds from the broader developer community. Please note that all participation with Truss falls under our [code of conduct](CODE_OF_CONDUCT.md).

We use GitHub features for project management on Truss:

* For bugs and feature requests, [file an issue](https://github.com/basetenlabs/truss/issues).
* For changes and updates, create a [pull request](https://github.com/basetenlabs/truss/pulls).
* To view and comment on the roadmap, [check the projects tab](https://github.com/orgs/basetenlabs/projects/3).

## Local development

To get started contributing to the library, all you have to do is clone this repository!

### Setup

**PLEASE NOTE:** the ML ecosystem in general is still not well supported on M1 Macs, and as such, we do not recommend or support local development on M1 for Truss. Truss is well-optimized for use with GitHub Codespaces and other container-based development environments.

We use `asdf` to manage Python binaries and `poetry` to manage Python dependencies.

For development in a macOS environment, we use `brew` to manage system packages.

```bash
# Install asdf (or use another method https://asdf-vm.com/)
brew install asdf

# Install `asdf` managed python and poetry
asdf plugin add python
asdf plugin add poetry
asdf install

# Install poetry dependencies
poetry install --with=dev,dev-server --extras=all

# And finally precommit
poetry run pre-commit install
```

Then to run the entire test suite

```bash
poetry run pytest truss/tests
```

## Documentation

To learn about Truss see the [official documentation](https://truss.baseten.co).

Contributions to documentation are very welcome! Simply edit the appropriate markdown files in the `docs/` folder and make a pull request. For larger changes, tutorials, or any questions please contact [team@trussml.com](mailto:team@trussml.com).
