---
title: Caching Implementation
---

## BaseCache (lightapi.cache.BaseCache)

Interface for caching backends:

- `get(key: str) -> Optional[Dict]`: Retrieve a value or `None`.
- `set(key: str, value: Dict, timeout: int = 300) -> bool`: Store a value with optional expiration.

## RedisCache (lightapi.cache.RedisCache)

Redis-based cache implementation:

```python
from lightapi.cache import RedisCache

cache = RedisCache(host='localhost', port=6379, db=0)
cache.set('foo', {'bar': 1}, timeout=300)
value = cache.get('foo')  # {'bar': 1}
```

### Key Generation

Redis keys are generated by hashing the provided key string with MD5 and prefixing with `lightapi:`.

### Error Handling

`RedisCache.get` returns `None` on missing or decode errors.
`RedisCache.set` returns `False` if serialization or Redis errors occur.
