# 使用 echarts 的基本图表
def chart_html(option):
    s = ['<!DOCTYPE html>',
         '<html lang="zh-CN" style="height: 100%">',
         '<head>',
         '    <meta charset="utf-8">',
         '</head>',
         '<body style="height: 100%; margin: 0">',
         '<div id="container" style="height: 100%"></div>',
         '<script type="text/javascript" src="https://fastly.jsdelivr.net/npm/echarts@5.4.2/dist/echarts.min.js"></script>',
         '<script type="text/javascript">',
         '    var dom = document.getElementById("container");',
         '    var myChart = echarts.init(dom, null, {',
         '        renderer: "canvas",',
         '        useDirtyRect: false,',
         '    });',
         '    var app = {};',
         '    var option = -option-;',
         '    if (option && typeof option === "object") {',
         '        myChart.setOption(option);',
         '    }',
         '    window.addEventListener("resize", myChart.resize);',
         '</script>',
         '</body>',
         '</html>',
         '']
    return list(map(lambda x: x.replace('-option-', '\n    '.join(option)), s))


# 折线图的 html 模板代码
def line_stack_html():
    option = ['{',
              '    title: {',
              '        text: "-chart_name-",',
              '    },',
              '    tooltip: {',
              '        trigger: "axis",',
              '    },',
              '    dataZoom: [',
              '        {',
              '            show: true,',
              '            realtime: true,',
              '        },',
              '        {',
              '            type: "inside",',
              '            realtime: true,',
              '        },',
              '    ],',
              '    grid: {',
              '        left: "30px",',
              '        right: "40px",',
              '        bottom: "80px",',
              '        containLabel: true,',
              '    },',
              '    toolbox: {',
              '        feature: {',
              '            saveAsImage: {',
              '                pixelRatio: 5',
              '            },',
              '        },',
              '    },',
              '    yAxis: {',
              '        type: "value",',
              '    },',
              '    xAxis: {',
              '        type: "category",',
              '        boundaryGap: false,',
              '        data: -x_list-,',
              '    },',
              '    legend: {',
              '        -legend-,',
              '    },',
              '    series: -series-,',
              '}']
    return chart_html(option)


# 折线图的 html 模板代码
def line_area_html():
    option = ['{',
              '  tooltip: {',
              '    trigger: "axis",',
              '  },',
              '  title: {',
              '    text: "-chart_name-"',
              '  },',
              '  toolbox: {',
              '    feature: {',
              '       saveAsImage: {',
              '           pixelRatio: 5',
              '       },',
              '    }',
              '  },',
              '    grid: {',
              '        left: "30px",',
              '        right: "40px",',
              '        bottom: "80px",',
              '        containLabel: true,',
              '    },',
              '  xAxis: {',
              '    type: "category",',
              '    boundaryGap: false,',
              '    data: -x_list-',
              '  },',
              '  yAxis: {',
              '    type: "value",',
              '  },',
              '    dataZoom: [',
              '        {',
              '            show: true,',
              '            realtime: true,',
              '        },',
              '        {',
              '            type: "inside",',
              '            realtime: true,',
              '        },',
              '    ],',
              '  series: [',
              '    {',
              '      type: "line",',
              '      symbol: "none",',
              '      smooth: -smooth-,',
              '      sampling: "lttb",',
              '      itemStyle: {',
              '        color: "rgb(255, 70, 131)"',
              '      },',
              '      areaStyle: {',
              '        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [',
              '          {',
              '            offset: 0,',
              '            color: "rgb(255, 158, 68)"',
              '          },',
              '          {',
              '            offset: 1,',
              '            color: "rgb(255, 70, 131)"',
              '          }',
              '        ])',
              '      },',
              '      data: -y_list-',
              '    }',
              '  ]',
              '}']
    return chart_html(option)


# 饼图的 html 模板代码
def pie_html():
    option = ['{',
              '  title: {',
              '    text: "-chart_name-",',
              '    left: 10',
              '  },',
              '  tooltip: {',
              '    trigger: "item"',
              '  },',
              '    toolbox: {',
              '        feature: {',
              '            saveAsImage: {',
              '                pixelRatio: 5',
              '            },',
              '        },',
              '    },',
              '  legend: {',
              '    top: "5%",',
              '    left: "center"',
              '  },',
              '  series: [',
              '    {',
              '      name: "-chart_name-",',
              '      type: "pie",',
              '      radius: ["30%", "70%"],',
              '      itemStyle: {',
              '        borderRadius: 10,',
              '        borderColor: "#fff",',
              '        borderWidth: 1',
              '      },',
              '      emphasis: {',
              '        label: {',
              '          show: true,',
              '          fontSize: 30,',
              '          fontWeight: "bold"',
              '        }',
              '      },',
              '      labelLine: {',
              '        show: true',
              '      },',
              '      data: -x_list-',
              '    }',
              '  ]',
              '}']
    return chart_html(option)


# 柱状的 html 模板代码
def bar_html():
    option = ['{',
              '  title: {',
              '    text: "-chart_name-",',
              '    left: 10',
              '  },',
              '  toolbox: {',
              '    feature: {',
              '      dataZoom: {',
              '        yAxisIndex: false',
              '      },',
              '      saveAsImage: {',
              '            saveAsImage: {',
              '                pixelRatio: 5',
              '            },',
              '      }',
              '    }',
              '  },',
              '  tooltip: {',
              '    trigger: "axis",',
              '    axisPointer: {',
              '      type: "shadow"',
              '    }',
              '  },',
              '    grid: {',
              '        left: "30px",',
              '        right: "40px",',
              '        bottom: "80px",',
              '        containLabel: true,',
              '    },',
              '  dataZoom: [',
              '    {',
              '      type: "inside"',
              '    },',
              '    {',
              '      type: "slider"',
              '    }',
              '  ],',
              '  xAxis: {',
              '    data: -x_list-,',
              '    silent: false,',
              '    splitLine: {',
              '      show: false',
              '    },',
              '    splitArea: {',
              '      show: false',
              '    }',
              '  },',
              '  yAxis: {',
              '    splitArea: {',
              '      show: false',
              '    }',
              '  },',
              '  series: [',
              '    {',
              '      type: "bar",',
              '      data: -y_list-,',
              '      large: true',
              '    }',
              '  ]',
              '}']
    return chart_html(option)
