use std::fs;
use std::process::Command;

use tempfile::tempdir;

fn run(cmd: &mut Command) -> (i32, String, String) {
    let out = cmd.output().expect("failed to run helper");
    let code = out.status.code().unwrap_or(-1);
    let stdout = String::from_utf8_lossy(&out.stdout).into_owned();
    let stderr = String::from_utf8_lossy(&out.stderr).into_owned();
    (code, stdout, stderr)
}

#[test]
fn dc_error_on_user_global_config_dir() {
    let td = tempdir().unwrap();
    let xdg = td.path().join("xdg").join("yamllint");
    fs::create_dir_all(xdg.join("config")).unwrap(); // create directory where file is expected

    let exe = env!("CARGO_BIN_EXE_discover_config_bin");
    let (code, _out, err) = run(Command::new(exe)
        .env("XDG_CONFIG_HOME", td.path().join("xdg"))
        .current_dir(td.path()));
    assert_eq!(code, 2, "expected exit 2: {err}");
    assert!(err.contains("failed to read"));
}
