from contextlib import asynccontextmanager
from importlib.metadata import version


def is_openai_v1():
    return version("openai") >= "1.0.0"


def _with_tracer_wrapper(func):
    def _with_tracer(tracer, guard):
        def wrapper(wrapped, instance, args, kwargs):
            return func(tracer, guard, wrapped, instance, args, kwargs)

        return wrapper

    return _with_tracer


@asynccontextmanager
async def start_as_current_span_async(tracer, *args, **kwargs):
    with tracer.start_as_current_span(*args, **kwargs) as span:
        yield span
