"""
Defines ``FIPS_TO_STATE``, ``STATE_ABBR``, ``OFFICE_NAMES`` and ``PARTY_NAMES``
look-up constants.
"""
FIPS_TO_STATE = {
    'CT': {
        '09001': 'FAIRFIELD',
        '09003': 'HARTFORD',
        '09005': 'LITCHFIELD',
        '09007': 'MIDDLESEX',
        '09009': 'NEW HAVEN',
        '09011': 'NEW LONDON',
        '09013': 'TOLLAND',
        '09015': 'WINDHAM'
    },
    'ME': {
        '23001': 'ANDROSCOGGIN',
        '23003': 'AROOSTOOK',
        '23005': 'CUMBERLAND',
        '23007': 'FRANKLIN',
        '23009': 'HANCOCK',
        '23011': 'KENNEBEC',
        '23013': 'KNOX',
        '23015': 'LINCOLN',
        '23017': 'OXFORD',
        '23019': 'PENOBSCOT',
        '23021': 'PISCATAQUIS',
        '23023': 'SAGADAHOC',
        '23025': 'SOMERSET',
        '23027': 'WALDO',
        '23029': 'WASHINGTON',
        '23031': 'YORK'
    },
    'MA': {
        '25001': 'BARNSTABLE',
        '25003': 'BERKSHIRE',
        '25005': 'BRISTOL',
        '25007': 'DUKES',
        '25009': 'ESSEX',
        '25011': 'FRANKLIN',
        '25013': 'HAMPDEN',
        '25015': 'HAMPSHIRE',
        '25017': 'MIDDLESEX',
        '25019': 'NANTUCKET',
        '25021': 'NORFOLK',
        '25023': 'PLYMOUTH',
        '25025': 'SUFFOLK',
        '25027': 'WORCESTER'
    },
    'NH': {
        '33001': 'BELKNAP',
        '33003': 'CARROLL',
        '33005': 'CHESHIRE',
        '33007': 'COOS',
        '33009': 'GRAFTON',
        '33011': 'HILLSBOROUGH',
        '33013': 'MERRIMACK',
        '33015': 'ROCKINGHAM',
        '33017': 'STRAFFORD',
        '33019': 'SULLIVAN'
    },
    'RH': {
        '44001': 'BRISTOL',
        '44003': 'KENT',
        '44005': 'NEWPORT',
        '44007': 'PROVIDENCE',
        '44009': 'WASHINGTON'
    },
    'VT': {
        '50001': 'ADDISON',
        '50003': 'BENNINGTON',
        '50005': 'CALEDONIA',
        '50007': 'CHITTENDEN',
        '50009': 'ESSEX',
        '50011': 'FRANKLIN',
        '50013': 'GRAND ISLE',
        '50015': 'LAMOILLE',
        '50017': 'ORANGE',
        '50019': 'ORLEANS',
        '50021': 'RUTLAND',
        '50023': 'WASHINGTON',
        '50025': 'WINDHAM',
        '50027': 'WINDSOR'
    }

}

STATE_ABBR = {
    'AL': 'Alabama',
    'AK': 'Alaska',
    'AS': 'America Samoa',
    'AZ': 'Arizona',
    'AR': 'Arkansas',
    'CA': 'California',
    'CO': 'Colorado',
    'CT': 'Connecticut',
    'DE': 'Delaware',
    'DC': 'District of Columbia',
    'FM': 'Micronesia1',
    'FL': 'Florida',
    'GA': 'Georgia',
    'GU': 'Guam',
    'HI': 'Hawaii',
    'ID': 'Idaho',
    'IL': 'Illinois',
    'IN': 'Indiana',
    'IA': 'Iowa',
    'KS': 'Kansas',
    'KY': 'Kentucky',
    'LA': 'Louisiana',
    'ME': 'Maine',
    'MH': 'Islands1',
    'MD': 'Maryland',
    'MA': 'Massachusetts',
    'MI': 'Michigan',
    'MN': 'Minnesota',
    'MS': 'Mississippi',
    'MO': 'Missouri',
    'MT': 'Montana',
    'NE': 'Nebraska',
    'NV': 'Nevada',
    'NH': 'New Hampshire',
    'NJ': 'New Jersey',
    'NM': 'New Mexico',
    'NY': 'New York',
    'NC': 'North Carolina',
    'ND': 'North Dakota',
    'OH': 'Ohio',
    'OK': 'Oklahoma',
    'OR': 'Oregon',
    'PW': 'Palau',
    'PA': 'Pennsylvania',
    'PR': 'Puerto Rico',
    'RI': 'Rhode Island',
    'SC': 'South Carolina',
    'SD': 'South Dakota',
    'TN': 'Tennessee',
    'TX': 'Texas',
    'UT': 'Utah',
    'VT': 'Vermont',
    'VI': 'Virgin Island',
    'VA': 'Virginia',
    'WA': 'Washington',
    'WV': 'West Virginia',
    'WI': 'Wisconsin',
    'WY': 'Wyoming'
}

OFFICE_NAMES = {
    'A': 'Attorney General',
    'C': 'Controller or Comptroller',
    'D': 'District Attorney',
    'E': 'Education Commissioner or Supt Public Instruction',
    'J': 'Insurance Commissioner',
    'L': 'Lieutenant Governor',
    'M': 'Mayor',
    'N': 'City Council',
    'R': 'Secretary of State',
    'T': 'Treasurer',
    'G': 'Governor',
    'H': 'U.S. House',
    'I': 'Amendment, Ballot Measure, Initiative, Proposal, Proposition, \
Referendum or Question',
    'P': 'President',
    'S': 'U.S. Senate',
    'Y': 'State House, State Assembly, General Assembly or House of Delegates',
    'Z': 'State Senate'
}

PARTY_NAMES = {
    'ACP': 'A CONNECTICUT PARTY',
    'AFP': 'AMERICAN FREEDOM (FORMERLY ATP)',
    'AGN': 'AGAINST',
    'AHP': 'AMERICAN HERITAGE',
    'AIP': 'AMERICAN INDEPENDENT',
    'AKI': 'ALASKAN INDEPENDENCE',
    'AMC': 'AMERICAN CONSTITUTION',
    'AME': 'AMERICANS ELECT',
    'AMF': 'AMERICA FIRST',
    'AMI': 'AMERICAN INDIAN',
    'AMP': 'AMERICA\'S PARTY',
    'AMR': 'AMERICAN PARTY',
    'AMS': 'AMERICANS',
    'AO': 'ALL OTHERS',
    'ATP': 'AMERICAN THIRD POSITION (NOW AFP)',
    'BEP': 'BLUE ENIGMA PARTY',
    'BLD': 'BUILDERS PARTY',
    'BOT': 'Boston Tea',
    'BUC': 'BUCHANAN REFORM',
    'CAM': 'CONSTITUTIONAL AMERICANS',
    'CC': 'CONCERNED CITIZENS',
    'CEN': 'CENTRIST PARTY',
    'CF': 'CITIZENS FIRST',
    'CIP': 'CONNECTICUT INDEPENDENT PARTY',
    'CM': 'COOL MOOSE',
    'CMT': 'COMMUNIST',
    'CNL': 'CONSTITUTIONAL GOVERNMENT',
    'CNP': 'CONCERNS OF PEOPLE',
    'CON': 'CONSERVATIVE',
    'CRK': 'POLITICIANS ARE CROOKS',
    'CST': 'CONSTITUTION',
    'CTL': 'CT FOR LIEBERMAN',
    'DAS': 'DESCENDANTS OF AMERICAN SLAVES',
    'DCG': 'DC STATEHOOD GREEN',
    'DEM': 'DEMOCRAT',
    'EFP': 'EARTH FEDERATION',
    'EPF': 'ECOLOGY PARTY OF FL',
    'FAA': 'FAIR',
    'FDL': 'FAIR DEAL',
    'FEP': 'FREE ENERGY',
    'FOR': 'FOR',
    'FRE': 'FREEDOM',
    'FRU': 'FRIENDS UNITED',
    'FSB': 'FARMERS & SMALL BUSINESS',
    'FSO': 'FREEDOM SOCIALIST',
    'FVP': 'FAMILY VALUES PARTY',
    'GNW': 'GREENS NO TO WAR',
    'GOP': 'REPUBLICAN',
    'GRN': 'GREEN',
    'GRP': 'GRASS ROOTS',
    'HCP': 'HEALTHCARE PARTY',
    'HP': 'HOME PROTECTION',
    'HQ8': 'Heartquake \'08',
    'IAP': 'INDEPENDENT AMERICAN',
    'IF': 'INDEPENDENT FUSION',
    'IG': 'INDEPENDENT GRASSROOTS',
    'IGR': 'INDEPENDENT GREEN',
    'ILS': 'ILLINOIS SOLIDARITY',
    'IND': 'INDEPENDENT',
    'INP': 'INDEPENDENCE',
    'INR': 'INDEPENDENT REFORM',
    'INT': 'INTEGRITY PARTY',
    'IP': 'INDEPENDENT PARTY',
    'IPD': 'INDEPENDENT PARTY OF DE',
    'IPH': 'INDEPENDENT PARTY OF HAWAII',
    'ISC': 'INDEPENDENT SAVE OUR CHILDREN',
    'IX': 'ILLINOIS GREEN',
    'JP': 'JUSTICE PARTY',
    'JS': 'JESUS PARTY',
    'LBL': 'LIBERAL',
    'LBP': 'LOOKING BACK',
    'LEC': 'LIBERTY,COLOGY,OMMUNITY',
    'LFM': 'LABOR AND FARM',
    'LIB': 'LIBERTARIAN',
    'LMJ': 'LEGALIZE MARIJUANA',
    'LTP': 'LOUISIANA TAXPAYERS PARTY',
    'LUN': 'LIBERTY UNION',
    'LUP': 'LIBERTY UNION/PROGRESSIVE',
    'MDE': 'MODERATE DEMOCRAT',
    'MIP': 'MARYLAND INDEPENDENT PARTY',
    'MJP': 'MARIJUANA PARTY',
    'MML': 'MAKE MARIJUANA LEGAL',
    'MNT': 'MOUNTAIN PARTY',
    'MOD': 'MODERATE',
    'MRP': 'MARIJUANA REFORM',
    'NAL': 'NEW ALLIANCE',
    'NEB': 'NEBRASKA',
    'NEW': 'NEW',
    'NLP': 'NATURAL LAW',
    'NMI': 'NEW MEXICO INDEPENDENT PARTY',
    'NNT': 'NO NEW TAXES',
    'NO': 'NO',
    'NON': 'NONE OF THE ABOVE',
    'NP': 'NON PARTISAN',
    'NPA': 'NO PARTY AFFILIATION',
    'NPD': 'NO PARTY DESIGNATION',
    'OBJ': 'Objectivist',
    'ONE': 'ONE EARTH',
    'OTE': '128 DISTRICT',
    'OTH': 'OTHER',
    'PAC': 'PACIFIC',
    'PAG': 'PACIFIC GREEN',
    'PAT': 'PATRIOT PARTY',
    'PCF': 'Pacifist',
    'PCH': 'PERSONAL CHOICE',
    'PEC': 'PETITIONING CANDIDATE',
    'PFP': 'PEACE & FREEDOM',
    'PIP': 'PUERTO RICAN INDEPENDENCE (PR)',
    'PJP': 'PEACE AND JUSTICE PARTY',
    'PLC': 'PRO-LIFE CONSERVATIVE',
    'PLP': 'PROGRESSIVE LABOR PARTY',
    'PNP': 'NEW PROGRESSIVE (PUERTO RICO)',
    'POP': 'POPULIST',
    'PPD': 'POPULAR DEMOCRATIC (PUERTO RICO)',
    'PPO': 'PEACE PARTY OF OREGON',
    'PRG': 'PROGRESSIVE',
    'PRO': 'PROHIBITION',
    'PRT': 'PRESERVE OUR TOWN',
    'PSL': 'SOCIALISM & LIBERATION',
    'PTC': 'PROPERTY TAX CUT',
    'PWF': 'PROTECT WORKING FAMILIES',
    'RES': 'RESOURCE',
    'RFC': 'RANDOLPH FOR CONGRESS',
    'RJF': 'RESTORE JUSTICE-FREEDOM',
    'RM': 'REFORM MINNESOTA',
    'RP': 'REFORM',
    'RPM': 'REPUBLICAN MODERATE',
    'RTL': 'RIGHT TO LIFE',
    'SCC': 'SCHOOL CHOICE',
    'SCL': 'Socialism',
    'SEP': 'SOCIALIST EQUALITY',
    'SM': 'SAVE MEDICARE',
    'SOC': 'SOCIALIST',
    'SPU': 'SOCIALIST USA',
    'Sta': 'STATEHOOD PARTY',
    'SWP': 'SOCIALIST WORKERS',
    'TBD': 'TO BE DETERMINED',
    'TBL': 'THE BETTER LIFE',
    'TCN': 'TAX CUTS NOW',
    'TEA': 'TEA PARTY',
    'TLM': 'TERM LIMITS',
    'TS': 'TIMESIZING.COM PARTY',
    'UCZ': 'UNITED CITIZENS',
    'UNA': 'UNAFFILIATED',
    'UNI': 'UNITED INDEPENDENT',
    'UNP': 'UNITED PACIFISTS',
    'UNR': 'UNENROLLED',
    'UNT': 'UNITED PARTY',
    'UST': 'U.S. TAXPAYERS',
    'UTY': 'UNITY',
    'VET': 'VETERANS PARTY OF AMERICA',
    'WCP': 'WORKING CLASS',
    'WF': 'WORKING FAMILIES',
    'WLG': 'WORKER\'S LEAGUE',
    'WRI': 'WRITE - IN',
    'WSN': 'WEST SIDE NEIGHBORS',
    'WTP': 'WE THE PEOPLE',
    'WW': 'WORKERS WORLD',
    'WYC': 'WYOMING COUNTRY PARTY',
    'YES': 'YES'
}
