"""EidosUI - A modern, flexible Tailwind CSS-based UI library for Python web frameworks.

Quick start:
    >>> from eidos import *
    >>> DataTable.from_lists([["A", "B"], ["C", "D"]], headers=["Col1", "Col2"])

Or use explicit imports:
    >>> from eidos import DataTable, Button, H1, Table
    >>> from eidos import styles
"""

# Import all styled HTML tags
# Import style namespaces
from . import styles

# Import components
from .components import (
    DataTable,
    EidosHeaders,
    NavBar,
    ThemeSwitch,
)
from .styles import buttons, lists, tables, typography
from .tags import (
    # Headings
    H1,
    H2,
    H3,
    H4,
    H5,
    H6,
    # Pass-through HTML tags
    A,
    Abbr,
    Address,
    Area,
    Article,
    Aside,
    Audio,
    B,
    Base,
    Bdi,
    Bdo,
    Blockquote,
    # Body
    Body,
    Br,
    # Buttons
    Button,
    Canvas,
    Caption,
    # Form elements
    Checkbox,
    Cite,
    Code,
    Col,
    Colgroup,
    ColorPicker,
    Data,
    Datalist,
    DatePicker,
    Dd,
    Del,
    Details,
    Dfn,
    Dialog,
    Div,
    Dl,
    Dt,
    Em,
    EmailInput,
    Embed,
    Fieldset,
    Figcaption,
    Figure,
    FileInput,
    Footer,
    Form,
    FormError,
    FormHelp,
    Head,
    Header,
    Hgroup,
    Hr,
    Html,
    I,
    Iframe,
    Img,
    Input,
    Ins,
    Kbd,
    Label,
    Legend,
    Li,
    Link,
    Main,
    Map,
    Mark,
    Menu,
    Meta,
    Meter,
    Nav,
    Noscript,
    NumberInput,
    Object,
    Ol,
    Optgroup,
    Option,
    Output,
    P,
    Param,
    PasswordInput,
    Picture,
    Pre,
    Progress,
    Q,
    Radio,
    Rp,
    Rt,
    Ruby,
    S,
    Samp,
    Script,
    Search,
    SearchInput,
    Section,
    Select,
    Small,
    Source,
    Span,
    # Semantic typography
    Strong,
    Style,
    Sub,
    Summary,
    Sup,
    # Table elements
    Table,
    Tbody,
    Td,
    TelInput,
    Template,
    Textarea,
    Tfoot,
    Th,
    Thead,
    Time,
    TimePicker,
    Title,
    Tr,
    Track,
    U,
    Ul,
    UrlInput,
    Var,
    Video,
    Wbr,
)

# Version info
__version__ = "0.10.0"

# Define what's available with "from eidos import *"
__all__ = [
    # Version
    "__version__",
    # Style namespaces
    "styles",
    "buttons",
    "typography",
    "lists",
    "tables",
    # Components
    "DataTable",
    "NavBar",
    "EidosHeaders",
    "ThemeSwitch",
    # HTML Tags
    "H1",
    "H2",
    "H3",
    "H4",
    "H5",
    "H6",
    "Body",
    "Button",
    "Strong",
    "I",
    "Small",
    "Del",
    "Abbr",
    "Var",
    "Mark",
    "Time",
    "Code",
    "Pre",
    "Kbd",
    "Samp",
    "Blockquote",
    "Cite",
    "Address",
    "Hr",
    "Details",
    "Summary",
    "Dl",
    "Dt",
    "Dd",
    "Figure",
    "Figcaption",
    "Table",
    "Thead",
    "Tbody",
    "Tfoot",
    "Tr",
    "Th",
    "Td",
    "A",
    "Area",
    "Article",
    "Aside",
    "Audio",
    "B",
    "Base",
    "Bdi",
    "Bdo",
    "Br",
    "Canvas",
    "Caption",
    "Col",
    "Colgroup",
    "Data",
    "Datalist",
    "Dfn",
    "Dialog",
    "Div",
    "Em",
    "Embed",
    "Fieldset",
    "Footer",
    "Form",
    "Head",
    "Header",
    "Hgroup",
    "Html",
    "Iframe",
    "Img",
    "Input",
    "Ins",
    "Label",
    "Legend",
    "Li",
    "Link",
    "Main",
    "Map",
    "Menu",
    "Meta",
    "Meter",
    "Nav",
    "Noscript",
    "Object",
    "Ol",
    "Optgroup",
    "Option",
    "Output",
    "P",
    "Param",
    "Picture",
    "Progress",
    "Q",
    "Rp",
    "Rt",
    "Ruby",
    "S",
    "Script",
    "Search",
    "Section",
    "Select",
    "Source",
    "Span",
    "Style",
    "Sub",
    "Sup",
    "Template",
    "Textarea",
    "Title",
    "Track",
    "U",
    "Ul",
    "Video",
    "Wbr",
    # Form elements
    "Checkbox",
    "Radio",
    "DatePicker",
    "TimePicker",
    "ColorPicker",
    "NumberInput",
    "EmailInput",
    "PasswordInput",
    "SearchInput",
    "UrlInput",
    "TelInput",
    "FileInput",
    "FormError",
    "FormHelp",
]
