from typing import Any, Unpack

import cytoolz as toolz
import wadler_lindig as wl

from liblaf.grapes.wadler_lindig._typing import WadlerLindigOptions


def pdoc_rich_repr(
    obj: Any, **kwargs: Unpack[WadlerLindigOptions]
) -> wl.AbstractDoc | None:
    if not hasattr(obj, "__rich_repr__"):
        return None
    cls: type = type(obj)
    args: list[Any] = []
    pairs: list[tuple[str, Any]] = []
    for field in obj.__rich_repr__():
        name: str
        value: Any
        default: Any
        if isinstance(field, tuple):
            if len(field) == 2:
                name, value = field
                pairs.append((name, value))
            elif len(field) == 3:
                name, value, default = field
                if kwargs.get("hide_defaults", True) and value is default:
                    continue
                pairs.append((name, value))
        else:
            value = field
            args.append(value)
    show_dataclass_module: bool = kwargs.get("show_dataclass_module", False)
    name_kwargs: dict[str, Any] = toolz.assoc(
        kwargs, "show_type_module", show_dataclass_module
    )
    return wl.bracketed(
        begin=wl.pdoc(cls, **name_kwargs) + wl.TextDoc("("),
        docs=[wl.pdoc(arg, **kwargs) for arg in args] + wl.named_objs(pairs, **kwargs),
        sep=wl.comma,
        end=wl.TextDoc(")"),
        indent=kwargs.get("indent", 2),
    )
