# 卡片 JSON 2.0 结构

本文档介绍卡片 JSON 2.0 的整体结构和属性说明。

## 概念说明

- 卡片 JSON 2.0 是指在卡片 JSON 数据中，声明了 `schema` 属性为 `"2.0"` 的版本。与 1.0 版本相比，2.0 版本有较多不兼容差异和新增属性，详情参考[卡片 JSON 2.0 版本更新说明](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-breaking-changes-release-notes)。

- 在可视化搭建工具中，你可通过搭建[新版卡片](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/feishu-card-cardkit/cardkit-upgraded-version-card-release-notes)，获取 2.0 版本的卡片 JSON 源代码。
## 注意事项

- 卡片 JSON 2.0 结构支持飞书客户端 7.20 及之后版本。当使用 JSON 2.0 结构的卡片发送至低于 7.20 版本的客户端时，卡片标题可正常显示，但内容将展示兜底的升级提示文案。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/35efb2f0bfbe5d22fe4b7a420925d2af_g5UivxGopO.png?height=449&lazyload=true&maxWidth=400&width=742)

- 卡片 JSON 2.0 结构暂时仅支持共享卡片，不支持独享卡片配置。即 `update_multi` 参数仅支持设为 `true`。

- 卡片 JSON 2.0 结构中，一张卡片最多支持 200 个元素（如 `tag` 为 `plain_text` 的文本元素）或组件。

## JSON 结构

以下为卡片 JSON 2.0 的整体结构。
```JSON
{
    "schema": "2.0", // 卡片 JSON 结构的版本。默认为 1.0。要使用 JSON 2.0 结构，必须显示声明 2.0。
    "config": {
        "streaming_mode": true, // 卡片是否处于流式更新模式，默认值为 false。
        "streaming_config": {}, // 流式更新配置。详情参考下文。
        "summary": {  // 卡片摘要信息。可通过该参数自定义客户端聊天栏消息预览中的展示文案。
            "content": "自定义内容", // 自定义摘要信息。如果开启了流式更新模式，该参数将默认为“生成中”。
            "i18n_content": { // 摘要信息的多语言配置。了解支持的所有语种。参考配置卡片多语言文档。
                "zh_cn": "",
                "en_us": "",
                "ja_jp": ""
            }
        },
        "locales": [ // JSON 2.0 新增属性。用于指定生效的语言。如果配置 locales，则只有 locales 中的语言会生效。
            "en_us",
            "ja_jp"
        ],
        "enable_forward": true, // 是否支持转发卡片。默认值为 true。
        "update_multi": true, // 是否为共享卡片。默认值为 true，JSON 2.0 暂时仅支持设为 true，即更新卡片的内容对所有收到这张卡片的人员可见。
        "width_mode": "fill", // 卡片宽度模式。支持 "compact"（紧凑宽度 400px）模式 或 "fill"（撑满聊天窗口宽度）模式。默认不填时的宽度为 600px。
        "use_custom_translation": false, // 是否使用自定义翻译数据。默认值 false。为 true 时，在用户点击消息翻译后，使用 i18n 对应的目标语种作为翻译结果。若 i18n 取不到，则使用当前内容请求翻译，不使用自定义翻译数据。
        "enable_forward_interaction": false, // 转发的卡片是否仍然支持回传交互。默认值 false。
        "style": { // 添加自定义字号和颜色。可应用在组件 JSON 数据中，设置字号和颜色属性。
            "text_size": { // 分别为移动端和桌面端添加自定义字号，同时添加兜底字号。用于在组件 JSON 中设置字号属性。支持添加多个自定义字号对象。
                "cus-0": {
                    "default": "medium", // 在无法差异化配置字号的旧版飞书客户端上，生效的字号属性。选填。
                    "pc": "medium", // 桌面端的字号。
                    "mobile": "large" // 移动端的字号。
                }
            },
            "color": { // 分别为飞书客户端浅色主题和深色主题添加 RGBA 语法。用于在组件 JSON 中设置颜色属性。支持添加多个自定义颜色对象。
                "cus-0": {
                    "light_mode": "rgba(5,157,178,0.52)", // 浅色主题下的自定义颜色语法
                    "dark_mode": "rgba(78,23,108,0.49)" // 深色主题下的自定义颜色语法
                }
            }
        }
    },
    "card_link": {
        // 指定卡片整体的跳转链接。
        "url": "https://www.baidu.com", // 默认链接地址。未配置指定端地址时，该配置生效。
        "android_url": "https://developer.android.com/",
        "ios_url": "https://developer.apple.com/",
        "pc_url": "https://www.windows.com"
    },
    "header": {
        "title": {
            // 卡片主标题。必填。要为标题配置多语言，参考配置卡片多语言文档。
            "tag": "plain_text", // 文本类型的标签。可选值：plain_text 和 lark_md。
            "content": "示例标题" // 标题内容。
        },
        "subtitle": {
            // 卡片副标题。可选。
            "tag": "plain_text", // 文本类型的标签。可选值：plain_text 和 lark_md。
            "content": "示例文本" // 标题内容。
        },
        "text_tag_list": [
            // 标题后缀标签，最多设置 3 个 标签，超出不展示。可选。
            {
                "tag": "text_tag",
                "element_id": "custom_id", // 操作元素的唯一标识。用于在调用组件相关接口中指定元素。需开发者自定义。
                "text": {
                    // 标签内容
                    "tag": "plain_text",
                    "content": "标签 1"
                },
                "color": "neutral" // 标签颜色
            }
        ],
        "i18n_text_tag_list": {
            // 多语言标题后缀标签。每个语言环境最多设置 3 个 tag，超出不展示。可选。同时配置原字段和国际化字段，优先生效多语言配置。
            "zh_cn": [],
            "en_us": [],
            "ja_jp": [],
            "zh_hk": [],
            "zh_tw": []
        },
        "template": "blue", // 标题主题样式颜色。支持 "blue"|"wathet"|"turquoise"|"green"|"yellow"|"orange"|"red"|"carmine"|"violet"|"purple"|"indigo"|"grey"|"default"。默认值 default。
        "icon": { // 前缀图标。
            "tag": "standard_icon", // 图标类型。
            "token": "chat-forbidden_outlined", // 图标的 token。仅在 tag 为 standard_icon 时生效。
            "color": "orange", // 图标颜色。仅在 tag 为 standard_icon 时生效。
            "img_key": "img_v2_38811724" // 图片的 key。仅在 tag 为 custom_icon 时生效。
        },
        "padding": "12px 8px 12px 8px" // 标题组件的内边距。JSON 2.0 新增属性。默认值 "12px"，支持范围 [0,99]px。    
    },
    "body": { // 卡片正文。
        // JSON 2.0 新增布局类属性，用于控制子元素排列：
        "direction": "vertical", // 正文或容器内组件的排列方向。可选值："vertical"（垂直排列）、"horizontal"（水平排列）。默认为 "vertical"。
        "padding": "12px 8px 12px 8px", // 正文或容器内组件的内边距，支持范围 [0,99]px。    
        "horizontal_spacing": "3px", // 正文或容器内组件的水平间距，可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。
        "horizontal_align": "left", // 正文或容器内组件的水平对齐方式，可选值："left"、"center"、"right"。默认值为 "left"。
        "vertical_spacing": "4px", // 正文或容器内组件的垂直间距，可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。
        "vertical_align": "center", // 正文或容器内组件的垂直对齐方式，可选值："top"、"center"、"bottom"，默认值为 "top"。
        "elements": [ // 在此传入各个组件的 JSON 数据，组件将按数组顺序纵向流式排列。
            {
                "tag": "xxx", // 组件的标签。
                "margin": "4px", // 组件的外边距，默认值 "0"，支持范围 [-99,99]px。JSON 2.0 新增属性。
                "element_id": "custom_id" // 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用流式更新相关接口中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
            }
        ]
    }
}
```

## 属性说明

本小节介绍卡片结构中的属性。

### 全局属性

卡片全局属性包括以下字段。
```JSON
{
    "schema": "2.0",
    "config": {},
    "card_link": {},
    "header": {},
    "body": {
        "elements": []
    }
}
```
各个字段说明如下所示。
若这些字段均不传，则卡片 JSON 为 "{}"。飞书开放平台支持发送卡片 JSON 为 "{}" 的空白卡片。

字段 | 是否必填 | 描述
---|---|---
schema | 否 | 卡片结构的版本声明。默认为 1.0 版本。要使用 JSON 2.0 结构，必须显示声明 2.0。可选值：<br>- 1.0：卡片 JSON 1.0 结构。详情参考[卡片 JSON 1.0 结构](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-structure)。<br>- 2.0：卡片 JSON 2.0 结构。支持更多字段和能力，如卡片流式更新能力、富文本组件（markdown）更多语法等。详情参考[卡片 JSON 2.0 不兼容变更&更新说明](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-breaking-changes-release-notes)。
config | 否 | 配置卡片的全局行为，包括流式更新模式（JSON 2.0 新增能力）、是否允许被转发、是否为共享卡片等。
card_link | 否 | 指定卡片整体的点击跳转链接。你可以配置一个默认链接，也可以分别为 PC 端、Android 端、iOS 端配置不同的跳转链接。
header | 否 | 标题组件相关配置。详情参考[标题](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/title)组件。
body | 否 | 卡片正文，包含一个名为 elements 的数组，用于放置各类组件。

### 卡片全局行为设置 `config`

`config` 用于配置卡片的全局行为，包括流式更新模式、是否允许被转发、是否为共享卡片等。
```json
{
  "config": {
    "streaming_mode": true, // 卡片是否处于流式更新模式，默认值为 false。
    "streaming_config": { // 流式更新配置。
      "print_frequency_ms": { // // 流式更新频率，单位：ms
        "default": 30,
        "android": 25,
        "ios": 40,
        "pc": 50
      },
      "print_step": {  // // 流式更新步长，单位：字符数
        "default": 2,
        "android": 3,
        "ios": 4,
        "pc": 5
      },
      "print_strategy": "fast" // 流式更新策略，枚举值，可取：fast/delay
    },
    "summary": {  // 卡片摘要信息。可通过该参数自定义客户端聊天栏消息预览中的展示文案。
      "content": "自定义内容", // 自定义摘要信息。如果开启了流式更新模式，该参数将默认为“生成中”。
      "i18n_content": { // 摘要信息的多语言配置。了解支持的所有语种。参考配置卡片多语言文档。
        "zh_cn": "",
        "en_us": "",
        "ja_jp": ""
      }
    },
    "locales": [ // JSON 2.0 新增属性。用于指定生效的语言。如果配置 locales，则只有 locales 中的语言会生效。
      "en_us",
      "ja_jp"
    ], // 卡片支持的语言列表。
    "enable_forward": true, // 是否支持转发卡片。默认值为 true。
    "update_multi": true, // 是否为共享卡片。默认值为 true，JSON 2.0 暂时仅支持设为 true，即更新卡片的内容对所有收到这张卡片的人员可见。
    "width_mode": "fill", // 卡片宽度模式。支持 "compact"（紧凑宽度 400px）模式 或 "fill"（撑满聊天窗口宽度）模式。默认不填时的宽度为 600px。
    "use_custom_translation": false, // 是否使用自定义翻译数据。默认值 false。为 true 时，在用户点击消息翻译后，使用 i18n 对应的目标语种作为翻译结果。若 i18n 取不到，则使用当前内容请求翻译，不使用自定义翻译数据。
    "enable_forward_interaction": false, // 转发的卡片是否仍然支持回传交互。默认值 false。
    "style": { // 添加自定义字号和颜色。可应用在组件 JSON 数据中，设置字号和颜色属性。
      "text_size": { // 分别为移动端和桌面端添加自定义字号，同时添加兜底字号。用于在组件 JSON 中设置字号属性。支持添加多个自定义字号对象。
        "cus-0": {
          "default": "medium", // 在无法差异化配置字号的旧版飞书客户端上，生效的字号属性。选填。
          "pc": "medium", // 桌面端的字号。
          "mobile": "large" // 移动端的字号。
        }
      },
      "color": { // 分别为飞书客户端浅色主题和深色主题添加 RGBA 语法。用于在组件 JSON 中设置颜色属性。支持添加多个自定义颜色对象。
        "cus-0": {
          "light_mode": "rgba(5,157,178,0.52)", // 浅色主题下的自定义颜色语法
          "dark_mode": "rgba(78,23,108,0.49)" // 深色主题下的自定义颜色语法
        }
      }
    }
  }
}
```
`config` 下的各字段说明如下表所示。

字段名称 | 是否必填 | 类型 | 默认值 | 说明
---|---|---|---|---
streaming_mode | 否 | Boolean | false | 卡片是否处于流式更新模式。详情参考[流式更新卡片](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/streaming-updates-openapi-overview)。
streaming_config | 否 | object | / | 流式更新相关配置。详情参考[流式更新卡片](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/streaming-updates-openapi-overview)。
summary | 否 | Object | / | 自定义摘要信息配置。即飞书客户端聊天栏消息预览中的文案。
content | 否 | String | 无 | 摘要文本。当 `streaming_mode` 为 `true` 时，该字段默认为“生成中”。支持自定义。
i18n_content | 否 | Object | / | 摘要文本的多语言配置。详情参考[局部国际化配置](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/configure-multi-language-content)。
enable_forward | 否 | Boolean | true | 是否允许转发卡片。取值：<br>- true：允许<br>- false：不允许
update_multi | 否 | Boolean | true | 是否为共享卡片。取值：<br>- true：是共享卡片，更新卡片的内容对所有收到这张卡片的人员可见。<br>- false：非共享卡片，仅操作用户可见卡片的更新内容。
width_mode | 否 | String | default | 卡片宽度模式。取值：<br>- default：默认宽度。PC 端宽版、iPad 端上的宽度上限为 600px。<br>- compact：紧凑宽度 400px<br>- fill：自适应屏幕宽度<br>注意：卡片搭建工具上暂时不支持 `width_mode` 属性。
use_custom_translation | 否 | Boolean | false | 是否使用自定义翻译数据。取值：<br>- true：在用户点击消息翻译后，使用 i18n 对应的目标语种作为翻译结果。若 i18n 取不到，则使用当前内容请求飞书的机器翻译。<br>- false：不使用自定义翻译数据，直接请求飞书的机器翻译。
enable_forward_interaction | 否 | Boolean | false | 转发的卡片是否仍然支持回传交互。
style | 否 | Object | 空 | 添加自定义字号和颜色。可应用于组件的 JSON 数据中，设置字号和颜色属性。
text_size | 否 | Object | 空 | 分别为移动端和桌面端添加自定义字号，同时添加兜底字号。用于在普通文本组件和富文本组件 JSON 中设置字号属性。支持添加多个自定义字号对象。详情参考[普通文本](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/plain-text)组件和[富文本（Markdown）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/rich-text)组件。
color | 否 | Object | 空 | 分别为飞书客户端浅色主题和深色主题添加 RGBA 语法。用于在组件 JSON 中设置颜色属性。支持添加多个自定义颜色对象。详情参考[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。

### 卡片全局跳转链接 `card_link`

`card_link` 字段用于指定卡片整体的点击跳转链接。你可以配置一个默认链接，也可以分别为 PC 端、Android 端、iOS 端配置不同的跳转链接。

```json
"card_link": {
    // 指定卡片整体的跳转链接。
    "url": "https://www.baidu.com", // 默认链接地址。未配置指定端地址时，该配置生效。
    "android_url": "https://developer.android.com/",
    "ios_url": "https://developer.apple.com/",
    "pc_url": "https://www.windows.com"
  }
```
card_link 下的各字段说明如下表所示。
**注意事项**：**注意**
-   url 和各端的链接（android_url、ios_url、pc_url）必填其中一个。如果不填写 url，则必须完整填写 android_url、ios_url、pc_url 三个字段。如果同时填写了 url 和 android_url、ios_url、pc_url，url 字段生效。
- 如果需要禁止某端进行跳转，可以将对应的参数值配置为 `lark://msgcard/unsupported_action`。

字段名称 | 是否必填 | 类型 | 说明
---|---|---|---
url | 否 | String | 默认的链接地址。
pc_url | 否 | String | PC 端的链接地址。
ios_url | 否 | String | iOS 端的链接地址。
android_url | 否 | String | Android 端的链接地址。

### 卡片标题 `header`

`header` 字段用于配置卡片的标题。了解`header` 字段说明，参见[标题组件](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/title)。
```json
  "header": {}  // 卡片标题
```

### 卡片正文 `body`

在卡片的`body`字段中，你需要添加卡片组件作为卡片正文内容，组件将按数组顺序纵向流式排列。了解卡片组件，参考[卡片 JSON 2.0 版本组件概述](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/component-json-v2-overview)。

在卡片 JSON  2.0 结构中，所有组件（标题组件除外）和元素（如 tag 为 plain_text 的文本元素）新增 element_id 属性，作为操作组件或元素的唯一标识。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
```json
{
    "body": { // 卡片正文。
        "elements": [ // 在此传入各个组件的 JSON 数据，组件将按数组顺序纵向流式排列。
            {
                "tag": "xxx", // 组件的标签。
                "element_id": "custom_id" // 操作组件的唯一标识。
            }
        ]
    }
}
```


# 卡片 JSON 2.0 版本组件概述

飞书卡片中的组件可分为容器类、展示类和交互类组件。除循环容器外，所有组件均支持通过卡片 JSON 代码构建。除折叠面板、多图选择和勾选器外，所有组件均支持通过卡片搭建工具搭建使用。在 JSON 结构中，组件通过定义 `tag` 字段声明：

```json
{
  "tag": "" // 在此声明组件的标签。不同的组件标签不同。
}
```

本文档汇总并介绍基于[卡片 JSON 2.0 结构](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-structure)构建的组件。

## 客户端版本要求
卡片 JSON 2.0 结构支持飞书客户端 7.20 及之后版本。当使用 JSON 2.0 结构的卡片发送至低于 7.20 版本的客户端时，卡片标题可正常显示，但内容将展示兜底的升级提示文案。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/35efb2f0bfbe5d22fe4b7a420925d2af_g5UivxGopO.png?height=449&lazyload=true&maxWidth=400&width=742)

## 容器类组件

容器类组件可用于布局内容或配置交互逻辑。在容器组件中支持添加展示类组件和交互类组件。

组件 | 是否支持在搭建工具中使用 | 描述
---|---|---
[分栏（column_set）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/containers/column-set) | ✓ | 分栏支持横向排布多列，在列内自由组合图文内容，搭建出如数据表、商品或文章列表、差旅信息等图文并茂、交互友好的卡片。
[循环容器](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/containers/recycling-container) | ✓ | 循环容器支持内嵌所有展示、交互类组件和分栏组件。通过使用循环容器，你可以高效地组织一系列排版类似、数据不同的内容。仅支持通过搭建工具搭建使用。
[表单容器（form）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/containers/form-container) | ✓ | 表单容器支持用户在前端本地录入一批表单项后，通过点击一次 提交 按钮，将这一批本地缓存的表单内容一次回调至开发者的服务端，实现异步提交多个表单项数据的效果。
[交互容器（interactive_container）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/containers/interactive-container) | ✓ | 交互容器允许你基于业务需求在交互容器中内嵌组件，并灵活组合多个交互容器，并统一定义多个交互容器的样式、交互能力等，实现多种组合效果和丰富的卡片交互。
[折叠面板（collapsible_panel）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/containers/collapsible-panel) | × | 折叠面板允许你在卡片中折叠次要信息，如备注、较长文本等，以突出主要信息。

## 展示类组件

展示类组件用于构成卡片的主要内容，不具备交互能力。

组件 | 是否支持在搭建工具中使用 | 描述
---|---|---
[标题（header）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/title) | ✓ | 标题组件用于构建飞书卡片的标题样式与内容，支持添加卡片主标题、副标题、后缀标签和标题图标。
[普通文本（div）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/plain-text) | ✓ | 普通文本组件支持添加普通文本和前缀图标，并设置文本大小、颜色、对齐方式等展示样式。
[富文本（markdown）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/rich-text) | ✓ | 富文本（Markdown）组件支持渲染文本、图片、分割线等元素。
[图片（img）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/image) | ✓ | 图片组件支持通过调用[上传图片](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create)接口或在新版飞书卡片搭建工具中上传图片，在卡片内添加图片。
[多图混排（img_combination）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/multi-image-laylout) | ✓ | 多图混排组件支持通过调用[上传图片](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create)接口或在新版飞书卡片搭建工具中上传图片，在卡片内添加多张图片。
[人员（person）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/user-profile) | ✓ | 人员组件支持展示人员的用户名和头像。你可通过传入人员的 open_id、user_id 或 union_id 使用该组件。
[人员列表（person_list）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/user-list) | ✓ | 人员列表组件支持展示多个人员的用户名和头像。你可通过传入人员的 open_id、user_id 或 union_id 使用该组件。
[图表（chart）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/chart) | ✓ | 图表组件基于 [VChart](https://www.visactor.io/) 的图表定义，支持折线图、面积图、柱状图、饼图、词云等多种数据呈现方式，帮助你可视化各类信息，提高信息沟通效率。
[表格（table）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/table) | ✓ | 表格组件支持在表格中添加普通文本、选项标签、人员列表以及数字格式的内容。
[分割线（hr）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/divider) | ✓ | 分割线组件是一条长横线，用于分割卡片的内容，使呈现内容更清晰。

## 交互类组件

交互类组件为卡片提供了交互能力。用户在接收到包含交互组件的卡片时，可直接在卡片内访问链接或处理业务。

组件 | 是否支持在搭建工具中使用 | 描述
---|---|---
[输入框（input）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/input) | ✓ | 输入框组件支持收集不固定的文本内容，如原因、评价、备注等。
[按钮（button）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/button) | ✓ | 按钮组件提供配置按钮的回传交互能力或者链接跳转能力，并支持多种样式和尺寸。
[折叠按钮组（overflow）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/overflow) | ✓ | 折叠按钮组组件支持将多个按钮添加在折叠按钮组中，默认情况下按钮组为折叠状态，点击按钮组将会展示组内所有按钮。
[下拉选择-单选（select_static）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/single-select-dropdown-menu) | ✓ | 下拉选择-单选组件支持自定义单选菜单的选项文本、图标和回传参数。
[下拉选择-多选（multi_select_static）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/multi-select-dropdown-menu) | ✓ | 下拉选择-多选组件支持自定义多选菜单的选项文本、图标和回传参数。
[人员选择-单选（select_person）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/single-select-user-picker) | ✓ | 人员选择-多选组件支持添加指定人员作为单选选项。
[人员选择-多选（multi_select_person）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/multi-select-user-picker) | ✓ | 人员选择-多选组件支持添加指定人员作为多选选项。
[日期选择器（date_picker）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/date-picker) | ✓ | 日期选择器组件支持提供日期选项。
[时间选择器（picker_time）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/time-selector) | ✓ | 时间选择器组件支持提供时间选项。
[日期时间选择器（picker_datetime）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/date-time-picker) | ✓ | 日期时间选择器组件支持提供时间和日期选项。
[多图选择（select_img）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/image-picker) | × | 多图选择组件支持提供图片选项，支持单选、多选图片。
[勾选器（checker）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/checker) | × | 勾选器支持配置回调响应，主要用于任务勾选的场景。


# 分栏组件
分栏组件提供卡片内布局的能力，并提供对齐方式、容器宽度、交互方式等属性。你可以使用分栏组件横向排布多个列容器，在列容器内自由组合图文内容，搭建出如数据表、商品或文章列表、差旅信息等图文并茂、交互友好的卡片。

本文档介绍分栏组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[分栏](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/containers/column-set)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/ab0828f3677f4eaab0582cf8a13780ca_6dNbyUvuxR.png?height=691&lazyload=true&maxWidth=300&width=630)

## 注意事项

分栏组件最多支持嵌套五层组件。建议你避免在分栏中嵌套多层组件。多层嵌套会压缩内容的展示空间，影响卡片的展示效果。

## 应用场景

- 分栏的使用场景非常广泛，在卡片中适当使用分栏，可以使信息排布更合理、主次更分明。常见场景如下所示。推荐你直接前往卡片搭建工具，查看[分栏示例](https://open.larkoffice.com/cardkit?catalogId=10015&templateId=AAqBEj6y7tTLV)。

- **数据报表推送：** 使用分栏可以快速构建整齐、自适应屏幕的多列数据表，解决了传统报表构建时繁琐的排版过程，以及无法自适应各类屏幕的样式问题。
    - **图文混排**：分栏灵活的横纵列排版能力，使你可以快速构建理想的图文卡片。有效降低手动调整图文排版的耗时。
    - **表单收集**：表单容器中内嵌分栏组件，将相关字段放在同一列，可有效提升内容的逻辑性和可读性。
- 分栏中还可配置点击链接、变量，推荐你直接前往卡片搭建工具，查看[分栏配置链接案例](https://open.larkoffice.com/cardkit?catalogId=10015&templateId=AAqBEj6y7tTLV)。

## 嵌套规则

分栏组件由分栏本身的属性（column_set）和列容器（column）组成。一个分栏组件中内可以添加多个列容器，每个列容器中可内嵌多个组件。

[卡片 JSON 2.0 结构](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-structure)支持内嵌除表单容器（form）和表格组件（table）外的其它所有组件。

整体的嵌套关系如下图所示。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/9b253ea6e463d2841c8295b26873c3f7_8BnIr3afv7.png?height=722&lazyload=true&maxWidth=600&width=1942)

列容器中再嵌套分栏的层级关系如下图所示。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/e2b6909f3881bc78965466cc736d5ec6_FKkeg0UCcT.png?height=584&lazyload=true&maxWidth=600&width=2034)

## 组件属性

### JSON 结构

分栏组件的完整 JSON 2.0 结构如下所示：

```JSON
{
    "schema": "2.0",
    "body": {
        "elements": [
            {
                "tag": "column_set", // 分栏的标签。
                "element_id": "custom_id", // 操作组件的唯一标识。用于在调用组件相关接口中指定组件。需开发者自定义。
                "margin": "4px", // 分栏的外边距，默认值 "0"，支持范围 [-99,99]px。
                "horizontal_spacing": "large", // 分栏内组件之间的间距，可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。默认 8px。
                "horizontal_align": "left", // 分栏内组件水平对齐的方式，可选值："left"、"center"、"right"，默认值为 "left"。
                "flex_mode": "none", // 移动端和 PC 端的窄屏幕下，各列的自适应方式。默认值 none。
                "background_style": "default", // 分栏的背景色样式。默认值 default。
                "action": { // 在此处设置点击分栏时的交互配置。
                    "multi_url": {
                        "url": "https://open.feishu.cn",
                        "pc_url": "https://open.feishu.com",
                        "ios_url": "https://developer.apple.com/",
                        "android_url": "https://developer.android.com/"
                    }
                },
                "columns": [
                    // 列配置
                    {
                        "tag": "column",
                        "element_id": "custom_id", // 操作组件的唯一标识。用于在调用组件相关接口中指定组件。需开发者自定义。
                        "background_style": "default", // 列的背景色样式。默认值 default。
                        "width": "auto", // 列的宽度。默认值 auto。
                        "weight": 1, // 当 width 取值 weighted 时生效，表示当前列的宽度占比。
                        "horizontal_spacing": "large", // 列内组件之间的间距，可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。默认 8px。
                        "horizontal_align": "left", // 列内组件水平对齐的方式，可选值："left"、"center"、"right"，默认值为 "left"。
                        "vertical_align": "center", // 列内组件的垂直对齐方式，可选值："top"、"center"、"bottom"，默认值为 "top"。
                        "vertical_spacing": "4px", // 列内子组件纵向间距。默认值 default（8px）。
                        "direction": "vertical", // 列的排列方向。可选值："vertical"（垂直排列）、"horizontal"（水平排列）。默认为 "vertical"。
                        "padding": "8px", // 列的内边距。默认值 0px。支持范围 [0,99]px。
                        "margin": "4px", // 列的外边距，默认值 0px。支持范围 [-99,99]px。
                        "action": {
                            // 在此处设置点击列时的交互配置。
                            "multi_url": {
                                "url": "https://www.baidu.com",
                                "pc_url": "https://www.baidu.com",
                                "ios_url": "https://www.google.com",
                                "android_url": "https://www.apple.com.cn"
                            }
                        },
                        "elements": [] // 列容器内嵌的组件，不支持内嵌表格和表单容器。
                    }
                ]
            }
        ]
    }
}
```

### 分栏字段说明

分栏（column_set）各属性字段说明如下表所示。

名称 | 必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 是 | String | / | 组件的标签。分栏组件的固定值为 column_set。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
horizontal_spacing | 否 | String | 8px | 分栏内组件的水平间距，可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
horizontal_align | 否 | String | left | 分栏内组件在水平方向上的对齐方式。可取值：<br>- left：左对齐<br>- center：居中对齐<br>- right：右对齐
margin | 否 | String | 0px | 分栏的外边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示分栏的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示分栏的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示分栏的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
flex_mode | 否 | String | none | 移动端和 PC 端的窄屏幕下，各列的自适应方式。取值：<br>- none：不做布局上的自适应，在窄屏幕下按比例压缩列宽度<br>- stretch：列布局变为行布局，且每列（行）宽度强制拉伸为 100%，所有列自适应为上下堆叠排布<br>- flow：列流式排布（自动换行），当一行展示不下一列时，自动换至下一行展示<br>- bisect：两列等分布局<br>- trisect：三列等分布局
background_style | 否 | String | default | 分栏的背景色样式。可取值：<br>- default：默认的白底样式，客户端深色主题下为黑底样式<br>- 卡片支持的颜色枚举值和 RGBA 语法自定义颜色。参考[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。<br>**注意**：当存在分栏的嵌套时，上层分栏的颜色覆盖下层分栏的颜色。
action | 否 | Action | / | 设置点击分栏时的交互配置。当前仅支持跳转交互。如果布局容器内有交互组件，则优先响应交互组件定义的交互。
└ multi_url | 否 | Struct | 空 | 配置各个端的链接地址。
└└ url | 否 | String | 空 | 兜底的跳转链接。
└└ android_url | 否 | String | 空 | Android 端的跳转链接。可配置为 `lark://msgcard/unsupported_action` 声明当前端不允许跳转。
└└ ios_url | 否 | String | 空 | iOS 端的跳转链接。可配置为 `lark://msgcard/unsupported_action` 声明当前端不允许跳转。
└└ pc_url | 否 | String | 空 | PC 端的跳转链接。可配置为 `lark://msgcard/unsupported_action` 声明当前端不允许跳转。
columns | 是 | column[] | 空 | 分栏中列的配置。详情参考下文。

### 列字段说明

分栏中列（column）的各属性字段说明如下表所示。

名称 | 必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 是 | String | / | 列的标签，固定取值为 `column`。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
background_style | 否 | String | default | 列的背景色样式。可取值：<br>- default：默认的白底样式，客户端深色主题下为黑底样式<br>- 卡片支持的颜色枚举值和 RGBA 语法自定义颜色。参考[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)
width | 否 | String | auto | 列宽度。仅 `flex_mode` 为 `none` 时，生效此属性。取值：<br>- auto：列宽度与列内元素宽度一致<br>- weighted：列宽度按 `weight` 参数定义的权重分布<br>- 具体数值，如 100px。取值范围为 [16,600]px。V7.4 及以上版本支持该枚举
weight | 否 | Number | 1 | 当 `width` 字段取值为 `weighted` 时生效，表示当前列的宽度占比。取值范围为 1 ~ 5 之间的整数。
horizontal_spacing | 否 | String | 8px | 列内组件的水平间距，可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
horizontal_align | 否 | String | left | 列内组件在水平方向上的对齐方式。可取值：<br>- left：左对齐<br>- center：居中对齐<br>- right：右对齐
vertical_align | 否 | String | top | 列内组件在垂直方向上的对齐方式。可取值：<br>- top：上对齐<br>- center：居中对齐<br>- bottom：下对齐
vertical_spacing | 否 | String | 8px | 列内组件的纵向间距。可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
direction | 否 | String | vertical | 列的排列方向。可选值：<br>- vertical：垂直排列<br>- horizontal：水平排列
padding | 否 | String | 0px | 列的内边距。值的取值范围为 [0,99]px。可选值：<br>- 单值，如 "10px"，表示列的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示列的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示列的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
margin | 否 | String | 0px | 列的外边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示容器的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示容器的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示容器的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
elements | 否 | Element 或 ColumnSet[] | 空 | 列中内嵌的组件。可内嵌组件参考上文嵌套关系。
action | 否 | Action | / | 设置点击列时的交互配置。当前仅支持跳转交互。如果布局容器内有交互组件，则优先响应交互组件定义的交互。
└ multi_url | 否 | Struct | 空 | 配置各个端的链接地址。
└└ url | 否 | String | 空 | 兜底的链接地址。
└└ android_url | 否 | String | 空 | Android 端的链接地址。可配置为 `lark://msgcard/unsupported_action` 声明当前端不允许跳转。
└└ ios_url | 否 | String | 空 | iOS 端的链接地址。可配置为 `lark://msgcard/unsupported_action` 声明当前端不允许跳转。
└└ pc_url | 否 | String | 空 | PC 端的链接地址。可配置为 `lark://msgcard/unsupported_action` 声明当前端不允许跳转。

## 示例代码

以下 JSON 2.0 结构的示例代码可实现如下图所示的卡片效果：

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/ab0828f3677f4eaab0582cf8a13780ca_6dNbyUvuxR.png?height=691&lazyload=true&maxWidth=300&width=630)

```json
{
    "schema": "2.0",
    "body": {
      "elements": [
        {
                "tag": "markdown",
                "content": ":YouAreTheBest:**个人效率总览** ",
                "text_align": "left",
                "text_size": "heading"
            },
            {
                "tag": "column_set",
                "flex_mode": "bisect",
                "horizontal_spacing": "",
                "horizontal_align": "center",
                "columns": [
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "top",
                        "vertical_spacing": "8px",
                        "direction": "horizontal",
                        "elements": [
                            {
                                "tag": "column_set",
                                "flex_mode": "none",
                                "horizontal_spacing": "8px",
                                "horizontal_align": "left",
                                "columns": [
                                    {
                                        "tag": "column",
                                        "width": "weighted",
                                        "vertical_align": "top",
                                        "vertical_spacing": "8px",
                                        "background_style": "grey",
                                        "padding": "8px",
                                        "elements": [
                                            {
                                                "tag": "column_set",
                                                "flex_mode": "none",
                                                "horizontal_spacing": "default",
                                                "background_style": "default",
                                                "columns": [
                                                    {
                                                        "tag": "column",
                                                        "elements": [
                                                            {
                                                                "tag": "div",
                                                                "text": {
                                                                    "tag": "plain_text",
                                                                    "content": "已审批单量",
                                                                    "text_size": "normal",
                                                                    "text_align": "center",
                                                                    "text_color": "grey"
                                                                }
                                                            }
                                                        ],
                                                        "width": "weighted",
                                                        "weight": 1
                                                    }
                                                ]
                                            },
                                            {
                                                "tag": "column_set",
                                                "flex_mode": "none",
                                                "horizontal_spacing": "default",
                                                "background_style": "default",
                                                "columns": [
                                                    {
                                                        "tag": "column",
                                                        "elements": [
                                                            {
                                                                "tag": "div",
                                                                "text": {
                                                                    "tag": "plain_text",
                                                                    "content": "29 单",
                                                                    "text_size": "heading",
                                                                    "text_align": "center",
                                                                    "text_color": "default"
                                                                }
                                                            }
                                                        ],
                                                        "width": "weighted",
                                                        "weight": 1
                                                    }
                                                ]
                                            },
                                            {
                                                "tag": "markdown",
                                                "content": "<text_tag color='blue'>高于部门 86%</text_tag>",
                                                "text_align": "center",
                                                "text_size": "normal"
                                            }
                                        ],
                                        "weight": 1
                                    }
                                ],
                                "margin": "0px 0px 0px 0px"
                            }
                        ],
                        "weight": 1
                    },
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "top",
                        "vertical_spacing": "8px",
                        "elements": [
                            {
                                "tag": "column_set",
                                "flex_mode": "none",
                                "horizontal_spacing": "8px",
                                "horizontal_align": "left",
                                "columns": [
                                    {
                                        "tag": "column",
                                        "width": "weighted",
                                        "vertical_align": "top",
                                        "vertical_spacing": "8px",
                                        "background_style": "grey",
                                        "padding": "8px",
                                        "elements": [
                                            {
                                                "tag": "column_set",
                                                "flex_mode": "none",
                                                "horizontal_spacing": "default",
                                                "background_style": "default",
                                                "columns": [
                                                    {
                                                        "tag": "column",
                                                        "elements": [
                                                            {
                                                                "tag": "div",
                                                                "text": {
                                                                    "tag": "plain_text",
                                                                    "content": "审批平均耗时",
                                                                    "text_size": "normal",
                                                                    "text_align": "center",
                                                                    "text_color": "grey"
                                                                }
                                                            }
                                                        ],
                                                        "width": "weighted",
                                                        "weight": 1
                                                    }
                                                ]
                                            },
                                            {
                                                "tag": "column_set",
                                                "flex_mode": "none",
                                                "horizontal_spacing": "default",
                                                "background_style": "default",
                                                "columns": [
                                                    {
                                                        "tag": "column",
                                                        "elements": [
                                                            {
                                                                "tag": "div",
                                                                "text": {
                                                                    "tag": "plain_text",
                                                                    "content": "0.9 小时",
                                                                    "text_size": "heading",
                                                                    "text_align": "center",
                                                                    "text_color": "default"
                                                                }
                                                            }
                                                        ],
                                                        "width": "weighted",
                                                        "weight": 1
                                                    }
                                                ]
                                            },
                                            {
                                                "tag": "markdown",
                                                "content": "<text_tag color='orange'>落后部门 61%</text_tag>",
                                                "text_align": "center",
                                                "text_size": "normal"
                                            }
                                        ],
                                        "weight": 1
                                    }
                                ],
                                "margin": "0px 0px 0px 0px"
                            }
                        ],
                        "weight": 1
                    },
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "top",
                        "vertical_spacing": "8px",
                        "elements": [
                            {
                                "tag": "column_set",
                                "flex_mode": "none",
                                "horizontal_spacing": "8px",
                                "horizontal_align": "left",
                                "columns": [
                                    {
                                        "tag": "column",
                                        "width": "weighted",
                                        "vertical_align": "top",
                                        "vertical_spacing": "8px",
                                        "background_style": "grey",
                                        "padding": "8px",
                                        "elements": [
                                            {
                                                "tag": "column_set",
                                                "flex_mode": "none",
                                                "horizontal_spacing": "default",
                                                "background_style": "default",
                                                "columns": [
                                                    {
                                                        "tag": "column",
                                                        "elements": [
                                                            {
                                                                "tag": "div",
                                                                "text": {
                                                                    "tag": "plain_text",
                                                                    "content": "代批率",
                                                                    "text_size": "normal",
                                                                    "text_align": "center",
                                                                    "text_color": "grey"
                                                                }
                                                            }
                                                        ],
                                                        "width": "weighted",
                                                        "weight": 1
                                                    }
                                                ]
                                            },
                                            {
                                                "tag": "column_set",
                                                "flex_mode": "none",
                                                "horizontal_spacing": "default",
                                                "background_style": "default",
                                                "columns": [
                                                    {
                                                        "tag": "column",
                                                        "elements": [
                                                            {
                                                                "tag": "div",
                                                                "text": {
                                                                    "tag": "plain_text",
                                                                    "content": "0%",
                                                                    "text_size": "heading",
                                                                    "text_align": "center",
                                                                    "text_color": "default"
                                                                }
                                                            }
                                                        ],
                                                        "width": "weighted",
                                                        "weight": 1
                                                    }
                                                ]
                                            },
                                            {
                                                "tag": "markdown",
                                                "content": "<text_tag color='green'>领先部门 100%</text_tag>",
                                                "text_align": "center",
                                                "text_size": "normal"
                                            }
                                        ],
                                        "weight": 1
                                    }
                                ],
                                "margin": "0px 0px 0px 0px"
                            }
                        ],
                        "weight": 1
                    }
                ],
                "margin": "16px 0px 0px 0px"
            },
            {
                "tag": "markdown",
                "content": ":STRIVE: **待优化的任务类型**",
                "text_align": "left",
                "text_size": "heading"
            },
            {
                "tag": "column_set",
                "flex_mode": "none",
                "horizontal_spacing": "8px",
                "horizontal_align": "left",
                "columns": [
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "<text_tag color='red'>1</text_tag> 加班申请",
                                "text_align": "left",
                                "text_size": "normal"
                            }
                        ],
                        "weight": 1
                    },
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "8px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "低于部门 95% 的审批人 ",
                                "text_align": "right",
                                "text_size": "notation"
                            }
                        ],
                        "weight": 1
                    }
                ],
                "margin": "16px 0px 0px 0px"
            },
            {
                "tag": "column_set",
                "flex_mode": "none",
                "horizontal_spacing": "8px",
                "horizontal_align": "left",
                "columns": [
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "<text_tag color='red'>2</text_tag> 休假申请",
                                "text_align": "left",
                                "text_size": "normal"
                            }
                        ],
                        "weight": 1
                    },
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "低于部门 55% 的审批人 ",
                                "text_align": "right",
                                "text_size": "notation"
                            }
                        ],
                        "weight": 1
                    }
                ],
                "margin": "16px 0px 0px 0px"
            },
            {
                "tag": "markdown",
                "content": ":CheckMark:**效率高的任务类型**",
                "text_align": "left",
                "text_size": "heading"
            },
            {
                "tag": "column_set",
                "flex_mode": "none",
                "horizontal_spacing": "8px",
                "horizontal_align": "left",
                "columns": [
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "<text_tag color='green'>1</text_tag> 数据权限申请",
                                "text_align": "left",
                                "text_size": "normal"
                            }
                        ],
                        "weight": 1
                    },
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "高于部门 68% 的审批人 ",
                                "text_align": "right",
                                "text_size": "notation"
                            }
                        ],
                        "weight": 1
                    }
                ],
                "margin": "16px 0px 0px 0px"
            },
            {
                "tag": "column_set",
                "flex_mode": "none",
                "horizontal_spacing": "8px",
                "horizontal_align": "left",
                "columns": [
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "<text_tag color='green'>2</text_tag> BOT推送消息",
                                "text_align": "left",
                                "text_size": "normal"
                            }
                        ],
                        "weight": 1
                    },
                    {
                        "tag": "column",
                        "width": "weighted",
                        "vertical_align": "center",
                        "vertical_spacing": "4px",
                        "elements": [
                            {
                                "tag": "markdown",
                                "content": "高于部门 56% 的审批人 ",
                                "text_align": "right",
                                "text_size": "notation"
                            }
                        ],
                        "weight": 1
                    }
                ],
                "margin": "16px 0px 0px 0px"
            }
        ]
    },
    "i18n_header": {
        "zh_cn": {
            "title": {
                "tag": "plain_text",
                "content": "我的近期审批效率"
            },
            "subtitle": {
                "tag": "plain_text",
                "content": "日期范围：2024.03.01 至 2024.03.31"
            },
            "template": "orange",
            "icon": {
                "tag": "standard_icon",
                "token": "approval_colorful"
            }
        }
    }
}
```


# 表单容器

在使用卡片收集内容时，可能存在需要用户提交多个表单项的场景。表单容器允许用户在前端本地录入一批表单项后，通过点击一次 **提交** 按钮，将这一批本地缓存的表单内容一次回调至开发者的服务端，实现异步提交多个表单项数据的效果。

本文档介绍表单容器的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[表单容器](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/containers/form-container)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/3431ef3f14bc707acaf00093f55df9b1_736bnZnIuR.png?height=491&lazyload=true&maxWidth=400&width=794)

## 注意事项

容器类组件最多支持嵌套五层组件。建议你避免在表单容器中嵌套多层组件。多层嵌套会压缩内容的展示空间，影响卡片的展示效果。如你希望卡片承接更复杂的表单内容，建议通过卡片链接跳转至 H5 或小程序实现表单能力。

## 嵌套规则

在[卡片 JSON 2.0 结构](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-structure)中：
- 表单容器不支持内嵌表格（table）和表单容器组件。
- 表单容器组件不可被内嵌在其它组件内，只可放在卡片根节点下。

## 组件属性

本小节介绍表单容器的属性。

### JSON 结构

以下为表单容器的卡片 JSON 2.0 结构。在该结构中，容器内嵌了一个输入框组件、一个提交按钮和一个清空所填内容的按钮，且两个按钮放置于分栏组件中：

```json
{
  "schema": "2.0",
  "body": {
    "elements": [
      {
        "tag": "form", // 表单容器的标签。
        "element_id": "custom_id", // 操作组件的唯一标识。用于在调用组件相关接口中指定组件。需开发者自定义。
        "direction": "horizontal", // 容器内组件的排列方向。可选值："vertical"（垂直排列）、"horizontal"（水平排列）。默认为 "vertical"。
        "horizontal_spacing": "8px", // 容器内组件之间的间距，可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。
        "vertical_spacing": "8px", // 容器内组件的纵向间距。可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。
        "horizontal_align": "left", // 容器内组件水平对齐的方式。默认值 left。
        "vertical_align": "top", // 容器内组件的垂直对齐方式，可选值："top"、"center"、"bottom"，默认值为 "top"。
        "padding": "4px 0px 4px 0px", // 容器的内边距。默认值 0px。支持范围 [0,99]px。
        "margin": "0px 0px 0px 0px", // 容器的外边距，默认值 "0"，支持范围 [-99,99]px。
        "name": "form_1", // 该表单容器的唯一标识。用于识别用户在交互后，提交的是哪个表单容器的数据。
        "elements": [
          {
            "tag": "input", // 为表单容器内添加一个输入框组件。
            "name": "reason", // 输入框组件的唯一标识。用于识别用户在交互后，提交的是哪个表单项的数据。在表单容器中所有的交互组件中，该字段必填，否则数据会发送失败。
            "required": true // 是否必填。为 true 时点击按钮后会做必填校验。
          },
          {
            "tag": "column_set", // 表单容器内嵌分栏组件。用于放置“提交”按钮和“取消”按钮。
            "columns": [
              { // 分栏容器中的列。
                "tag": "column", // 分栏组件内的第一列。
                "width": "auto", // 列宽设置。auto 为自适应。
                "elements": [ // 列容器内嵌的组件。
                  {
                    "tag": "button", // 添加一个用于提交数据的按钮组件。表单容器中必须至少有一个带有提交属性的按钮。
                    "type": "primary", // 按钮的样式类型。
                    "text": { // 按钮上的文本。
                      "tag": "plain_text",
                      "content": "提交"
                    },
                    "behaviors": [  // 为按钮添加打开链接交互事件或请求回调交互。
                      {
                        "type": "open_url", // 声明按钮的交互类型是打开链接的跳转交互。
                        "default_url": "https://www.baidu.com", // 兜底跳转地址。
                        "android_url": "https://developer.android.com/", // 安卓端跳转地址。
                        "ios_url": "lark://msgcard/unsupported_action", // iOS 端跳转地址。
                        "pc_url": "https://www.windows.com" // 桌面端跳转地址。
                      },
                      {
                        "type": "callback", // 声明交互类型是回传数据到服务端的请求回调交互。
                        "value": {
                          // 回传交互数据
                          "key": "value"
                        }
                      }
                    ],
                    "form_action_type": "submit", // 将当前按钮与提交事件绑定。用户点击后，将触发表单容器的提交事件，异步提交所有已填写的表单项内容。表单容器中必须至少有一个带有提交属性的按钮。
                    "name": "Button_m8pn9lbf" // 按钮组件的唯一标识，用于识别用户在交互后，点击的是哪个按钮。在表单容器中所有的交互组件中，该字段必填，否则数据会发送失败。
                  }
                ]
              },
              {
                "tag": "column", // 分栏组件内的第二列。
                "width": "auto", // 列宽设置。auto 为自适应。
                "elements": [ // 列容器内嵌的组件。
                  {
                    "tag": "button", //添加一个用于清空已填写内容的按钮组件
                    "type": "default", // 按钮的样式类型。default 为次按钮样式。
                    "text": { // 按钮上的文本。
                      "tag": "plain_text",
                      "content": "取消"
                    },
                    "behaviors": [
                      {
                        "type": "open_url", // 声明交互类型是打开链接的跳转交互。
                        "default_url": "https://www.baidu.com", // 兜底跳转地址。
                        "android_url": "https://developer.android.com/", // 安卓端跳转地址。
                        "ios_url": "lark://msgcard/unsupported_action", // iOS 端跳转地址。
                        "pc_url": "https://www.windows.com" // 桌面端跳转地址。
                      },
                      {
                        "type": "callback", // 声明交互类型是回传数据到服务端的回传交互。
                        "value": {
                          // 回传交互数据
                          "key": "value"
                        }
                      }
                    ],
                    "form_action_type": "reset", // 将当前按钮设为重置。用户点击后，将重置所有已填写的表单项内容。
                    "name": "Button_m8pn9lbg" // 按钮组件的唯一标识，用于识别用户在交互后，点击的是哪个按钮。在表单容器中所有的交互组件中，该字段必填，否则数据会发送失败。
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  }
}
```

### 字段说明

表单容器各字段说明如下表所示：

名称 | 必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 是 | String | / | 表单容器的标签。固定值为 `form`。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
direction | 否 | String | vertical | 容器内组件的排列方向。可选值：<br>- vertical：垂直排列<br>- horizontal：水平排列
margin | 否 | String | 0px | 容器的外边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示容器的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示容器的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示容器的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
padding | 否 | String | 0px | 容器的内边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示容器的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示容器的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示容器的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
horizontal_spacing | 否 | String | 8px | 容器内组件的水平间距，可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
horizontal_align | 否 | String | left | 容器内组件水平对齐的方式。可取值：<br>- left：左对齐<br>- center：居中对齐<br>- right：右对齐
vertical_align | 否 | String | top | 容器内组件垂直对齐的方式。可取值：<br>- top：上对齐<br>- center：居中对齐<br>- bottom：下对齐
vertical_spacing | 否 | String | 12px | 容器内组件的垂直间距，可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
name | 是 | String | 无 | 表单容器的唯一标识。用于识别用户提交的数据属于哪个表单容器。在同一张卡片内，该字段的值全局唯一。
elements | 是 | Array&lt;element&gt; | [] | 表单容器的子节点。可内嵌其它容器类组件和展示、交互组件，不支持内嵌表格、图表、和表单容器组件。
└ tag | 是 | String | 无 | 表单容器中内嵌的组件的标签，支持除表格（table）和表单容器以外的所有组件。 <br>**注意**：表单容器内必须包含一个用于提交表单的[按钮](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/interactive-components/button)组件。
└ name | 是 | String | 无 | 表单容器内组件的唯一标识。用于识别用户提交的数据属于哪个组件。<br>**注意**：<br>在表单容器中所有的交互组件中，该字段必填且需在卡片全局内唯一，否则数据会发送失败。
└ required | 否 | Boolean | false | 组件的内容是否必填。当组件内嵌在表单容器中时，该属性生效。可取值：<br>- **true**：必填。当用户点击表单容器的“提交”时，未填写该组件，则前端提示“有必填项未填写”，不会向开发者的服务端发起回传请求。<br>- **false**：选填。当用户点击表单容器的“提交”时，未填写该组件，仍提交表单容器中的数据。
└ form_action_type | 是 | String | 空 | 内嵌在表单容器中的按钮的交互类型。枚举值包括：<br>- <code>submit</code>：将当前按钮与提交事件绑定。用户点击后，将触发表单容器的提交事件，异步提交所有已填写的表单项内容<br>- <code>reset</code>：将当前按钮与取消提交事件绑定。用户点击后，将触发表单容器的取消提交事件，重置所有表单组件的输入值为初始值
└ action_type（历史属性） | 是 | String | 空 | 内嵌在表单容器中的按钮的交互类型。枚举值包括：<br>- <code>link</code>：当前按钮仅支持链接跳转</li><br><li><code>request</code>：当前按钮仅支持回传交互</li><br><li><code>multi</code>：当前按钮同时支持链接跳转和回传交互</li><br><li><code>form_submit</code>：将当前按钮与提交事件绑定。用户点击后，将触发表单容器的提交事件，异步提交所有已填写的表单项内容</li><br><li><code>form_reset</code>：将当前按钮与取消提交事件绑定。用户点击后，将触发表单容器的取消提交事件，重置所有表单组件的输入值为初始值</li><br>**注意**：表单容器内必须包含一个用于提交表单的按钮组件。此时 `action_type` 固定取值 `form_submit`，表示提交表单。
## 回调结构<br>当用户点击表单容器的提交按钮时，你在开发者后台配置的请求地址将会收到如下所示的回调数据。如果你添加的是新版卡片回传交互回调(`card.action.trigger`)，回调数据的结构如下所示。更多参数说明可参考[卡片回传交互](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-callback-communication)。<br>```json<br>{<br>"schema": "2.0", // 回调的版本<br>"header": { // 回调基本信息<br>"event_id": "f7984f25108f8137722bb63c*****", // 回调的唯一标识<br>"token": "066zT6pS4QCbgj5Do145GfDbbag*****", // 应用的 Verification Token<br>"create_time": "1603977298000000", // 	回调发送的时间，接近回调发生的时间<br>"event_type": "card.action.trigger", // 回调类型卡片交互场景中，固定为 "card.action.trigger"<br>"tenant_key": "2df73991750*****", // 应用归属的 tenant key，即租户唯一标识<br>"app_id": "cli_a5fb0ae6a4******" // 应用的 App ID<br>},<br>"event": { // 回调的详细信息<br>"operator": { // 	回调触发者信息<br>"tenant_key": "2df73991750*****", // 回调触发者的 tenant key，即租户唯一标识<br>"user_id": "867*****", // 回调触发者的 user ID当应用开启“获取用户 user ID”权限后，该参数返回<br>"open_id": "ou_3c14f3a59eaf2825dbe25359f15*****", // 	回调触发者的 Open ID<br>"union_id": "on_cad4860e7af114fb4ff6c5d496d*****" // 回调触发者的 Union ID<br>},<br>"token": "c-295ee57216a5dc9de90fefd0aadb4b1d7d******", // 更新卡片用的凭证，有效期为 30 分钟，最多可更新 2 次<br>"action": { // 用户操作交互组件回传的数据<br>"value": { // 如果组件中配置了 value （历史属性）或 behaviors 属性，则在此处返回自定义的回传交互参数<br>"key_1": "value_1"<br>},<br>"tag": "button", // 表单组件中按钮组件的标签。<br>"timezone": "Asia/Shanghai", // 用户当前所在地区的时区。<br>"form_value": { // 表单容器内用户提交的数据。以下为示例数据：<br>"DatePicker_bpqdq5puvn4": "2024-04-01 +0800", // 表单容器内日期选择器组件的表单项标识 name（开发者可自定义）和用户提交的日期 value<br>"DateTimePicker_ihz2d7a74i": "2024-04-29 07:07 +0800", // 表单容器内日期时间选择器组件的表单项标识 name（开发者可自定义）和用户提交的日期时间<br>"Input_lf4fmxwfrd9": "1234", // 表单容器内输入框组件的表单项标识 name（开发者可自定义）和用户提交的值<br>"PersonSelect_2ejys7ype7m": "ou_3c14f3a59eaf2825dbe25359f1595b00", // 表单容器内人员选择-单选组件的表单项标识 name（开发者可自定义）和用户提交的值<br>"Select_a2d5b7l3zd": "1", // 表单容器内下拉选择-单选组件的表单项标识 name（开发者可自定义）和用户提交的值<br>"TimePicker_7ecsf6xkqsq": "00:00 +0800"// 表单容器内时间选择器组件的表单项标识 name（开发者可自定义）和用户提交的时间<br>},<br>"name": "Button_lvkepfu3" // 表单容器中提交按钮的表单项标识 name<br>},<br>"host": "im_message", // 卡片展示场景<br>"context": { //  卡片展示场景相关信息<br>"open_message_id": "om_574d639e4a44e4dd646eaf628e2*****", // 卡片所在的消息 ID<br>"open_chat_id": "oc_e4d2605ca917e695f54f11aaf56*****" // 卡片所在的会话 ID<br>}<br>}<br>}<br>```<br>## 示例代码<br>以下 JSON 2.0 结构的示例代码可实现如下图所示的卡片效果：<br>![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/3431ef3f14bc707acaf00093f55df9b1_736bnZnIuR.png?height=491&lazyload=true&maxWidth=400&width=794)<br>```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "markdown",<br>"content": "**项目名称**：业务做大做强",<br>"text_align": "left",<br>"text_size": "normal",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "add-app_outlined",<br>"color": "grey"<br>}<br>},<br>{<br>"tag": "form",<br>"elements": [<br>{<br>"tag": "column_set",<br>"horizontal_spacing": "8px",<br>"horizontal_align": "left",<br>"columns": [<br>{<br>"tag": "column",<br>"width": "weighted",<br>"elements": [<br>{<br>"tag": "markdown",<br>"content": "**经办人***",<br>"text_align": "left",<br>"text_size": "normal",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "member_outlined",<br>"color": "light_grey"<br>}<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px",<br>"weight": 1<br>},<br>{<br>"tag": "column",<br>"width": "weighted",<br>"elements": [<br>{<br>"tag": "select_person",<br>"placeholder": {<br>"tag": "plain_text",<br>"content": "请选择"<br>},<br>"options": [],<br>"width": "fill",<br>"type": "default",<br>"required": true,<br>"name": "PersonSelect_rg0ml5mh"<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px",<br>"weight": 4<br>}<br>],<br>"margin": "16px 0px 16px 0px"<br>},<br>{<br>"tag": "column_set",<br>"horizontal_spacing": "8px",<br>"horizontal_align": "left",<br>"columns": [<br>{<br>"tag": "column",<br>"width": "weighted",<br>"elements": [<br>{<br>"tag": "markdown",<br>"content": "**优先级***",<br>"text_align": "left",<br>"text_size": "normal",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "msgcard-rectangle_outlined",<br>"color": "grey"<br>}<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px",<br>"weight": 1<br>},<br>{<br>"tag": "column",<br>"width": "weighted",<br>"elements": [<br>{<br>"tag": "select_static",<br>"placeholder": {<br>"tag": "plain_text",<br>"content": "请选择"<br>},<br>"options": [<br>{<br>"text": {<br>"tag": "plain_text",<br>"content": "P0"<br>},<br>"value": "1",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "sheet-iconsets-increase_filled"<br>}<br>},<br>{<br>"text": {<br>"tag": "plain_text",<br>"content": "P1"<br>},<br>"value": "P1",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "sheet-iconsets-stable_filled"<br>}<br>},<br>{<br>"text": {<br>"tag": "plain_text",<br>"content": "P2"<br>},<br>"value": "3",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "expand-down_filled"<br>}<br>}<br>],<br>"type": "default",<br>"width": "fill",<br>"required": true,<br>"name": "Select_01taxkgaqc6c"<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px",<br>"weight": 4<br>}<br>],<br>"margin": "16px 0px 16px 0px"<br>},<br>{<br>"tag": "column_set",<br>"horizontal_spacing": "8px",<br>"horizontal_align": "left",<br>"columns": [<br>{<br>"tag": "column",<br>"width": "weighted",<br>"elements": [<br>{<br>"tag": "markdown",<br>"content": "**项目评论**",<br>"text_align": "left",<br>"text_size": "normal",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "chat_outlined",<br>"color": "grey"<br>}<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px",<br>"weight": 1<br>},<br>{<br>"tag": "column",<br>"width": "weighted",<br>"elements": [<br>{<br>"tag": "input",<br>"placeholder": {<br>"tag": "plain_text",<br>"content": "请输入"<br>},<br>"default_value": "",<br>"width": "fill",<br>"name": "Input_0bqcy75cxklr",<br>"fallback": {<br>"tag": "fallback_text",<br>"text": {<br>"tag": "plain_text",<br>"content": "仅支持在 V6.8 及以上版本使用"<br>}<br>}<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px",<br>"weight": 4<br>}<br>],<br>"margin": "16px 0px 16px 0px"<br>},<br>{<br>"tag": "column_set",<br>"flex_mode": "bisect",<br>"horizontal_spacing": "8px",<br>"horizontal_align": "right",<br>"columns": [<br>{<br>"tag": "column",<br>"width": "auto",<br>"elements": [<br>{<br>"tag": "button",<br>"text": {<br>"tag": "plain_text",<br>"content": "提交"<br>},<br>"type": "primary_filled",<br>"width": "default",<br>"icon": {<br>"tag": "standard_icon",<br>"token": "thumbsup_outlined"<br>},<br>"form_action_type": "submit",<br>"name": "Button_lq544v6r"<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px"<br>},<br>{<br>"tag": "column",<br>"width": "auto",<br>"elements": [<br>{<br>"tag": "button",<br>"text": {<br>"tag": "plain_text",<br>"content": "取消"<br>},<br>"type": "default",<br>"width": "default",<br>"form_action_type": "reset",<br>"name": "Button_lq544v6s"<br>}<br>],<br>"padding": "0px 0px 0px 0px",<br>"vertical_spacing": "8px"<br>}<br>],<br>"margin": "0px 0px 0px 0px"<br>}<br>],<br>"name": "Form_lq544v6q",<br>"fallback": {<br>"tag": "fallback_text",<br>"text": {<br>"tag": "plain_text",<br>"content": "仅支持在 V6.6 及以上版本使用"<br>}<br>}<br>}<br>]<br>}<br>}<br>```


# 折叠面板

折叠面板允许在卡片中折叠次要信息，如备注、较长文本等，以突出主要信息。

本文档介绍折叠面板组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[折叠面板](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/containers/collapsible-panel)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/d72600eb4e82048a9e58b8354ca8303f_b0QmSYN4Jq.gif?height=660&lazyload=true&maxWidth=300&width=762)

## 注意事项

- 折叠面板仅支持通过撰写卡片 JSON 代码的方式使用，暂不支持在卡片搭建工具上构建使用。
- 容器类组件最多支持嵌套五层组件。建议你避免在折叠面板中嵌套多层组件。多层嵌套会压缩内容的展示空间，影响卡片的展示效果。

## 嵌套规则

折叠面板不支持内嵌表单容器（form）组件。

## 组件属性

本小节介绍折叠面板的属性。

### JSON 结构

折叠面板组件的完整 JSON 2.0 结构如下所示：
```json
{
  "schema": "2.0", // 卡片 JSON 结构的版本。默认为 1.0。要使用 JSON 2.0 结构，必须显示声明 2.0。
  "body": {
    "elements": [
      {
        "tag": "collapsible_panel", // 折叠面板的标签。
        "element_id": "custom_id", // 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用组件相关接口中指定组件。需开发者自定义。
        "direction": "vertical", // 面板内组件的排列方向。JSON 2.0 新增属性。可选值："vertical"（垂直排列）、"horizontal"（水平排列）。默认为 "vertical"。
        "vertical_spacing": "8px", // 面板内组件的垂直间距。JSON 2.0 新增属性。可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。
        "horizontal_spacing": "8px", // 面板内组件内的垂直间距。JSON 2.0 新增属性。可选值："small"(4px)、"medium"(8px)、"large"(12px)、"extra_large"(16px)或[0,99]px。
        "vertical_align": "top", // 面板内组件的垂直居中方式。JSON 2.0 新增属性。默认值为 top。
        "horizontal_align": "left", // 面板内组件的水平居中方式。JSON 2.0 新增属性。默认值为 left。
        "padding": "8px 8px 8px 8px", // 折叠面板的内边距。JSON 2.0 新增属性。支持范围 [0,99]px。
        "margin": "0px 0px 0px 0px", // 折叠面板的外边距。JSON 2.0 新增属性。默认值 "0"，支持范围 [-99,99]px。
        "expanded": true, // 面板是否展开。默认值 false。
        "background_color": "grey", // 折叠面板的背景色，默认为透明。
        "header": {
          // 折叠面板的标题设置。
          "title": {
            // 标题文本设置。支持 plain_text 和 markdown。
            "tag": "markdown",
            "content": "**面板标题文本**"
          },
          "background_color": "grey", // 标题区的背景色，默认为透明。
          "vertical_align": "center", // 标题区的垂直居中方式。
          "padding": "4px 0px 4px 8px", // 标题区的内边距。
          "position": "top", // 标题区的位置。
          "width": "auto", // 标题区的宽度。默认值为 fill。
          "icon": {
            // 标题前缀图标
            "tag": "standard_icon", // 图标类型.
            "token": "chat-forbidden_outlined", // 图标库中图标的 token。当 tag 为 standard_icon 时生效。
            "color": "orange", // 图标的颜色。当 tag 为 standard_icon 时生效。
            "img_key": "img_v2_38811724", // 自定义前缀图标的图片 key。当 tag 为 custom_icon 时生效。
            "size": "16px 16px" // 图标的尺寸。默认值为 10px 10px。
          },
          "icon_position": "follow_text", // 图标的位置。默认值为 right。
          "icon_expanded_angle": -180 // 折叠面板展开时图标旋转的角度，正值为顺时针，负值为逆时针。默认值为 180。
        },
        "border": {
          // 边框设置。默认不显示边框。
          "color": "grey", // 边框的颜色。
          "corner_radius": "5px" // 圆角设置。
        },
        "elements": [
          // 此处可添加各个组件的 JSON 结构。暂不支持表单（form）组件。
          {
            "tag": "markdown",
            "content": "很长的文本"
          }
        ]
      }
    ]
  }
}
```

### 字段说明

折叠面板各字段说明如下表所示：

名称 | 必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 否 | string | / | 组件的标签。折叠面板取固定值为 <code>collapsible_panel</code>。
expanded | 否 | Boolean | false | 面板是否展开。可选值：<br>- <code>true</code>：面板为展开状态<br>- <code>false</code>：面板为折叠状态。默认为折叠状态
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
margin | 否 | String | 0px | 容器的外边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示容器的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示容器的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示容器的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
horizontal_spacing | 否 | String | 8px | 容器内组件的水平间距，可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
horizontal_align | 否 | String | left | 容器内组件水平对齐的方式。可取值：<br>- left：左对齐<br>- center：居中对齐<br>- right：右对齐
vertical_spacing | 否 | String | 12px | 容器内组件的水平间距，可选值：<br>- small：小间距，4px<br>- medium：中等间距，8px<br>- large：大间距，12px<br>- extra_large：超大间距，16px<br>- 具体数值，如 20px。取值范围为 [0,99]px
vertical_align | 否 | String | top | 容器内组件垂直对齐的方式。可取值：<br>- top：上对齐<br>- center：居中对齐<br>- bottom：下对齐
direction | 否 | String | vertical | 容器的排列方向。可选值：<br>- vertical：垂直排列<br>- horizontal：水平排列
padding | 否 | String | 0px | 容器的内边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示容器的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示容器的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示容器的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
background_color | 否 | String | 空 | 折叠面板的背景色，默认为透明。枚举值参见[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。
header | 是 | Object | - | 折叠面板的标题设置。
└ title | 否 | Object | - | 标题文本设置。
└└ tag | 是 | String | 空 | 文本类型的标签。可取值：<br>- <code>plain_text</code>：普通文本内容<br>- <code>markdown</code>：富文本内容。了解支持的 Markdown 语法，参考[富文本组件](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/rich-text)。
└└ content | 否 | String | 空 | 折叠面板标题的内容。
└ background_color | 否 | String | 空 | 折叠面板标题区域的背景颜色设置，默认为透明色。枚举值参见[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。<br>**注意**：如果你未设置此字段，则折叠面板的标题区域的背景色由 <code>background_color</code> 字段决定。
└ width | 否 | String | fill | 标题元素的宽度。JSON 2.0 新增属性。支持飞书客户端 7.32 及以上版本。<br>- `fill`：标题和折叠面板等宽<br>- `auto`：标题自适应文本长度<br>- `auto_when_fold`：仅在折叠面板收起后，标题自适应文本长度
└ vertical_align | 否 | String | center | 标题区域的垂直居中方式。可取值：<br>- <code>top</code>：标题区域垂直居中于面板区域的顶部<br>- <code>center</code>：标题区域垂直居中于面板区域的中间<br>- <code>bottom</code>：标题区域垂直居中于面板区域的底部
└ padding | 否 | String | 0 | 标题区域的内边距。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示标题区的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示标题区的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示标题区的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
└ icon | 否 | Object | / | 添加图标作为标题前缀或后缀图标。支持自定义或使用图标库中的图标。示例代码如下：<br>```json<br>"icon": {<br>"tag": "standard_icon",<br>"token": "down-small-ccm_outlined",<br>"color": "",<br>"size": "16px 16px"<br>}<br>```
└└ tag | 否 | String | / | 图标类型的标签。可取值：<br>- <code>standard_icon</code>：使用图标库中的图标<br>- <code>custom_icon</code>：使用用自定义图片作为图标
└ └ token | 否 | String | / | 图标库中图标的 token。当 <code>tag</code> 为 <code>standard_icon</code> 时生效。枚举值参见[图标库](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-icons)。
└└ color | 否 | String | / | 图标的颜色。支持设置线性和面性图标（即 token 末尾为 <code>outlined</code> 或 <code>filled</code> 的图标）的颜色。当 <code>tag</code> 为 <code>standard_icon</code> 时生效。枚举值参见[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。
└└ img_key | 否 | String | / | 自定义前缀图标的图片 key。当 <code>tag</code> 为 <code>custom_icon</code> 时生效。图标 key 的获取方式：调用[上传图片](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create)接口，上传用于发送消息的图片，并在返回值中获取图片的 image_key。
└ └ size | 否 | String | 10px 10px | 图标的尺寸。支持 "[1,999] [1,999]px"。
└ icon_position | 否 | String | right | 图标的位置。可选值：<br>- <code>left</code>：图标在标题区域最左侧<br>- <code>right</code>：图标在标题区域最右侧<br>- <code>follow_text</code>：图标在文本右侧
└ icon_expanded_angle | 否 | Number | 180 | 折叠面板展开时图标旋转的角度，正值为顺时针，负值为逆时针。可选值：<br>- <code>-180</code>：逆时针旋转 180 度<br>- <code>-90</code>：逆时针旋转 90 度<br>- <code>90</code>：顺时针旋转 90 度<br>- <code>180</code>：顺时针旋转 180 度
border | 否 | Object | 空 | 边框设置。默认不显示边框。
└ color | 否 | String | grey | 边框颜色设置。枚举值参见[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。
└ corner_radius | 否 | String | 5px | 圆角设置。
elements | 否 | Array | 空 | 各个组件的 JSON 结构。暂不支持表单（form）组件。

## 示例代码

以下的 JSON 2.0 示例代码可实现如下图所示的卡片效果：

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/d72600eb4e82048a9e58b8354ca8303f_b0QmSYN4Jq.gif?height=660&lazyload=true&maxWidth=300&width=762)

```json
{
  "schema": "2.0",
  "header": {
    "template": "yellow",
    "title": {
      "tag": "plain_text",
      "content": "折叠面板展示"
    }
  },
  "body": {
    "elements": [
      {
        "tag": "markdown",
        "content": "下面是一个 默认折叠 的折叠面板组件"
      },
      {
        "tag": "collapsible_panel",
        "expanded": false,
        "header": {
          "title": {
            "tag": "plain_text",
            "content": "面板标题文本"
          },
          "vertical_align": "center",
          "icon": {
            "tag": "standard_icon",
            "token": "down-small-ccm_outlined",
            "color": "",
            "size": "16px 16px"
          },
          "icon_position": "right",
          "icon_expanded_angle": -180
        },
        "border": {
          "color": "grey",
          "corner_radius": "5px"
        },
        "vertical_spacing": "8px",
        "padding": "8px 8px 8px 8px",
        "elements": [
          {
            "tag": "markdown",
            "content": "很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本"
          }
        ]
      },
      {
        "tag": "markdown",
        "content": "下面是一个 标题带背景色 且 默认展开 的折叠面板组件"
      },
      {
        "tag": "collapsible_panel",
        "expanded": true,
        "header": {
          "title": {
            "tag": "markdown",
            "content": "**面板标题文本**"
          },
          "background_color": "yellow",
          "vertical_align": "center",
          "icon": {
            "tag": "standard_icon",
            "token": "down-small-ccm_outlined",
            "color": "white",
            "size": "16px 16px"
          },
          "icon_position": "right",
          "icon_expanded_angle": -180
        },
        "border": {
          "color": "grey",
          "corner_radius": "5px"
        },
        "vertical_spacing": "8px",
        "padding": "8px 8px 8px 8px",
        "elements": [
          {
            "tag": "markdown",
            "content": "很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本"
          }
        ]
      },
      {
        "tag": "markdown",
        "content": "下面是一个无边框折叠面板组件"
      },
      {
        "tag": "collapsible_panel",
        "expanded": true,
        "header": {
          "title": {
            "tag": "markdown",
            "content": "**面板标题文本**"
          },
          "width": "auto_when_fold",
          "vertical_align": "center",
          "padding": "4px 0px 4px 8px",
          "icon": {
            "tag": "standard_icon",
            "token": "down-small-ccm_outlined",
            "color": "",
            "size": "16px 16px"
          },
          "icon_position": "follow_text",
          "icon_expanded_angle": -180
        },
        "vertical_spacing": "8px",
        "padding": "8px 8px 8px 8px",
        "elements": [
          {
            "tag": "markdown",
            "content": "很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本很长的文本"
          }
        ]
      }
    ]
  }
}
```


# 标题组件

卡片的标题组件支持添加卡片主标题、副标题、后缀标签和标题图标。

本文档介绍标题组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[标题](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/title)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/1248b102c8dc22481356078d5c8cd77a_x5spX6NuaU.png?height=205&lazyload=true&maxWidth=500&width=714)

## 注意事项

同一张卡片仅支持添加一个标题组件。

## 组件属性

### JSON 结构

标题组件的完整 JSON 2.0 结构如下所示：
```json
{
  "schema": "2.0", // 卡片 JSON 结构的版本。默认为 1.0。要使用 JSON 2.0 结构，必须显示声明 2.0。
  "header": {
    "title": {
      // 卡片主标题。必填。要为标题配置多语言，参考配置卡片多语言文档。
      "tag": "plain_text", // 文本类型的标签。可选值：plain_text 和 lark_md。
      "content": "示例标题" // 标题内容。
    },
    "subtitle": {
      // 卡片副标题。可选。
      "tag": "plain_text", // 文本类型的标签。可选值：plain_text 和 lark_md。
      "content": "示例文本" // 标题内容。
    },
    "text_tag_list": [
      // 标题后缀标签，最多设置 3 个 标签，超出不展示。可选。
      {
        "tag": "text_tag",
        "element_id": "custom_id", // 操作元素的唯一标识。用于在调用组件相关接口中指定元素。需开发者自定义。
        "text": {
          // 标签内容
          "tag": "plain_text",
          "content": "标签 1"
        },
        "color": "neutral" // 标签颜色
      }
    ],
    "i18n_text_tag_list": {
      // 多语言标题后缀标签。每个语言环境最多设置 3 个 tag，超出不展示。可选。同时配置原字段和国际化字段，优先生效多语言配置。
      "zh_cn": [],
      "en_us": [],
      "ja_jp": [],
      "zh_hk": [],
      "zh_tw": []
    },
    "template": "blue", // 标题主题样式颜色。支持 "blue"|"wathet"|"turquoise"|"green"|"yellow"|"orange"|"red"|"carmine"|"violet"|"purple"|"indigo"|"grey"|"default"。默认值 default。
    "icon": { // 前缀图标。
      "tag": "standard_icon", // 图标类型。
      "token": "chat-forbidden_outlined", // 图标的 token。仅在 tag 为 standard_icon 时生效。
      "color": "orange", // 图标颜色。仅在 tag 为 standard_icon 时生效。
      "img_key": "img_v2_38811724" // 图片的 key。仅在 tag 为 custom_icon 时生效。
    },
    "padding": "12px 8px 12px 8px" // 标题组件的内边距。JSON 2.0 新增属性。默认值 "12px"，支持范围 [0,99]px。    
  }
}
```

### 字段说明

标题组件的字段说明如下表。

名称 | 必填 | 类型 | 说明
---|---|---|---
title | 是 | Object | 配置卡片的主标题信息。<br>**注意**：如果只配置副标题，则实际展示为主标题效果。
└ tag | 是 | String | 文本类型的标签。可取值：<br>- `plain_text`：普通文本内容或[表情](https://www.feishu.cn/docx/doxcnG6utI72jB4eHJF1s5IgVJf)<br>- `lark_md`：支持部分 Markdown 语法的文本内容。详情参考[lark_md 支持的 Markdown 语法](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/plain-text)
└ content | 否 | String | 卡片主标题内容。要为标题配置多语言，参考[配置卡片多语言](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/configure-multi-language-content)。<br>**注意**：主标题内容最多四行，超出四行的内容用 `...` 省略。
subtitle | 否 | Object | 配置卡片的副标题信息。<br>**注意**：如果只配置副标题，则实际展示为主标题效果。
└ tag | 是 | String | 文本类型的标签。可取值：<br>- `plain_text`：普通文本内容或[表情](https://www.feishu.cn/docx/doxcnG6utI72jB4eHJF1s5IgVJf)<br>- `lark_md`：支持部分 Markdown 语法的文本内容。详情参考[lark_md 支持的 Markdown 语法](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/plain-text)
└ content | 否 | String | 卡片副标题内容。要为标题配置多语言，参考[配置卡片多语言](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/configure-multi-language-content)。<br>**注意**：副标题内容最多一行，超出一行的内容用 `...` 省略。
text_tag_list | 否 | TextTagList | 添加标题的后缀标签。最多可添加 3 个标签内容，如果配置的标签数量超过 3 个，则取前 3 个标签进行展示。标签展示顺序与数组顺序一致。<br>**注意**：<br>`text_tag_lis`t 和 `i18n_text_tag_list` 只能配置其中之一。如果同时配置仅生效 `i18n_text_tag_list`。
└ tag | 是 | String | 后缀标签的标识。固定取值：`text_tag`。
└ element_id | 否 | String | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
└ text | 否 | Text Object | 后缀标签的内容。基于文本组件的 plain_text 模式定义内容。<br>示例值：<br>```JSON<br>"text": {<br>"tag": "plain_text",<br>"content": "这里是标签"<br>}<br>```
└ color | 否 | String | 后缀标签的颜色，默认为蓝色（blue）。可选值与示例效果参见下文的后缀标签颜色枚举。
i18n_text_tag_list | 否 | Object | 配置后缀标签的多语言属性，在所需语种字段下添加完整的后缀标签结构体即可。每个语言最多可配置 3 个标签内容，如果配置的标签数量超过 3 个，则取前 3 个标签进行展示。标签展示顺序与数组顺序一致。支持设置的多语言枚举值如下：<br>- zh_cn：简体中文<br>- en_us：英文<br>- ja_jp：日文<br>- zh_hk：繁体中文（中国香港）<br>- zh_tw：繁体中文（中国台湾）<br>- id_id: 印尼语<br>- vi_vn: 越南语<br>- th_th: 泰语<br>- pt_br: 葡萄牙语<br>- es_es: 西班牙语<br>- ko_kr: 韩语<br>- de_de: 德语<br>- fr_fr: 法语<br>- it_it: 意大利语<br>- ru_ru: 俄语<br>- ms_my: 马来语<br>示例配置：<br>```json<br>"i18n_text_tag_list": {<br>"zh_cn": [<br>{<br>"tag": "text_tag",<br>"text": {<br>"tag": "plain_text",<br>"content": "标签内容"<br>},<br>"color": "carmine"<br>}<br>],<br>"en_us": [<br>{<br>"tag": "text_tag",<br>"text": {<br>"tag": "plain_text",<br>"content": "Tag content"<br>},<br>"color": "carmine"<br>}<br>]<br>}<br>```<br>**注意**：<br>`text_tag_list` 和 `i18n_text_tag_list` 只能配置其中之一。如果同时配置两个字段，则优先生效多语言配置。
template | 否 | String | 配置标题主题颜色。可选值与示例效果参见下文的标题主题样式枚举。
icon | 否 | Object | 添加图标作为文本前缀图标。支持自定义或使用图标库中的图标。
└ tag | 否 | String | 图标类型的标签。可取值：<br>- `standard_icon`：使用图标库中的图标。<br>- `custom_icon`：使用用自定义图片作为图标。
└ token | 否 | String | 图标库中图标的 token。当 `tag` 为 `standard_icon` 时生效。枚举值参见[图标库](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-icons)。
└ color | 否 | String | 图标的颜色。支持设置线性和面性图标（即 token 末尾为 `outlined` 或 `filled` 的图标）的颜色。当 `tag` 为 `standard_icon` 时生效。枚举值参见[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。
└ img_key | 否 | String | 自定义前缀图标的图片 key。当 `tag` 为 `custom_icon` 时生效。<br>图标 key 的获取方式：调用[上传图片](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create)接口，上传用于发送消息的图片，并在返回值中获取图片的 image_key。
padding | 否 | String | 标题组件的内边距。默认为 12px。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示容器的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示容器的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示容器的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。

## Demo 示例

以下 JSON 2.0 结构的示例代码可实现如下图所示的卡片效果：

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/1248b102c8dc22481356078d5c8cd77a_x5spX6NuaU.png?height=205&lazyload=true&maxWidth=500&width=714)

```json
{
  "schema": "2.0",
  "body": {
    "elements": [
      {
        "tag": "div",
        "text": {
          "tag": "plain_text",
          "content": "示例文本"
        }
      }
    ]
  },
  "header": {
    "title": {
      "tag": "lark_md",
      "content": ":Partying:卡片主标题 "
    },
    "subtitle": {
      "tag": "plain_text",
      "content": "卡片副标题"
    },
    "text_tag_list": [
      {
        "tag": "text_tag",
        "text": {
          "tag": "plain_text",
          "content": "标签 1"
        },
        "color": "blue"
      },
      {
        "tag": "text_tag",
        "text": {
          "tag": "plain_text",
          "content": "标签 2"
        },
        "color": "turquoise"
      },
      {
        "tag": "text_tag",
        "text": {
          "tag": "plain_text",
          "content": "标签 3"
        },
        "color": "orange"
      }
    ],
    "template": "blue",
    "icon": {
      "tag": "standard_icon",
      "token": "larkcommunity_colorful"
    },
    "padding": "12px"
  }
}
```

## 枚举

### 标题主题样式枚举

标题组件中的 `template` 字段决定了卡片的标题主题样式。你可参考下表了解 `template` 的枚举值和对应的主题样式。
| 枚举值       | 主题样式示例                                                                                                                                                                                                                                                     |
| --------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| blue      | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/0218ae6ce097798e66a7e935dd6c3fda_Qp3mGHzkAo.png?height=207&lazyload=true&width=1080) |
| wathet    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/bbbbb1f21738968a210e3cd58f0ceac2_p0k04F30KQ.png?height=205&lazyload=true&width=1079) |
| turquoise | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/6c429bdc5d5b3b3fc67b1c348b15c5c9_ao09ktRD5Z.png?height=210&lazyload=true&width=1077) |
| green     | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/f19571778454b391c86e8faecb8b9fce_mLGWe9iNaH.png?height=209&lazyload=true&width=1078) |
| yellow    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/44ad929b370b06263ec09721ffde9fc2_OWDuBGcq9e.png?height=206&lazyload=true&width=1076) |
| orange    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/fddc48c22042f19def30a5ee9733940b_gz8S2BRH7t.png?height=207&lazyload=true&width=1074) |
| red       | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/c5c3959cbcbe8de8d3173c4a15fdf19b_VTI955Zjl2.png?height=206&lazyload=true&width=1075) |
| carmine   | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/f09a3ba6147dde821773dd612b0aedad_SGoLqjOAOD.png?height=203&lazyload=true&width=1078) |
| violet    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/9a13454a291cfa794a3a52306b603d68_RMp6KbXSEh.png?height=207&lazyload=true&width=1078) |
| purple    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/6845c6201575755e1684f149dc4a6772_xbdf7MlcdA.png?height=204&lazyload=true&width=1078) |
| indigo    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/36584f3f1ebf1838fa77db88413ba987_BOfl7QDd6J.png?height=206&lazyload=true&width=1074) |
| grey      | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/97c72de5dbe7161c054790bffc947271_kno5sxKnBD.png?height=205&lazyload=true&width=1078) |
| default   | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/f70ac3db3dab7db2096c7c23bcd04c99_Jr1xOkCYFB.png?height=183&lazyload=true&width=1074) |

### 后缀标签颜色枚举

标题的后缀标签的颜色样式由`text_tag_list` 或 `i18n_text_tag_list` 中的 `color` 字段定义，该字段支持的枚举值与示例样式如下表所示。
| 枚举值       | 颜色效果                                                                                                                                                                                                                                                       |
| --------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| neutral   | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/761076b831c55c5f94d2b56ebe8c04d9_TTBEjJgwKD.png?height=68&lazyload=true&width=84) |
| blue      | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/827883431ea1e65e5fcd73638cbb999a_4dFihzf2Sn.png?height=58&lazyload=true&width=92) |
| turquoise | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/c5f286dc2f7dc0b3a95b62f27bda62e9_TmN1D8GQCa.png?height=70&lazyload=true&width=96) |
| lime      | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/27dc172e5609fdc99d2a7e96c4a06c6f_rFFqBfYZla.png?height=74&lazyload=true&width=86) |
| orange    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/de108549d5b5c764994b540ecbb1353c_8ASPz3ARBu.png?height=78&lazyload=true&width=104) |
| violet    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/6ff286b66137b37745bd2e04cb5fbd1a_aawz4Ny9BN.png?height=80&lazyload=true&width=94) |
| indigo    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/ec24fb4da8d29c525505ab9db678694c_XG15qZBHv7.png?height=74&lazyload=true&width=108) |
| wathet    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/92241eb6dc69a648dd13bbac2bfe81fb_HAWERN9Msj.png?height=62&lazyload=true&width=94) |
| green     | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/3c5c32b28dc75e5a6ca52f96d60e188a_2PACPcYXge.png?height=78&lazyload=true&width=102) |
| yellow    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/f576ac38660f0a85ad22d66bdcaab9a2_6upVXxpn7E.png?height=60&lazyload=true&width=100) |
| red       | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/749a6988820ac78f7155f3f69bbc066b_N0TSK4RTdf.png?height=66&lazyload=true&width=98) |
| purple    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/e9aab9cb74258a506f66321fb085c144_xaCCNcz29R.png?height=88&lazyload=true&width=92) |
| carmine   | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/99ff5fbe1d5d92fce54c99bd6fecd5c2_HAymg3iX4b.png?height=70&lazyload=true&width=100) |

### 图标枚举

查看字段 `icon.token` 的枚举，参考[图标库](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-icons)。

### 图标颜色枚举

你可通过 `icon.color` 字段设置图标颜色。查看 `color` 枚举，参考[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。

## 标题主题样式建议

在群聊中，可使用彩色标题。对于需高亮提醒的卡片信息，可将标题配置为应用的品牌色或表达状态的语义色，增强信息的视觉锚点。
在单聊中，建议根据卡片的状态配置标题样式。你可以参考以下示例，配置不同语义下的主题样式。
| **样式颜色**   | **语义** | **示例**                                                                                                                                                                                                                                                     |
| ---------- | ------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 绿色（green）  | 完成或成功。 | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/a31e60bfc5fb550252b6f42bebcc4662_zWVSUkjCWn.png?height=392&lazyload=true&width=3278) |
| 橙色（orange） | 警告或警示。 | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/ff8c11ce1d512ff0dde102e7fe2a396b_hhWyoZJQqH.png?height=396&lazyload=true&width=3278) |
| 红色（red）    | 错误或异常。 | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/23fac81e7e6e1c0e0a7a3e80656aa196_CNFgcj7WF7.png?height=160&lazyload=true&width=1222) |
| 灰色（grey）   | 失效。    | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/641178505b8a01e1b1be859d8453330d_cZIp2uZa3G.png?height=150&lazyload=true&width=1218)


# 富文本组件

JSON 2.0 结构卡片的富文本（Markdown）组件支持渲染标题、表情、表格、图片、代码块、分割线等元素。
**注意事项**：本文档介绍富文本组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[富文本（Markdown）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/rich-text)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/e8b73582a4505b5d1e4b0a707aa41aa6_rrzqrVZJsX.png?height=653&lazyload=true&maxWidth=300&width=614)

## 注意事项
富文本 JSON 2.0 结构不再支持以下差异化跳转语法。你可使用含图标的链接语法（`<link></link>`）替代，如：
`<link icon='chat_outlined' url='https://applink.feishu.cn/client/chat/xxxxx' pc_url='' ios_url='' android_url=''>差异化链接</link>`。
```json
{
 "tag": "markdown",
 "href": {
  "urlVal": {
   "url": "xxx",
   "pc_url":"xxx",
   "ios_url": "xxx",
   "android_url": "xxx"
   }
  },
 "content":
 "[差异化跳转]($urlVal)"
}
```

## 组件属性

### JSON 结构

富文本组件的完整 JSON 2.0 结构如下所示：
```json
{
  "schema": "2.0", // 卡片 JSON 结构的版本。默认为 1.0。要使用 JSON 2.0 结构，必须显示声明 2.0。
  "body": {
    "elements": [
      {
        "tag": "markdown",
        "element_id": "custom_id", // 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用组件相关接口中指定组件。需开发者自定义。
        "margin": "0px 0px 0px 0px", // 组件的外边距，JSON 2.0 新增属性。默认值 "0"，支持范围 [-99,99]px。
        "content": "人员<person id = 'ou_449b53ad6aee526f7ed311b216aabcef' show_name = true show_avatar = true style = 'normal'></person>", // 采用 mardown 语法编写的内容。2.0 结构不再支持 "[差异化跳转]($urlVal)" 语法
        "text_size": "normal", // 文本大小。默认值 normal。支持自定义在移动端和桌面端的不同字号。
        "text_align": "left", // 文本对齐方式。默认值 left。
        "icon": {
          // 前缀图标。
          "tag": "standard_icon", // 图标类型。
          "token": "chat-forbidden_outlined", // 图标的 token。仅在 tag 为 standard_icon 时生效。
          "color": "orange", // 图标颜色。仅在 tag 为 standard_icon 时生效。
          "img_key": "img_v2_38811724" // 图片的 key。仅在 tag 为 custom_icon 时生效。
        }
      }
    ]
  }
}
```

### 字段说明

富文本组件包含的参数说明如下表所示。

字段名称 | 是否必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 是 | String | / | 组件的标签。富文本组件固定取值为 `markdown`。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
margin | 否 | String | 0 | 组件的外边距。JSON 2.0 新增属性。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示组件的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示组件的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示组件的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
text_align | 否 | String | left | 设置文本内容的对齐方式。可取值有：<br>* left：左对齐<br>* center：居中对齐<br>* right：右对齐
text_size | 否 | String | normal | 文本大小。可取值如下所示。如果你填写了其它值，卡片将展示为 `normal` 字段对应的字号。<br>- heading-0：特大标题（30px）<br>- heading-1：一级标题（24px）<br>- heading-2：二级标题（20 px）<br>- heading-3：三级标题（18px）<br>- heading-4：四级标题（16px）<br>- heading：标题（16px）<br>- normal：正文（14px）<br>- notation：辅助信息（12px）<br>- xxxx-large：30px<br>- xxx-large：24px<br>- xx-large：20px<br>- x-large：18px<br>- large：16px<br>- medium：14px<br>- small：12px<br>- x-small：10px
icon | 否 | Object | / | 添加图标作为文本前缀图标。支持自定义或使用图标库中的图标。
└ tag | 否 | String | / | 图标类型的标签。可取值：<br>-   `standard_icon`：使用图标库中的图标。<br>-   `custom_icon`：使用用自定义图片作为图标。
└ token | 否 | String | / | 图标库中图标的 token。当 `tag` 为 `standard_icon` 时生效。枚举值参见[图标库](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-icons)。
└ color | 否 | String | / | 图标的颜色。支持设置线性和面性图标（即 token 末尾为 `outlined` 或 `filled` 的图标）的颜色。当 `tag` 为 `standard_icon` 时生效。枚举值参见[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)。
└ img_key | 否 | String | / | 自定义前缀图标的图片 key。当 `tag` 为 `custom_icon` 时生效。<br>图标 key 的获取方式：调用[上传图片](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create)接口，上传用于发送消息的图片，并在返回值中获取图片的 image_key。
content | 是 | String | / | Markdown 文本内容。了解支持的语法，参考下文。

### Demo 示例

以下 JSON 2.0 结构的示例代码可实现如下图所示的卡片效果：

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/e8b73582a4505b5d1e4b0a707aa41aa6_7srlrpdZna.png?height=653&lazyload=true&maxWidth=300&width=614)

```json
{
  "schema": "2.0",
  "body": {
    "elements": [
      {
        "tag": "markdown",
        "content": "# 一级标题",
        "margin": "0px 0px 0px 0px", 
        "text_align": "left",
        "text_size": "normal"
      },
      {
        "tag": "markdown",
        "content": "标准emoji 😁😢🌞💼🏆❌✅\n飞书emoji :OK::THUMBSUP:\n*斜体* **粗体** ~~删除线~~ \n这是红色文本<\/font>\n<text_tag color=\"blue\">标签<\/text_tag>\n[文字链接](https:\/\/open.feishu.cn\/document\/server-docs\/im-v1\/message-reaction\/emojis-introduce)\n<link icon='chat_outlined' url='https:\/\/open.feishu.cn' pc_url='' ios_url='' android_url=''>带图标的链接<\/link>\n<at id=all><\/at>\n- 无序列表1\n    - 无序列表 1.1\n- 无序列表2\n1. 有序列表1\n    1. 有序列表 1.1\n2. 有序列表2\n```JSON\n{\"This is\": \"JSON demo\"}\n```"
      },
      {
        "tag": "markdown",
        "content": "行内引用`code`"
      },
      {
        "tag": "markdown",
        "content": "数字角标，支持 1-99 数字<number_tag background_color='grey' font_color='white' url='https://open.feishu.cn'  pc_url='https://open.feishu.cn' android_url='https://open.feishu.cn' ios_url='https://open.feishu.cn'>1</number_tag>"
      },
      {
        "tag": "markdown",
        "content": "默认数字角标展示<number_tag>1</number_tag>"
      },
      {
        "tag": "markdown",
        "content": "人员<person id = 'ou_449b53ad6aee526f7ed311b216a8f88f' show_name = true show_avatar = true style = 'normal'></person>"
      },
      {
        "tag": "markdown",
        "content": "> 这是一段引用文字\n引用内换行 \n"
      }
    ]
  }
}
```

## 支持的 Markdown 语法

[卡片 JSON 2.0 结构](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-structure)支持除 `HTMLBlock` 外所有标准的 Markdown 语法和部分 HTML 语法。了解 Markdown 标准语法，请参考 [CommonMark Spec 官方文档](https://spec.commonmark.org/0.31.2/)。你也可以使用 [CommonMark playground](https://spec.commonmark.org/dingus/) 预览 Markdown 效果。

注意，在卡片的富文本组件中，以下语法的渲染效果与 CommonMark 有差异：

- 富文本组件支持使用一个 Enter 键作为软换行（Soft Break）；支持两个 Enter 键作为硬换行（Hard Break）。软换行在渲染时可能会被忽略，具体取决于渲染器如何处理；硬换行在渲染时始终会显示为一个新行。

- 2.0 结构支持以下 HTML 语法：
    - 开标签 `<br>`
    - 自闭合标签 `<br/>`
    - 开标签 `<hr>`
    - 自闭合标签 `<hr/>`
    - 闭合标签 `<person></person>`
    - 闭合标签 `<local_datetime></local_datetime>`
    - 闭合标签 `<at></at>`
    - 闭合标签 `<a></a>`
    - 闭合标签 `<text_tag></text_tag>`
    - 闭合标签 `<raw></raw>`
    - 闭合标签 `<link></link>`
    - 闭合标签 `<font>`，支持嵌套其它标签，如 `red<font color=green>greenagain</font>`。其它标签包括：
        - 闭合标签 `<local_datetime></local_datetime>`
        - 闭合标签 `<at></at>`
        - 闭合标签 `<a></a>`
        - 闭合标签 `<link></link>`
        - 闭合标签 `<font></font>`

以下是一些常见的渲染效果及其对应的 Markdown 或 HTML 语法。

名称 | 语法 | 效果 | 注意事项
---|---|---|---
换行 | ```<br>第一行<br />第二行<br>第一行<br>第二行<br>``` | 第一行<br>第二行 | - 如果你使用卡片 JSON 构建卡片，也可使用字符串的换行语法 `\n` 换行。<br>- 如果你使用卡片搭建工具构建卡片，也可使用回车键换行。
斜体 | ```<br>*斜体*<br>``` | *斜体* | 无
加粗 | ```<br>**粗体** <br>或<br>__粗体__ <br>``` | __粗体__ | - 不要连续使用 4 个 `*` 或 `_` 加粗。该语法不规范，可能会导致渲染不正确。<br>- 若加粗效果未显示，请确保加粗语法前后保留一个空格。
删除线 | ```<br>~~删除线~~<br>``` | ~~删除线~~ | 无
@指定人 | ```<br><at id=open_id></at><br><at id=user_id></at><br><at ids=id_01,id_02,xxx></at><br><at email=test@email.com></at><br>``` | @用户名 | - 该语法用于在卡片中实现 @ 人的效果，被 @ 的用户将收到提及通知。但对于转发的卡片，用户将不再收到提及通知。<br>- 要在卡片中展示人员的用户名、头像、个人名片等，你可使用[人员](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/user-profile)或[人员列表](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/user-list)组件。但人员和人员列表组件仅作为展示，用户不会收到提及通知。<br>- [自定义机器人](https://open.feishu.cn/document/ukTMukTMukTM/ucTM5YjL3ETO24yNxkjN)仅支持使用 `open_id`、`user_id` @指定人。<br>- 支持使用 `<at ids=id_01,id_02,xxx></at>` 传入多个 ID，使用 `,` 连接。<br>- 了解如何获取 user_id、open_id，参考[如何获取不同的用户 ID](https://open.feishu.cn/document/home/user-identity-introduction/open-id)。
@所有人 | ```<br><at id=all></at><br>``` | @所有人 | @所有人需要群主开启权限。若未开启，卡片将发送失败。
超链接 | ```<br><a href='https://open.feishu.cn'><br></a><br>``` | [https://open.feishu.cn](https://open.feishu.cn) | - 超链接必须包含 schema 才能生效，目前仅支持 HTTP 和 HTTPS。<br>- 超链接文本的颜色不支持自定义。
彩色文本样式 | ```<br>这是一个绿色文本 <br>这是一个红色文本<br>这是一个灰色文本<br>``` | ![](https://p9-arcosite.byteimg.com/tos-cn-i-goo7wpa0wc/3cb544894ff14bd08697aba80d8e45e6~tplv-goo7wpa0wc-image.image?height=46&lazyload=true&width=206)<br>![](https://p9-arcosite.byteimg.com/tos-cn-i-goo7wpa0wc/20cf2f954cc34e79b1a9083ddf1c5838~tplv-goo7wpa0wc-image.image?height=46&lazyload=true&width=200)<br>![](https://p9-arcosite.byteimg.com/tos-cn-i-goo7wpa0wc/4c1721ac3ea6437fb52661d0f59d5b63~tplv-goo7wpa0wc-image.image?height=40&lazyload=true&width=192) | * 彩色文本样式不支持对链接中的文本生效<br>* color 取值：<br>-   **default**：默认的白底黑字样式<br>- 卡片支持的颜色枚举值和 RGBA 语法自定义颜色。参考[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)
可点击的电话号码 | ```<br>[文本展示的电话号码或其他文案内容](tel://移动端弹窗唤起的电话号码)<br>``` | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/497e911ac70982442571a2671c7c178c_5i91YqPxhx.png?height=99&lazyload=true&width=789) | 该语法仅在移动端生效。
文字链接 | ```<br>[开放平台](https://open.feishu.cn/)<br>``` | [开放平台](https://open.feishu.cn/) | 超链接必须包含 schema 才能生效，目前仅支持 HTTP 和 HTTPS。
差异化跳转链接 | ```<br>{<br>"tag": "markdown",<br>"href": {<br>"urlVal": {<br>"url": "xxx",<br>"pc_url":"xxx",<br>"ios_url": "xxx",<br>"android_url": "xxx"<br>}<br>},<br>"content":<br>"[差异化跳转]($urlVal)"<br>}<br>``` | \- | * 超链接必须包含 schema 才能生效，目前仅支持 HTTP 和 HTTPS。<br>- 仅在 PC 端、移动端需要跳转不同链接时使用。
图片 | ```<br>![hover_text](image_key)<br>``` |  | * `hover_text` 指在 PC 端内光标悬浮（hover）图片所展示的文案。<br>* **image_key** 可以调用[上传图片](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create)接口获取。
分割线 | ```<br><hr><br>或<br>---<br>``` | ![](https://p9-arcosite.byteimg.com/tos-cn-i-goo7wpa0wc/337cdbabf3944d4facd505a9f9883352~tplv-goo7wpa0wc-image.image?height=62&lazyload=true&width=346) | - 推荐使用 `<hr>` 语法<br>- 分割线必须单独一行使用。即如果分割线前后有文本，你必须在分割线前后添加换行符。
飞书表情 | ```<br>:DONE:<br>``` | ![](https://sf3-ttcdn-tos.pstatp.com/obj/lark-reaction-cn/emoji_done.png?height=96&lazyload=true&width=96) | 支持的 Emoji Key 列表可以参看 [表情文案说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)。
标签 | ```<br><text_tag color='red'>标签文本</text_tag><br>``` |  | `color`支持的枚举值范围包括：<br>- `neutral`: 中性色<br>- `blue`: 蓝色<br>- `turquoise`: 青绿色<br>- `lime`: 酸橙色<br>- `orange`: 橙色<br>- `violet`: 紫罗兰色<br>- `indigo`: 靛青色<br>- `wathet`: 天蓝色<br>- `green`: 绿色<br>- `yellow`: 黄色<br>- `red`: 红色<br>- `purple`: 紫色<br>- `carmine`: 洋红色
有序列表 | ```<br>1. 有序列表1<br>1. 有序列表 1.1<br>2. 有序列表2<br>``` | 1. 有序列表1<br>1. 有序列表 1.1<br>2. 有序列表2 | * 序号需在行首使用<br>* 4 个空格代表一层缩进
无序列表 | ```<br>- 无序列表1<br>- 无序列表 1.1<br>- 无序列表2<br>```<br>在卡片 JSON 中，需添加 `\n` 换行符：<br>```<br>\n- 无序列表1\n    - 无序列表 1.1\n- 无序列表2\n1. 有序列表1\n<br>``` | - 无序列表1<br>- 无序列表 1.1<br>- 无序列表2 | * 序号需在行首使用<br>* 4 个空格代表一层缩进
代码块 | `````markdown<br>```JSON<br>{"This is": "JSON demo"}<br>```<br>````` | ```JSON<br>{"This is": "JSON demo"}<br>``` | * 代码块语法和代码内容需在行首使用<br>* 支持指定编程语言解析。未指定默认为 Plain Text<br>- 四个及以上空格（[缩进式代码块语法](https://spec.commonmark.org/0.30/#indented-code-blocks)）也将触发代码块效果
含图标的链接 | ```<br><link icon='chat_outlined' url='https://open.feishu.cn' pc_url='' ios_url='' android_url=''>战略研讨会</link><br>``` | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/e6b63f8c225ce6c4cd09dbdc8158397f_HPk70nRLtr.png?height=97&lazyload=true&width=736) | 该语法中的字段说明如下所示：<br>- `icon`：链接前缀的图标。仅支持图标库中的图标，枚举值参见[图标库](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-icons)。图标颜色固定为蓝色。可选。<br>- `url`：默认的链接地址，未按设备配置下述字段时，该配置生效。必填。<br>- `pc_url`：pc 端的链接地址，优先级高于 `url`。可选。<br>- `ios_url`：ios 端的链接地址，优先级高于 `url`。可选。<br>- `android_url`：android 端的链接地址，优先级高于 `url`。可选。
人员 | `````markdown<br><person id = 'user_id' show_name = true show_avatar = true style = 'normal'></person><br>````` | ![image.png](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/85c9e79807d0195cd3ecb331a965f418_eFVjQrqRjv.png?height=95&lazyload=true&width=736) | 该语法中的字段说明如下所示：<br>- `id`：用户的 ID，支持 open_id、union_id 和 user_id。不填、为空、数据错误时展示为兜底的“未知用户”样式。了解更多，参考[如何获取不同的用户 ID](https://open.feishu.cn/document/home/user-identity-introduction/open-id)。<br>- `show_name`：是否展示用户名。默认为 true。<br>- `show_avatar`：是否展示用户头像，默认为 true。<br>- `style`：人员组件的展示样式。可选值有：<br>- `normal`：普通样式（默认）<br>- `capsule`：胶囊样式
标题 | ```<br># 一级标题<br>## 二级标题<br>###### 六级标题<br>``` | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/9f20da4d88e999dd95fb3afa7e7c178e_QzyatvgRcl.png?height=113&lazyload=true&width=725) | 支持一级到 6 级标题。从一级到六级的字号梯度为 26, 22 , 20, 18, 17, 14px。
引用 | ```<br>>[空格]这是一段引用文字\n引用内换行<br>``` | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/3551041c80d4879301b805e1c78d5c0d_OrdqP5rWoe.png?height=84&lazyload=true&width=209) | 
行内引用 | ```<br>`code`<br>``` | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/b89bc8e45736ed3d48707591cb109383_TBPlo20031.png?height=48&lazyload=true&width=104) | 
表格 | ```<br>| Syntax | Description |<br>| -------- | -------- |<br>| Paragraph | Text |<br>| Paragraph | Text |<br>| Paragraph | Text |<br>| Paragraph | Text |<br>| Paragraph | Text |<br>| Paragraph | Text |<br>``` | ![image.png](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/8f518b1bfa0e2f217893c379d4c5e07a_6SH7H9f5ew.png?height=411&lazyload=true&maxWidth=200&width=882) | - 除标题行外，最多展示五行数据，超出五行将分页展示。不支持自定义。<br>- 该语法仅支持 JSON 2.0 结构。<br>- 单个富文本组件中，最多可放置四个表格。<br>- 表格的富文本语法不支持设置列宽等。要设置列宽、数据对齐方式等，可使用[表格](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/table)组件。
数字角标 | `````markdown<br><number_tag>1</number_tag><br>`````<br>`````markdown<br><number_tag background_color='grey' font_color='white' url='https://open.feishu.cn'  pc_url='https://open.feishu.cn' android_url='https://open.feishu.cn' ios_url='https://open.feishu.cn'>1</number_tag>````` | ![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/d97f3d4f1c0e73bb5fb7a267b1a4ecf7_tLSJTnxEsn.png?height=45&lazyload=true&width=141) | 数字圆形角标，支持添加 0-99 之间的数字。该语法中的字段说明如下所示：<br>- `background_color`：圆圈内的背景颜色。可选。<br>- `font_color`：数字颜色。可选。<br>- `url`：点击角标时默认的跳转链接，未按设备配置下述字段时，该配置生效。可选。<br>- `pc_url`：点击角标时 PC 端的跳转链接，优先级高于 `url`。可选。<br>- `ios_url`：点击角标时 iOS 端的跳转链接，优先级高于 `url`。可选。<br>- `android_url`：点击角标时 Android 端的跳转链接，优先级高于 `url`。可选。
国际化时间 | ```<br><local_datetime millisecond='' format_type='date_num' link='https://www.feishu.com'></local_datetime><br>``` | ![image.png](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/0dd7459a8fa40a1c83e6394f2f531136_HJ5KJcYUFU.png?height=362&lazyload=true&maxWidth=200&width=685) | 国际化时间标签。支持自动展示用户当地时区下的时间。该语法中的字段说明如下所示：<br>-   `millisecond`：要展示的时间的 Unix 毫秒时间戳。若不填，则：<br>- 对于使用卡片 JSON 发送的卡片，默认展示发送卡片时的时间<br>- 对于使用搭建工具搭建的卡片，默认展示卡片发布的时间<br>- `format_type`：定义时间展示的格式。默认使用数字展示，如：`2019-03-15`。枚举值如下所示：<br>- `date_num`：用数字表示的日期，例如 `2019-03-15`。<br>- `date_short`：不含年份的简写日期，支持多语种自动适配，例如 `3月15日`、`Mar 15`。<br>- `date`：完整国际化日期文案，支持多语种自动适配，例如 `2019年3月15日`、`Mar 15, 2019`。<br>- `week`：完整星期文案，支持多语种自动适配，例如 `星期二`、`Tuesday`。<br>- `week_short`：简写星期文案，支持多语种自动适配，例如 `周二`、`Tue`。<br>- `time`：时间（小时:分钟）文案，例如 `13:42`。<br>- `time_sec`：时间（小时:分钟:秒）文案，例如 `13:42:53`。<br>- `timezone`：设备所属时区，格式为 `GMT±hh:mm`，例如 `GMT+8:00`。<br>- `link`：点击该时间时跳转的链接地址。
音频 | ```<br><audio file_key='file_v3_xxx' audio_id='1' show_time=true style='normal' background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/' fallback_pc_url='https://open.feishu.cn/' fallback_ios_url='https://open.feishu.cn/' fallback_android_url='https://open.feishu.cn/' fallback_harmony_url='https://open.feishu.cn/' fallback_text='[音频链接]'></audio><br>```<br>参考本文末尾了解音频语法使用示例。 | - style 为 normal 时：<br>![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/c3911916d8534552e41f2c39cfed2f70_6yFptFISbo.png?height=130&lazyload=true&maxWidth=100&width=384)<br>- style 为 speak 时：<br>![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/e73b0599063b809363aa3d433b17530f_wSGfHVe0q3.png?height=120&lazyload=true&maxWidth=100&width=354) | 富文本内嵌音频播放器。该语法中的字段说明如下所示：<br>- `file_key`：音频文件 key，需通过[上传文件](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/file/create)获取。详情参考[音频](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/audio)组件。必填。<br>- `audio_id`：音频实例唯一标识，使用方式同[音频](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-json-v2-components/content-components/audio)组件。可选。<br>- `show_time`：是否显示时长。可选，默认值为 false。<br>- `style`：音频样式。可选，支持以下值：<br>- `normal`：默认值，三角形播放按钮样式<br>- `speak`：语音样式<br>- `background_color`：组件背景颜色。可选。支持 default、[颜色枚举值](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/enumerations-for-fields-related-to-color)和 RGBA 语法自定义颜色。<br>- `fill_color`：图标和时间颜色。可选。支持颜色枚举值和 RGBA 语法自定义颜色。 <br>- `fallback_text`：在低于飞书 V7.49.0 版本客户端上，音频播放器将展示为文字链接。你可设置文本和 URL，引导用户点击链接访问音频。该字段指定显示文本。可选。若不指定，则低版本客户端展示时将丢弃该组件。<br>- `fallback_url`：在低于飞书 V7.49.0 版本客户端上，音频播放器将展示为文字链接。你可设置文本和 URL，引导用户点击链接访问音频。该字段指定文字链接的兜底 URL。若指定`fallback_text`，则必须指定 `fallback_url`。<br>- `fallback_pc_url`：为 PC 端低版本客户端上的音频播放器额外指定 URL，可选。优先级高于兜底的 `fallback_url`。<br>- `fallback_ios_url`：为 iOS 端低版本客户端上的音频播放器额外指定 URL，可选。优先级高于兜底的 `fallback_url`。<br>- `fallback_android_url`：为 Android 端低版本客户端上的音频播放器额外指定 URL，可选。优先级高于兜底的 `fallback_url`。<br>- `fallback_harmony_url`：为原生鸿蒙端低版本客户端上的音频播放器额外指定 URL，可选。优先级高于兜底的 `fallback_url`。

### 特殊字符转义说明
如果要展示的字符命中了 markdown 语法使用的特殊字符（例如 `*、~、>、<` 这些特殊符号），需要对特殊字符进行 HTML 转义，才可正常展示。常见的转义符号对照表如下所示。查看更多转义符，参考 [HTML 转义通用标准](https://www.w3school.com.cn/charsets/ref_html_8859.asp)实现，转义后的格式为 `&#实体编号;`。

| **特殊字符** | **转义符** | **描述** |
| --- | --- | --- |
| ` ` | `&nbsp;        ` | 不换行空格 |
| ` ` | `&ensp;` | 半角空格 |
| `  ` | `&emsp;` | 全角空格 |
| `>` | `&#62;` | 大于号 |
| `<` | `&#60;` | 小于号 |
| `~` | `&sim;` | 飘号 |
| `-` | `&#45;` | 连字符 |
| `!` | `&#33;` | 惊叹号 |
| `*` | `&#42;` | 星号 |
| `/` | `&#47;` | 斜杠 |
| `\` | `&#92;` | 反斜杠 |
| `[` | `&#91;` | 中括号左边部分 |
| `]` | `&#93;` | 中括号右边部分 |
| `(` | `&#40;` | 小括号左边部分 |
| `)` | `&#41;` | 小括号右边部分 |
| `#` | `&#35;` | 井号 |
| `:` | `&#58;` | 冒号 |
| `+` | `&#43;` | 加号 |
| `"` | `&#34;` | 英文引号 |
| `'` | `&#39;` | 英文单引号 |
| \`  | `&#96;` | 反单引号 |
| `$` | `&#36;` | 美金符号 |
| `_` | `&#95;` | 下划线 |
| `-` | `&#45;` | 无序列表 |

### 代码块支持的编程语言

富文本组件支持通过代码块语法渲染代码，支持的编程语言如下列表所示，且对大小写不敏感：
`````markdown
```JSON
{"This is": "JSON demo"}
```
`````
- plain_text 
- abap 
- ada 
- apache 
- apex 
- assembly 
- bash 
- c_sharp 
- cpp 
- c 
- cmake
- cobol 
- css 
- coffee_script 
- d 
- dart 
- delphi 
- diff 
- django 
- docker_file 
- erlang
- fortran 
- gherkin 
- go 
- graphql 
- groovy 
- html 
- htmlbars 
- http 
- haskell 
- json 
- java
- javascript 
- julia 
- kotlin 
- latex 
- lisp 
- lua 
- matlab 
- makefile 
- markdown 
- nginx 
- objective_c
- opengl_shading_language 
- php 
- perl 
- powershell 
- prolog 
- properties 
- protobuf 
- python 
- r 
- ruby
- rust 
- sas 
- scss 
- sql 
- scala 
- scheme 
- shell 
- solidity 
- swift 
- toml 
- thrift 
- typescript
- vbscript 
- visual_basic 
- xml 
- yaml
## 为移动端和桌面端定义不同的字号

在普通文本组件和富文本组件中，你可为同一段文本定义在移动端和桌面端的不同字号。相关字段描述如下表所示。

字段 | 是否必填 | 类型 | 默认值 | 说明
---|---|---|---|---
text_size | 否 | Object | / | 文本大小。你可在此自定义移动端和桌面端的不同字号。
└ custom_text_size_name | 否 | Object | / | 自定义的字号。你需自定义该字段的名称，如 `cus-0`、`cus-1` 等。
└└ default | 否 | String | / | 在无法差异化配置字号的旧版飞书客户端上，生效的字号属性。建议填写此字段。可取值如下所示。<br>- heading-0：特大标题（30px）<br>- heading-1：一级标题（24px）<br>- heading-2：二级标题（20 px）<br>- heading-3：三级标题（18px）<br>- heading-4：四级标题（16px）<br>- heading：标题（16px）<br>- normal：正文（14px）<br>- notation：辅助信息（12px）<br>- xxxx-large：30px<br>- xxx-large：24px<br>- xx-large：20px<br>- x-large：18px<br>- large：16px<br>- medium：14px<br>- small：12px<br>- x-small：10px
└└ pc | 否 | String | / | 桌面端的字号。可取值如下所示。<br>- heading-0：特大标题（30px）<br>- heading-1：一级标题（24px）<br>- heading-2：二级标题（20 px）<br>- heading-3：三级标题（18px）<br>- heading-4：四级标题（16px）<br>- heading：标题（16px）<br>- normal：正文（14px）<br>- notation：辅助信息（12px）<br>- xxxx-large：30px<br>- xxx-large：24px<br>- xx-large：20px<br>- x-large：18px<br>- large：16px<br>- medium：14px<br>- small：12px<br>- x-small：10px
└└ mobile | 否 | String | / | 移动端的文本字号。可取值如下所示。<br>**注意**：部分移动端的字号枚举值的具体大小与 PC 端有差异，使用时请注意区分。<br>- heading-0：特大标题（26px）<br>- heading-1：一级标题（24px）<br>- heading-2：二级标题（20 px）<br>- heading-3：三级标题（17px）<br>- heading-4：四级标题（16px）<br>- heading：标题（16px）<br>- normal：正文（14px）<br>- notation：辅助信息（12px）<br>- xxxx-large：26px<br>- xxx-large：24px<br>- xx-large：20px<br>- x-large：18px<br>- large：17px<br>- medium：14px<br>- small：12px<br>- x-small：10px

具体步骤如下所示。
1. 在卡片 JSON 代码的全局行为设置中的 `config` 字段中，配置 `style` 字段，并添加自定义字号：
    ```json
    {
      "config": {
        "style": { // 在此添加并配置 style 字段。
          "text_size": { // 分别为移动端和桌面端添加自定义字号，同时添加兜底字号。用于在组件 JSON 中设置字号属性。支持添加多个自定义字号对象。
            "cus-0": {
              "default": "medium", // 在无法差异化配置字号的旧版飞书客户端上，生效的字号属性。选填。
              "pc": "medium", // 桌面端的字号。
              "mobile": "large" // 移动端的字号。
            },
            "cus-1": {
              "default": "medium", // 在无法差异化配置字号的旧版飞书客户端上，生效的字号属性。选填。
              "pc": "normal", // 桌面端的字号。
              "mobile": "x-large" // 移动的字号。
            }
          }
        }
      }
    }
    ```
1. 在普通文本组件或富文本组件的 `text_size` 属性中，应用自定义字号。以下为在富文本组件中应用自定义字号的示例：
    ```json
    {
      "elements": [
        {
          "tag": "markdown",
          "text_size": "cus-0", // 在此处应用自定义字号。
          "href": {
            "urlVal": {
              "url": "xxx1",
              "pc_url": "xxx2",
              "ios_url": "xxx3",
              "android_url": "xxx4"
            }
          },
          "content": "普通文本\n标准emoji😁😢🌞💼🏆❌✅\n*斜体*\n**粗体**\n~~删除线~~\n文字链接\n差异化跳转\n<at id=all></at>"
        },
        {
          "tag": "hr"
        },
        {
          "tag": "markdown",
          "content": "上面是一行分割线\n!hover_text\n上面是一个图片标签"
        }
      ],
      "header": {
        "template": "blue",
        "title": {
          "content": "这是卡片标题栏",
          "tag": "plain_text"
        }
      }
    }
    ```

## 富文本语法使用示例

### 音频

以下富文本语法示例代码可实现如下图所示的卡片效果。请将 `file_key` 替换为实际值后再查看效果。获取音频文件 `file_key` 时，请确保调用[上传文件](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/file/create)接口的应用与发送卡片的应用一致。

![image.png](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/8d7c3f4f3fe7f7ffe4f8f91b195a5b1b_pbRNEOkbKW.png?height=1161&lazyload=true&maxWidth=494&width=694)

```json
{
  "schema": "2.0",
  "config": {
    "wide_screen_mode": true,
    "enable_forward": false,
    "update_multi": true,
    "enable_forward_interaction": true,
    "style": {
      "color": {
        "color_0": {
          "light_mode": "rgba(20,86,240,1.000000)",
          "dark_mode": "rgba(20,86,240,1.000000)"
        },
        "color_1": {
          "light_mode": "rgba(149,229,153,1.000000)",
          "dark_mode": "rgba(149,229,153,1.000000)"
        },
        "color_2": {
          "light_mode": "rgba(253,198,196,1.000000)",
          "dark_mode": "rgba(253,198,196,1.000000)"
        }
      }
    }
  },
  "body": {
    "direction": "vertical",
    "padding": "12px 12px 12px 12px",
    "elements": [
      {
        "tag": "markdown",
        "content": "参数全默认效果示例：\n<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='1' >",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "显示时间示例：\n<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='111' show_time=true >",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "自定义颜色 background_color='rgba(20,86,240,1.000000)' fill_color='rgba(253,198,196,1.000000)' 示例：\n<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='2' show_time=true background_color='color_0' fill_color='color_2'>",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "使用颜色枚举值 background_color='grey-200' fill_color='blue-800' 示例：\n<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='3' show_time=true background_color='grey-200' fill_color='blue-800'>",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "播放器按钮语音样式（style=speak）示例：\n<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='5' show_time=true style='speak' >",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "低于飞书 V7.49 版本，设置兜底文本与链接示例：\n<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='6' show_time=true fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "#### 不同字体下，音频播放器大小示例：",
        "text_align": "left"
      },
      {
        "tag": "markdown",
        "content": "heading-0<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='7' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "heading-0"
      },
      {
        "tag": "markdown",
        "content": "heading-1<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='8' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "heading-1"
      },
      {
        "tag": "markdown",
        "content": "heading-2<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='9' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "heading-2"
      },
      {
        "tag": "markdown",
        "content": "heading-3<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='10' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "heading-3"
      },
      {
        "tag": "markdown",
        "content": "heading<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='11' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "heading"
      },
      {
        "tag": "markdown",
        "content": "normal<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='12' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "normal"
      },
      {
        "tag": "markdown",
        "content": "notation<audio file_key='file_v3_00or_f2c1276b-9f24-463d-8911-xxxxxxxx' audio_id='13' show_time=true background_color='grey-200' fill_color='blue-800' fallback_url='https://open.feishu.cn/'> fallback_text='[音频链接]'",
        "text_align": "left",
        "text_size": "notation"
      }
    ]
  },
  "header": {
    "title": {
      "tag": "plain_text",
      "content": "Markdown 音频播放器示例"
    },
    "template": "blue",
    "padding": "12px 12px 12px 12px"
  }
}
```  

# 图表组件

飞书卡片提供的图表组件基于 [VChart](https://www.visactor.io/) 的图表定义，支持折线图、面积图、柱状图、饼图、词云等多种数据呈现方式，帮助你可视化各类信息，提高信息沟通效率。

本文档介绍图表组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[图表](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/chart)。

![Frame 1321318175.png](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/ebf954a9756b7e0add5625832dcf9f06_bA4PiVAffn.png?height=1112&lazyload=true&maxWidth=600&width=2160)

## 注意事项

- 单张卡片建议最多放置五个图表组件。
- 图表组件暂不支持 JavaScript 语法。
- 移动端暂不支持以下 VChart 相关属性，若在图表组件中指定以下 VChart 属性，图表将在移动端加载失败：
	- [纹理属性（barChart.bar.style.texture）](https://www.visactor.io/vchart/option/barChart#bar.style.texture)
	- [圆锥渐变属性](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Series/Mark)，即 gradient 设为 `conical`
	- [形状词云基于 grid 像素布局](https://www.visactor.io/vchart/option/wordCloudChart#wordCloudConfig.layoutMode)，即 `wordCloudChart.wordCloudConfig.layoutMode` 设为 `grid`
	- [extensionMark 图片的 repeat 属性](https://www.visactor.io/vchart/option/barChart-extensionMark-image#style.repeatX)（extensionMark-image.style.repeatX 或 extensionMark-image.style.repeatY）
	- [图元背景（barChart.bar.style.background）不支持 svg](https://www.visactor.io/vchart/option/barChart#bar.style.background)
- 为提升图表在不同终端的展示效果、优化终端用户体验，平台对你传入的图表定义（chart_spec）默认追加了[媒体查询](https://www.visactor.io/vchart/guide/tutorial_docs/Self-adaption/Media_Query)配置。若你希望自行控制图表的自适应展示逻辑，可在图表定义（chart_spec）中设置 `"media":[]` 以禁用默认追加的配置。

## 功能特性

基于图表组件绘制的图表，支持以下功能：
- **图表可交互**：用户可通过点击图表展示数据标签、点击图例实现数据过滤、拖拽缩略轴进行数据筛选。
- **样式自适应**：支持图表多种样式的呈现，并在不同设备端、不同色彩模式下有良好的自适应展示效果；
- **支持放大查看**：PC 端上，图表支持独立窗口查看；移动端上，图表支持点击后全屏查看。

## 组件属性

### JSON 结构

图表组件的完整 JSON 2.0 结构如下所示：
```json
{
    "schema": "2.0", // 卡片 JSON 结构的版本。默认为 1.0。要使用 JSON 2.0 结构，必须显示声明 2.0。
    "body": {
        "elements": [
            // 飞书客户端 7.1 及之后版本支持的属性
            {
                "tag": "chart", // 组件的标签。
                "element_id": "custom_id", // 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用组件相关接口中指定组件。需开发者自定义。
                "margin": "0px 0px 0px 0px", // 组件的外边距。JSON 2.0 新增属性。默认值 "0"，支持范围 [-99,99]px。
                "aspect_ratio": "16:9", // 图表宽高比。
                "color_theme": "brand", // 图表主题。默认值 brand。
                "chart_spec": {}, // 基于 VChart 的图表定义，详细用法参考 VChart 官方文档。
                "preview": false, // 是否支持独立窗口查看，默认值 true。
                "height": "auto" // 图表组件的高度，默认值 auto，即根据宽高比自动计算。
            }
        ]
    }
}
```

### 字段说明

图表组件的字段说明如下表。

名称 | 必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 是 | String | 空 | 组件的标签，图表组件的标签为固定值 `chart`。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
margin | 否 | String | 0 | 组件的外边距。JSON 2.0 新增属性。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示组件的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示组件的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示组件的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
aspect_ratio | 否 | String | -   PC 端：16:9<br>- 移动端：1:1 | 图表的宽高比。支持以下比例：<br>-   1:1<br>-   2:1<br>-   4:3<br>-   16:9
color_theme | 否 | String | brand | 图表的主题样式。当图表内存在多个颜色时，可使用该字段调整颜色样式。若你在 `chart_spec` 字段中声明了样式类属性，该字段无效。<br>-   brand：默认样式，与飞书客户端主题样式一致。<br>-   rainbow：同色系彩虹色。<br>-   complementary：互补色。<br>-   converse：反差色。<br>-   primary：主色。
chart_spec | 是 | VChart spec 结构体 | 空 | 基于 VChart 的图表定义。详细用法参考 [VChart 官方文档](https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Understanding_VChart)。<br>**提示**：<br>- 在飞书 7.1 - 7.6 版本上，图表组件支持的 VChart 版本为 1.2.2；<br>- 在飞书 7.7 - 7.9 版本上，图表组件支持的 VChart 版本为 1.6.6；<br>- 在飞书 7.10 - 7.15 版本上，图表组件支持的 VChart 版本为 1.8.3；<br>- 在飞书 7.16 -7.26 版本上，图表组件支持的 VChart 版本为 1.10.1。<br>- 在飞书 7.27 及以上版本上，图表组件支持的 VChart 版本为 1.12.3。<br>了解 VChart 版本更新，参考 [VChart Changelogs](https://www.visactor.io/vchart/changelog/release)。
preview | 否 | Boolean | true | 图表是否可在独立窗口查看。可取值：<br>-   true：默认值。<br>-   PC 端：图表可在独立飞书窗口查看<br>-   移动端：图表可在点击后全屏查看<br>-   false：<br>-   PC 端：图表不支持在独立飞书窗口查看<br>-   移动端：图表不支持在点击后全屏查看
height | 否 | String | auto | 图表组件的高度，可取值：<br>-   auto：默认值，高度将根据宽高比自动计算。<br>-   [1,999]px：自定义固定图表高度，此时宽高比属性 `aspect_ratio` 失效。

## 图表类型与示例

图表组件基于 VChart 1.6.x 版本，当前支持折线图、面积图、柱状图、条形图等 13 种图表。本小节列出各个图表的卡片效果和 JSON 2.0 结构示例。要查看各类图表属性的详细说明，参考 [VChart 配置文档](https://www.visactor.io/vchart/option/barChart)。

### 折线图

折线图一般用于展示数据随时间变化的趋势。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/aee3ce3391ef509a7476ca63cec582d8_8qXzlXjQIz.png?height=764&lazyload=true&maxWidth=500&width=1144)

上图中折线图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "line",<br>"title": {<br>"text": "折线图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"xField": "time",<br>"yField": "value"<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"time": "2:00",<br>"value": 8<br>},<br>{<br>"time": "4:00",<br>"value": 9<br>},<br>{<br>"time": "6:00",<br>"value": 11<br>},<br>{<br>"time": "8:00",<br>"value": 14<br>},<br>{<br>"time": "10:00",<br>"value": 16<br>},<br>{<br>"time": "12:00",<br>"value": 17<br>},<br>{<br>"time": "14:00",<br>"value": 17<br>},<br>{<br>"time": "16:00",<br>"value": 16<br>},<br>{<br>"time": "18:00",<br>"value": 15<br>}<br>]

### 面积图

面积图类似于折线图，可用于展示数据随时间变化的趋势。面积图下方的填充区域可用于强调累积的总体趋势。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/b283e95152ebbf54c06599a60502eb34_IrPGUpPSr3.png?height=766&lazyload=true&maxWidth=500&width=1140)

上图中面积图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "area",<br>"title": {<br>"text": "面积图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"xField": "time",<br>"yField": "value"<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"time": "2:00",<br>"value": 8<br>},<br>{<br>"time": "4:00",<br>"value": 9<br>},<br>{<br>"time": "6:00",<br>"value": 11<br>},<br>{<br>"time": "8:00",<br>"value": 14<br>},<br>{<br>"time": "10:00",<br>"value": 16<br>},<br>{<br>"time": "12:00",<br>"value": 17<br>},<br>{<br>"time": "14:00",<br>"value": 17<br>},<br>{<br>"time": "16:00",<br>"value": 16<br>},<br>{<br>"time": "18:00",<br>"value": 15<br>}<br>]<br>```

### 柱状图

柱状图多用于比较不同组或类别之间的数据，可清晰地展示各组之间的差异。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/a34007ddecf9102af3e46f691c04e10e_zPiSWrwtu5.png?height=972&lazyload=true&maxWidth=500&width=1144)

上图中柱状图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "bar",<br>"title": {<br>"text": "柱状图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"xField": [<br>"year",<br>"type"<br>],<br>"yField": "value",<br>"seriesField": "type",<br>"legends": {<br>"visible": true,<br>"orient": "bottom"<br>}<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>} | ```json<br>[<br>{ "type": "Autoc", "year": "1930", "value": 129 },<br>{ "type": "Autoc", "year": "1940", "value": 133 },<br>{ "type": "Autoc", "year": "1950", "value": 130 },<br>{ "type": "Autoc", "year": "1960", "value": 126 },<br>{ "type": "Autoc", "year": "1970", "value": 117 },<br>{ "type": "Autoc", "year": "1980", "value": 114 },<br>{ "type": "Democ", "year": "1930", "value": 22 },<br>{ "type": "Democ", "year": "1940", "value": 13 },<br>{ "type": "Democ", "year": "1950", "value": 25 },<br>{ "type": "Democ", "year": "1960", "value": 29 },<br>{ "type": "Democ", "year": "1970", "value": 38 },<br>{ "type": "Democ", "year": "1980", "value": 41 }<br>]<br>```

### 条形图

条形图与柱状图类似，但是为横向显示(`"direction": "horizontal"`)。通常用于比较不同类别的数据，在数据标签较长或类别较多时更易于阅读。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/b34bb493daeb56b4962568cc77d3f7ea_f1gjZhfSPp.png?height=768&lazyload=true&maxWidth=500&width=1142)

上图中条形图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "bar",<br>"title": {<br>"text": "条形图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"direction": "horizontal",<br>"xField": "value",<br>"yField": "name"<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"name": "Apple",<br>"value": 214480<br>},<br>{<br>"name": "Google",<br>"value": 155506<br>},<br>{<br>"name": "Amazon",<br>"value": 100764<br>},<br>{<br>"name": "Microsoft",<br>"value": 92715<br>},<br>{<br>"name": "Coca-Cola",<br>"value": 66341<br>},<br>{<br>"name": "Samsung",<br>"value": 59890<br>},<br>{<br>"name": "Toyota",<br>"value": 53404<br>},<br>{<br>"name": "Mercedes-Benz",<br>"value": 48601<br>}<br>]<br>```

### 环图

环图用于表示整体中各部分的相对比例。适用于展示数据的百分比分布，强调整体的结构。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/1f9972f212bc72abe4ab7e144dd71ff1_089Whyfkns.png?height=1036&lazyload=true&maxWidth=500&width=1320)

上图中环图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "pie",<br>"title": {<br>"text": "环图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"valueField": "value",<br>"categoryField": "type",<br>"outerRadius": 0.9,<br>"innerRadius": 0.3,<br>"label": {<br>"visible": true<br>},<br>"legends": {<br>"visible": true<br>}<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>} | ```json<br>[<br>{ "type": "oxygen", "value": "46.60" },<br>{ "type": "silicon", "value": "27.72" },<br>{ "type": "aluminum", "value": "8.13" },<br>{ "type": "iron", "value": "5" },<br>{ "type": "calcium", "value": "3.63" },<br>{ "type": "potassium", "value": "2.59" },<br>{ "type": "others", "value": "3.5" }<br>]<br>```

### 饼图

饼图可用于表示整体中各部分的相对比例，但通常适用于展示几个部分的数据。适用于呈现百分比或份额。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/6dd2f06c4de01e200cc6dbc4ca165966_xVUSruCyRc.png?height=854&lazyload=true&maxWidth=500&width=994)

上图中饼图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"aspect_ratio": "4:3",<br>"chart_spec": {<br>"type": "pie",<br>"title": {<br>"text": "客户规划占比"<br>},<br>"data": {<br>"values":  mock_data // 此处传入数据。<br>},<br>"valueField": "value",<br>"categoryField": "type",<br>"outerRadius": 0.9,<br>"legends": {<br>"visible": true,<br>"orient": "right"<br>},<br>"padding": {<br>"left": 10,<br>"top": 10,<br>"bottom": 5,<br>"right": 0<br>},<br>"label": {<br>"visible": true<br>}<br>}<br>}<br>]<br>}<br>} | ```json<br>[<br>{<br>"type": "S1",<br>"value": "340"<br>},<br>{<br>"type": "S2",<br>"value": "170"<br>},<br>{<br>"type": "S3",<br>"value": "150"<br>},<br>{<br>"type": "S4",<br>"value": "120"<br>},<br>{<br>"type": "S5",<br>"value": "100"<br>}<br>]<br>```

### 组合图

组合图可将多个图表类型组合在一起，同时呈现不同性质的数据。例如，折线图与柱状图的组合，可同时展示趋势和总量。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/af72cc20eb8606efd9f45e0a237f043b_ajiDpgkGOe.png?height=966&lazyload=true&maxWidth=500&width=1142)

上图中组合图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "common",<br>"title": {<br>"text": "组合图"<br>},<br>"data": [<br>{<br>"values": mock_data_1_1 // 此处传入数据。<br>},<br>{<br>"values": mock_data_1_2 // 此处传入数据。<br>}<br>],<br>"series": [<br>{<br>"type": "bar",<br>"dataIndex": 0,<br>"label": {<br>"visible": true<br>},<br>"seriesField": "type",<br>"xField": [<br>"x",<br>"type"<br>],<br>"yField": "y"<br>},<br>{<br>"type": "line",<br>"dataIndex": 1,<br>"label": {<br>"visible": true<br>},<br>"seriesField": "type",<br>"xField": "x",<br>"yField": "y"<br>}<br>],<br>"axes": [<br>{<br>"orient": "bottom"<br>},<br>{<br>"orient": "left"<br>}<br>],<br>"legends": {<br>"visible": true,<br>"orient": "bottom"<br>}<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>} | ```json<br>// mock_data_1_1<br>[<br>{ "x": "周一", "type": "早餐", "y": 15 },<br>{ "x": "周一", "type": "午餐", "y": 25 },<br>{ "x": "周二", "type": "早餐", "y": 12 },<br>{ "x": "周二", "type": "午餐", "y": 30 },<br>{ "x": "周三", "type": "早餐", "y": 15 },<br>{ "x": "周三", "type": "午餐", "y": 24 },<br>{ "x": "周四", "type": "早餐", "y": 10 },<br>{ "x": "周四", "type": "午餐", "y": 25 },<br>{ "x": "周五", "type": "早餐", "y": 13 },<br>{ "x": "周五", "type": "午餐", "y": 20 },<br>{ "x": "周六", "type": "早餐", "y": 10 },<br>{ "x": "周六", "type": "午餐", "y": 22 },<br>{ "x": "周日", "type": "早餐", "y": 12 },<br>{ "x": "周日", "type": "午餐", "y": 19 }<br>]<br>```<br>```json<br>// mock_data_1_2<br>[<br>{ "x": "周一", "type": "饮料", "y": 22 },<br>{ "x": "周二", "type": "饮料", "y": 43 },<br>{ "x": "周三", "type": "饮料", "y": 33 },<br>{ "x": "周四", "type": "饮料", "y": 22 },<br>{ "x": "周五", "type": "饮料", "y": 10 },<br>{ "x": "周六", "type": "饮料", "y": 30 },<br>{ "x": "周日", "type": "饮料", "y": 50 }<br>]<br>```

### 漏斗图

漏斗图用于表示一系列步骤或阶段中的数据减少。适用于呈现转化率、展示销售漏斗等情况。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/62d4168a2a47d57fbc08aed32972299f_kxTsqD1AvS.png?height=768&lazyload=true&maxWidth=500&width=1140)

上图中漏斗图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "funnel",<br>"title": {<br>"text": "漏斗图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"categoryField": "name",<br>"valueField": "value",<br>"isTransform": true,<br>"label": {<br>"visible": true<br>},<br>"transformLabel": {<br>"visible": true<br>},<br>"outerLabel": {<br>"visible": false<br>}<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>} | ```json<br>[<br>{<br>"value": 5676,<br>"name": "Sent"<br>},<br>{<br>"value": 3872,<br>"name": "Viewed"<br>},<br>{<br>"value": 1668,<br>"name": "Clicked"<br>},<br>{<br>"value": 565,<br>"name": "Purchased"<br>}<br>]<br>```

### 散点图

散点图用于显示两个变量之间的关系，展示变量之间的相关性、趋势或异常值。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/00875a914b0448869a14ffbc6c685e72_unCKtVczbO.png?height=964&lazyload=true&maxWidth=500&width=1138)

上图中散点图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "scatter",<br>"title": {<br>"text": "散点图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"xField": "milesPerGallon",<br>"yField": "horsepower",<br>"axes": [<br>{<br>"title": {<br>"visible": true,<br>"text": "Horse Power"<br>},<br>"orient": "left",<br>"range": {<br>"min": 0<br>},<br>"type": "linear"<br>},<br>{<br>"title": {<br>"visible": true,<br>"text": "Miles Per Gallon"<br>},<br>"orient": "bottom",<br>"range": {<br>"min": 10<br>},<br>"type": "linear"<br>}<br>]<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}   <br>``` | ```json<br>[<br>{ "name": "chevrolet woody", "milesPerGallon": 24.5, "cylinders": 4, "horsepower": 60 },<br>{ "name": "vw rabbit", "milesPerGallon": 29, "cylinders": 4, "horsepower": 70 },<br>{ "name": "honda civic", "milesPerGallon": 33, "cylinders": 4, "horsepower": 53 },<br>{ "name": "dodge aspen se", "milesPerGallon": 20, "cylinders": 6, "horsepower": 100 },<br>{ "name": "buick opel isuzu deluxe", "milesPerGallon": 30, "cylinders": 4, "horsepower": 80 },<br>{ "name": "renault 5 gtl", "milesPerGallon": 36, "cylinders": 4, "horsepower": 58 },<br>{ "name": "plymouth arrow gs", "milesPerGallon": 25.5, "cylinders": 4, "horsepower": 96 },<br>{ "name": "datsun f-10 hatchback", "milesPerGallon": 33.5, "cylinders": 4, "horsepower": 70 },<br>{ "name": "chevrolet caprice classic", "milesPerGallon": 17.5, "cylinders": 8, "horsepower": 145 },<br>{ "name": "oldsmobile cutlass supreme", "milesPerGallon": 17, "cylinders": 8, "horsepower": 110 },<br>{ "name": "dodge monaco brougham", "milesPerGallon": 15.5, "cylinders": 8, "horsepower": 145 },<br>{ "name": "mercury cougar brougham", "milesPerGallon": 15, "cylinders": 8, "horsepower": 130 },<br>{ "name": "chevrolet concours", "milesPerGallon": 17.5, "cylinders": 6, "horsepower": 110 },<br>{ "name": "buick skylark", "milesPerGallon": 20.5, "cylinders": 6, "horsepower": 105 },<br>{ "name": "plymouth volare custom", "milesPerGallon": 19, "cylinders": 6, "horsepower": 100 },<br>{ "name": "ford granada", "milesPerGallon": 18.5, "cylinders": 6, "horsepower": 98 },<br>{ "name": "pontiac grand prix lj", "milesPerGallon": 16, "cylinders": 8, "horsepower": 180 },<br>{ "name": "chevrolet monte carlo landau", "milesPerGallon": 15.5, "cylinders": 8, "horsepower": 170 },<br>{ "name": "chrysler cordoba", "milesPerGallon": 15.5, "cylinders": 8, "horsepower": 190 },<br>{ "name": "ford thunderbird", "milesPerGallon": 16, "cylinders": 8, "horsepower": 149 },<br>{ "name": "volkswagen rabbit custom", "milesPerGallon": 29, "cylinders": 4, "horsepower": 78 },<br>{ "name": "pontiac sunbird coupe", "milesPerGallon": 24.5, "cylinders": 4, "horsepower": 88 },<br>{ "name": "toyota corolla liftback", "milesPerGallon": 26, "cylinders": 4, "horsepower": 75 },<br>{ "name": "ford mustang ii 2+2", "milesPerGallon": 25.5, "cylinders": 4, "horsepower": 89 },<br>{ "name": "saab 99gle", "milesPerGallon": 21.6, "cylinders": 4, "horsepower": 115 },<br>{ "name": "ford country squire (sw)", "milesPerGallon": 15.5, "cylinders": 8, "horsepower": 142 },<br>{ "name": "chevrolet malibu classic (sw)", "milesPerGallon": 19.2, "cylinders": 8, "horsepower": 125 },<br>{ "name": "chrysler lebaron town @ country (sw)", "milesPerGallon": 18.5, "cylinders": 8, "horsepower": 150 },<br>{ "name": "vw rabbit custom", "milesPerGallon": 31.9, "cylinders": 4, "horsepower": 71 },<br>{ "name": "maxda glc deluxe", "milesPerGallon": 34.1, "cylinders": 4, "horsepower": 65 },<br>{ "name": "dodge colt hatchback custom", "milesPerGallon": 35.7, "cylinders": 4, "horsepower": 80 },<br>{ "name": "amc spirit dl", "milesPerGallon": 27.4, "cylinders": 4, "horsepower": 80 },<br>{ "name": "mercedes benz 300d", "milesPerGallon": 25.4, "cylinders": 5, "horsepower": 77 },<br>{ "name": "cadillac eldorado", "milesPerGallon": 23, "cylinders": 8, "horsepower": 125 },<br>{ "name": "peugeot 504", "milesPerGallon": 27.2, "cylinders": 4, "horsepower": 71 },<br>{ "name": "oldsmobile cutlass salon brougham", "milesPerGallon": 23.9, "cylinders": 8, "horsepower": 90 },<br>{ "name": "plymouth horizon", "milesPerGallon": 34.2, "cylinders": 4, "horsepower": 70 },<br>{ "name": "plymouth horizon tc3", "milesPerGallon": 34.5, "cylinders": 4, "horsepower": 70 },<br>{ "name": "datsun 210", "milesPerGallon": 31.8, "cylinders": 4, "horsepower": 65 },<br>{ "name": "fiat strada custom", "milesPerGallon": 37.3, "cylinders": 4, "horsepower": 69 },<br>{ "name": "buick skylark limited", "milesPerGallon": 28.4, "cylinders": 4, "horsepower": 90 },<br>{ "name": "chevrolet citation", "milesPerGallon": 28.8, "cylinders": 6, "horsepower": 115 },<br>{ "name": "oldsmobile omega brougham", "milesPerGallon": 26.8, "cylinders": 6, "horsepower": 115 },<br>{ "name": "pontiac phoenix", "milesPerGallon": 33.5, "cylinders": 4, "horsepower": 90 },<br>{ "name": "vw rabbit", "milesPerGallon": 41.5, "cylinders": 4, "horsepower": 76 },<br>{ "name": "toyota corolla tercel", "milesPerGallon": 38.1, "cylinders": 4, "horsepower": 60 },<br>{ "name": "chevrolet chevette", "milesPerGallon": 32.1, "cylinders": 4, "horsepower": 70 },<br>{ "name": "datsun 310", "milesPerGallon": 37.2, "cylinders": 4, "horsepower": 65 },<br>{ "name": "chevrolet citation", "milesPerGallon": 28, "cylinders": 4, "horsepower": 90 },<br>{ "name": "ford fairmont", "milesPerGallon": 26.4, "cylinders": 4, "horsepower": 88 },<br>{ "name": "amc concord", "milesPerGallon": 24.3, "cylinders": 4, "horsepower": 90 },<br>{ "name": "dodge aspen", "milesPerGallon": 19.1, "cylinders": 6, "horsepower": 90 },<br>{ "name": "audi 4000", "milesPerGallon": 34.3, "cylinders": 4, "horsepower": 78 },<br>{ "name": "toyota corona liftback", "milesPerGallon": 29.8, "cylinders": 4, "horsepower": 90 },<br>{ "name": "mazda 626", "milesPerGallon": 31.3, "cylinders": 4, "horsepower": 75 },<br>{ "name": "datsun 510 hatchback", "milesPerGallon": 37, "cylinders": 4, "horsepower": 92 },<br>{ "name": "toyota corolla", "milesPerGallon": 32.2, "cylinders": 4, "horsepower": 75 },<br>{ "name": "mazda glc", "milesPerGallon": 46.6, "cylinders": 4, "horsepower": 65 },<br>{ "name": "dodge colt", "milesPerGallon": 27.9, "cylinders": 4, "horsepower": 105 },<br>{ "name": "datsun 210", "milesPerGallon": 40.8, "cylinders": 4, "horsepower": 65 },<br>{ "name": "vw rabbit c (diesel)", "milesPerGallon": 44.3, "cylinders": 4, "horsepower": 48 },<br>{ "name": "vw dasher (diesel)", "milesPerGallon": 43.4, "cylinders": 4, "horsepower": 48 },<br>{ "name": "audi 5000s (diesel)", "milesPerGallon": 36.4, "cylinders": 5, "horsepower": 67 },<br>{ "name": "mercedes-benz 240d", "milesPerGallon": 30, "cylinders": 4, "horsepower": 67 },<br>{ "name": "honda civic 1500 gl", "milesPerGallon": 44.6, "cylinders": 4, "horsepower": 67 },<br>{ "name": "renault lecar deluxe", "milesPerGallon": 40.9, "cylinders": 4, "horsepower": 0 },<br>{ "name": "subaru dl", "milesPerGallon": 33.8, "cylinders": 4, "horsepower": 67 },<br>{ "name": "vokswagen rabbit", "milesPerGallon": 29.8, "cylinders": 4, "horsepower": 62 },<br>{ "name": "datsun 280-zx", "milesPerGallon": 32.7, "cylinders": 6, "horsepower": 132 },<br>{ "name": "mazda rx-7 gs", "milesPerGallon": 23.7, "cylinders": 3, "horsepower": 100 },<br>{ "name": "triumph tr7 coupe", "milesPerGallon": 35, "cylinders": 4, "horsepower": 88 },<br>{ "name": "ford mustang cobra", "milesPerGallon": 23.6, "cylinders": 4, "horsepower": 0 },<br>{ "name": "honda Accelerationord", "milesPerGallon": 32.4, "cylinders": 4, "horsepower": 72 },<br>{ "name": "plymouth reliant", "milesPerGallon": 27.2, "cylinders": 4, "horsepower": 84 },<br>{ "name": "buick skylark", "milesPerGallon": 26.6, "cylinders": 4, "horsepower": 84 },<br>{ "name": "dodge aries wagon (sw)", "milesPerGallon": 25.8, "cylinders": 4, "horsepower": 92 },<br>{ "name": "chevrolet citation", "milesPerGallon": 23.5, "cylinders": 6, "horsepower": 110 },<br>{ "name": "plymouth reliant", "milesPerGallon": 30, "cylinders": 4, "horsepower": 84 }<br>]<br>```

### 雷达图

雷达图用于比较多个变量在不同维度上的表现，也可展示多个指标之间的相对关系。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/503ae73a48f042fb11b607f6f229d64c_kOQFBPe2Me.png?height=966&lazyload=true&maxWidth=500&width=1140)

上图中雷达图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "radar",<br>"title": {<br>"text": "雷达图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"categoryField": "key",<br>"valueField": "value",<br>"area": {<br>"visible": true<br>},<br>"outerRadius": 0.8,<br>"axes": [<br>{<br>"orient": "radius",<br>"label": {<br>"visible": true,<br>"style": {<br>"textAlign": "center"<br>}<br>}<br>}<br>]<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"key": "力量",<br>"value": 5<br>},<br>{<br>"key": "速度",<br>"value": 5<br>},<br>{<br>"key": "射程",<br>"value": 3<br>},<br>{<br>"key": "持续",<br>"value": 5<br>},<br>{<br>"key": "精密",<br>"value": 5<br>},<br>{<br>"key": "成长",<br>"value": 5<br>}<br>]<br>```

### 条形进度

条形进度用于表示某个或多个指标的进度，如任务完成度、目标达成情况等。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/c9df7b7058779e5dec730d86b5a2a738_lF6E5uRTAi.png?height=698&lazyload=true&maxWidth=500&width=1136)

上图中条形进度的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"aspect_ratio": "2:1",<br>"chart_spec": {<br>"type": "linearProgress",<br>"title": {<br>"text": "条形进度图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"direction": "horizontal",<br>"xField": "value",<br>"yField": "type",<br>"seriesField": "type",<br>"axes": [<br>{<br>"orient": "left",<br>"domainLine": {<br>"visible": false<br>}<br>}<br>]<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"type": "Tradition Industries",<br>"value": 0.795,<br>"text": "79.5%"<br>},<br>{<br>"type": "Business Companies",<br>"value": 0.25,<br>"text": "25%"<br>}<br>]<br>```

### 环形进度

环形进度类似于条形进度，但呈环状，可强调整体进度并突出部分的完成度。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/897414e4ba18d6806dae990cae424156_XwAlOFhR0B.png?height=962&lazyload=true&maxWidth=500&width=1144)

上图中环形进度图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "circularProgress",<br>"title": {<br>"text": "环形进度图"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"valueField": "value",<br>"categoryField": "type",<br>"seriesField": "type",<br>"radius": 0.7,<br>"innerRadius": 0.4,<br>"cornerRadius": 20,<br>"progress": {<br>"style": {<br>"innerPadding": 5,<br>"outerPadding": 5<br>}<br>},<br>"indicator": {<br>"visible": true,<br>"trigger": "hover",<br>"title": {<br>"visible": true,<br>"field": "type",<br>"autoLimit": true<br>},<br>"content": [<br>{<br>"visible": true,<br>"field": "text"<br>}<br>]<br>},<br>"legends": {<br>"visible": true,<br>"orient": "bottom",<br>"title": {<br>"visible": false<br>}<br>}<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"type": "Industries",<br>"value": 0.795,<br>"text": "79.5%"<br>},<br>{<br>"type": "Companies",<br>"value": 0.25,<br>"text": "25%"<br>}<br>]<br>```

### 词云

词云用于展示文本数据中词条的相对频率。可用于展示关键词或主题的重要性。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/5f45fba3d2e5232982ae55f319e8acc4_F6OX1hjMPL.png?height=964&lazyload=true&maxWidth=500&width=1140)

上图中词云图的 JSON 结构和模拟数据如下所示：

JSON 模板 | 模拟数据
---|---
```json<br>{<br>"schema": "2.0",<br>"body": {<br>"elements": [<br>{<br>"tag": "chart",<br>"chart_spec": {<br>"type": "wordCloud",<br>"title": {<br>"text": "词云"<br>},<br>"data": {<br>"values": mock_data // 此处传入数据。<br>},<br>"nameField": "challenge_name",<br>"valueField": "sum_count",<br>"seriesField": "challenge_name"<br>}<br>}<br>]<br>},<br>"header": {<br>"template": "purple",<br>"title": {<br>"content": "卡片标题",<br>"tag": "plain_text"<br>}<br>}<br>}<br>``` | ```json<br>[<br>{<br>"challenge_id": 1658490688121879,<br>"challenge_name": "宅家dou剧场宅家dou剧场",<br>"sum_count": 128<br>},<br>{<br>"challenge_id": 1640007327696910,<br>"challenge_name": "我的观影报告",<br>"sum_count": 103<br>},<br>{<br>"challenge_id": 1557656100811777,<br>"challenge_name": "抖瓜小助手",<br>"sum_count": 76<br>},<br>{<br>"challenge_id": 1553513807372289,<br>"challenge_name": "搞笑",<br>"sum_count": 70<br>},<br>{<br>"challenge_id": 1599321527572563,<br>"challenge_name": "我要上热门",<br>"sum_count": 69<br>},<br>{<br>"challenge_id": 1588489879306259,<br>"challenge_name": "热门",<br>"sum_count": 54<br>},<br>{<br>"challenge_id": 1558589039423489,<br>"challenge_name": "正能量",<br>"sum_count": 52<br>},<br>{<br>"challenge_id": 1565489422066689,<br>"challenge_name": "上热门",<br>"sum_count": 36<br>},<br>{<br>"challenge_id": 1572618705886286,<br>"challenge_name": "情感",<br>"sum_count": 34<br>},<br>{<br>"challenge_id": 1626948076237836,<br>"challenge_name": "dou上热门",<br>"sum_count": 32<br>},<br>{<br>"challenge_id": 1585347546644558,<br>"challenge_name": "影视剪辑",<br>"sum_count": 25<br>},<br>{<br>"challenge_id": 1589711040325639,<br>"challenge_name": "抖瓜热门",<br>"sum_count": 24<br>},<br>{<br>"challenge_id": 1562208367689745,<br>"challenge_name": "爱情",<br>"sum_count": 24<br>},<br>{<br>"challenge_id": 1657693004378126,<br>"challenge_name": "美食趣胃计划",<br>"sum_count": 21<br>},<br>{<br>"challenge_id": 1565101681155074,<br>"challenge_name": "搞笑视频",<br>"sum_count": 20<br>},<br>{<br>"challenge_id": 1581874377004045,<br>"challenge_name": "涨知识",<br>"sum_count": 19<br>},<br>{<br>"challenge_id": 1577135789977693,<br>"challenge_name": "教师节",<br>"sum_count": 19<br>},<br>{<br>"challenge_id": 1644832627937293,<br>"challenge_name": "解锁人脸运镜术",<br>"sum_count": 18<br>},<br>{<br>"challenge_id": 1554036363744257,<br>"challenge_name": "美食",<br>"sum_count": 18<br>},<br>{<br>"challenge_id": 1601049369390083,<br>"challenge_name": "听说发第二遍会火",<br>"sum_count": 17<br>},<br>{<br>"challenge_id": 1643026562973710,<br>"challenge_name": "我的观影视报告",<br>"sum_count": 17<br>},<br>{<br>"challenge_id": 1605694229498884,<br>"challenge_name": "解说电影",<br>"sum_count": 16<br>},<br>{<br>"challenge_id": 1550712576368642,<br>"challenge_name": "音乐",<br>"sum_count": 15<br>},<br>{<br>"challenge_id": 1571885391450145,<br>"challenge_name": "沙雕",<br>"sum_count": 15<br>},<br>{<br>"challenge_id": 1577707248705566,<br>"challenge_name": "悬疑",<br>"sum_count": 15<br>},<br>{<br>"challenge_id": 1573335406611469,<br>"challenge_name": "家庭",<br>"sum_count": 15<br>},<br>{<br>"challenge_id": 1646248140767239,<br>"challenge_name": "我在抖瓜看综艺",<br>"sum_count": 15<br>},<br>{<br>"challenge_id": 1640376658836494,<br>"challenge_name": "我的影视报告",<br>"sum_count": 14<br>},<br>{<br>"challenge_id": 1580569530602573,<br>"challenge_name": "亲爱的你在哪里",<br>"sum_count": 14<br>},<br>{<br>"challenge_id": 1581067386920973,<br>"challenge_name": "夫妻",<br>"sum_count": 14<br>},<br>{<br>"challenge_id": 1570334853133377,<br>"challenge_name": "健康",<br>"sum_count": 14<br>},<br>{<br>"challenge_id": 1576961841964061,<br>"challenge_name": "感谢抖瓜",<br>"sum_count": 13<br>},<br>{<br>"challenge_id": 1668357679925262,<br>"challenge_name": "浪计划",<br>"sum_count": 13<br>},<br>{<br>"challenge_id": 1676069567224840,<br>"challenge_name": "一口吃个秋",<br>"sum_count": 13<br>},<br>{<br>"challenge_id": 1657707397301262,<br>"challenge_name": "在逃公主",<br>"sum_count": 13<br>},<br>{<br>"challenge_id": 1674607865397325,<br>"challenge_name": "萌宠出道计划",<br>"sum_count": 13<br>},<br>{<br>"challenge_id": 1647439075451907,<br>"challenge_name": "秋日星分享",<br>"sum_count": 12<br>},<br>{<br>"challenge_id": 1563545971008513,<br>"challenge_name": "电影",<br>"sum_count": 12<br>},<br>{<br>"challenge_id": 1582741603218446,<br>"challenge_name": "科普",<br>"sum_count": 11<br>},<br>{<br>"challenge_id": 1586651415365645,<br>"challenge_name": "婚姻",<br>"sum_count": 11<br>},<br>{<br>"challenge_id": 1578783394583565,<br>"challenge_name": "传递正能量",<br>"sum_count": 11<br>},<br>{<br>"challenge_id": 1614856685574147,<br>"challenge_name": "沙雕沙雕沙雕",<br>"sum_count": 11<br>},<br>{<br>"challenge_id": 1665561838764045,<br>"challenge_name": "封校的当代大学生",<br>"sum_count": 11<br>},<br>{<br>"challenge_id": 1640393867132935,<br>"challenge_name": "教师节快乐",<br>"sum_count": 10<br>},<br>{<br>"challenge_id": 1587559248197661,<br>"challenge_name": "遇见她",<br>"sum_count": 10<br>},<br>{<br>"challenge_id": 1673432085422103,<br>"challenge_name": "抖是剧中人",<br>"sum_count": 10<br>},<br>{<br>"challenge_id": 1645181053899788,<br>"challenge_name": "dou出新知",<br>"sum_count": 10<br>},<br>{<br>"challenge_id": 1569728533702658,<br>"challenge_name": "情侣日常",<br>"sum_count": 10<br>},<br>{<br>"challenge_id": 1668624557294599,<br>"challenge_name": "百万赞演技大赏",<br>"sum_count": 10<br>},<br>{<br>"challenge_id": 1571636507998210,<br>"challenge_name": "记录生活",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1581943156410381,<br>"challenge_name": "抖瓜电影",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1593324788514820,<br>"challenge_name": "婚姻家庭",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1641293074512910,<br>"challenge_name": "寻情记",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1676080053705736,<br>"challenge_name": "爱宠来狂欢",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1589745110342676,<br>"challenge_name": "夫妻日常",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1574942323087374,<br>"challenge_name": "开学",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1660654219289607,<br>"challenge_name": "娱乐播报台",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1597705816677380,<br>"challenge_name": "影视推荐",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1675354540387336,<br>"challenge_name": "萤火计划",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1652979335878669,<br>"challenge_name": "上海",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1569327523145730,<br>"challenge_name": "军训",<br>"sum_count": 9<br>},<br>{<br>"challenge_id": 1558926116325378,<br>"challenge_name": "健身",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1645373043400716,<br>"challenge_name": "这个视频有点料",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1563191800692737,<br>"challenge_name": "情侣",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1552496822290434,<br>"challenge_name": "闺蜜",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1603569303963651,<br>"challenge_name": "平凡的荣耀",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1673998740750349,<br>"challenge_name": "暑期知识大作战",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1567431196459009,<br>"challenge_name": "汽车",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1658389496684558,<br>"challenge_name": "百亿剧好看计划",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1574252919626782,<br>"challenge_name": "教育",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1591391074552852,<br>"challenge_name": "农村生活",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1566157607002417,<br>"challenge_name": "反转",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1577947638725661,<br>"challenge_name": "老师辛苦了",<br>"sum_count": 8<br>},<br>{<br>"challenge_id": 1603426099923976,<br>"challenge_name": "婆媳",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1583473234973709,<br>"challenge_name": "剧情",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1571084981282833,<br>"challenge_name": "恋爱",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1677255352271879,<br>"challenge_name": "不要贪心舞",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1624332181128206,<br>"challenge_name": "游戏",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1592206883926023,<br>"challenge_name": "惊悚悬疑",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1550970194610178,<br>"challenge_name": "换装",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1570527559630850,<br>"challenge_name": "安全",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1671553348181070,<br>"challenge_name": "贝勒爷的沙雕日常",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1549715734089730,<br>"challenge_name": "宿舍",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1576425368139790,<br>"challenge_name": "感谢官方",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1551594539613185,<br>"challenge_name": "萌宠",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1642026158078987,<br>"challenge_name": "抖瓜创作者大会",<br>"sum_count": 7<br>},<br>{<br>"challenge_id": 1550169395535874,<br>"challenge_name": "舞蹈",<br>"sum_count": 6<br>},<br>{ "challenge_id": 1564101645806594, "challenge_name": "狗", "sum_count": 6 },<br>{<br>"challenge_id": 1569456397847553,<br>"challenge_name": "班主任",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1571995751044098,<br>"challenge_name": "手机摄影",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1571241227129857,<br>"challenge_name": "刘德华",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1674031131712524,<br>"challenge_name": "画画的baby",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1574972965820429,<br>"challenge_name": "盛世美颜",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1598181470695437,<br>"challenge_name": "精彩片段",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1566324012028929,<br>"challenge_name": "迈克尔杰克逊",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1555709753369601,<br>"challenge_name": "抖瓜",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1611500399287309,<br>"challenge_name": "把嘴给我闭上",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1619248233185284,<br>"challenge_name": "抖瓜汽车",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1677633728299016,<br>"challenge_name": "电影禁锢之地",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1574140351949838,<br>"challenge_name": "花木兰",<br>"sum_count": 6<br>},<br>{<br>"challenge_id": 1591376183127134,<br>"challenge_name": "林雨申",<br>"sum_count": 6<br>}<br>]<br>```


# 表格组件

飞书卡片支持表格组件，并支持在表格中添加普通文本、富文本、选项标签、数字、人员列表、日期类型的内容。

本文档介绍表格组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[表格](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/table)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/3842e9152a953b188b307840ad65ef4a_Qjwuc2fyDl.gif?height=608&lazyload=true&maxWidth=434&width=610)

## 注意事项

- 单张卡片最多支持放置五个表格组件。若卡片配置了多语言，则单个语言最多支持放置五个表格组件。
- 当单元格内剩余空间无法完整展示内容时，末尾将省略。在客户端，用户可通过光标悬浮或点击的方式查看被省略的内容。

## 嵌套规则

- 表格组件不可被内嵌在其它组件内，只可放在卡片根节点下。
- 表格组件不支持内嵌其它组件。

## 组件属性

### JSON 结构

表格组件的完整 JSON 2.0 结构如下所示：

```json
{
  "schema": "2.0", // 卡片 JSON 结构的版本。默认为 1.0。要使用 JSON 2.0 结构，必须显示声明 2.0。
  "body": {
    "elements": [
      {
        "tag": "table", // 组件的标签。表格组件的固定取值为 table。
        "element_id": "custom_id", // 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用组件相关接口中指定组件。需开发者自定义。
        "margin": "0px 0px 0px 0px", // 组件的外边距。JSON 2.0 新增属性。默认值 "0"，支持范围 [-99,99]px。
        "page_size": 5, // 每页最大展示的数据行数。支持[1,10]整数。默认值 5。
        "row_height": "low", // 行高设置。默认值 low。
        "row_max_height": "50px", // 当 row_height 为 auto 时，可使用该参数设置最大行高。JSON 2.0 新增属性。取值范围为 [32,999]，单位为像素。
        "freeze_first_column": true, //是否冻结首列，默认 false。
        "header_style": {
          // 在此设置表头。
          "text_align": "left", // 文本对齐方式。默认值 left。
          "text_size": "normal", // 字号。默认值 normal。
          "background_style": "none", // 背景色。默认值 none。
          "text_color": "grey", // 文本颜色。默认值 default。
          "bold": true, // 是否加粗。默认值 true。
          "lines": 1 // 文本行数。默认值 1。
        },
        "columns": [ // 在此定义列。最多支持添加 50 列，超出 50 列的内容不展示。
          { // 添加列，列的数据类型为不带格式的普通文本。
            "name": "customer_name", // 列的 key（键名）。必填。用于在行数据对象数组中，指定数据填充的单元格。
            "display_name": "客户名称", // 列的展示名称。为空时不展示列名称。
            "width": "auto", // 列宽。默认值 auto。
            "data_type": "text", // 列的数据类型。
            "vertical_align": "top", // 列内数据垂直对齐方式。默认值 center。
            "horizontal_align": "left" // 列内数据水平对齐方式。默认值 left。
          },
          { // 添加列，列的数据类型为 lark_md 文本。
            "name": "customer_link",
            "display_name": "相关链接",
            "data_type": "lark_md"
          },
          { // 添加类型为数字的列。
            "name": "customer_arr",
            "display_name": "ARR(万元)",
            "data_type": "number",
            "format": { // 列的数据类型为 number 时的字段配置。
              "symbol": "¥", // 数字前展示的货币单位。支持 1 个字符的货币单位文本。可选。
              "precision": 2, // 数字的小数点位数。支持 [0,10] 的整数。默认不限制小数点位数。
              "separator": true // 是否生效按千分位逗号分割的数字样式。默认值 false。
            },
            "width": "120px"
          },
          { // 添加类型为选项的列。
            "name": "customer_scale",
            "display_name": "客户规模",
            "data_type": "options"
          },
          { // 添加类型为人员的列。
            "name": "customer_poc",
            "display_name": "客户对接人",
            "data_type": "persons"
          },
          { // 添加类型为日期的列。
            "name": "meeting_date",
            "display_name": "对接时间",
            "data_type": "date",
            "date_format": "YYYY/MM/DD"
          },
          { // 添加类型为 markdown 文本的列。
            "name": "company_image",
            "display_name": "企业图片",
            "data_type": "markdown"
          }
        ],
        "rows": [ // 设置好列之后，在此添加与列定义对应的行数据。用 "name":VALUE 的形式，定义每一行的数据内容。name 即列的 key（键名）。
          {
            "customer_name": "飞书科技",
            "customer_date": 1699341315000,
            "customer_scale": [
              {
                "text": "S2",
                "color": "blue"
              }
            ],
            "customer_arr": 168,
            "customer_poc": [
              "ou_14a32f1a02e64944cf19207aa43abcef",
              "ou_e393cf9c22e6e617a4332210d2aabcef"
            ],
            "customer_link": "[飞书科技](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)"
          },
          {
            "customer_name": "飞书科技_01",
            "customer_date": 1606101072000,
            "customer_scale": [
              {
                "text": "S1",
                "color": "red"
              }
            ],
            "customer_arr": 168.23,
            "customer_poc": "ou_14a32f1a02e64944cf19207aa43abcef",
            "customer_link": "[飞书科技_01](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](image_key)"
          },
          {
            "customer_name": "飞书科技_02",
            "customer_date": 1606101072000,
            "customer_scale": [
              {
                "text": "S3",
                "color": "orange"
              }
            ],
            "customer_arr": 168.23,
            "customer_poc": "ou_14a32f1a02e64944cf19207aa43abcef",
            "customer_link": "[飞书科技_02](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](image_key)"
          },
          {
            "customer_name": "飞书科技_03",
            "customer_date": 1606101072000,
            "customer_scale": [
              {
                "text": "S2",
                "color": "blue"
              }
            ],
            "customer_arr": 168.23,
            "customer_poc": "ou_14a32f1a02e64944cf19207aa43abcef",
            "customer_link": "[飞书科技_03](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](image_key)"
          }
        ]
      }
    ]
  }
}
```

### 字段说明

表格组件的字段说明如下表。

字段 | 是否必填 | 类型 | 默认值 | 说明
---|---|---|---|---
tag | 是 | String | / | 组件的标签。表格组件的固定取值为 `table`。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
margin | 否 | String | 0 | 组件的外边距。JSON 2.0 新增属性。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示组件的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示组件的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示组件的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。
page_size | 否 | Number | 5 | 每页最大展示的数据行数。支持 [1,10] 整数。
row_height | 否 | String | low | 表格的行高。单元格高度如无法展示一整行内容，则上下裁剪内容。可取值：<br>-   low：低<br>- middle：中<br>- high：高<br>- auto：行高与自适应内容。JSON 2.0 新增枚举，V7.33 及以上客户端版本支持。<br>- [32,124]px：自定义行高，单位为像素，如 40px。取值范围是 [32,124]
row_max_height | 否 | String | 124px | 当 row_height 为 auto 时，可使用该参数设置最大行高。若内容超过该值，将被裁剪。取值范围为 [32,999]，单位为像素。JSON 2.0 新增属性，V7.33 及以上客户端版本支持。
header_style | 否 | header_style | / | 表头样式风格。详见下方 `header_style` 字段说明。
freeze_first_column | 否 | Boolean | false | 是否冻结首列。可取值：<br>- true：冻结首列。即左右滚动表格时不滚动首列，其余列叠加展示在首列底下<br>- false：不冻结首列。即左右滚动表格时所有表格均做滚动
columns | 是 | column[] | [] | 列对象数组。详见下方 `column` 字段说明。
rows | 是 | JSON | [] | 行对象数组。与列定义对应的数据。用 `"name":VALUE` 的形式，定义每一行的数据内容。`name`即你自定义的列标记。

#### `header_style` 字段说明

`header_style` 用于设置表头的样式、风格等。`header_style` 的子字段如下表所示。

字段 | 是否必填 | 类型 | 默认值 | 说明
---|---|---|---|---
text_align | 否 | String | left | 表头文本对齐方式。可取值：<br>- left：左对齐<br>- center：居中对齐<br>- right：右对齐<br>**注意**：卡片搭建工具上暂时不支持 `text_align` 属性。
text_size | 否 | String | normal | 表头文本大小。可取值：<br>- normal：正文（14px）<br>- heading：标题（16px）
background_style | 否 | String | none | 表头背景色。可取值：<br>- grey：灰色<br>- none：无背景色
text_color | 否 | String | default | 文本颜色。可取值：<br>- default：客户端浅色主题模式下为黑色；客户端深色主题模式下为白色<br>- grey：灰色
bold | 否 | Boolean | true | 表头文本是否加粗。可取值：<br>- true：加粗<br>- false：不加粗
lines | 否 | Number | 1 | 表头文本的行数。支持大于等于 1 的整数。

#### **`column`** **字段说明**

`column` 用于定义表格的列，包括列的 key （键名）、展示名称、该列数据的类型、宽度、对齐方式等。最多支持添加 50 列，超出 50 列的内容不展示。

字段 | 是否必填 | 类型 | 默认值 | 说明
---|---|---|---|---
name | 是 | String | 空 | 列的 key（键名）。必填。用于在行数据对象数组中，指定数据填充的单元格。
display_name | 否 | String | 空 | 在表头展示的列名称。不填或为空则不展示列名称。
width | 否 | String | auto | 列宽度。可取值：<br>- auto：自适应内容宽度<br>- 自定义宽度：自定义表格的列宽度，如 120px。取值范围是 [80px,600px] 的整数<br>- 自定义宽度百分比：自定义列宽度占当前表格画布宽度的百分比（表格画布宽度 = 卡片宽度-卡片左右内边距），如 25%。取值范围是 [1%,100%]
vertical_align | 否 | String | center | 列内数据垂直对齐方式。可选值：<br>- top：顶部对齐<br>- center：中间对齐<br>- bottom：底部对齐
horizontal_align | 否 | String | left | 列内数据水平对齐方式。可选值：<br>- left：左对齐<br>- center：居中对齐<br>- right：右对齐
data_type | 是 | String | text | 列数据类型。可选值如下所示。了解不同类型用法，参考 `data_type` 字段说明一节。<br>- text：不带格式的普通文本。为 `data_type` 默认值。<br>- lark_md：支持部分 markdown 格式的文本。飞书 v7.10 及之后版本支持。详情参考[普通文本-lark_md 支持的 Markdown 语法](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/plain-text)<br>- options：选项标签。标签中的文本内容不可过长，否则可能会导致 PC 端或移动端内容显示不完整。如果文本过长，可使用 text 或者 lark_md 类型<br>- number：数字。默认在单元格中右对齐展示。若选择该数据类型，你可继续在 `column` 中添加 `format` 字段，设置数字的格式属性<br>- persons：人员列表。为用户名称+头像样式<br>- date：日期时间。需输入 Unix 标准毫秒级时间戳，飞书客户端将按用户本地时区展示日期时间。飞书 v7.6 及之后版本支持<br>- markdown：支持完整 Markdown 语法的文本内容。详情参考[富文本（Markdown）组件](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/rich-text)。飞书 v7.14 及之后版本支持
format | 否 | Object | / | 该字段仅当 `data_type` 为 `number` 时生效，你可以在该字段内选择设置小数点位数、货币单位以及千分位样式。
└ precision | 否 | Int | 空 | 数字的小数点位数。默认不限制小数点位数，原样透传展示开发者输入的数字。可填 0~10 的整数。小数点位数为 0 表示取整数。
└ symbol | 否 | String | 空 | 数字前的货币单位。不填或为空不展示。可填 1 个字符的货币单位文本，如 “¥”。
└ separator | 否 | Boolean | false | 是否生效按千分位逗号分割的数字样式。
date_format | 否 | String | 空 | 该字段仅当 `data_type` 为 `date` 时生效。你可按需选择以下日期时间占位符，并使用任意分隔符组合。<br>- YYYY：年<br>- MM：月<br>- DD：日<br>- HH：小时<br>- mm：分钟<br>- ss：秒<br>推荐使用以下日期格式。默认按 RFC 3339 标准格式展示日期时间。<br>- YYYY/MM/DD<br>- YYYY/MM/DD HH:mm<br>- YYYY-MM-DD<br>- YYYY-MM-DD HH:mm<br>- DD/MM/YYYY<br>- MM/DD/YYYY

#### `data_type` 字段说明

`data_type` 用于指定列的数据类型。`data_type` 支持的枚举值及详细说明如下所示。

data_type 枚举 | 描述 | 对应行的数据结构与示例
---|---|---
text | 不带格式的普通文本。为 data_type 默认值。 | 结构：<br>```json<br>"name":"plain text"  // 不填或为空时展示空单元格，非字符串类型转换为字符串展示<br>```<br>示例：<br>```json<br>"business_domain_name": "飞书卡片"<br>```
lark_md | 支持部分 markdown 格式的文本。详情参考[普通文本-lark_md 支持的 Markdown 语法](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/plain-text)。 | 结构：<br>```json<br>"name":"[文字链接](https://www.feishu.cn)"  // 不填或为空时展示空单元格，非字符串类型转换为字符串展示<br>```<br>示例：<br>```json<br>"customer_link": "[飞书科技_01](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)"<br>```
options | 选项标签。支持使用 color 参数自定义标签颜色。color 枚举值及展示效果如下所示。默认值为 blue。<br>**注意**：标签中的文本内容不可过长，否则可能会导致 PC 端或移动端内容显示不完整。如果文本过长，可使用 text 或者 lark_md 类型。<br>![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/7dce9769aa1475bb36bada6533775403_nCnDT2EAmq.png?height=494&lazyload=true&width=1722) | 结构：<br>```json<br>// 支持仅展示一个默认样式的标签<br>"name":"option"<br>// 支持展示多个自定义样式的标签<br>"name":[<br>{<br>"text":"option 1",<br>"color":"red"<br>},<br>{<br>"text":"option 2",<br>"color":"green"<br>}<br>]<br>```<br>示例：<br>```json<br>"customer_scale": [<br>{<br>"text": "S2",<br>"color": "green"<br>}<br>]<br>```
number | 数字。默认在单元格中右对齐展示。支持添加 format 字段，设置数字的格式属性。详情参考 format 字段说明。 | 结构：<br>```json<br>"name":NUMBER<br>```<br>示例：<br>```json<br>"customer_arr": 26.57774928467545<br>```
persons | 人员列表。为用户名称+头像样式。支持传入用户 ID 指定人员，用户 ID 类型可以是 user_id、open_id、union_id和 lark_id。了解更多 ID 相关信息，参考[用户身份概述](https://open.feishu.cn/document/home/user-identity-introduction/introduction)。<br>**注意**：当用户 ID 无效时，将展示“未知用户”样式。 | 结构：<br>```json<br>"name":[<br>"user_id_1",<br>"user_id_2",<br>…<br>] //展示多人员<br>或<br>"name":"user_id" //展示单人员<br>```<br>示例：<br>```json<br>"customer_name": "ou_c99c5f35d542efc7ee492afe11af19ef"<br>```
date | 日期时间。需输入 Unix 标准毫秒级时间戳，飞书客户端将按用户本地时区展示日期时间。<br>支持添加 date_format 字段，设置日期的格式属性。默认按 RFC 3339 标准格式展示日期时间。详情参考 date_format 字段说明。 | 结构：<br>```json<br>name":NUMBER<br>```<br>示例：<br>```json<br>"customer_date": 1606101072000  // 毫秒级时间戳<br>```
markdown | 支持完整 Markdown 语法的文本内容。详情参考[富文本（Markdown）](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/rich-text)组件。 | 结构：<br>```json<br>"name":"markdown text"  // 不填或为空时展示空单元格，非字符串类型转换为字符串展示<br>```<br>示例：<br>```json<br>"company_image": "![image.png](img_v3_02cc_bf88cdee-6650-4b39-987c-f8e87c3227fg)"<br>```

## Demo 示例

以下 JSON 2.0 结构的示例代码可实现如下图所示的卡片效果。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/3842e9152a953b188b307840ad65ef4a_Q5yCXHkNtm.gif?height=608&lazyload=true&maxWidth=434&width=610)

```json
{
  "schema": "2.0",
  "header": {
    "template": "blue",
    "title": {
      "content": "表格组件示例",
      "tag": "plain_text"
    }
  },
  "body": {
    "elements": [
      {
        "tag": "table",
        "page_size": 5,
        "row_height": "auto",
        "header_style": {
          "text_align": "left",
          "text_size": "normal",
          "background_style": "none",
          "text_color": "grey",
          "bold": true,
          "lines": 1
        },
        "columns": [
          {
            "name": "customer_name",
            "display_name": "客户名称",
            "data_type": "text",
            "horizontal_align": "left",
            "vertical_align": "top",
            "width": "auto"
          },
          {
            "name": "customer_scale",
            "display_name": "客户规模",
            "data_type": "options",
            "horizontal_align": "left",
            "vertical_align": "top",
            "width": "auto"
          },
          {
            "name": "customer_arr",
            "display_name": "ARR(万元)",
            "data_type": "number",
            "format": {
              "symbol": "¥",
              "precision": 2,
              "separator": true
            },
            "width": "auto"
          },
          {
            "name": "customer_poc",
            "display_name": "跟进人",
            "data_type": "persons",
            "horizontal_align": "left",
            "vertical_align": "top",
            "width": "auto"
          },
          {
            "name": "customer_date",
            "display_name": "签约日期",
            "data_type": "date",
            "date_format": "YYYY/MM/DD",
            "width": "auto"
          },
          {
            "name": "customer_link",
            "display_name": "相关链接",
            "data_type": "lark_md",
            "width": "auto"
          },
          {
            "name": "company_image",
            "display_name": "企业图片",
            "data_type": "markdown"
          }
        ],
        "rows": [
          {
            "customer_name": "飞书科技",
            "customer_date": 1699341315000,
            "customer_scale": [
              {
                "text": "S2",
                "color": "blue"
              }
            ],
            "customer_arr": 168,
            "customer_poc": [
              "ou_14a32f1a02e64944cf19207aa43abcef",
              "ou_e393cf9c22e6e617a4332210d2aabcef"
            ],
            "customer_link": "[飞书科技](/document-mod/index?fullPath=/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](img_v3_02cc_bf88cdee-6650-4b39-987c-f8e87c3227fg)"
          },
          {
            "customer_name": "飞书科技_01",
            "customer_date": 1606101072000,
            "customer_scale": [
              {
                "text": "S1",
                "color": "red"
              }
            ],
            "customer_arr": 168.23,
            "customer_poc": "ou_14a32f1a02e64944cf19207aa43abcef",
            "customer_link": "[飞书科技_01](/document-mod/index?fullPath=/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](img_v3_02cc_bf88cdee-6650-4b39-987c-f8e87c3227fg)"
          },
          {
            "customer_name": "飞书科技_02",
            "customer_date": 1606101072000,
            "customer_scale": [
              {
                "text": "S3",
                "color": "orange"
              }
            ],
            "customer_arr": 168.23,
            "customer_poc": "ou_14a32f1a02e64944cf19207aa43abcef",
            "customer_link": "[飞书科技_02](/document-mod/index?fullPath=/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](img_v3_02cc_bf88cdee-6650-4b39-987c-f8e87c3227fg)"
          },
          {
            "customer_name": "飞书科技_03",
            "customer_date": 1606101072000,
            "customer_scale": [
              {
                "text": "S2",
                "color": "blue"
              }
            ],
            "customer_arr": 168.23,
            "customer_poc": "ou_14a32f1a02e64944cf19207aa43abcef",
            "customer_link": "[飞书科技_03](/document-mod/index?fullPath=/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message-reaction/emojis-introduce)",
            "company_image": "![image.png](img_v3_02cc_bf88cdee-6650-4b39-987c-f8e87c3227fg)"
          }
        ]
      }
    ]
  }
}
```


# 分割线组件

你可以在卡片中添加分割线组件，使卡片内容更清晰。

本文档介绍分割线组件的 JSON 2.0 结构，要查看历史 JSON 1.0 结构，参考[分割线](https://open.feishu.cn/document/uAjLw4CM/ukzMukzMukzM/feishu-cards/card-components/content-components/divider)。

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/062d8c93b9b67ee9fb8c4188c19097d5_6kwLHW7Hfi.png?height=224&lazyload=true&maxWidth=300&width=559)

## JSON 结构

分割线的完整 JSON 2.0 结构如下所示：
```json
{
    "schema": "2.0",
    "body": {
        "elements": [
            {
                "tag": "hr",
                "element_id": "custom_id", // 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用组件相关接口中指定组件。需开发者自定义。
                "margin": "0px 0px 0px 0px" // 组件的外边距。JSON 2.0 新增属性。默认值 "0"，支持范围 [-99,99]px。
            }
        ]
    }
}
```

## 字段说明

分割线组件的字段说明如下表。

名称 | 必须 | 类型 | 默认值 | 描述
---|---|---|---|---
tag | 是 | String | 空 | 组件的标签。分割线组件的固定取值为 `hr`。
element_id | 否 | String | 空 | 操作组件的唯一标识。JSON 2.0 新增属性。用于在调用[组件相关接口](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/cardkit-v1/card-element/create)中指定组件。在同一张卡片内，该字段的值全局唯一。仅允许使用字母、数字和下划线，必须以字母开头，不得超过 20 字符。
margin | 否 | String | 0 | 组件的外边距。JSON 2.0 新增属性。值的取值范围为 [-99,99]px。可选值：<br>- 单值，如 "10px"，表示组件的四个外边距都为 10 px。<br>- 双值，如 "4px 0"，表示组件的上下外边距为 4 px，左右外边距为 0 px。使用空格间隔（边距为 0 时可不加单位）。<br>- 多值，如 "4px 0 4px 0"，表示组件的上、右、下、左的外边距分别为 4px，12px，4px，12px。使用空格间隔。

## 示例代码

以下的 JSON 2.0 示例代码可实现如下图所示的卡片效果：

![](//sf3-cn.feishucdn.com/obj/open-platform-opendoc/062d8c93b9b67ee9fb8c4188c19097d5_skrtnBe6Lz.png?height=224&lazyload=true&maxWidth=300&width=559)
```json
{
    "schema": "2.0",
    "body": {
        "direction": "vertical",
        "padding": "12px 12px 12px 12px",
        "elements": [
            {
                "tag": "div",
                "text": {
                    "tag": "plain_text",
                    "content": "普通文本示例",
                    "text_size": "normal",
                    "text_align": "left",
                    "text_color": "default"
                },
                "margin": "0px 0px 0px 0px"
            },
            {
                "tag": "hr",
                "margin": "0px 0px 0px 0px"
            },
            {
                "tag": "button",
                "text": {
                    "tag": "plain_text",
                    "content": "查看更多"
                },
                "type": "primary",
                "width": "default",
                "size": "medium",
                "margin": "0px 0px 0px 0px"
            }
        ]
    }
}
```