# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[builtins.int],
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 consistency_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_online_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_replica: Optional[pulumi.Input[builtins.str]] = None,
                 source_vol_id: Optional[pulumi.Input[builtins.str]] = None,
                 volume_retype_policy: Optional[pulumi.Input[builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[builtins.int] size: The size of the volume to create (in gigabytes).
        :param pulumi.Input[builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[builtins.str] backup_id: The backup ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
               creates a new volume. Requires microversion >= 3.47.
        :param pulumi.Input[builtins.str] consistency_group_id: The consistency group to place the volume
               in.
        :param pulumi.Input[builtins.str] description: A description of the volume. Changing this updates
               the volume's description.
        :param pulumi.Input[builtins.bool] enable_online_resize: When this option is set it allows extending
               attached volumes. Note: updating size of an attached volume requires Cinder
               support for version 3.42 and a compatible storage driver.
        :param pulumi.Input[builtins.str] image_id: The image ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to associate with the volume.
               Changing this updates the existing volume metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the volume. Changing this updates the
               volume's name.
        :param pulumi.Input[builtins.str] region: The region in which to create the volume. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]] scheduler_hints: Provide the Cinder scheduler with hints on where
               to instantiate a volume in the OpenStack cloud. The available hints are described below.
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] source_replica: The volume ID to replicate with.
        :param pulumi.Input[builtins.str] source_vol_id: The volume ID from which to create the volume.
               Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] volume_retype_policy: Migration policy when changing `volume_type`.
               `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
               allows migration if needed. Applicable only when updating `volume_type`.
        :param pulumi.Input[builtins.str] volume_type: The type of volume to create or update.
               Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        pulumi.set(__self__, "size", size)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if consistency_group_id is not None:
            pulumi.set(__self__, "consistency_group_id", consistency_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_online_resize is not None:
            pulumi.set(__self__, "enable_online_resize", enable_online_resize)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if source_replica is not None:
            pulumi.set(__self__, "source_replica", source_replica)
        if source_vol_id is not None:
            pulumi.set(__self__, "source_vol_id", source_vol_id)
        if volume_retype_policy is not None:
            pulumi.set(__self__, "volume_retype_policy", volume_retype_policy)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[builtins.int]:
        """
        The size of the volume to create (in gigabytes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone for the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backup ID from which to create the volume.
        Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
        creates a new volume. Requires microversion >= 3.47.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="consistencyGroupId")
    def consistency_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The consistency group to place the volume
        in.
        """
        return pulumi.get(self, "consistency_group_id")

    @consistency_group_id.setter
    def consistency_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consistency_group_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the volume. Changing this updates
        the volume's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableOnlineResize")
    def enable_online_resize(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this option is set it allows extending
        attached volumes. Note: updating size of an attached volume requires Cinder
        support for version 3.42 and a compatible storage driver.
        """
        return pulumi.get(self, "enable_online_resize")

    @enable_online_resize.setter
    def enable_online_resize(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_online_resize", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image ID from which to create the volume.
        Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata key/value pairs to associate with the volume.
        Changing this updates the existing volume metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the volume. Changing this updates the
        volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the volume. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]]]:
        """
        Provide the Cinder scheduler with hints on where
        to instantiate a volume in the OpenStack cloud. The available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @scheduler_hints.setter
    def scheduler_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]]]):
        pulumi.set(self, "scheduler_hints", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The snapshot ID from which to create the volume.
        Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="sourceReplica")
    def source_replica(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume ID to replicate with.
        """
        return pulumi.get(self, "source_replica")

    @source_replica.setter
    def source_replica(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_replica", value)

    @property
    @pulumi.getter(name="sourceVolId")
    def source_vol_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume ID from which to create the volume.
        Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "source_vol_id")

    @source_vol_id.setter
    def source_vol_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_vol_id", value)

    @property
    @pulumi.getter(name="volumeRetypePolicy")
    def volume_retype_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Migration policy when changing `volume_type`.
        `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
        allows migration if needed. Applicable only when updating `volume_type`.
        """
        return pulumi.get(self, "volume_retype_policy")

    @volume_retype_policy.setter
    def volume_retype_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_retype_policy", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of volume to create or update.
        Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 consistency_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_online_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_replica: Optional[pulumi.Input[builtins.str]] = None,
                 source_vol_id: Optional[pulumi.Input[builtins.str]] = None,
                 volume_retype_policy: Optional[pulumi.Input[builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]] attachments: If a volume is attached to an instance, this attribute will
               display the Attachment ID, Instance ID, and the Device as the Instance
               sees it.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[builtins.str] backup_id: The backup ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
               creates a new volume. Requires microversion >= 3.47.
        :param pulumi.Input[builtins.str] consistency_group_id: The consistency group to place the volume
               in.
        :param pulumi.Input[builtins.str] description: A description of the volume. Changing this updates
               the volume's description.
        :param pulumi.Input[builtins.bool] enable_online_resize: When this option is set it allows extending
               attached volumes. Note: updating size of an attached volume requires Cinder
               support for version 3.42 and a compatible storage driver.
        :param pulumi.Input[builtins.str] image_id: The image ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to associate with the volume.
               Changing this updates the existing volume metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the volume. Changing this updates the
               volume's name.
        :param pulumi.Input[builtins.str] region: The region in which to create the volume. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]] scheduler_hints: Provide the Cinder scheduler with hints on where
               to instantiate a volume in the OpenStack cloud. The available hints are described below.
        :param pulumi.Input[builtins.int] size: The size of the volume to create (in gigabytes).
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] source_replica: The volume ID to replicate with.
        :param pulumi.Input[builtins.str] source_vol_id: The volume ID from which to create the volume.
               Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] volume_retype_policy: Migration policy when changing `volume_type`.
               `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
               allows migration if needed. Applicable only when updating `volume_type`.
        :param pulumi.Input[builtins.str] volume_type: The type of volume to create or update.
               Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if consistency_group_id is not None:
            pulumi.set(__self__, "consistency_group_id", consistency_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_online_resize is not None:
            pulumi.set(__self__, "enable_online_resize", enable_online_resize)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if source_replica is not None:
            pulumi.set(__self__, "source_replica", source_replica)
        if source_vol_id is not None:
            pulumi.set(__self__, "source_vol_id", source_vol_id)
        if volume_retype_policy is not None:
            pulumi.set(__self__, "volume_retype_policy", volume_retype_policy)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]]:
        """
        If a volume is attached to an instance, this attribute will
        display the Attachment ID, Instance ID, and the Device as the Instance
        sees it.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone for the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backup ID from which to create the volume.
        Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
        creates a new volume. Requires microversion >= 3.47.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="consistencyGroupId")
    def consistency_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The consistency group to place the volume
        in.
        """
        return pulumi.get(self, "consistency_group_id")

    @consistency_group_id.setter
    def consistency_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consistency_group_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the volume. Changing this updates
        the volume's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableOnlineResize")
    def enable_online_resize(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When this option is set it allows extending
        attached volumes. Note: updating size of an attached volume requires Cinder
        support for version 3.42 and a compatible storage driver.
        """
        return pulumi.get(self, "enable_online_resize")

    @enable_online_resize.setter
    def enable_online_resize(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_online_resize", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image ID from which to create the volume.
        Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata key/value pairs to associate with the volume.
        Changing this updates the existing volume metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the volume. Changing this updates the
        volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the volume. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]]]:
        """
        Provide the Cinder scheduler with hints on where
        to instantiate a volume in the OpenStack cloud. The available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @scheduler_hints.setter
    def scheduler_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSchedulerHintArgs']]]]):
        pulumi.set(self, "scheduler_hints", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of the volume to create (in gigabytes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The snapshot ID from which to create the volume.
        Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="sourceReplica")
    def source_replica(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume ID to replicate with.
        """
        return pulumi.get(self, "source_replica")

    @source_replica.setter
    def source_replica(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_replica", value)

    @property
    @pulumi.getter(name="sourceVolId")
    def source_vol_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume ID from which to create the volume.
        Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "source_vol_id")

    @source_vol_id.setter
    def source_vol_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_vol_id", value)

    @property
    @pulumi.getter(name="volumeRetypePolicy")
    def volume_retype_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Migration policy when changing `volume_type`.
        `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
        allows migration if needed. Applicable only when updating `volume_type`.
        """
        return pulumi.get(self, "volume_retype_policy")

    @volume_retype_policy.setter
    def volume_retype_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_retype_policy", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of volume to create or update.
        Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("openstack:blockstorage/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 consistency_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_online_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeSchedulerHintArgs', 'VolumeSchedulerHintArgsDict']]]]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_replica: Optional[pulumi.Input[builtins.str]] = None,
                 source_vol_id: Optional[pulumi.Input[builtins.str]] = None,
                 volume_retype_policy: Optional[pulumi.Input[builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a V3 volume resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        volume1 = openstack.blockstorage.Volume("volume_1",
            region="RegionOne",
            name="volume_1",
            description="first test volume",
            size=3)
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:blockstorage/volume:Volume volume_1 ea257959-eeb1-4c10-8d33-26f0409a755d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[builtins.str] backup_id: The backup ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
               creates a new volume. Requires microversion >= 3.47.
        :param pulumi.Input[builtins.str] consistency_group_id: The consistency group to place the volume
               in.
        :param pulumi.Input[builtins.str] description: A description of the volume. Changing this updates
               the volume's description.
        :param pulumi.Input[builtins.bool] enable_online_resize: When this option is set it allows extending
               attached volumes. Note: updating size of an attached volume requires Cinder
               support for version 3.42 and a compatible storage driver.
        :param pulumi.Input[builtins.str] image_id: The image ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to associate with the volume.
               Changing this updates the existing volume metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the volume. Changing this updates the
               volume's name.
        :param pulumi.Input[builtins.str] region: The region in which to create the volume. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new volume.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeSchedulerHintArgs', 'VolumeSchedulerHintArgsDict']]]] scheduler_hints: Provide the Cinder scheduler with hints on where
               to instantiate a volume in the OpenStack cloud. The available hints are described below.
        :param pulumi.Input[builtins.int] size: The size of the volume to create (in gigabytes).
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] source_replica: The volume ID to replicate with.
        :param pulumi.Input[builtins.str] source_vol_id: The volume ID from which to create the volume.
               Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] volume_retype_policy: Migration policy when changing `volume_type`.
               `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
               allows migration if needed. Applicable only when updating `volume_type`.
        :param pulumi.Input[builtins.str] volume_type: The type of volume to create or update.
               Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V3 volume resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        volume1 = openstack.blockstorage.Volume("volume_1",
            region="RegionOne",
            name="volume_1",
            description="first test volume",
            size=3)
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:blockstorage/volume:Volume volume_1 ea257959-eeb1-4c10-8d33-26f0409a755d
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 consistency_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_online_resize: Optional[pulumi.Input[builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeSchedulerHintArgs', 'VolumeSchedulerHintArgsDict']]]]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_replica: Optional[pulumi.Input[builtins.str]] = None,
                 source_vol_id: Optional[pulumi.Input[builtins.str]] = None,
                 volume_retype_policy: Optional[pulumi.Input[builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["consistency_group_id"] = consistency_group_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_online_resize"] = enable_online_resize
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduler_hints"] = scheduler_hints
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["source_replica"] = source_replica
            __props__.__dict__["source_vol_id"] = source_vol_id
            __props__.__dict__["volume_retype_policy"] = volume_retype_policy
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["attachments"] = None
        super(Volume, __self__).__init__(
            'openstack:blockstorage/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeAttachmentArgs', 'VolumeAttachmentArgsDict']]]]] = None,
            availability_zone: Optional[pulumi.Input[builtins.str]] = None,
            backup_id: Optional[pulumi.Input[builtins.str]] = None,
            consistency_group_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable_online_resize: Optional[pulumi.Input[builtins.bool]] = None,
            image_id: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeSchedulerHintArgs', 'VolumeSchedulerHintArgsDict']]]]] = None,
            size: Optional[pulumi.Input[builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            source_replica: Optional[pulumi.Input[builtins.str]] = None,
            source_vol_id: Optional[pulumi.Input[builtins.str]] = None,
            volume_retype_policy: Optional[pulumi.Input[builtins.str]] = None,
            volume_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeAttachmentArgs', 'VolumeAttachmentArgsDict']]]] attachments: If a volume is attached to an instance, this attribute will
               display the Attachment ID, Instance ID, and the Device as the Instance
               sees it.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[builtins.str] backup_id: The backup ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
               creates a new volume. Requires microversion >= 3.47.
        :param pulumi.Input[builtins.str] consistency_group_id: The consistency group to place the volume
               in.
        :param pulumi.Input[builtins.str] description: A description of the volume. Changing this updates
               the volume's description.
        :param pulumi.Input[builtins.bool] enable_online_resize: When this option is set it allows extending
               attached volumes. Note: updating size of an attached volume requires Cinder
               support for version 3.42 and a compatible storage driver.
        :param pulumi.Input[builtins.str] image_id: The image ID from which to create the volume.
               Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to associate with the volume.
               Changing this updates the existing volume metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the volume. Changing this updates the
               volume's name.
        :param pulumi.Input[builtins.str] region: The region in which to create the volume. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new volume.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeSchedulerHintArgs', 'VolumeSchedulerHintArgsDict']]]] scheduler_hints: Provide the Cinder scheduler with hints on where
               to instantiate a volume in the OpenStack cloud. The available hints are described below.
        :param pulumi.Input[builtins.int] size: The size of the volume to create (in gigabytes).
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] source_replica: The volume ID to replicate with.
        :param pulumi.Input[builtins.str] source_vol_id: The volume ID from which to create the volume.
               Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
               creates a new volume.
        :param pulumi.Input[builtins.str] volume_retype_policy: Migration policy when changing `volume_type`.
               `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
               allows migration if needed. Applicable only when updating `volume_type`.
        :param pulumi.Input[builtins.str] volume_type: The type of volume to create or update.
               Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["consistency_group_id"] = consistency_group_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_online_resize"] = enable_online_resize
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduler_hints"] = scheduler_hints
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["source_replica"] = source_replica
        __props__.__dict__["source_vol_id"] = source_vol_id
        __props__.__dict__["volume_retype_policy"] = volume_retype_policy
        __props__.__dict__["volume_type"] = volume_type
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.VolumeAttachment']]:
        """
        If a volume is attached to an instance, this attribute will
        display the Attachment ID, Instance ID, and the Device as the Instance
        sees it.
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        The availability zone for the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The backup ID from which to create the volume.
        Conflicts with `snapshot_id`, `source_vol_id`, `image_id`. Changing this
        creates a new volume. Requires microversion >= 3.47.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="consistencyGroupId")
    def consistency_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The consistency group to place the volume
        in.
        """
        return pulumi.get(self, "consistency_group_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the volume. Changing this updates
        the volume's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableOnlineResize")
    def enable_online_resize(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When this option is set it allows extending
        attached volumes. Note: updating size of an attached volume requires Cinder
        support for version 3.42 and a compatible storage driver.
        """
        return pulumi.get(self, "enable_online_resize")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The image ID from which to create the volume.
        Conflicts with `snapshot_id`, `source_vol_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Metadata key/value pairs to associate with the volume.
        Changing this updates the existing volume metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the volume. Changing this updates the
        volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to create the volume. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeSchedulerHint']]]:
        """
        Provide the Cinder scheduler with hints on where
        to instantiate a volume in the OpenStack cloud. The available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[builtins.int]:
        """
        The size of the volume to create (in gigabytes).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The snapshot ID from which to create the volume.
        Conflicts with `source_vol_id`, `image_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="sourceReplica")
    def source_replica(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The volume ID to replicate with.
        """
        return pulumi.get(self, "source_replica")

    @property
    @pulumi.getter(name="sourceVolId")
    def source_vol_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The volume ID from which to create the volume.
        Conflicts with `snapshot_id`, `image_id`, `backup_id`. Changing this
        creates a new volume.
        """
        return pulumi.get(self, "source_vol_id")

    @property
    @pulumi.getter(name="volumeRetypePolicy")
    def volume_retype_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Migration policy when changing `volume_type`.
        `"never"` *(default)* prevents migration to another storage backend, while `"on-demand"`
        allows migration if needed. Applicable only when updating `volume_type`.
        """
        return pulumi.get(self, "volume_retype_policy")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of volume to create or update.
        Changing this will attempt an in-place retype operation; migration depends on `volume_retype_policy`.
        """
        return pulumi.get(self, "volume_type")

