# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKeypairResult',
    'AwaitableGetKeypairResult',
    'get_keypair',
    'get_keypair_output',
]

@pulumi.output_type
class GetKeypairResult:
    """
    A collection of values returned by getKeypair.
    """
    def __init__(__self__, fingerprint=None, id=None, name=None, public_key=None, region=None, user_id=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def fingerprint(self) -> builtins.str:
        """
        The fingerprint of the OpenSSH key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        The OpenSSH-formatted public key of the keypair.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetKeypairResult(GetKeypairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeypairResult(
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            public_key=self.public_key,
            region=self.region,
            user_id=self.user_id)


def get_keypair(name: Optional[builtins.str] = None,
                region: Optional[builtins.str] = None,
                user_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeypairResult:
    """
    Use this data source to get the ID and public key of an OpenStack keypair.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    kp = openstack.compute.get_keypair(name="sand")
    ```


    :param builtins.str name: The unique name of the keypair.
    :param builtins.str region: The region in which to obtain the V2 Compute client.
           If omitted, the `region` argument of the provider is used.
    :param builtins.str user_id: The user id of the owner of the key pair.
           This parameter can be specified only if the provider is configured to use
           the credentials of an OpenStack administrator.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:compute/getKeypair:getKeypair', __args__, opts=opts, typ=GetKeypairResult).value

    return AwaitableGetKeypairResult(
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'),
        region=pulumi.get(__ret__, 'region'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_keypair_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       user_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeypairResult]:
    """
    Use this data source to get the ID and public key of an OpenStack keypair.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    kp = openstack.compute.get_keypair(name="sand")
    ```


    :param builtins.str name: The unique name of the keypair.
    :param builtins.str region: The region in which to obtain the V2 Compute client.
           If omitted, the `region` argument of the provider is used.
    :param builtins.str user_id: The user id of the owner of the key pair.
           This parameter can be specified only if the provider is configured to use
           the credentials of an OpenStack administrator.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:compute/getKeypair:getKeypair', __args__, opts=opts, typ=GetKeypairResult)
    return __ret__.apply(lambda __response__: GetKeypairResult(
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public_key=pulumi.get(__response__, 'public_key'),
        region=pulumi.get(__response__, 'region'),
        user_id=pulumi.get(__response__, 'user_id')))
