# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_hints: Optional[pulumi.Input[builtins.str]] = None,
                 block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]]] = None,
                 config_drive: Optional[pulumi.Input[builtins.bool]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 hypervisor_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]] = None,
                 personalities: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]]] = None,
                 power_state: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 stop_before_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input['InstanceVendorOptionsArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] admin_pass: The administrative password to assign to the server.
               Changing this changes the root password on the existing server.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone in which to create
               the server. Conflicts with `availability_zone_hints`. Changing this creates
               a new server.
        :param pulumi.Input[builtins.str] availability_zone_hints: The availability zone in which to
               create the server. This argument is preferred to `availability_zone`, when
               scheduling the server on a
               [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
               host or node. Conflicts with `availability_zone`. Changing this creates a
               new server.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]] block_devices: Configuration of block devices. The block_device
               structure is documented below. Changing this creates a new server.
               You can specify multiple block devices which will create an instance with
               multiple disks. This configuration is very flexible, so please see the
               following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
               for more information.
        :param pulumi.Input[builtins.bool] config_drive: Whether to use the config_drive feature to
               configure the instance. Changing this creates a new server.
        :param pulumi.Input[builtins.str] flavor_id: The flavor ID of
               the desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.str] flavor_name: The name of the
               desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.bool] force_delete: Whether to force the OpenStack instance to be
               forcefully deleted. This is useful for environments that have reclaim / soft
               deletion enabled.
        :param pulumi.Input[builtins.str] hypervisor_hostname: Specifies the exact hypervisor hostname on
               which to create the instance. When provided, this parameter is included in
               the request to Nova, directing the scheduler to launch the instance on the
               specified host. Note: This option requires administrative privileges and a
               Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
               this value forces a new instance to be created.
        :param pulumi.Input[builtins.str] image_id: (Optional; Required if `image_name` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The image ID of
               the desired image for the server. Changing this rebuilds the existing
               server.
        :param pulumi.Input[builtins.str] image_name: (Optional; Required if `image_id` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The name of the
               desired image for the server. Changing this rebuilds the existing server.
        :param pulumi.Input[builtins.str] key_pair: The name of a key pair to put on the server. The key
               pair must already be created and associated with the tenant's account.
               Changing this creates a new server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Changing this updates the existing server metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the resource.
        :param pulumi.Input[builtins.str] network_mode: Special string for `network` option to create
               the server. `network_mode` can be `"auto"` or `"none"`.
               Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]] personalities: Customize the personality of an instance by
               defining one or more files and their contents. The personality structure is
               described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
               the existing server.
        :param pulumi.Input[builtins.str] power_state: Provide the VM state. Only 'active', 'shutoff', 'paused'
               and 'shelved_offloaded' are supported values.
               *Note*: If the initial power_state is the shutoff or paused
               the VM will be stopped immediately after build and the provisioners like
               remote-exec or files are not supported.
        :param pulumi.Input[builtins.str] region: The region in which to create the server instance. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]] scheduler_hints: Provide the Nova scheduler with hints on how
               the instance should be launched. The available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: An array of one or more security group names
               to associate with the server. Changing this results in adding/removing
               security groups from the existing server. *Note*: When attaching the
               instance to networks using Ports, place the security groups on the Port
               and not the instance. *Note*: Names should be used and not ids, as ids
               trigger unnecessary updates.
        :param pulumi.Input[builtins.bool] stop_before_destroy: Whether to try stop instance gracefully
               before destroying it, thus giving chance for guest OS daemons to stop correctly.
               If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the instance. Changing this
               updates the existing instance tags.
        :param pulumi.Input[builtins.str] user_data: The user data to provide when launching the instance.
               Changing this creates a new server.
        :param pulumi.Input['InstanceVendorOptionsArgs'] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_hints is not None:
            pulumi.set(__self__, "availability_zone_hints", availability_zone_hints)
        if block_devices is not None:
            pulumi.set(__self__, "block_devices", block_devices)
        if config_drive is not None:
            pulumi.set(__self__, "config_drive", config_drive)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if hypervisor_hostname is not None:
            pulumi.set(__self__, "hypervisor_hostname", hypervisor_hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if personalities is not None:
            pulumi.set(__self__, "personalities", personalities)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if stop_before_destroy is not None:
            pulumi.set(__self__, "stop_before_destroy", stop_before_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vendor_options is not None:
            pulumi.set(__self__, "vendor_options", vendor_options)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The administrative password to assign to the server.
        Changing this changes the root password on the existing server.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone in which to create
        the server. Conflicts with `availability_zone_hints`. Changing this creates
        a new server.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone in which to
        create the server. This argument is preferred to `availability_zone`, when
        scheduling the server on a
        [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
        host or node. Conflicts with `availability_zone`. Changing this creates a
        new server.
        """
        return pulumi.get(self, "availability_zone_hints")

    @availability_zone_hints.setter
    def availability_zone_hints(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone_hints", value)

    @property
    @pulumi.getter(name="blockDevices")
    def block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]]]:
        """
        Configuration of block devices. The block_device
        structure is documented below. Changing this creates a new server.
        You can specify multiple block devices which will create an instance with
        multiple disks. This configuration is very flexible, so please see the
        following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
        for more information.
        """
        return pulumi.get(self, "block_devices")

    @block_devices.setter
    def block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]]]):
        pulumi.set(self, "block_devices", value)

    @property
    @pulumi.getter(name="configDrive")
    def config_drive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to use the config_drive feature to
        configure the instance. Changing this creates a new server.
        """
        return pulumi.get(self, "config_drive")

    @config_drive.setter
    def config_drive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "config_drive", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The flavor ID of
        the desired flavor for the server. Changing this resizes the existing server.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the
        desired flavor for the server. Changing this resizes the existing server.
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to force the OpenStack instance to be
        forcefully deleted. This is useful for environments that have reclaim / soft
        deletion enabled.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hypervisorHostname")
    def hypervisor_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the exact hypervisor hostname on
        which to create the instance. When provided, this parameter is included in
        the request to Nova, directing the scheduler to launch the instance on the
        specified host. Note: This option requires administrative privileges and a
        Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
        this value forces a new instance to be created.
        """
        return pulumi.get(self, "hypervisor_hostname")

    @hypervisor_hostname.setter
    def hypervisor_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hypervisor_hostname", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional; Required if `image_name` is empty and not booting
        from a volume. Do not specify if booting from a volume.) The image ID of
        the desired image for the server. Changing this rebuilds the existing
        server.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional; Required if `image_id` is empty and not booting
        from a volume. Do not specify if booting from a volume.) The name of the
        desired image for the server. Changing this rebuilds the existing server.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a key pair to put on the server. The key
        pair must already be created and associated with the tenant's account.
        Changing this creates a new server.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata key/value pairs to make available from
        within the instance. Changing this updates the existing server metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Special string for `network` option to create
        the server. `network_mode` can be `"auto"` or `"none"`.
        Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]:
        """
        An array of one or more networks to attach to the
        instance. The network object structure is documented below. Changing this
        creates a new server.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def personalities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]]]:
        """
        Customize the personality of an instance by
        defining one or more files and their contents. The personality structure is
        described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
        the existing server.
        """
        return pulumi.get(self, "personalities")

    @personalities.setter
    def personalities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]]]):
        pulumi.set(self, "personalities", value)

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide the VM state. Only 'active', 'shutoff', 'paused'
        and 'shelved_offloaded' are supported values.
        *Note*: If the initial power_state is the shutoff or paused
        the VM will be stopped immediately after build and the provisioners like
        remote-exec or files are not supported.
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "power_state", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the server instance. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new server.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]:
        """
        Provide the Nova scheduler with hints on how
        the instance should be launched. The available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @scheduler_hints.setter
    def scheduler_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]):
        pulumi.set(self, "scheduler_hints", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of one or more security group names
        to associate with the server. Changing this results in adding/removing
        security groups from the existing server. *Note*: When attaching the
        instance to networks using Ports, place the security groups on the Port
        and not the instance. *Note*: Names should be used and not ids, as ids
        trigger unnecessary updates.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="stopBeforeDestroy")
    def stop_before_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to try stop instance gracefully
        before destroying it, thus giving chance for guest OS daemons to stop correctly.
        If instance doesn't stop within timeout, it will be destroyed anyway.
        """
        return pulumi.get(self, "stop_before_destroy")

    @stop_before_destroy.setter
    def stop_before_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stop_before_destroy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of string tags for the instance. Changing this
        updates the existing instance tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user data to provide when launching the instance.
        Changing this creates a new server.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional[pulumi.Input['InstanceVendorOptionsArgs']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @vendor_options.setter
    def vendor_options(self, value: Optional[pulumi.Input['InstanceVendorOptionsArgs']]):
        pulumi.set(self, "vendor_options", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 access_ip_v4: Optional[pulumi.Input[builtins.str]] = None,
                 access_ip_v6: Optional[pulumi.Input[builtins.str]] = None,
                 admin_pass: Optional[pulumi.Input[builtins.str]] = None,
                 all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_hints: Optional[pulumi.Input[builtins.str]] = None,
                 block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]]] = None,
                 config_drive: Optional[pulumi.Input[builtins.bool]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 hypervisor_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]] = None,
                 personalities: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]]] = None,
                 power_state: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 stop_before_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated: Optional[pulumi.Input[builtins.str]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input['InstanceVendorOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.str] access_ip_v4: The first detected Fixed IPv4 address.
        :param pulumi.Input[builtins.str] access_ip_v6: The first detected Fixed IPv6 address.
        :param pulumi.Input[builtins.str] admin_pass: The administrative password to assign to the server.
               Changing this changes the root password on the existing server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] all_tags: The collection of tags assigned on the instance, which have
               been explicitly and implicitly added.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone in which to create
               the server. Conflicts with `availability_zone_hints`. Changing this creates
               a new server.
        :param pulumi.Input[builtins.str] availability_zone_hints: The availability zone in which to
               create the server. This argument is preferred to `availability_zone`, when
               scheduling the server on a
               [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
               host or node. Conflicts with `availability_zone`. Changing this creates a
               new server.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]] block_devices: Configuration of block devices. The block_device
               structure is documented below. Changing this creates a new server.
               You can specify multiple block devices which will create an instance with
               multiple disks. This configuration is very flexible, so please see the
               following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
               for more information.
        :param pulumi.Input[builtins.bool] config_drive: Whether to use the config_drive feature to
               configure the instance. Changing this creates a new server.
        :param pulumi.Input[builtins.str] created: The creation time of the instance.
        :param pulumi.Input[builtins.str] flavor_id: The flavor ID of
               the desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.str] flavor_name: The name of the
               desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.bool] force_delete: Whether to force the OpenStack instance to be
               forcefully deleted. This is useful for environments that have reclaim / soft
               deletion enabled.
        :param pulumi.Input[builtins.str] hypervisor_hostname: Specifies the exact hypervisor hostname on
               which to create the instance. When provided, this parameter is included in
               the request to Nova, directing the scheduler to launch the instance on the
               specified host. Note: This option requires administrative privileges and a
               Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
               this value forces a new instance to be created.
        :param pulumi.Input[builtins.str] image_id: (Optional; Required if `image_name` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The image ID of
               the desired image for the server. Changing this rebuilds the existing
               server.
        :param pulumi.Input[builtins.str] image_name: (Optional; Required if `image_id` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The name of the
               desired image for the server. Changing this rebuilds the existing server.
        :param pulumi.Input[builtins.str] key_pair: The name of a key pair to put on the server. The key
               pair must already be created and associated with the tenant's account.
               Changing this creates a new server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Changing this updates the existing server metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the resource.
        :param pulumi.Input[builtins.str] network_mode: Special string for `network` option to create
               the server. `network_mode` can be `"auto"` or `"none"`.
               Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]] personalities: Customize the personality of an instance by
               defining one or more files and their contents. The personality structure is
               described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
               the existing server.
        :param pulumi.Input[builtins.str] power_state: Provide the VM state. Only 'active', 'shutoff', 'paused'
               and 'shelved_offloaded' are supported values.
               *Note*: If the initial power_state is the shutoff or paused
               the VM will be stopped immediately after build and the provisioners like
               remote-exec or files are not supported.
        :param pulumi.Input[builtins.str] region: The region in which to create the server instance. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]] scheduler_hints: Provide the Nova scheduler with hints on how
               the instance should be launched. The available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: An array of one or more security group names
               to associate with the server. Changing this results in adding/removing
               security groups from the existing server. *Note*: When attaching the
               instance to networks using Ports, place the security groups on the Port
               and not the instance. *Note*: Names should be used and not ids, as ids
               trigger unnecessary updates.
        :param pulumi.Input[builtins.bool] stop_before_destroy: Whether to try stop instance gracefully
               before destroying it, thus giving chance for guest OS daemons to stop correctly.
               If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the instance. Changing this
               updates the existing instance tags.
        :param pulumi.Input[builtins.str] updated: The time when the instance was last updated.
        :param pulumi.Input[builtins.str] user_data: The user data to provide when launching the instance.
               Changing this creates a new server.
        :param pulumi.Input['InstanceVendorOptionsArgs'] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        if access_ip_v4 is not None:
            pulumi.set(__self__, "access_ip_v4", access_ip_v4)
        if access_ip_v6 is not None:
            pulumi.set(__self__, "access_ip_v6", access_ip_v6)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if all_metadata is not None:
            pulumi.set(__self__, "all_metadata", all_metadata)
        if all_tags is not None:
            pulumi.set(__self__, "all_tags", all_tags)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_hints is not None:
            pulumi.set(__self__, "availability_zone_hints", availability_zone_hints)
        if block_devices is not None:
            pulumi.set(__self__, "block_devices", block_devices)
        if config_drive is not None:
            pulumi.set(__self__, "config_drive", config_drive)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if hypervisor_hostname is not None:
            pulumi.set(__self__, "hypervisor_hostname", hypervisor_hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if personalities is not None:
            pulumi.set(__self__, "personalities", personalities)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if stop_before_destroy is not None:
            pulumi.set(__self__, "stop_before_destroy", stop_before_destroy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vendor_options is not None:
            pulumi.set(__self__, "vendor_options", vendor_options)

    @property
    @pulumi.getter(name="accessIpV4")
    def access_ip_v4(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The first detected Fixed IPv4 address.
        """
        return pulumi.get(self, "access_ip_v4")

    @access_ip_v4.setter
    def access_ip_v4(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_ip_v4", value)

    @property
    @pulumi.getter(name="accessIpV6")
    def access_ip_v6(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The first detected Fixed IPv6 address.
        """
        return pulumi.get(self, "access_ip_v6")

    @access_ip_v6.setter
    def access_ip_v6(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_ip_v6", value)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The administrative password to assign to the server.
        Changing this changes the root password on the existing server.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "all_metadata")

    @all_metadata.setter
    def all_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "all_metadata", value)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The collection of tags assigned on the instance, which have
        been explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @all_tags.setter
    def all_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "all_tags", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone in which to create
        the server. Conflicts with `availability_zone_hints`. Changing this creates
        a new server.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone in which to
        create the server. This argument is preferred to `availability_zone`, when
        scheduling the server on a
        [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
        host or node. Conflicts with `availability_zone`. Changing this creates a
        new server.
        """
        return pulumi.get(self, "availability_zone_hints")

    @availability_zone_hints.setter
    def availability_zone_hints(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone_hints", value)

    @property
    @pulumi.getter(name="blockDevices")
    def block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]]]:
        """
        Configuration of block devices. The block_device
        structure is documented below. Changing this creates a new server.
        You can specify multiple block devices which will create an instance with
        multiple disks. This configuration is very flexible, so please see the
        following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
        for more information.
        """
        return pulumi.get(self, "block_devices")

    @block_devices.setter
    def block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceArgs']]]]):
        pulumi.set(self, "block_devices", value)

    @property
    @pulumi.getter(name="configDrive")
    def config_drive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to use the config_drive feature to
        configure the instance. Changing this creates a new server.
        """
        return pulumi.get(self, "config_drive")

    @config_drive.setter
    def config_drive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "config_drive", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation time of the instance.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The flavor ID of
        the desired flavor for the server. Changing this resizes the existing server.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the
        desired flavor for the server. Changing this resizes the existing server.
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to force the OpenStack instance to be
        forcefully deleted. This is useful for environments that have reclaim / soft
        deletion enabled.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hypervisorHostname")
    def hypervisor_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the exact hypervisor hostname on
        which to create the instance. When provided, this parameter is included in
        the request to Nova, directing the scheduler to launch the instance on the
        specified host. Note: This option requires administrative privileges and a
        Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
        this value forces a new instance to be created.
        """
        return pulumi.get(self, "hypervisor_hostname")

    @hypervisor_hostname.setter
    def hypervisor_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hypervisor_hostname", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional; Required if `image_name` is empty and not booting
        from a volume. Do not specify if booting from a volume.) The image ID of
        the desired image for the server. Changing this rebuilds the existing
        server.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional; Required if `image_id` is empty and not booting
        from a volume. Do not specify if booting from a volume.) The name of the
        desired image for the server. Changing this rebuilds the existing server.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a key pair to put on the server. The key
        pair must already be created and associated with the tenant's account.
        Changing this creates a new server.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata key/value pairs to make available from
        within the instance. Changing this updates the existing server metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Special string for `network` option to create
        the server. `network_mode` can be `"auto"` or `"none"`.
        Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]:
        """
        An array of one or more networks to attach to the
        instance. The network object structure is documented below. Changing this
        creates a new server.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def personalities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]]]:
        """
        Customize the personality of an instance by
        defining one or more files and their contents. The personality structure is
        described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
        the existing server.
        """
        return pulumi.get(self, "personalities")

    @personalities.setter
    def personalities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePersonalityArgs']]]]):
        pulumi.set(self, "personalities", value)

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide the VM state. Only 'active', 'shutoff', 'paused'
        and 'shelved_offloaded' are supported values.
        *Note*: If the initial power_state is the shutoff or paused
        the VM will be stopped immediately after build and the provisioners like
        remote-exec or files are not supported.
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "power_state", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the server instance. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new server.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]:
        """
        Provide the Nova scheduler with hints on how
        the instance should be launched. The available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @scheduler_hints.setter
    def scheduler_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]):
        pulumi.set(self, "scheduler_hints", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of one or more security group names
        to associate with the server. Changing this results in adding/removing
        security groups from the existing server. *Note*: When attaching the
        instance to networks using Ports, place the security groups on the Port
        and not the instance. *Note*: Names should be used and not ids, as ids
        trigger unnecessary updates.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="stopBeforeDestroy")
    def stop_before_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to try stop instance gracefully
        before destroying it, thus giving chance for guest OS daemons to stop correctly.
        If instance doesn't stop within timeout, it will be destroyed anyway.
        """
        return pulumi.get(self, "stop_before_destroy")

    @stop_before_destroy.setter
    def stop_before_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stop_before_destroy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of string tags for the instance. Changing this
        updates the existing instance tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the instance was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user data to provide when launching the instance.
        Changing this creates a new server.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional[pulumi.Input['InstanceVendorOptionsArgs']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @vendor_options.setter
    def vendor_options(self, value: Optional[pulumi.Input['InstanceVendorOptionsArgs']]):
        pulumi.set(self, "vendor_options", value)


@pulumi.type_token("openstack:compute/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_hints: Optional[pulumi.Input[builtins.str]] = None,
                 block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceArgs', 'InstanceBlockDeviceArgsDict']]]]] = None,
                 config_drive: Optional[pulumi.Input[builtins.bool]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 hypervisor_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
                 personalities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePersonalityArgs', 'InstancePersonalityArgsDict']]]]] = None,
                 power_state: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 stop_before_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input[Union['InstanceVendorOptionsArgs', 'InstanceVendorOptionsArgsDict']]] = None,
                 __props__=None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_pass: The administrative password to assign to the server.
               Changing this changes the root password on the existing server.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone in which to create
               the server. Conflicts with `availability_zone_hints`. Changing this creates
               a new server.
        :param pulumi.Input[builtins.str] availability_zone_hints: The availability zone in which to
               create the server. This argument is preferred to `availability_zone`, when
               scheduling the server on a
               [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
               host or node. Conflicts with `availability_zone`. Changing this creates a
               new server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceArgs', 'InstanceBlockDeviceArgsDict']]]] block_devices: Configuration of block devices. The block_device
               structure is documented below. Changing this creates a new server.
               You can specify multiple block devices which will create an instance with
               multiple disks. This configuration is very flexible, so please see the
               following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
               for more information.
        :param pulumi.Input[builtins.bool] config_drive: Whether to use the config_drive feature to
               configure the instance. Changing this creates a new server.
        :param pulumi.Input[builtins.str] flavor_id: The flavor ID of
               the desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.str] flavor_name: The name of the
               desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.bool] force_delete: Whether to force the OpenStack instance to be
               forcefully deleted. This is useful for environments that have reclaim / soft
               deletion enabled.
        :param pulumi.Input[builtins.str] hypervisor_hostname: Specifies the exact hypervisor hostname on
               which to create the instance. When provided, this parameter is included in
               the request to Nova, directing the scheduler to launch the instance on the
               specified host. Note: This option requires administrative privileges and a
               Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
               this value forces a new instance to be created.
        :param pulumi.Input[builtins.str] image_id: (Optional; Required if `image_name` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The image ID of
               the desired image for the server. Changing this rebuilds the existing
               server.
        :param pulumi.Input[builtins.str] image_name: (Optional; Required if `image_id` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The name of the
               desired image for the server. Changing this rebuilds the existing server.
        :param pulumi.Input[builtins.str] key_pair: The name of a key pair to put on the server. The key
               pair must already be created and associated with the tenant's account.
               Changing this creates a new server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Changing this updates the existing server metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the resource.
        :param pulumi.Input[builtins.str] network_mode: Special string for `network` option to create
               the server. `network_mode` can be `"auto"` or `"none"`.
               Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePersonalityArgs', 'InstancePersonalityArgsDict']]]] personalities: Customize the personality of an instance by
               defining one or more files and their contents. The personality structure is
               described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
               the existing server.
        :param pulumi.Input[builtins.str] power_state: Provide the VM state. Only 'active', 'shutoff', 'paused'
               and 'shelved_offloaded' are supported values.
               *Note*: If the initial power_state is the shutoff or paused
               the VM will be stopped immediately after build and the provisioners like
               remote-exec or files are not supported.
        :param pulumi.Input[builtins.str] region: The region in which to create the server instance. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]] scheduler_hints: Provide the Nova scheduler with hints on how
               the instance should be launched. The available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: An array of one or more security group names
               to associate with the server. Changing this results in adding/removing
               security groups from the existing server. *Note*: When attaching the
               instance to networks using Ports, place the security groups on the Port
               and not the instance. *Note*: Names should be used and not ids, as ids
               trigger unnecessary updates.
        :param pulumi.Input[builtins.bool] stop_before_destroy: Whether to try stop instance gracefully
               before destroying it, thus giving chance for guest OS daemons to stop correctly.
               If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the instance. Changing this
               updates the existing instance tags.
        :param pulumi.Input[builtins.str] user_data: The user data to provide when launching the instance.
               Changing this creates a new server.
        :param pulumi.Input[Union['InstanceVendorOptionsArgs', 'InstanceVendorOptionsArgsDict']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_hints: Optional[pulumi.Input[builtins.str]] = None,
                 block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceArgs', 'InstanceBlockDeviceArgsDict']]]]] = None,
                 config_drive: Optional[pulumi.Input[builtins.bool]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 hypervisor_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
                 personalities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePersonalityArgs', 'InstancePersonalityArgsDict']]]]] = None,
                 power_state: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 stop_before_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input[Union['InstanceVendorOptionsArgs', 'InstanceVendorOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["admin_pass"] = None if admin_pass is None else pulumi.Output.secret(admin_pass)
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["availability_zone_hints"] = availability_zone_hints
            __props__.__dict__["block_devices"] = block_devices
            __props__.__dict__["config_drive"] = config_drive
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["flavor_name"] = flavor_name
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["hypervisor_hostname"] = hypervisor_hostname
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["network_mode"] = network_mode
            __props__.__dict__["networks"] = networks
            __props__.__dict__["personalities"] = personalities
            __props__.__dict__["power_state"] = power_state
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduler_hints"] = scheduler_hints
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["stop_before_destroy"] = stop_before_destroy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vendor_options"] = vendor_options
            __props__.__dict__["access_ip_v4"] = None
            __props__.__dict__["access_ip_v6"] = None
            __props__.__dict__["all_metadata"] = None
            __props__.__dict__["all_tags"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPass"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'openstack:compute/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_ip_v4: Optional[pulumi.Input[builtins.str]] = None,
            access_ip_v6: Optional[pulumi.Input[builtins.str]] = None,
            admin_pass: Optional[pulumi.Input[builtins.str]] = None,
            all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            availability_zone: Optional[pulumi.Input[builtins.str]] = None,
            availability_zone_hints: Optional[pulumi.Input[builtins.str]] = None,
            block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceArgs', 'InstanceBlockDeviceArgsDict']]]]] = None,
            config_drive: Optional[pulumi.Input[builtins.bool]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            flavor_id: Optional[pulumi.Input[builtins.str]] = None,
            flavor_name: Optional[pulumi.Input[builtins.str]] = None,
            force_delete: Optional[pulumi.Input[builtins.bool]] = None,
            hypervisor_hostname: Optional[pulumi.Input[builtins.str]] = None,
            image_id: Optional[pulumi.Input[builtins.str]] = None,
            image_name: Optional[pulumi.Input[builtins.str]] = None,
            key_pair: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_mode: Optional[pulumi.Input[builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
            personalities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePersonalityArgs', 'InstancePersonalityArgsDict']]]]] = None,
            power_state: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            stop_before_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated: Optional[pulumi.Input[builtins.str]] = None,
            user_data: Optional[pulumi.Input[builtins.str]] = None,
            vendor_options: Optional[pulumi.Input[Union['InstanceVendorOptionsArgs', 'InstanceVendorOptionsArgsDict']]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_ip_v4: The first detected Fixed IPv4 address.
        :param pulumi.Input[builtins.str] access_ip_v6: The first detected Fixed IPv6 address.
        :param pulumi.Input[builtins.str] admin_pass: The administrative password to assign to the server.
               Changing this changes the root password on the existing server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] all_tags: The collection of tags assigned on the instance, which have
               been explicitly and implicitly added.
        :param pulumi.Input[builtins.str] availability_zone: The availability zone in which to create
               the server. Conflicts with `availability_zone_hints`. Changing this creates
               a new server.
        :param pulumi.Input[builtins.str] availability_zone_hints: The availability zone in which to
               create the server. This argument is preferred to `availability_zone`, when
               scheduling the server on a
               [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
               host or node. Conflicts with `availability_zone`. Changing this creates a
               new server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceArgs', 'InstanceBlockDeviceArgsDict']]]] block_devices: Configuration of block devices. The block_device
               structure is documented below. Changing this creates a new server.
               You can specify multiple block devices which will create an instance with
               multiple disks. This configuration is very flexible, so please see the
               following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
               for more information.
        :param pulumi.Input[builtins.bool] config_drive: Whether to use the config_drive feature to
               configure the instance. Changing this creates a new server.
        :param pulumi.Input[builtins.str] created: The creation time of the instance.
        :param pulumi.Input[builtins.str] flavor_id: The flavor ID of
               the desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.str] flavor_name: The name of the
               desired flavor for the server. Changing this resizes the existing server.
        :param pulumi.Input[builtins.bool] force_delete: Whether to force the OpenStack instance to be
               forcefully deleted. This is useful for environments that have reclaim / soft
               deletion enabled.
        :param pulumi.Input[builtins.str] hypervisor_hostname: Specifies the exact hypervisor hostname on
               which to create the instance. When provided, this parameter is included in
               the request to Nova, directing the scheduler to launch the instance on the
               specified host. Note: This option requires administrative privileges and a
               Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
               this value forces a new instance to be created.
        :param pulumi.Input[builtins.str] image_id: (Optional; Required if `image_name` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The image ID of
               the desired image for the server. Changing this rebuilds the existing
               server.
        :param pulumi.Input[builtins.str] image_name: (Optional; Required if `image_id` is empty and not booting
               from a volume. Do not specify if booting from a volume.) The name of the
               desired image for the server. Changing this rebuilds the existing server.
        :param pulumi.Input[builtins.str] key_pair: The name of a key pair to put on the server. The key
               pair must already be created and associated with the tenant's account.
               Changing this creates a new server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Changing this updates the existing server metadata.
        :param pulumi.Input[builtins.str] name: A unique name for the resource.
        :param pulumi.Input[builtins.str] network_mode: Special string for `network` option to create
               the server. `network_mode` can be `"auto"` or `"none"`.
               Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePersonalityArgs', 'InstancePersonalityArgsDict']]]] personalities: Customize the personality of an instance by
               defining one or more files and their contents. The personality structure is
               described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
               the existing server.
        :param pulumi.Input[builtins.str] power_state: Provide the VM state. Only 'active', 'shutoff', 'paused'
               and 'shelved_offloaded' are supported values.
               *Note*: If the initial power_state is the shutoff or paused
               the VM will be stopped immediately after build and the provisioners like
               remote-exec or files are not supported.
        :param pulumi.Input[builtins.str] region: The region in which to create the server instance. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]] scheduler_hints: Provide the Nova scheduler with hints on how
               the instance should be launched. The available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: An array of one or more security group names
               to associate with the server. Changing this results in adding/removing
               security groups from the existing server. *Note*: When attaching the
               instance to networks using Ports, place the security groups on the Port
               and not the instance. *Note*: Names should be used and not ids, as ids
               trigger unnecessary updates.
        :param pulumi.Input[builtins.bool] stop_before_destroy: Whether to try stop instance gracefully
               before destroying it, thus giving chance for guest OS daemons to stop correctly.
               If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the instance. Changing this
               updates the existing instance tags.
        :param pulumi.Input[builtins.str] updated: The time when the instance was last updated.
        :param pulumi.Input[builtins.str] user_data: The user data to provide when launching the instance.
               Changing this creates a new server.
        :param pulumi.Input[Union['InstanceVendorOptionsArgs', 'InstanceVendorOptionsArgsDict']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["access_ip_v4"] = access_ip_v4
        __props__.__dict__["access_ip_v6"] = access_ip_v6
        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["all_metadata"] = all_metadata
        __props__.__dict__["all_tags"] = all_tags
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["availability_zone_hints"] = availability_zone_hints
        __props__.__dict__["block_devices"] = block_devices
        __props__.__dict__["config_drive"] = config_drive
        __props__.__dict__["created"] = created
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["hypervisor_hostname"] = hypervisor_hostname
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["network_mode"] = network_mode
        __props__.__dict__["networks"] = networks
        __props__.__dict__["personalities"] = personalities
        __props__.__dict__["power_state"] = power_state
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduler_hints"] = scheduler_hints
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["stop_before_destroy"] = stop_before_destroy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated"] = updated
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vendor_options"] = vendor_options
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessIpV4")
    def access_ip_v4(self) -> pulumi.Output[builtins.str]:
        """
        The first detected Fixed IPv4 address.
        """
        return pulumi.get(self, "access_ip_v4")

    @property
    @pulumi.getter(name="accessIpV6")
    def access_ip_v6(self) -> pulumi.Output[builtins.str]:
        """
        The first detected Fixed IPv6 address.
        """
        return pulumi.get(self, "access_ip_v6")

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The administrative password to assign to the server.
        Changing this changes the root password on the existing server.
        """
        return pulumi.get(self, "admin_pass")

    @property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "all_metadata")

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The collection of tags assigned on the instance, which have
        been explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        The availability zone in which to create
        the server. Conflicts with `availability_zone_hints`. Changing this creates
        a new server.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The availability zone in which to
        create the server. This argument is preferred to `availability_zone`, when
        scheduling the server on a
        [particular](https://docs.openstack.org/nova/latest/admin/availability-zones.html)
        host or node. Conflicts with `availability_zone`. Changing this creates a
        new server.
        """
        return pulumi.get(self, "availability_zone_hints")

    @property
    @pulumi.getter(name="blockDevices")
    def block_devices(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceBlockDevice']]]:
        """
        Configuration of block devices. The block_device
        structure is documented below. Changing this creates a new server.
        You can specify multiple block devices which will create an instance with
        multiple disks. This configuration is very flexible, so please see the
        following [reference](https://docs.openstack.org/nova/latest/user/block-device-mapping.html)
        for more information.
        """
        return pulumi.get(self, "block_devices")

    @property
    @pulumi.getter(name="configDrive")
    def config_drive(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to use the config_drive feature to
        configure the instance. Changing this creates a new server.
        """
        return pulumi.get(self, "config_drive")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        The creation time of the instance.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[builtins.str]:
        """
        The flavor ID of
        the desired flavor for the server. Changing this resizes the existing server.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the
        desired flavor for the server. Changing this resizes the existing server.
        """
        return pulumi.get(self, "flavor_name")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to force the OpenStack instance to be
        forcefully deleted. This is useful for environments that have reclaim / soft
        deletion enabled.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="hypervisorHostname")
    def hypervisor_hostname(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the exact hypervisor hostname on
        which to create the instance. When provided, this parameter is included in
        the request to Nova, directing the scheduler to launch the instance on the
        specified host. Note: This option requires administrative privileges and a
        Nova microversion of 2.74 or later. Conflicts with `personality`. Changing
        this value forces a new instance to be created.
        """
        return pulumi.get(self, "hypervisor_hostname")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[builtins.str]:
        """
        (Optional; Required if `image_name` is empty and not booting
        from a volume. Do not specify if booting from a volume.) The image ID of
        the desired image for the server. Changing this rebuilds the existing
        server.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[builtins.str]:
        """
        (Optional; Required if `image_id` is empty and not booting
        from a volume. Do not specify if booting from a volume.) The name of the
        desired image for the server. Changing this rebuilds the existing server.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a key pair to put on the server. The key
        pair must already be created and associated with the tenant's account.
        Changing this creates a new server.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Metadata key/value pairs to make available from
        within the instance. Changing this updates the existing server metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Special string for `network` option to create
        the server. `network_mode` can be `"auto"` or `"none"`.
        Please see the following [reference](https://docs.openstack.org/api-ref/compute/?expanded=create-server-detail#id11) for more information. Conflicts with `network`.
        """
        return pulumi.get(self, "network_mode")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.InstanceNetwork']]:
        """
        An array of one or more networks to attach to the
        instance. The network object structure is documented below. Changing this
        creates a new server.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def personalities(self) -> pulumi.Output[Optional[Sequence['outputs.InstancePersonality']]]:
        """
        Customize the personality of an instance by
        defining one or more files and their contents. The personality structure is
        described below. Conflicts with `hypervisor_hostname`. Changing this rebuilds
        the existing server.
        """
        return pulumi.get(self, "personalities")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Provide the VM state. Only 'active', 'shutoff', 'paused'
        and 'shelved_offloaded' are supported values.
        *Note*: If the initial power_state is the shutoff or paused
        the VM will be stopped immediately after build and the provisioners like
        remote-exec or files are not supported.
        """
        return pulumi.get(self, "power_state")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to create the server instance. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new server.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceSchedulerHint']]]:
        """
        Provide the Nova scheduler with hints on how
        the instance should be launched. The available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An array of one or more security group names
        to associate with the server. Changing this results in adding/removing
        security groups from the existing server. *Note*: When attaching the
        instance to networks using Ports, place the security groups on the Port
        and not the instance. *Note*: Names should be used and not ids, as ids
        trigger unnecessary updates.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="stopBeforeDestroy")
    def stop_before_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to try stop instance gracefully
        before destroying it, thus giving chance for guest OS daemons to stop correctly.
        If instance doesn't stop within timeout, it will be destroyed anyway.
        """
        return pulumi.get(self, "stop_before_destroy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A set of string tags for the instance. Changing this
        updates the existing instance tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[builtins.str]:
        """
        The time when the instance was last updated.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user data to provide when launching the instance.
        Changing this creates a new server.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> pulumi.Output[Optional['outputs.InstanceVendorOptions']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

