# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceBlockDevice',
    'InstanceNetwork',
    'InstancePersonality',
    'InstanceSchedulerHint',
    'InstanceVendorOptions',
    'ServerGroupRules',
    'VolumeAttachVendorOptions',
    'GetInstanceV2NetworkResult',
    'GetServergroupV2RuleResult',
]

@pulumi.output_type
class InstanceBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "bootIndex":
            suggest = "boot_index"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "destinationType":
            suggest = "destination_type"
        elif key == "deviceType":
            suggest = "device_type"
        elif key == "diskBus":
            suggest = "disk_bus"
        elif key == "guestFormat":
            suggest = "guest_format"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: builtins.str,
                 boot_index: Optional[builtins.int] = None,
                 delete_on_termination: Optional[builtins.bool] = None,
                 destination_type: Optional[builtins.str] = None,
                 device_type: Optional[builtins.str] = None,
                 disk_bus: Optional[builtins.str] = None,
                 guest_format: Optional[builtins.str] = None,
                 multiattach: Optional[builtins.bool] = None,
                 uuid: Optional[builtins.str] = None,
                 volume_size: Optional[builtins.int] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        :param builtins.str source_type: The source type of the device. Must be one of
               "blank", "image", "volume", or "snapshot". Changing this creates a new
               server.
        :param builtins.int boot_index: The boot index of the volume. It defaults to 0.
               Changing this creates a new server.
        :param builtins.bool delete_on_termination: Delete the volume / block device upon
               termination of the instance. Defaults to false. Changing this creates a
               new server.
        :param builtins.str destination_type: The type that gets created. Possible values
               are "volume" and "local". Changing this creates a new server.
        :param builtins.str device_type: The low-level device type that will be used. Most
               common thing is to leave this empty. Changing this creates a new server.
        :param builtins.str disk_bus: The low-level disk bus that will be used. Most common
               thing is to leave this empty. Changing this creates a new server.
        :param builtins.str guest_format: Specifies the guest server disk file system format,
               such as `ext2`, `ext3`, `ext4`, `xfs` or `swap`. Swap block device mappings
               have the following restrictions: source_type must be blank and destination_type
               must be local and only one swap disk per server and the size of the swap disk
               must be less than or equal to the swap size of the flavor. Changing this
               creates a new server.
        :param builtins.bool multiattach: Enable the attachment of multiattach-capable
               volumes.
        :param builtins.str uuid: The UUID of
               the image, volume, or snapshot. Changing this creates a new server.
        :param builtins.int volume_size: The size of the volume to create (in gigabytes). Required
               in the following combinations: source=image and destination=volume,
               source=blank and destination=local, and source=blank and destination=volume.
               Changing this creates a new server.
        :param builtins.str volume_type: The volume type that will be used, for example SSD
               or HDD storage. The available options depend on how your specific OpenStack
               cloud is configured and what classes of storage are provided. Changing this
               creates a new server.
        """
        pulumi.set(__self__, "source_type", source_type)
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if disk_bus is not None:
            pulumi.set(__self__, "disk_bus", disk_bus)
        if guest_format is not None:
            pulumi.set(__self__, "guest_format", guest_format)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The source type of the device. Must be one of
        "blank", "image", "volume", or "snapshot". Changing this creates a new
        server.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[builtins.int]:
        """
        The boot index of the volume. It defaults to 0.
        Changing this creates a new server.
        """
        return pulumi.get(self, "boot_index")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[builtins.bool]:
        """
        Delete the volume / block device upon
        termination of the instance. Defaults to false. Changing this creates a
        new server.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[builtins.str]:
        """
        The type that gets created. Possible values
        are "volume" and "local". Changing this creates a new server.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[builtins.str]:
        """
        The low-level device type that will be used. Most
        common thing is to leave this empty. Changing this creates a new server.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter(name="diskBus")
    def disk_bus(self) -> Optional[builtins.str]:
        """
        The low-level disk bus that will be used. Most common
        thing is to leave this empty. Changing this creates a new server.
        """
        return pulumi.get(self, "disk_bus")

    @property
    @pulumi.getter(name="guestFormat")
    def guest_format(self) -> Optional[builtins.str]:
        """
        Specifies the guest server disk file system format,
        such as `ext2`, `ext3`, `ext4`, `xfs` or `swap`. Swap block device mappings
        have the following restrictions: source_type must be blank and destination_type
        must be local and only one swap disk per server and the size of the swap disk
        must be less than or equal to the swap size of the flavor. Changing this
        creates a new server.
        """
        return pulumi.get(self, "guest_format")

    @property
    @pulumi.getter
    def multiattach(self) -> Optional[builtins.bool]:
        """
        Enable the attachment of multiattach-capable
        volumes.
        """
        return pulumi.get(self, "multiattach")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[builtins.str]:
        """
        The UUID of
        the image, volume, or snapshot. Changing this creates a new server.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        The size of the volume to create (in gigabytes). Required
        in the following combinations: source=image and destination=volume,
        source=blank and destination=local, and source=blank and destination=volume.
        Changing this creates a new server.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        The volume type that will be used, for example SSD
        or HDD storage. The available options depend on how your specific OpenStack
        cloud is configured and what classes of storage are provided. Changing this
        creates a new server.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstanceNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessNetwork":
            suggest = "access_network"
        elif key == "fixedIpV4":
            suggest = "fixed_ip_v4"
        elif key == "fixedIpV6":
            suggest = "fixed_ip_v6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_network: Optional[builtins.bool] = None,
                 fixed_ip_v4: Optional[builtins.str] = None,
                 fixed_ip_v6: Optional[builtins.str] = None,
                 mac: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None,
                 uuid: Optional[builtins.str] = None):
        """
        :param builtins.bool access_network: Specifies if this network should be used for
               provisioning access. Accepts true or false. Defaults to false.
        :param builtins.str fixed_ip_v4: Specifies a fixed IPv4 address to be used on this
               network. Changing this creates a new server.
        :param builtins.str name: The human-readable
               name of the network. Changing this creates a new server.
        :param builtins.str port: The port UUID of a
               network to attach to the server. Changing this creates a new server.
        :param builtins.str uuid: The network UUID to
               attach to the server. Changing this creates a new server.
        """
        if access_network is not None:
            pulumi.set(__self__, "access_network", access_network)
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="accessNetwork")
    def access_network(self) -> Optional[builtins.bool]:
        """
        Specifies if this network should be used for
        provisioning access. Accepts true or false. Defaults to false.
        """
        return pulumi.get(self, "access_network")

    @property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[builtins.str]:
        """
        Specifies a fixed IPv4 address to be used on this
        network. Changing this creates a new server.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[builtins.str]:
        return pulumi.get(self, "fixed_ip_v6")

    @property
    @pulumi.getter
    def mac(self) -> Optional[builtins.str]:
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The human-readable
        name of the network. Changing this creates a new server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        The port UUID of a
        network to attach to the server. Changing this creates a new server.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[builtins.str]:
        """
        The network UUID to
        attach to the server. Changing this creates a new server.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class InstancePersonality(dict):
    def __init__(__self__, *,
                 content: builtins.str,
                 file: builtins.str):
        """
        :param builtins.str content: The contents of the file. Limited to 255 bytes.
        :param builtins.str file: The absolute path of the destination file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The contents of the file. Limited to 255 bytes.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def file(self) -> builtins.str:
        """
        The absolute path of the destination file.
        """
        return pulumi.get(self, "file")


@pulumi.output_type
class InstanceSchedulerHint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "buildNearHostIp":
            suggest = "build_near_host_ip"
        elif key == "differentCells":
            suggest = "different_cells"
        elif key == "differentHosts":
            suggest = "different_hosts"
        elif key == "sameHosts":
            suggest = "same_hosts"
        elif key == "targetCell":
            suggest = "target_cell"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSchedulerHint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSchedulerHint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSchedulerHint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_properties: Optional[Mapping[str, builtins.str]] = None,
                 build_near_host_ip: Optional[builtins.str] = None,
                 different_cells: Optional[Sequence[builtins.str]] = None,
                 different_hosts: Optional[Sequence[builtins.str]] = None,
                 group: Optional[builtins.str] = None,
                 queries: Optional[Sequence[builtins.str]] = None,
                 same_hosts: Optional[Sequence[builtins.str]] = None,
                 target_cell: Optional[builtins.str] = None):
        """
        :param Mapping[str, builtins.str] additional_properties: Arbitrary key/value pairs of additional
               properties to pass to the scheduler.
        :param builtins.str build_near_host_ip: An IP Address in CIDR form. The instance
               will be placed on a compute node that is in the same subnet.
        :param Sequence[builtins.str] different_cells: The names of cells where not to build the instance.
        :param Sequence[builtins.str] different_hosts: A list of instance UUIDs. The instance will
               be scheduled on a different host than all other instances.
        :param builtins.str group: A UUID of a Server Group. The instance will be placed
               into that group. See reference
               for details on managing servergroup resources
        :param Sequence[builtins.str] queries: A conditional query that a compute node must pass in
               order to host an instance. The query must use the `JsonFilter` syntax
               which is described
               [here](https://docs.openstack.org/nova/latest/admin/configuration/schedulers.html#jsonfilter).
               At this time, only simple queries are supported. Compound queries using
               `and`, `or`, or `not` are not supported. An example of a simple query is:
               
               ```
               [">=", "$free_ram_mb", "1024"]
               ```
        :param Sequence[builtins.str] same_hosts: A list of instance UUIDs. The instance will be
               scheduled on the same host of those specified.
        :param builtins.str target_cell: The name of a cell to host the instance.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if build_near_host_ip is not None:
            pulumi.set(__self__, "build_near_host_ip", build_near_host_ip)
        if different_cells is not None:
            pulumi.set(__self__, "different_cells", different_cells)
        if different_hosts is not None:
            pulumi.set(__self__, "different_hosts", different_hosts)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if same_hosts is not None:
            pulumi.set(__self__, "same_hosts", same_hosts)
        if target_cell is not None:
            pulumi.set(__self__, "target_cell", target_cell)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Arbitrary key/value pairs of additional
        properties to pass to the scheduler.
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="buildNearHostIp")
    def build_near_host_ip(self) -> Optional[builtins.str]:
        """
        An IP Address in CIDR form. The instance
        will be placed on a compute node that is in the same subnet.
        """
        return pulumi.get(self, "build_near_host_ip")

    @property
    @pulumi.getter(name="differentCells")
    def different_cells(self) -> Optional[Sequence[builtins.str]]:
        """
        The names of cells where not to build the instance.
        """
        return pulumi.get(self, "different_cells")

    @property
    @pulumi.getter(name="differentHosts")
    def different_hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of instance UUIDs. The instance will
        be scheduled on a different host than all other instances.
        """
        return pulumi.get(self, "different_hosts")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        A UUID of a Server Group. The instance will be placed
        into that group. See reference
        for details on managing servergroup resources
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def queries(self) -> Optional[Sequence[builtins.str]]:
        """
        A conditional query that a compute node must pass in
        order to host an instance. The query must use the `JsonFilter` syntax
        which is described
        [here](https://docs.openstack.org/nova/latest/admin/configuration/schedulers.html#jsonfilter).
        At this time, only simple queries are supported. Compound queries using
        `and`, `or`, or `not` are not supported. An example of a simple query is:

        ```
        [">=", "$free_ram_mb", "1024"]
        ```
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter(name="sameHosts")
    def same_hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of instance UUIDs. The instance will be
        scheduled on the same host of those specified.
        """
        return pulumi.get(self, "same_hosts")

    @property
    @pulumi.getter(name="targetCell")
    def target_cell(self) -> Optional[builtins.str]:
        """
        The name of a cell to host the instance.
        """
        return pulumi.get(self, "target_cell")


@pulumi.output_type
class InstanceVendorOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detachPortsBeforeDestroy":
            suggest = "detach_ports_before_destroy"
        elif key == "ignoreResizeConfirmation":
            suggest = "ignore_resize_confirmation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceVendorOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceVendorOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceVendorOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detach_ports_before_destroy: Optional[builtins.bool] = None,
                 ignore_resize_confirmation: Optional[builtins.bool] = None):
        """
        :param builtins.bool detach_ports_before_destroy: Whether to try to detach all attached
               ports to the vm before destroying it to make sure the port state is correct
               after the vm destruction. This is helpful when the port is not deleted.
        :param builtins.bool ignore_resize_confirmation: Boolean to control whether
               to ignore manual confirmation of the instance resizing. This can be helpful
               to work with some OpenStack clouds which automatically confirm resizing of
               instances after some timeout.
        """
        if detach_ports_before_destroy is not None:
            pulumi.set(__self__, "detach_ports_before_destroy", detach_ports_before_destroy)
        if ignore_resize_confirmation is not None:
            pulumi.set(__self__, "ignore_resize_confirmation", ignore_resize_confirmation)

    @property
    @pulumi.getter(name="detachPortsBeforeDestroy")
    def detach_ports_before_destroy(self) -> Optional[builtins.bool]:
        """
        Whether to try to detach all attached
        ports to the vm before destroying it to make sure the port state is correct
        after the vm destruction. This is helpful when the port is not deleted.
        """
        return pulumi.get(self, "detach_ports_before_destroy")

    @property
    @pulumi.getter(name="ignoreResizeConfirmation")
    def ignore_resize_confirmation(self) -> Optional[builtins.bool]:
        """
        Boolean to control whether
        to ignore manual confirmation of the instance resizing. This can be helpful
        to work with some OpenStack clouds which automatically confirm resizing of
        instances after some timeout.
        """
        return pulumi.get(self, "ignore_resize_confirmation")


@pulumi.output_type
class ServerGroupRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxServerPerHost":
            suggest = "max_server_per_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_server_per_host: Optional[builtins.int] = None):
        if max_server_per_host is not None:
            pulumi.set(__self__, "max_server_per_host", max_server_per_host)

    @property
    @pulumi.getter(name="maxServerPerHost")
    def max_server_per_host(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_server_per_host")


@pulumi.output_type
class VolumeAttachVendorOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreVolumeConfirmation":
            suggest = "ignore_volume_confirmation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeAttachVendorOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeAttachVendorOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeAttachVendorOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_volume_confirmation: Optional[builtins.bool] = None):
        """
        :param builtins.bool ignore_volume_confirmation: Boolean to control whether
               to ignore volume status confirmation of the attached volume. This can be helpful
               to work with some OpenStack clouds which don't have the Block Storage V3 API available.
        """
        if ignore_volume_confirmation is not None:
            pulumi.set(__self__, "ignore_volume_confirmation", ignore_volume_confirmation)

    @property
    @pulumi.getter(name="ignoreVolumeConfirmation")
    def ignore_volume_confirmation(self) -> Optional[builtins.bool]:
        """
        Boolean to control whether
        to ignore volume status confirmation of the attached volume. This can be helpful
        to work with some OpenStack clouds which don't have the Block Storage V3 API available.
        """
        return pulumi.get(self, "ignore_volume_confirmation")


@pulumi.output_type
class GetInstanceV2NetworkResult(dict):
    def __init__(__self__, *,
                 fixed_ip_v4: builtins.str,
                 fixed_ip_v6: builtins.str,
                 mac: builtins.str,
                 name: builtins.str,
                 port: builtins.str,
                 uuid: builtins.str):
        """
        :param builtins.str fixed_ip_v4: The IPv4 address assigned to this network port.
        :param builtins.str fixed_ip_v6: The IPv6 address assigned to this network port.
        :param builtins.str mac: The MAC address assigned to this network interface.
        :param builtins.str name: The name of the network
        :param builtins.str port: The port UUID for this network
        :param builtins.str uuid: The UUID of the network
        """
        pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> builtins.str:
        """
        The IPv4 address assigned to this network port.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> builtins.str:
        """
        The IPv6 address assigned to this network port.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @property
    @pulumi.getter
    def mac(self) -> builtins.str:
        """
        The MAC address assigned to this network interface.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the network
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The port UUID for this network
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def uuid(self) -> builtins.str:
        """
        The UUID of the network
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetServergroupV2RuleResult(dict):
    def __init__(__self__, *,
                 max_server_per_host: builtins.int):
        pulumi.set(__self__, "max_server_per_host", max_server_per_host)

    @property
    @pulumi.getter(name="maxServerPerHost")
    def max_server_per_host(self) -> builtins.int:
        return pulumi.get(self, "max_server_per_host")


