# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConfigurationConfiguration',
    'ConfigurationDatastore',
    'InstanceDatabase',
    'InstanceDatastore',
    'InstanceNetwork',
    'InstanceUser',
]

@pulumi.output_type
class ConfigurationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringType":
            suggest = "string_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str,
                 string_type: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Configuration parameter name. Changing this creates a new resource.
        :param builtins.str value: Configuration parameter value. Changing this creates a new resource.
        :param builtins.bool string_type: Whether or not to store configuration parameter value as string. Changing this creates a new resource. See the below note for more information.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if string_type is not None:
            pulumi.set(__self__, "string_type", string_type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Configuration parameter name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Configuration parameter value. Changing this creates a new resource.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="stringType")
    def string_type(self) -> Optional[builtins.bool]:
        """
        Whether or not to store configuration parameter value as string. Changing this creates a new resource. See the below note for more information.
        """
        return pulumi.get(self, "string_type")


@pulumi.output_type
class ConfigurationDatastore(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str type: Database engine type to be used with this configuration. Changing this creates a new resource.
        :param builtins.str version: Version of database engine type to be used with this configuration. Changing this creates a new resource.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Database engine type to be used with this configuration. Changing this creates a new resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of database engine type to be used with this configuration. Changing this creates a new resource.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InstanceDatabase(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 charset: Optional[builtins.str] = None,
                 collate: Optional[builtins.str] = None):
        """
        :param builtins.str name: Database to be created on new instance. Changing this creates a
               new instance.
        :param builtins.str charset: Database character set. Changing this creates a
               new instance.
        :param builtins.str collate: Database collation. Changing this creates a new instance.
        """
        pulumi.set(__self__, "name", name)
        if charset is not None:
            pulumi.set(__self__, "charset", charset)
        if collate is not None:
            pulumi.set(__self__, "collate", collate)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Database to be created on new instance. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def charset(self) -> Optional[builtins.str]:
        """
        Database character set. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "charset")

    @property
    @pulumi.getter
    def collate(self) -> Optional[builtins.str]:
        """
        Database collation. Changing this creates a new instance.
        """
        return pulumi.get(self, "collate")


@pulumi.output_type
class InstanceDatastore(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str type: Database engine type to be used in new instance. Changing this
               creates a new instance.
        :param builtins.str version: Version of database engine type to be used in new instance.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Database engine type to be used in new instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of database engine type to be used in new instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InstanceNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedIpV4":
            suggest = "fixed_ip_v4"
        elif key == "fixedIpV6":
            suggest = "fixed_ip_v6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_ip_v4: Optional[builtins.str] = None,
                 fixed_ip_v6: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None,
                 uuid: Optional[builtins.str] = None):
        """
        :param builtins.str fixed_ip_v4: Specifies a fixed IPv4 address to be used on this
               network. Changing this creates a new instance.
        :param builtins.str fixed_ip_v6: Specifies a fixed IPv6 address to be used on this
               network. Changing this creates a new instance.
        :param builtins.str port: The port UUID of a
               network to attach to the instance. Changing this creates a new instance.
        :param builtins.str uuid: The network UUID to
               attach to the instance. Changing this creates a new instance.
        """
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[builtins.str]:
        """
        Specifies a fixed IPv4 address to be used on this
        network. Changing this creates a new instance.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[builtins.str]:
        """
        Specifies a fixed IPv6 address to be used on this
        network. Changing this creates a new instance.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        The port UUID of a
        network to attach to the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[builtins.str]:
        """
        The network UUID to
        attach to the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class InstanceUser(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 databases: Optional[Sequence[builtins.str]] = None,
                 host: Optional[builtins.str] = None,
                 password: Optional[builtins.str] = None):
        """
        :param builtins.str name: Username to be created on new instance. Changing this creates a
               new instance.
        :param Sequence[builtins.str] databases: A list of databases that user will have access to. If not specified,
               user has access to all databases on th einstance. Changing this creates a new instance.
        :param builtins.str host: An ip address or % sign indicating what ip addresses can connect with
               this user credentials. Changing this creates a new instance.
        :param builtins.str password: User's password. Changing this creates a
               new instance.
        """
        pulumi.set(__self__, "name", name)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Username to be created on new instance. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def databases(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of databases that user will have access to. If not specified,
        user has access to all databases on th einstance. Changing this creates a new instance.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        An ip address or % sign indicating what ip addresses can connect with
        this user credentials. Changing this creates a new instance.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        User's password. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "password")


