# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetZoneShareV2Result',
    'AwaitableGetZoneShareV2Result',
    'get_zone_share_v2',
    'get_zone_share_v2_output',
]

@pulumi.output_type
class GetZoneShareV2Result:
    """
    A collection of values returned by getZoneShareV2.
    """
    def __init__(__self__, all_projects=None, id=None, project_id=None, region=None, share_id=None, target_project_id=None, zone_id=None):
        if all_projects and not isinstance(all_projects, str):
            raise TypeError("Expected argument 'all_projects' to be a str")
        pulumi.set(__self__, "all_projects", all_projects)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if share_id and not isinstance(share_id, str):
            raise TypeError("Expected argument 'share_id' to be a str")
        pulumi.set(__self__, "share_id", share_id)
        if target_project_id and not isinstance(target_project_id, str):
            raise TypeError("Expected argument 'target_project_id' to be a str")
        pulumi.set(__self__, "target_project_id", target_project_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> Optional[builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "all_projects")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> builtins.str:
        """
        The ID of the zone share.
        """
        return pulumi.get(self, "share_id")

    @property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> Optional[builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "target_project_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneShareV2Result(GetZoneShareV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneShareV2Result(
            all_projects=self.all_projects,
            id=self.id,
            project_id=self.project_id,
            region=self.region,
            share_id=self.share_id,
            target_project_id=self.target_project_id,
            zone_id=self.zone_id)


def get_zone_share_v2(all_projects: Optional[builtins.str] = None,
                      project_id: Optional[builtins.str] = None,
                      region: Optional[builtins.str] = None,
                      share_id: Optional[builtins.str] = None,
                      target_project_id: Optional[builtins.str] = None,
                      zone_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneShareV2Result:
    """
    Use this data source to get information about a DNS zone share.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    example = openstack.dns.get_zone_share_v2(zone_id="00000000-0000-0000-0000-000000000000",
        target_project_id="11111111-1111-1111-1111-111111111111",
        project_id="22222222-2222-2222-2222-222222222222")
    ```


    :param builtins.str all_projects: If set to `true`, the data source will search
           across all projects. If set to `false`, it will only search within the
           current project. Defaults to `false`.
    :param builtins.str project_id: The owner project ID. If omitted, it is derived
           from the zone share details.
    :param builtins.str region: The region in which to obtain the V2 DNS client. If
           omitted, the `region` argument of the provider is used. Changing this creates
           a new DNS zone share data source.
    :param builtins.str share_id: The ID of the DNS zone share to retrieve. If
           provided, the data source returns only the share with this ID.
    :param builtins.str target_project_id: If provided, the data source returns the
           share with this target project ID.
    :param builtins.str zone_id: The ID of the DNS zone for which to get share.
    """
    __args__ = dict()
    __args__['allProjects'] = all_projects
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['shareId'] = share_id
    __args__['targetProjectId'] = target_project_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:dns/getZoneShareV2:getZoneShareV2', __args__, opts=opts, typ=GetZoneShareV2Result).value

    return AwaitableGetZoneShareV2Result(
        all_projects=pulumi.get(__ret__, 'all_projects'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        share_id=pulumi.get(__ret__, 'share_id'),
        target_project_id=pulumi.get(__ret__, 'target_project_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_share_v2_output(all_projects: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             share_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             target_project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             zone_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneShareV2Result]:
    """
    Use this data source to get information about a DNS zone share.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    example = openstack.dns.get_zone_share_v2(zone_id="00000000-0000-0000-0000-000000000000",
        target_project_id="11111111-1111-1111-1111-111111111111",
        project_id="22222222-2222-2222-2222-222222222222")
    ```


    :param builtins.str all_projects: If set to `true`, the data source will search
           across all projects. If set to `false`, it will only search within the
           current project. Defaults to `false`.
    :param builtins.str project_id: The owner project ID. If omitted, it is derived
           from the zone share details.
    :param builtins.str region: The region in which to obtain the V2 DNS client. If
           omitted, the `region` argument of the provider is used. Changing this creates
           a new DNS zone share data source.
    :param builtins.str share_id: The ID of the DNS zone share to retrieve. If
           provided, the data source returns only the share with this ID.
    :param builtins.str target_project_id: If provided, the data source returns the
           share with this target project ID.
    :param builtins.str zone_id: The ID of the DNS zone for which to get share.
    """
    __args__ = dict()
    __args__['allProjects'] = all_projects
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['shareId'] = share_id
    __args__['targetProjectId'] = target_project_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:dns/getZoneShareV2:getZoneShareV2', __args__, opts=opts, typ=GetZoneShareV2Result)
    return __ret__.apply(lambda __response__: GetZoneShareV2Result(
        all_projects=pulumi.get(__response__, 'all_projects'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        share_id=pulumi.get(__response__, 'share_id'),
        target_project_id=pulumi.get(__response__, 'target_project_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
