# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['QuotaV2Args', 'QuotaV2']

@pulumi.input_type
class QuotaV2Args:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 api_export_size: Optional[pulumi.Input[builtins.int]] = None,
                 recordset_records: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 zone_records: Optional[pulumi.Input[builtins.int]] = None,
                 zone_recordsets: Optional[pulumi.Input[builtins.int]] = None,
                 zones: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a QuotaV2 resource.
        :param pulumi.Input[builtins.str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[builtins.int] api_export_size: The maximum number of zones that can be
               exported via the API.
        :param pulumi.Input[builtins.int] recordset_records: The maximum number of records in a
               recordset.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS quota.
        :param pulumi.Input[builtins.int] zone_records: The maximum number of records in a zone.
        :param pulumi.Input[builtins.int] zone_recordsets: The maximum number of recordsets in a zone.
        :param pulumi.Input[builtins.int] zones: The maximum number of zones that can be created.
        """
        pulumi.set(__self__, "project_id", project_id)
        if api_export_size is not None:
            pulumi.set(__self__, "api_export_size", api_export_size)
        if recordset_records is not None:
            pulumi.set(__self__, "recordset_records", recordset_records)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if zone_records is not None:
            pulumi.set(__self__, "zone_records", zone_records)
        if zone_recordsets is not None:
            pulumi.set(__self__, "zone_recordsets", zone_recordsets)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the project to manage quota. Changing this
        creates new quota.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="apiExportSize")
    def api_export_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of zones that can be
        exported via the API.
        """
        return pulumi.get(self, "api_export_size")

    @api_export_size.setter
    def api_export_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "api_export_size", value)

    @property
    @pulumi.getter(name="recordsetRecords")
    def recordset_records(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of records in a
        recordset.
        """
        return pulumi.get(self, "recordset_records")

    @recordset_records.setter
    def recordset_records(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "recordset_records", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 DNS client. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new DNS quota.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="zoneRecords")
    def zone_records(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of records in a zone.
        """
        return pulumi.get(self, "zone_records")

    @zone_records.setter
    def zone_records(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zone_records", value)

    @property
    @pulumi.getter(name="zoneRecordsets")
    def zone_recordsets(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of recordsets in a zone.
        """
        return pulumi.get(self, "zone_recordsets")

    @zone_recordsets.setter
    def zone_recordsets(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zone_recordsets", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of zones that can be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _QuotaV2State:
    def __init__(__self__, *,
                 api_export_size: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recordset_records: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 zone_records: Optional[pulumi.Input[builtins.int]] = None,
                 zone_recordsets: Optional[pulumi.Input[builtins.int]] = None,
                 zones: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering QuotaV2 resources.
        :param pulumi.Input[builtins.int] api_export_size: The maximum number of zones that can be
               exported via the API.
        :param pulumi.Input[builtins.str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[builtins.int] recordset_records: The maximum number of records in a
               recordset.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS quota.
        :param pulumi.Input[builtins.int] zone_records: The maximum number of records in a zone.
        :param pulumi.Input[builtins.int] zone_recordsets: The maximum number of recordsets in a zone.
        :param pulumi.Input[builtins.int] zones: The maximum number of zones that can be created.
        """
        if api_export_size is not None:
            pulumi.set(__self__, "api_export_size", api_export_size)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if recordset_records is not None:
            pulumi.set(__self__, "recordset_records", recordset_records)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if zone_records is not None:
            pulumi.set(__self__, "zone_records", zone_records)
        if zone_recordsets is not None:
            pulumi.set(__self__, "zone_recordsets", zone_recordsets)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="apiExportSize")
    def api_export_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of zones that can be
        exported via the API.
        """
        return pulumi.get(self, "api_export_size")

    @api_export_size.setter
    def api_export_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "api_export_size", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the project to manage quota. Changing this
        creates new quota.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="recordsetRecords")
    def recordset_records(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of records in a
        recordset.
        """
        return pulumi.get(self, "recordset_records")

    @recordset_records.setter
    def recordset_records(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "recordset_records", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 DNS client. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new DNS quota.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="zoneRecords")
    def zone_records(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of records in a zone.
        """
        return pulumi.get(self, "zone_records")

    @zone_records.setter
    def zone_records(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zone_records", value)

    @property
    @pulumi.getter(name="zoneRecordsets")
    def zone_recordsets(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of recordsets in a zone.
        """
        return pulumi.get(self, "zone_recordsets")

    @zone_recordsets.setter
    def zone_recordsets(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zone_recordsets", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of zones that can be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("openstack:dns/quotaV2:QuotaV2")
class QuotaV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_export_size: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recordset_records: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 zone_records: Optional[pulumi.Input[builtins.int]] = None,
                 zone_recordsets: Optional[pulumi.Input[builtins.int]] = None,
                 zones: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages DNS quota in OpenStack DNS Service.

        > **Note:** This usually requires admin privileges.

        > **Note:** This resource has a no-op deletion so no actual actions will be
        done against the OpenStack API in case of delete call.

        ## Import

        Quotas can be imported using the `project_id/region_name`, e.g.

        ```sh
        $ pulumi import openstack:dns/quotaV2:QuotaV2 quota_1 2a0f2240-c5e6-41de-896d-e80d97428d6b/region_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] api_export_size: The maximum number of zones that can be
               exported via the API.
        :param pulumi.Input[builtins.str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[builtins.int] recordset_records: The maximum number of records in a
               recordset.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS quota.
        :param pulumi.Input[builtins.int] zone_records: The maximum number of records in a zone.
        :param pulumi.Input[builtins.int] zone_recordsets: The maximum number of recordsets in a zone.
        :param pulumi.Input[builtins.int] zones: The maximum number of zones that can be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DNS quota in OpenStack DNS Service.

        > **Note:** This usually requires admin privileges.

        > **Note:** This resource has a no-op deletion so no actual actions will be
        done against the OpenStack API in case of delete call.

        ## Import

        Quotas can be imported using the `project_id/region_name`, e.g.

        ```sh
        $ pulumi import openstack:dns/quotaV2:QuotaV2 quota_1 2a0f2240-c5e6-41de-896d-e80d97428d6b/region_1
        ```

        :param str resource_name: The name of the resource.
        :param QuotaV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_export_size: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 recordset_records: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 zone_records: Optional[pulumi.Input[builtins.int]] = None,
                 zone_recordsets: Optional[pulumi.Input[builtins.int]] = None,
                 zones: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaV2Args.__new__(QuotaV2Args)

            __props__.__dict__["api_export_size"] = api_export_size
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["recordset_records"] = recordset_records
            __props__.__dict__["region"] = region
            __props__.__dict__["zone_records"] = zone_records
            __props__.__dict__["zone_recordsets"] = zone_recordsets
            __props__.__dict__["zones"] = zones
        super(QuotaV2, __self__).__init__(
            'openstack:dns/quotaV2:QuotaV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_export_size: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            recordset_records: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            zone_records: Optional[pulumi.Input[builtins.int]] = None,
            zone_recordsets: Optional[pulumi.Input[builtins.int]] = None,
            zones: Optional[pulumi.Input[builtins.int]] = None) -> 'QuotaV2':
        """
        Get an existing QuotaV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] api_export_size: The maximum number of zones that can be
               exported via the API.
        :param pulumi.Input[builtins.str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[builtins.int] recordset_records: The maximum number of records in a
               recordset.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS quota.
        :param pulumi.Input[builtins.int] zone_records: The maximum number of records in a zone.
        :param pulumi.Input[builtins.int] zone_recordsets: The maximum number of recordsets in a zone.
        :param pulumi.Input[builtins.int] zones: The maximum number of zones that can be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaV2State.__new__(_QuotaV2State)

        __props__.__dict__["api_export_size"] = api_export_size
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["recordset_records"] = recordset_records
        __props__.__dict__["region"] = region
        __props__.__dict__["zone_records"] = zone_records
        __props__.__dict__["zone_recordsets"] = zone_recordsets
        __props__.__dict__["zones"] = zones
        return QuotaV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiExportSize")
    def api_export_size(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of zones that can be
        exported via the API.
        """
        return pulumi.get(self, "api_export_size")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the project to manage quota. Changing this
        creates new quota.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="recordsetRecords")
    def recordset_records(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of records in a
        recordset.
        """
        return pulumi.get(self, "recordset_records")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V2 DNS client. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new DNS quota.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="zoneRecords")
    def zone_records(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of records in a zone.
        """
        return pulumi.get(self, "zone_records")

    @property
    @pulumi.getter(name="zoneRecordsets")
    def zone_recordsets(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of recordsets in a zone.
        """
        return pulumi.get(self, "zone_recordsets")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of zones that can be created.
        """
        return pulumi.get(self, "zones")

