# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZoneShareV2Args', 'ZoneShareV2']

@pulumi.input_type
class ZoneShareV2Args:
    def __init__(__self__, *,
                 target_project_id: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZoneShareV2 resource.
        :param pulumi.Input[builtins.str] target_project_id: The ID of the target project with which the
               DNS zone will be shared.
        :param pulumi.Input[builtins.str] zone_id: The ID of the DNS zone to be shared.
        :param pulumi.Input[builtins.str] project_id: The ID of the project DNS zone is created for, sets
               `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
               project).
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS zone share.
        """
        pulumi.set(__self__, "target_project_id", target_project_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the target project with which the
        DNS zone will be shared.
        """
        return pulumi.get(self, "target_project_id")

    @target_project_id.setter
    def target_project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_project_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the DNS zone to be shared.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project DNS zone is created for, sets
        `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
        project).
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 DNS client. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new DNS zone share.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ZoneShareV2State:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneShareV2 resources.
        :param pulumi.Input[builtins.str] project_id: The ID of the project DNS zone is created for, sets
               `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
               project).
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS zone share.
        :param pulumi.Input[builtins.str] target_project_id: The ID of the target project with which the
               DNS zone will be shared.
        :param pulumi.Input[builtins.str] zone_id: The ID of the DNS zone to be shared.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_project_id is not None:
            pulumi.set(__self__, "target_project_id", target_project_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project DNS zone is created for, sets
        `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
        project).
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 DNS client. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new DNS zone share.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the target project with which the
        DNS zone will be shared.
        """
        return pulumi.get(self, "target_project_id")

    @target_project_id.setter
    def target_project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_project_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the DNS zone to be shared.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("openstack:dns/zoneShareV2:ZoneShareV2")
class ZoneShareV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the sharing of a DNS zone in the OpenStack DNS Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        example = openstack.dns.ZoneShareV2("example",
            zone_id="00000000-0000-0000-0000-000000000000",
            target_project_id="11111111-1111-1111-1111-111111111111",
            project_id="22222222-2222-2222-2222-222222222222")
        ```

        ## Import

        DNS zone share can be imported by specifying the zone ID with share ID and optional project ID:

        bash

        ```sh
        $ pulumi import openstack:dns/zoneShareV2:ZoneShareV2 share_1 60cbdc69-64f9-49ee-b294-352e71e22827/0e1dae51-aee2-4b44-962f-885bb69f3a5c
        ```

        ```sh
        $ pulumi import openstack:dns/zoneShareV2:ZoneShareV2 share_1 60cbdc69-64f9-49ee-b294-352e71e22827/0e1dae51-aee2-4b44-962f-885bb69f3a5c/eb92139f6c054a878852ac9e8cbe612a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] project_id: The ID of the project DNS zone is created for, sets
               `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
               project).
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS zone share.
        :param pulumi.Input[builtins.str] target_project_id: The ID of the target project with which the
               DNS zone will be shared.
        :param pulumi.Input[builtins.str] zone_id: The ID of the DNS zone to be shared.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneShareV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the sharing of a DNS zone in the OpenStack DNS Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        example = openstack.dns.ZoneShareV2("example",
            zone_id="00000000-0000-0000-0000-000000000000",
            target_project_id="11111111-1111-1111-1111-111111111111",
            project_id="22222222-2222-2222-2222-222222222222")
        ```

        ## Import

        DNS zone share can be imported by specifying the zone ID with share ID and optional project ID:

        bash

        ```sh
        $ pulumi import openstack:dns/zoneShareV2:ZoneShareV2 share_1 60cbdc69-64f9-49ee-b294-352e71e22827/0e1dae51-aee2-4b44-962f-885bb69f3a5c
        ```

        ```sh
        $ pulumi import openstack:dns/zoneShareV2:ZoneShareV2 share_1 60cbdc69-64f9-49ee-b294-352e71e22827/0e1dae51-aee2-4b44-962f-885bb69f3a5c/eb92139f6c054a878852ac9e8cbe612a
        ```

        :param str resource_name: The name of the resource.
        :param ZoneShareV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneShareV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 target_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneShareV2Args.__new__(ZoneShareV2Args)

            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if target_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_project_id'")
            __props__.__dict__["target_project_id"] = target_project_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ZoneShareV2, __self__).__init__(
            'openstack:dns/zoneShareV2:ZoneShareV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            target_project_id: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZoneShareV2':
        """
        Get an existing ZoneShareV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] project_id: The ID of the project DNS zone is created for, sets
               `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
               project).
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 DNS client. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new DNS zone share.
        :param pulumi.Input[builtins.str] target_project_id: The ID of the target project with which the
               DNS zone will be shared.
        :param pulumi.Input[builtins.str] zone_id: The ID of the DNS zone to be shared.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneShareV2State.__new__(_ZoneShareV2State)

        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["target_project_id"] = target_project_id
        __props__.__dict__["zone_id"] = zone_id
        return ZoneShareV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project DNS zone is created for, sets
        `X-Auth-Sudo-Tenant-ID` header (requires an assigned user role in target
        project).
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V2 DNS client. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new DNS zone share.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="targetProjectId")
    def target_project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the target project with which the
        DNS zone will be shared.
        """
        return pulumi.get(self, "target_project_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the DNS zone to be shared.
        """
        return pulumi.get(self, "zone_id")

