# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, description=None, enabled=None, id=None, name=None, region=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "type")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            region=self.region,
            type=self.type)


def get_service(enabled: Optional[builtins.bool] = None,
                name: Optional[builtins.str] = None,
                region: Optional[builtins.str] = None,
                type: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Use this data source to get the ID of an OpenStack service.

    > **Note:** This usually requires admin privileges.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    service1 = openstack.identity.get_service(name="keystone")
    ```


    :param builtins.bool enabled: The service status.
    :param builtins.str name: The service name.
    :param builtins.str region: The region in which to obtain the V3 Keystone client.
           If omitted, the `region` argument of the provider is used.
    :param builtins.str type: The service type.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:identity/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_service_output(enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                       name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Use this data source to get the ID of an OpenStack service.

    > **Note:** This usually requires admin privileges.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    service1 = openstack.identity.get_service(name="keystone")
    ```


    :param builtins.bool enabled: The service status.
    :param builtins.str name: The service name.
    :param builtins.str region: The region in which to obtain the V3 Keystone client.
           If omitted, the `region` argument of the provider is used.
    :param builtins.str type: The service type.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:identity/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
